'use strict';

define(function() {
  var ActionsManager = function(
    $filter,
    extendedNgDialog,
    $rootScope,
    SelectManager,
    ConfigFactory,
    ngDialog,
    ngTableParams,
    DocumentFactory,
    ReportIndicatorFactory,
    $q,
    FilesFactory,
    ActionFeatureFactory,
    $timeout,
    processFactory, gaJsUtils
  ) {
    var scope = $rootScope.$new();

    function setMap(map) {
      scope.map = map;
    }



    /*
     * Add Action OUS
     */
    function executeAction(currentselectedActionOnObject, objectActions, currentselect,
      currentselectfti, result, relatedfeature, scopeOfWidget) {
      if (!currentselectedActionOnObject) {
        require('toastr').error(
          $filter('translate')('selectfeaturetree.selectActionFirst')
        );
        return;
      }
      var index = objectActions
        .map(function(x) {
          return x.name;
        })
        .indexOf(currentselectedActionOnObject.name);

      var selectedAction = objectActions[index];
      const myFeature = result.features.find(feature => feature.id === currentselect.id);
      const currentSelectInFeatureCollection = {
        crs: currentselect.crs,
        type: 'FeatureCollection',
        totalFeatures: 1,
        realTotalFeatures: {
          [currentselectfti.alias]: 1
        },
        features: [myFeature]
      };
      switch (selectedAction.actionType) {
        case $filter('translate')('model.featuretypes.actions.form'):
          executeForm(selectedAction, currentselect, result);
          break;
        case $filter('translate')('model.featuretypes.actions.jasper'):
          executeJasper(
            selectedAction,
            currentselect,
            'onobject',
            currentselectfti,
            result,
            relatedfeature
          );
          break;
        case $filter('translate')('model.featuretypes.actions.url'):
          executeUrl(selectedAction, currentselect.properties);
          break;
        case $filter('translate')('model.featuretypes.actions.esrigeoprocess'):
          // -- N'afficher la commande de visualisation que si on a affaire
          // -- à un GeoPocess ArcGIS et que si au moins un a été lancé
          scopeOfWidget.actionTypeEsriGeoprocess = selectedAction.actionType;
          ActionFeatureFactory.executeEsriGeoprocess(selectedAction, currentselect.properties,
            scopeOfWidget, myFeature.geometry, currentselectfti.srid);
          break;
        case $filter('translate')('model.featuretypes.actions.html'):
          executeHtml(selectedAction, currentselect, currentselectfti);
          break;
        case $filter('translate')('model.featuretypes.actions.widget'):
        // On créé une collection avec uniquement la feature sur laquelle on execute l'action
          ActionFeatureFactory.openWidget(selectedAction, scope, currentSelectInFeatureCollection);
          break;
        default:
          switch (selectedAction.typeInfo) {
            case 'FORMULAIRE':
              executeForm(selectedAction, currentselect, result);
              break;
            case 'JASPER':
              executeJasper(
                selectedAction,
                currentselect,
                'onobject',
                currentselectfti,
                result,
                relatedfeature
              );
              break;
            case 'URL':
              executeUrl(selectedAction, currentselect.properties);
              break;
            case 'HTML':
              executeHtml(selectedAction, currentselect, currentselectfti);
              break;
          }
          break;
      }
    }

    function executeActionOnComponent(
      currentselectedActionOnComponent,
      componentActions,
      currentselectfti,
      geoj,
      result,
      relatedfeature, ws
    ) {
      if (!currentselectedActionOnComponent) {
        require('toastr').error(
          $filter('translate')('selectfeaturetree.selectActionFirst')
        );
        return;
      }
      var index = componentActions
        .map(function(x) {
          return x.name;
        })
        .indexOf(currentselectedActionOnComponent.name);

      var selectedAction = componentActions[index];
      scope.ws = ws;
      if (geoj) scope.geoj = geoj;
      else
        scope.geoj = SelectManager.getFeaturesByftiType(currentselectfti.name);
      executeJasper(
        selectedAction,
        scope.geoj,
        'oncomponent',
        currentselectfti,
        result,
        relatedfeature
      );
    }

    function executeActionOnGlobal(currentselectedActionOnGlobal, result) {
      var rapport = currentselectedActionOnGlobal.rapports[0];
      scope.parametersRapportUtilisateur = [];
      if (
        (rapport.type ===
          $filter('translate')('model.featuretypes.actions.JasperModel') ||
          rapport.typeInfo === 'JasperModel') &&
        rapport.parameters &&
        rapport.parameters.length > 0
      ) {
        var param = [];
        for (var j = 0; j < rapport.parameters.length; j++) {
          if (
            rapport.parameters[j].attribut !== 'ids.list' &&
            rapport.parameters[j].attribut !== 'user'
          ) {
            //rapport.parameters[j].rapportName = rapport.name;
            param.push(rapport.parameters[j]);
          }
        }
        if (param.length > 0)
          scope.parametersRapportUtilisateur.push({
            name: rapport.name,
            parameters: param,
          });
      }

      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template:
            'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          function() {
            executeGlobalJasper(rapport, result);
          },
          function() {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        executeGlobalJasper(rapport, result);
      }
    }

    function executeHtml(action, currentselect, currentselectfti) {
      scope.newobj = {};
      scope.newobj.current = currentselect;
      scope.fti = currentselectfti;
      if (scope.openHTMLDialog) scope.openHTMLDialog.close();
      scope.openHTMLDialog = extendedNgDialog.open({
        template: 'fichemetiers/' + action.url,
        className: 'ngdialog-theme-plain width800 nopadding miniclose',
        closeByDocument: false,
        scope: scope,
        title: currentselectfti.name,
        draggable: true,
      });
    }

    function executeForm(action, currentselect, result) {
      for (var i = 0; i < result.features.length; i++) {
        if (result.features[i].id === currentselect.id) {
          var selectedCurrentFeature = result.features[i];
          break;
        }
      }
      ConfigFactory.get(action.type, action.form).then(
        function (res) {
          scope.currentTemplate = res.data;
          const newScope = scope.$new();
          newScope.newobj = {};
          newScope.newobj.allResult = result;
          newScope.newobj.current = selectedCurrentFeature;

          if (scope.openFormulaireDialog) {
            scope.openFormulaireDialog.close();
          }
          scope.openFormulaireDialog = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/formulaire.html',
            className:
              action.name === 'info_abonne_omega'
                ? 'ngdialog-theme-plain height700 nopadding miniclose'
                : 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: newScope,
            title: '',
            draggable: true,
            scrollable: true,
            minimizeMaximize: true,
            resizable: true,
            minWidth: '570px',
            minHeight: '400px',
            formOptions: scope.currentTemplate.options,
          });
          newScope.dlgPopup = scope.openFormulaireDialog;
        },
        function () {
          console.log('form does not exist');
        }
      );
    }

    function executeUrl(action, properties) {
      scope.parametersRapportUtilisateur = [];
      var param = [];
      for (var j = 0; j < action.parameters.length; j++) {
        if (
          action.parameters[j].saisieMode ===
            $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ) ||
          action.parameters[j].typeInfo === 'saisieUtilisateur'
        ) {
          //action.parameters[j].rapportName = action.name;
          //.parametersRapportUtilisateur.push(action.parameters[j]);
          param.push(action.parameters[j]);
        }
      }
      if (param.length > 0)
        scope.parametersRapportUtilisateur.push({
          name: action.name,
          parameters: param,
        });
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template:
            'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          function() {
            var url = parseUrl(action, properties);
            window.open(url);
          },
          function() {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        var url = parseUrl(action, properties);
        window.open(url);
      }
    }

    function parseUrl(action, properties) {
      var url = action.url;
      var params = action.parameters;
      if (params.length > 0) {
        url += '?';
        var value;
        for (var i = 0; i < params.length; i++) {
          switch (params[i].saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              properties[params[i].value] &&
              properties[params[i].value] !== null
                ? (value = properties[params[i].value])
                : (value = '');
              if (i > 0) url += '&';
              url += params[i].name + '=' + value;
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieStatic'
            ):
              if (i > 0) url += '&';
              url += params[i].name + '=' + params[i].attribute;
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ):
              if (i > 0) url += '&';
              url += params[i].name + '=' + params[i].value;
              break;
            default:
              switch (params[i].typeInfo) {
                case 'saisieAttribut':
                  properties[params[i].value] &&
                  properties[params[i].value] !== null
                    ? (value = properties[params[i].value])
                    : (value = '');
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + value;
                  break;
                case 'saisieStatic':
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].attribute;
                  break;
                case 'saisieUtilisateur':
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].value;
                  break;
              }
              break;
          }
        }
      }
      return url;
    }

    const executeGlobalJasper = (rapport, result) => {
      if (!rapport || !result) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.reportorresultabsent'
          ));
      }else {
        const sendata = generateSendataForGlobal(rapport, result);
        if (!rapport.format || rapport.format.length===0){
          rapport.format = 'pdf';
        }
        ReportIndicatorFactory.generateReportExtended(
          rapport.file,
          rapport.storeName,
          sendata,
          rapport.format,
          true
        ).then(
          (res) => {
            if (res.data.pdfdone) {
              ReportIndicatorFactory.getPdf(res.data.fileNameGenerated, rapport.format).then(
                (data) => {
                  const resultObject = data.data;
                  const blob = new Blob([resultObject], gaJsUtils.applicationTypes[rapport.format]);
                  const objectUrl = URL.createObjectURL(blob);
                  window.open(objectUrl);
                },
                () => {
                  require('toastr').error(
                    $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                      + rapport.format);
                }
              );
            } else {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.actions.unabletogeneratepdf'
                ) +
                    ' ' +
                    rapport.file
              );
            }
          },
          () => {
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletogeneratepdf'
              ) +
                  ' ' +
                  rapport.file
            );
          }
        );
      }
    };

    function generateSendataForGlobal(rapport, currentselect) {
      if (!rapport || !currentselect) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.reportorselecttabsent'
          ));
      } else {
        var res = {};
        angular.forEach(rapport.parameters, function (param) {
          switch (param.attribut) {
            case 'ids.list':
              for (var i = 0; i < currentselect.features.length; i++) {
                try {
                  var id = currentselect.features[i].id;
                  var featureName = id.split('.')[0];
                  if (Object.keys(res).indexOf(featureName) === -1)
                    res[featureName] = [];
                  res[featureName].push(Number(id.split('.')[1]));
                } catch (e) {
                  console.error(e.message);
                }
              }
              break;
            case 'user':
              res[param.name] = $rootScope.xgos.user.login;
              break;
            default:
              res[param.name] = param.value;
              break;
          }
        });
        return res;
      }
    }

    const executeJasper = (
      action,
      currentselect,
      which,
      currentselectfti,
      result,
      relatedfeature
    ) => {
      scope.parametersRapportUtilisateur = [];
      for (let i = 0; i < action.rapports.length; i++) {
        if (
          (action.rapports[i].type ===
            $filter('translate')('model.featuretypes.actions.JasperModel') ||
            action.rapports[i].typeInfo === 'JasperModel') &&
          action.rapports[i].parameters &&
          action.rapports[i].parameters.length > 0
        ) {
          const param = [];
          for (let j = 0; j < action.rapports[i].parameters.length; j++) {
            if (
              action.rapports[i].parameters[j].saisieMode ===
                $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ) ||
              action.rapports[i].parameters[j].typeInfo === 'saisieUtilisateur'
            ) {
              param.push(action.rapports[i].parameters[j]);
            }
          }
          if (param.length > 0)
            scope.parametersRapportUtilisateur.push({
              name: action.rapports[i].name,
              parameters: param,
            });
        }
      }
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              const displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template:
            'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          () => {
            switch (which) {
              case 'oncomponent':
                JasperOnComponent(action, currentselect, currentselectfti);
                break;
              case 'onobject':
                Jasper(
                  action,
                  currentselect,
                  currentselectfti,
                  result,
                  relatedfeature
                );
                break;
            }
          },
          () => {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        switch (which) {
          case 'oncomponent':
            JasperOnComponent(action, currentselect, currentselectfti);
            break;
          case 'onobject':
            Jasper(
              action,
              currentselect,
              currentselectfti,
              result,
              relatedfeature
            );
            break;
        }
      }
    };


    const Jasper = (action, currentselect, currentselectfti, result,
      relatedfeature) => {
      const sendata = getPortalDoc(currentselect, result, currentselectfti, relatedfeature);
      if (action.rapports.length === 1) {
        const rapport = action.rapports[0];

        switch (rapport.type) {
          case $filter('translate')('model.featuretypes.actions.PortalModel'):

            DocumentFactory.generatedocx(
              sendata,
              rapport.file,
              currentselect.id,
              false,
              scope.map.getView().getProjection().getCode()
            ).then((res) => {
              window.open(
                '/services/' +
                angular.module('gcMain').portalid +
                '/documents/downloaddocx?' +
                '&name=' +
                res.data.name
              );
            });
            break;
          case $filter('translate')('model.featuretypes.actions.StaticModel'):
            window.open(
              '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
              currentselectfti.name +
              '&filename=' +
              rapport.file
            );
            break;
          case $filter('translate')('model.featuretypes.actions.JasperModel'):
            generateJasperDoc(rapport, currentselect, currentselectfti, action);
            break;
          default:
            switch (rapport.typeInfo) {
              case 'PortalModel':
                DocumentFactory.generatedocx(
                  sendata,
                  rapport.file,
                  currentselect.id,
                  false,
                  scope.map.getView().getProjection().getCode()
                ).then((res) => {
                  window.open(
                    '/services/' +
                    angular.module('gcMain').portalid +
                    '/documents/downloaddocx?' +
                    '&name=' +
                    res.data.name
                  );
                });
                break;
              case 'StaticModel':
                window.open(
                  '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
                  currentselectfti.name +
                  '&filename=' +
                  rapport.file
                );
                break;
              case 'JasperModel':
                generateJasperDoc(rapport, currentselect, currentselectfti);
                break;
            }
            break;
        }
      } else {
        const promisses = [];
        const FullDataGenerate = [];
        for (let i = 0; i < action.rapports.length; i++) {
          const rapport = action.rapports[i];
          switch (rapport.type) {
            case $filter('translate')('model.featuretypes.actions.PortalModel'):
              ActionFeatureFactory.generateDocx(promisses, sendata, rapport, currentselect,
                FullDataGenerate);
              break;
            case $filter('translate')('model.featuretypes.actions.StaticModel'):
              FullDataGenerate.push({
                type: 'StaticModel',
                file: rapport.file,
                ftiname: currentselectfti.name,
              });
              break;
            case $filter('translate')('model.featuretypes.actions.JasperModel'):
              ActionFeatureFactory.generateJasper(rapport, currentselect, currentselectfti,
                promisses, FullDataGenerate);
              break;
            default:
              switch (rapport.typeInfo) {
                case 'PortalModel':
                  ActionFeatureFactory.generateDocx(promisses, sendata, rapport, currentselect,
                    FullDataGenerate);
                  break;
                case 'StaticModel':
                  FullDataGenerate.push({
                    type: 'StaticModel',
                    file: rapport.file,
                    ftiname: currentselectfti.name,
                  });
                  break;
                case 'JasperModel':
                  ActionFeatureFactory.generateJasper(rapport, currentselect, currentselectfti,
                    promisses, FullDataGenerate);
                  break;
              }
              break;
          }
        }
        $q.all(promisses).then(() => {
          FilesFactory.getActionsGeneratedZip(FullDataGenerate).then(
            (res) => {
              window.open(
                '/services/' +
                angular.module('gcMain').portalid +
                '/files/getgeneratedzip?filename=' +
                res.data.filename
              );
            },
            () => {
              require('toastr').error('error');
            }
          );
        });
      }
    };


    /**
     * Vérifie l'état d'un processus de génération de document avec un intervalle de 1 seconde
     *
     * Cette fonction interroge le statut d'un processus de génération de document et:
     * - Ouvre automatiquement le document si terminé avec succès (FINISHED)
     * - Affiche une erreur si la génération a échoué (FAILED)
     * - Continue de vérifier toutes les secondes si le processus est toujours en cours (RUNNING)
     * - Met à jour les indicateurs visuels dans l'interface utilisateur via scope.ws
     *
     * @param {string} processUid - Identifiant unique du processus à vérifier
     */
    const checkGeneratingDocx = (processUid) => {

      processFactory.getProcessByUid(processUid).then(response => {
        const data = response.data;
        if (!data) {
          // -- Quand pas de contenu, la description du process n'est pas prête
          $timeout(() => { checkGeneratingDocx(processUid); }, 1000);
        }
        else {
          // -- Le processus a 4 états possibles: RUNNING, FINISHED, FAILED, INTERRUPTED
          if (data.etat === 'FINISHED') {
            // -- Les documents on été générés, on les télécharge
            window.open(
              '/services/' + $rootScope.xgos.portal.uid +
              '/documents/getFileProcess?f=json&uid=' + processUid +
              '&token=' + encodeURIComponent(localStorage.getItem('auth_token'))
            );
            // -- Point vert pendant 15 secondes
            scope.ws.hasBeenGenerated = true;
            $timeout(() => {
              scope.ws.hasBeenGenerated = false;
            }, 15000);
          }
          else if (data.etat === 'FAILED') {
            // -- La fabrication es documents a échoué
            const error = data.errorMessage
              ? data.errorMessage : 'Erreur non détaillée';
            require('toastr').error(error);
            // -- Point rouge pendant 15 secondes
            scope.ws.generationError = true;
            $timeout(() => {
              scope.ws.generationError = false;
            }, 15000);
          }
          // -- Le processus est-il toujours en cours de génération ?
          scope.ws.isGeneratingDocx = data.etat === 'RUNNING';
          if (scope.ws.isGeneratingDocx) {
            $timeout(() => { checkGeneratingDocx(processUid); }, 1000);
          }
        }
      });
    };


    const JasperOnComponent = (action, geoj, currentselectfti) => {
      const rapport = action.rapports[0];
      if (
        rapport.typeInfo === 'PortalModel' ||
        rapport.type ===
          $filter('translate')('model.featuretypes.actions.PortalModel')
      ) {
        const senddata = getPortalDocMultiple(geoj, currentselectfti);
        scope.ws.isGeneratingDocx = true;
        DocumentFactory.generatemultipledocx(
          senddata,
          rapport.file,
          currentselectfti.uid,
          scope.map.getView().getProjection().getCode()
        ).then(
          (res) => {
            checkGeneratingDocx(res.data.uid);
          },
          () => {
            require('toastr').error('error');
          }
        );
      } else {
        const features = geoj.features;
        const sendata = [];
        angular.forEach(features, (feature) => {
          if (rapport && feature && currentselectfti){
            sendata.push(generateSendata(rapport, feature, currentselectfti));
          } else {
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.ftiorreportorselectabsent'
              ));
          }
        });
        const execStoreName = currentselectfti.type==='esri'
          && rapport.storeName ? rapport.storeName : currentselectfti.storeName;
        ReportIndicatorFactory.checkActionReportExists(rapport.file).then(
          (result)=>{
            if (result && result.data){
              ReportIndicatorFactory.generateMultipleReportExtended(
                rapport.file,
                execStoreName,
                sendata,
                true
              ).then(
                (res) => {
                  if (res.data && res.data.etat === 'fini') {
                    window.open(
                      '/services/' +
                      angular.module('gcMain').portalid +
                      '/indicator/' +
                      angular.module('gcMain').app +
                      '/getgeneratedzip?filename=' +
                      res.data.file
                    );
                  } else {
                    require('toastr').error($filter('translate')(
                      'model.featuretypes.actions.multiplereporterror'));
                  }
                },
                () => {
                  require('toastr').error($filter('translate')(
                    'model.featuretypes.actions.multiplereportfailure'));
                }
              );
            }
            else {
              swal({
                title: $filter('translate')('model.featuretypes.actions.deletedFile'),
                text: $filter('translate')(
                  'model.featuretypes.actions.deletedReport') + '\n'
                  + (rapport && rapport.file ? rapport.file : 'rapport = undefined'),
                type: 'error',
                showCancelButton: false,
                confirmButtonColor: '#CCC',
                confirmButtonText: $filter('translate')('common.ok'),
                closeOnConfirm: true,
              });
            }
          },
          ()=>{
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletocheckFileExist'
              ) +
                ' ' +
                rapport.file
            );
          }
        );
      }
    };


    const generateJasperDoc = (rapport, currentselect, currentselectfti) => {
      if (!currentselectfti || !rapport || !currentselect) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.ftiorreportorselectabsent'
          ));
      }else {
        const sendata = generateSendata(rapport, currentselect, currentselectfti);

        ReportIndicatorFactory.checkActionReportExists(rapport.file).then(
          (result) => {
            if (result && result.data) {
              let execStoreName = currentselectfti.type === 'esri'
                && rapport.storeName ? rapport.storeName
                : currentselectfti.storeName;
              if (!rapport.format || rapport.format.length === 0){
                rapport.format = 'pdf';
              }
              ReportIndicatorFactory.generateReportExtended(
                rapport.file,
                execStoreName,
                sendata,
                rapport.format,
                true).then(
                (res) => {
                  if (res.data && res.data.pdfdone) {
                    ReportIndicatorFactory.getPdf(
                      res.data.fileNameGenerated,
                      rapport.format).then(
                      (data) => {
                        const resultObject = data.data;
                        const blob
                          = new Blob([resultObject], gaJsUtils.applicationTypes[rapport.format]);
                        if ('rtf,odt,ods'.includes(rapport.format)){
                          const a = document.createElement('a');
                          document.body.appendChild(a);
                          a.style = 'display: none';
                          const url = window.URL.createObjectURL(blob);
                          a.href = url;
                          a.download = res.data.fileNameGenerated + '.' + rapport.format;
                          a.click();
                          window.URL.revokeObjectURL(url);
                        }else{
                          const objectUrl = URL.createObjectURL(blob);
                          window.open(objectUrl);
                        }
                      },
                      () => {
                        require('toastr').error(
                          $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                            + rapport.format);
                      }
                    );
                  } else {
                    require('toastr').error(
                      $filter('translate')(
                        'model.featuretypes.actions.unabletogeneratepdf') + ' ' + rapport.file
                    );
                  }
                },
                () => {
                  require('toastr').error(
                    $filter('translate')(
                      'model.featuretypes.actions.unabletogeneratepdf') + ' ' + rapport.file);
                }
              );
            } else {
              swal({
                title: $filter('translate')(
                  'model.featuretypes.actions.deletedFile'),
                text: $filter('translate')(
                  'model.featuretypes.actions.deletedReport') + '\n'
                      + (rapport && rapport.file ? rapport.file
                        : 'nom du rapport undefined'),
                type: 'error',
                showCancelButton: false,
                confirmButtonColor: '#CCC',
                confirmButtonText: $filter('translate')('common.ok'),
                closeOnConfirm: true,
              });
            }
          },
          () => {
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletocheckFileExist')
                + ' ' + rapport.file);
          }
        );
      }
    };

    const generateSendata = (rapport, currentselect, currentselectfti) => {
      if(!rapport || !currentselect || !currentselectfti){
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.ftiorreportorselectabsent'
          ));
      }else{
        const res = {};
        angular.forEach(rapport.parameters, (param) => {
          switch (param.saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              if (param.attribut === 'id' && currentselectfti.type !== 'esri') {
                res[param.name] = Number(
                  currentselect.id.replace(currentselectfti.name + '.', '')
                );
              } else {
                res[param.name] = currentselect.properties[param.attribut];
              }
              break;
            default:
              switch (param.typeInfo) {
                case 'saisieAttribut':
                  if (param.attribut === 'id') {
                    res[param.name] = Number(
                      currentselect.id.replace(currentselectfti.name + '.', '')
                    );
                  } else {
                    res[param.name] = currentselect.properties[param.attribut];
                  }
                  break;
                default:
                  res[param.name] = param.value;
                  break;
              }
              break;
          }
        });
        return res;
      }
    };

    const getPortalDocMultiple = (geoj, currentselectfti) => {
      const sendata = [];
      geoj.features.map((x) => {
        const res = {
          current: x,
          relationsNames: currentselectfti.relations
            .map((y) => {
              if (y.type === 'REL_NM') return y;
            })
            .filter((y) => {
              if (y) return y;
            }),
        };
        sendata.push(res);
      });
      return sendata;
    };

    const getPortalDoc = (
      currentselect,
      result,
      currentselectfti,
      relatedfeature
    ) => {
      let selectedCurrentFeature;
      for (let i = 0; i < result.features.length; i++) {
        if (result.features[i].id === currentselect.id) {
          selectedCurrentFeature = result.features[i];
          break;
        }
      }
      let res = {
        current: selectedCurrentFeature,
      };
      const idsNames = getNamesIds(currentselectfti, relatedfeature);
      res = createSendMessage(res, idsNames);

      return res;
    };

    const createSendMessage = (res, idsNames) => {
      const relationN = idsNames[2];
      const features = idsNames[3];
      let uniqueRelationNames = angular.copy(relationN);
      uniqueRelationNames = $.unique(uniqueRelationNames);
      for (let i = 0; i < uniqueRelationNames.length; i++) {
        const arr = [];
        for (let j = 0; j < relationN.length; j++) {
          if (relationN[j] === uniqueRelationNames[i]) arr.push(features[j]);
        }
        res[uniqueRelationNames[i]] = arr;
      }

      return res;
    };

    const getNamesIds = (currentselectfti, relatedfeature) => {
      const ids = [];
      const names = [];
      const relationN = [];
      const features = [];
      const relations = currentselectfti.relations;
      const relationsComponentsEnd = [];
      const relationsNames = [];
      relations.map((x) => {
        if (x.componentEnd) {
          relationsComponentsEnd.push(x.componentEnd);
          relationsNames.push(x.name);
        }
      });
      for (let i = 0; i < relatedfeature.features.length; i++) {
        const feature = relatedfeature.features[i];
        const id = feature.id;
        const name = id.substring(0, id.lastIndexOf('.'));
        if (relationsComponentsEnd.indexOf(name) !== -1) {
          ids.push(id);
          names.push(name);
          features.push(feature);
          relationN.push(relationsNames[relationsComponentsEnd.indexOf(name)]);
        }
      }

      return [ids, names, relationN, features];
    };

    return {
      setMap: setMap,
      executeAction: executeAction,
      executeActionOnComponent: executeActionOnComponent,
      executeActionOnGlobal: executeActionOnGlobal,
      executeHtml: executeHtml,
      executeForm: executeForm,
      executeUrl: executeUrl,
      parseUrl: parseUrl,
      executeGlobalJasper: executeGlobalJasper,
      generateSendataForGlobal: generateSendataForGlobal,
      executeJasper: executeJasper,
      Jasper: Jasper,
      JasperOnComponent: JasperOnComponent,
      generateJasperDoc: generateJasperDoc,
      generateSendata: generateSendata,
      getPortalDocMultiple: getPortalDocMultiple,
      getPortalDoc: getPortalDoc,
      createSendMessage: createSendMessage,
      getNamesIds: getNamesIds,
    };
  };

  ActionsManager.$inject = [
    '$filter',
    'extendedNgDialog',
    '$rootScope',
    'SelectManager',
    'ConfigFactory',
    'ngDialog',
    'ngTableParams',
    'DocumentFactory',
    'ReportIndicatorFactory',
    '$q',
    'FilesFactory',
    'ActionFeatureFactory',
    '$timeout',
    'processFactory',
    'gaJsUtils'
  ];

  return ActionsManager;
});
