'use strict';

define(function() {

  var LoggedOidcCtrl = function(
      $scope,
      $location,
      $q,
      $rootScope,
      PortalsFactory,
      authFactory,
      licenceFactory
  ) {

    const MAX_RETRY_COUNT = 3;

    const loginFn = (user, app, gotoHome, kisAncCfg, attemptCount = 0) => {
      const deferred = $q.defer();

      if (++attemptCount > MAX_RETRY_COUNT) {
        alert('Server unreachable!');
        return $q.reject('Server unreachable');
      }

      const portalId = $location.search().portalid;
      const oidcToken = $location.search().oidctoken;

      if (!oidcToken || !portalId) {
        deferred.reject('Missing OIDC token or portal ID');
        return deferred.promise;
      }

      authFactory.oidclogin(user, app, oidcToken, portalId, gotoHome)
        .then(response => {
          if (response.data && response.data !== '') {
            $scope.tempToken = response.data;
            postGetToken(user, kisAncCfg, deferred);
          } else {
            deferred.reject('Invalid credentials');
          }
        })
        .catch(err => {
          if (err.status === 503 || err.status === 0) {
            return loginFn(user, app, gotoHome, kisAncCfg, attemptCount);
          }
          deferred.reject(err);
        });

      return deferred.promise;
    };

    const postGetToken = (user, kisAncCfg, deferred) => {
      localStorage.setItem('auth_token', $scope.tempToken);
      localStorage.setItem('auth_token1', $scope.tempToken);

      if (PortalsFactory.getPortalId() === undefined && kisAncCfg !== undefined) {
        localStorage.setItem('portal', kisAncCfg.portalid);
      }

      // Retrieve portals list
      PortalsFactory.get()
        .then(() => {
          // dans le cas ou on a un seul portail, on va considérer que c'est le portail de l'utilisateur
          // dans le cas ou l'utilisateur c'est root on va considérer que c'est le premier portail
          if (
            PortalsFactory.getPortalId() === '-' &&
            ((user.login === 'root' && PortalsFactory.resources.portals.length > 0) ||
            (PortalsFactory.resources.portals.length === 1))
          ) {
            // gotta retrieve the portal
            const firstPortal = PortalsFactory.resources.portals[0].uid;
            PortalsFactory.setPortal(firstPortal);
          }

          try {
            licenceFactory.getAllLicences()
              .then(() => {
                const licence = licenceFactory.getLicence($rootScope.portalChosen);
                if (licence && licence.type !== 'free') {
                  licenceFactory.checkLicence(licence);
                }

                completeLogin(deferred);
              })
              .catch(() => {
                completeLogin(deferred);
              });
          } catch (e) {
            console.error('Error in license handling:', e);
            completeLogin(deferred);
          }
        })
        .catch(() => {
          deferred.reject('Failed to retrieve portal information');
        });
    };

    const completeLogin = (deferred) => {
      authFactory.getcurrentuser()
        .then(() => {
          deferred.resolve();
          authFactory.redirectAfterLogin();
        })
        .catch(error => {
          console.error('Failed to get current user:', error);
          deferred.reject('Authentication failed');
        });
    };

    /**
     * Initialize the login process when controller loads
     */
    const initLogin = () => {

      const app = $location.search().app || 'admin';

      const gotoParam = $location.search().goto;
      const gotoHome = !gotoParam || gotoParam === 'home' || gotoParam === 'calendar_invite';

      $scope.user = {
        login: $location.search().username || ''
      };

      const portalId = $location.search().portalid;
      const oidcToken = $location.search().oidctoken;

      if (portalId && oidcToken) {
        const logPromise = loginFn($scope.user, app, gotoHome);

        logPromise
          .then(() => {
            console.log('OIDC login successful');
          })
          .catch(err => {
            console.error('OIDC login failed:', err);
            // Handle failed login - redirect to regular login page
            $location.path('/login');
          });
      } else {
        console.error('Missing required OIDC parameters');
        // Redirect to regular login page if OIDC parameters are missing
        $location.path('/login');
      }
    }

    // Start the login process when controller initializes
    initLogin();
  }

  LoggedOidcCtrl.$inject = [
      '$scope',
      '$location',
      '$q',
      '$rootScope',
      'PortalsFactory',
      'authFactory',
      'licenceFactory'
  ];
  return LoggedOidcCtrl;
});