'use strict';
define(function() {
  var kisGeocoderPicker = function($rootScope, kisGeocodageFactory) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/kis_geocoder_picker.html',
      scope: {
        res: '=', //return id of geocoder
        type: '@?',
        escape: '@?',
        hideDetail: '@?', // hide detail
        multiServer: '@?', // add 'google' and 'nominatim'
      },
      restrict: 'EA',
      link: function(scope, element, attr) {
        scope.kiageocodeurs = $rootScope.xgos.portal.parameters.kisgeocodage;
        /**
         *  if multiServer, add 'google' and 'nominatim'
         */
        if (scope.multiServer) {
          var containGoogle = false,
            containNominatim = false;

          for (var i = 0; i < scope.kiageocodeurs.length; i++) {
            if (scope.kiageocodeurs[i].id == 'google') {
              containGoogle = true;
            }
            if (scope.kiageocodeurs[i].id == 'nominatim') {
              containNominatim = true;
            }
          }
          if (containNominatim == false) {
            scope.kiageocodeurs.unshift({
              label: 'Nominatim',
              id: 'nominatim',
            });
          }
          if (containGoogle == false) {
            scope.kiageocodeurs.unshift({
              label: 'Google',
              id: 'google',
            });
          }
        }

        /**
         * select default
         */
        if (scope.res) {
          if (scope.escape) {
            scope.currentKiscodeur = scope.kiageocodeurs[0];
            var res = angular.copy(scope.res.replace(/\'/g, ''));
            for (var i = 0; i < scope.kiageocodeurs.length; i++) {
              if (res == scope.kiageocodeurs[i].id) {
                scope.currentKiscodeur = scope.kiageocodeurs[i];
              }
            }
          } else {
            for (var i = 0; i < scope.kiageocodeurs.length; i++) {
              if (scope.res == scope.kiageocodeurs[i].id) {
                scope.currentKiscodeur = scope.kiageocodeurs[i];
              }
            }
          }
        } else {
          if (scope.kiageocodeurs)
            scope.currentKiscodeur = scope.kiageocodeurs[0];
          if (scope.currentKiscodeur && scope.currentKiscodeur.id) {
            scope.res = angular.copy(scope.currentKiscodeur.id);
          }
        }

        scope.object = {};

        if (scope.kiageocodeurs && scope.kiageocodeurs.length == 1) {
          scope.currentKiscodeur = scope.kiageocodeurs[0];
          scope.res = angular.copy(scope.currentKiscodeur.id);
        }
        if (scope.escape) {
          scope.res = "'" + scope.res + "'";
        }

        /**
         * use for type select
         */
        scope.selectKisgeocodeur = function() {
          scope.res = angular.copy(scope.currentKiscodeur.id);
          if (scope.escape) {
            scope.res = "'" + scope.res + "'";
          }
        };

        /**
         * use for type checkbox
         */
        scope.$watch(
          'object',
          function(object) {
            if (scope.object != {} && scope.type == 'checkbox') {
              scope.res = [];
              Object.keys(scope.object).forEach(function(key) {
                if (scope.object[key] == true) {
                  scope.res.push(key);
                }
              });
            }
          },
          1
        );
      },
    };
  };

  kisGeocoderPicker.$inject = ['$rootScope', 'kisGeocodageFactory'];
  return kisGeocoderPicker;
});
