'use strict';
/**
 * Directive pour empêcher la saisie de caractères interdits dans les champs input
 * Utilisée notamment pour le nom de fichier Geopackage
 */
define(function() {
  var noForbiddenChars = function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function(scope, element, attrs, ngModelCtrl) {
        // Liste des caractères interdits
        const forbiddenChars = '/!?£*%({[]})&#~§';
        
        // Fonction pour filtrer les caractères interdits pendant la saisie
        element.on('keypress', function(event) {
          if (forbiddenChars.indexOf(String.fromCharCode(event.which)) !== -1) {
            event.preventDefault();
          }
        });
        
        // Fonction pour nettoyer la valeur après collage (paste)
        element.on('input', function() {
          const value = element.val();
          let cleanValue = '';
          
          for (let i = 0; i < value.length; i++) {
            if (forbiddenChars.indexOf(value.charAt(i)) === -1) {
              cleanValue += value.charAt(i);
            }
          }
          
          if (cleanValue !== value) {
            ngModelCtrl.$setViewValue(cleanValue);
            ngModelCtrl.$render();
          }
        });
      }
    };
  };
  
  noForbiddenChars.$inject = [];
  
  return noForbiddenChars;
}); 