'use strict';
define(function() {
  var portalHelpLinks = function(
      $rootScope,
      $timeout,
      $window,
      ngDialog,
      $filter,
      PortalsFactory,
      gaDomUtils,
      gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/portalHelpLinks.html',
      restrict: 'EA',
      scope: {
        mode: '=' // (obligatoire) on affiche les boutons d'édition quand mode = 'config'
      },
      link: function(scope) {

        /**
         * Au clic sur le bouton "Ajouter un lien" du mapLeftMenu (parent)
         */
        scope.$on('openNewPortalNavLinkDialog',() => {
          scope.editHelpTool();
        });
        /**
         * Ouvre un nouvel onglet sur le wiki kis
         */
        scope.goToWiki = () => {
          $window.open(
              'http://support.altereo.fr/xwiki/wiki/kis/view/Main/',
              '_blank'
          );
        };
        /**
         * Ouvre un nouvel onglet sur Mantis
         */
        scope.goToHelpPage = () => {
          $window.open('https://mantis.altereo.fr/', '_blank');
        };
        /**
         * Ouvre un nouvel onglet vers l'Url
         * @param url string de l'url de la page de redirection
         */
        scope.redirectTo = (url) => {
          gaJsUtils.redirectTo(url)
        };

        /**
         * Met à jour le portail quand on toggle l'affichage d'un lien par défaut (wiki, mantis)
         * @param toolName nom du lien ('showWiki' ou 'showMantis')
         */
        scope.toggleDefaultHelpTool = (toolName) => {
          scope.defaultHelpTools[toolName] = !scope.defaultHelpTools[toolName];
          if ($rootScope.xgos && $rootScope.xgos.portal && $rootScope.xgos.portal.parameters
              && $rootScope.xgos.portal.parameters.helpTools) {
            $rootScope.xgos.portal.parameters.helpTools[toolName] = scope.defaultHelpTools[toolName];
          }
          updatePortal($rootScope.xgos.portal);
        };

        /**
         * En mode config, ouvre la popup d'édition d'un lien de navigation
         * depuis la rubrique "Aide" au bas de la barre verticale gauche de l'application Map.
         * Au clic sur le bouton "Ajouter un lien" ou au clic sur un bouton vert "Edit" (crayon)
         * @param index rang du lien dans le tableau de lien de navigation specialHelpTools
         */
        scope.editHelpTool = (index) => {
          const initTool = {
            title: '',
            url: '',
            titleFirst: true
          }

          // Fait varier le titre de la popup
          // editingHelpTool est true au clic sur lien existant.
          scope.editingHelpTool = !!(!isNaN(index) && index > -1);

          // si clic sur mini bouton vert "Edit" d'un lien : copie le lien depuis la liste
          // si clic sur bouton "Ajouter un lien" : assigne le lien de base initTool
          scope.helpTool = !isNaN(index) && index > -1 ? Object.assign({},
              scope.helpTools[index]) : initTool;

          scope.editHelpToolDialog = ngDialog.open({
            template:
                'js/XG/modules/common/views/modals/modal.add.navigation.link.html',
            className: 'ngdialog-theme-plain width400 height600 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
          // recentre la croix de la popup après 0.1 seconde
          $timeout(() => {
            const popcontent = document.querySelector('.helptool-edit');
            const dialogclose = popcontent ? popcontent.nextElementSibling : null;
            if (dialogclose) {
              dialogclose.style.top = '-5px';
              dialogclose.style.right = '-5px';
            }
          }, 100);
        };

        /**
         * Enregistre un nouveau lien de navigation dans les paramètres du portail
         * Toggle editingHelpTool pour masquer la popup d'édition d'un lien
         */
        scope.appendHelpTool = () => {
          let helpToolHasNewImage = false;
          if (scope.dzMemShare.dropzoneComponent) {
            const files = scope.dzMemShare.dropzoneComponent.files;
            if (files !== null && files !== undefined && files.length > 0) {
              // le lien récupère le nom de l'image déposée
              scope.helpTool.imageName = scope.dzMemShare.dropzoneComponent.files[0].name;
              // une nouvelle image a été déposée
              helpToolHasNewImage = true;
            }
          }
          // mise à jour du portail
          PortalsFactory.addOrEditPortalHelpTool(
              portalid,
              scope.dzMemShare.processId,
              scope.helpTool
          ).then(
              res => {
                if (res.data && Array.isArray(res.data) && res.data.length > 0) {
                  if (scope.helpTool.uid && helpToolHasNewImage) {
                    // si mise à jour et chgt d'image, attend 1s avant de rafraichir le html
                    // le temps de la copie de l'image dans le contexte
                    gaDomUtils.showGlobalLoader();
                    $timeout(()=>{
                      updateHelpTools(res.data);
                      gaDomUtils.hideGlobalLoader();
                    }, 1000);
                  } else {
                    updateHelpTools(res.data)
                  }
                }
              },
              err => {
                require('toastr').error($filter('translate')('portals.help.appendToolError')
                + err.data.message ? err.data.message : '');
              }
          ).finally(
              () => {
                if (scope.editHelpToolDialog) {
                  scope.editHelpToolDialog.close()
                }
                scope.helpTool = null;
                scope.editingHelpTool = null;
              }
          );
        };



        /**
         * Au clic sur le bouton rouge "Supprimer" de la confirmation,
         * supprime un lien de navigation et met à jour le portail
         */
        scope.deleteHelpTool = () => {
          if (scope.helpTool && scope.helpTool.uid && portalid) {
            // mise à jour du portail
            PortalsFactory.deletePortalHelpTool(portalid, scope.helpTool.uid).then(
                res => {
                  if (res.data && Array.isArray(res.data)) {
                    updateHelpTools(res.data);
                  }
                },
                err => {
                  require('toastr').error($filter('translate')('portals.help.deleteToolError')
                  + err.data.hasOwnProperty('message') ? err.data.message : '');
                }
            );
          }
        };

        /**
         * Au clic sur le bouton "Annuler" de l'ajout d'un lien de navigation
         * Ferme la popup
         */
        scope.cancelEditHelpTool = () => {
          if (scope.editHelpToolDialog) {
            scope.editHelpToolDialog.close()
          }
          scope.helpTool = null;
          scope.editingHelpTool = null;
        };


        /**
         * Change le rang dans une liste.
         * La méthode est facilement adaptable à tout tableau de cette directive
         * @param index rang actuel du lien dans la liste
         * @param direction sens dans lequel doit être déplacé le lien (haut ou bas)
         * @param saveOrder est true pour mettre à jour le portail à chaque clic
         * @return {boolean} renvoie false si le déplacement n'est pas permis
         */
        scope.moveField = function (index, direction, saveOrder=false) {
          let fields = scope.helpTools;

          if (
              (index === 0 && direction === 'up') ||
              (index === fields - 1 &&
                  direction === 'down')
          ) {
            return false;
          } else {
            const newIndex = direction === 'up' ? index - 1 : index + 1;
            fields.splice(
                index,
                0,
                fields.splice(newIndex, 1)[0]
            );

            if (saveOrder) {
              PortalsFactory.savePortalHelpToolsParameter(portalid, fields).then(
                  res => {
                    if (res.data) {
                      scope.helpTools = fields;
                    } else {
                      require('toastr').error($filter('translate')('portals.help.savePortalError'));
                    }
                  },
                  err => {
                    require('toastr').error($filter('translate')('portals.help.savePortalError')
                    + err.data.hasOwnProperty('message') ? err.data.message : '');
                  }
              );
            }
          }
        };

        /**
         * Au clic sur le bouton rouge "Supprimer" (corbeille) d'un lien de navigation,
         * ouvre la popup de confirmation pour supprimer un lien de navigation.
         * @param index rang du lien dans la liste des liens de navigation
         */
        scope.confirmDeleteHelpTool = (index) => {
          scope.helpTool = scope.helpTools[index];
          ngDialog.open({
            template:
                'js/XG/modules/common/views/modals/modal.remove.navigation.link.html',
            className: 'ngdialog-theme-plain miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * URL de téléchargement de l'image. Renseigne l'attribut ng-src de chaque lien
         * @param {string} imageName nom du fichier image
         * @return {string} /services/${portalid}/files/downloadfile?fileName=${imageName}
         */
        scope.buildImageUrl = (imageName) => {
          return `/services/${portalid}/files/downloadfile?fileName=${imageName}`
        };

        /**
         * Rectifie le nom des helpTools déjà existants avant les changements du ticket KIS-3301.
         * Stocke uniquement le nom du fichier et non plus l'URL entière dans la propriété <code>parameters.helpTools.links[i].imageName</code>
         * @param {object} portal portail courant
         * @return {object[]} tableau des liens personnalisés à affecter au scope à l'initialisation de la directive
         */
        const cleanCorruptedFileNames = (portal) => {
          const portalHelpTools = portal.parameters.helpTools.links;

          if (Array.isArray(portal.parameters.helpTools.links)) {
            let hasCorruptedHelptoolFilename = false;

            for (const helptool of portalHelpTools) {
              const fileNameIndex = helptool.imageName.indexOf('fileName=');

              if (fileNameIndex !== -1) {
                hasCorruptedHelptoolFilename = true;
                helptool.imageName = helptool.imageName.slice(fileNameIndex + 9);
              }
            }
            if (hasCorruptedHelptoolFilename) {
              updatePortal(portal);
            }
          }
          return portalHelpTools;
        };

        /**
         * Factorisation de la méthode de mise à jour du portail avec gestion des erreurs
         * @param {object} portal portail courant
         */
        const updatePortal = (portal) => {
          PortalsFactory.update(portal).then(
              res => {
                if (res.data) {
                  if (res.data.code && res.data.code === 403) {
                    require('toastr').error($filter('translate')('portals.help.savePortalError')
                    + res.data.message ? res.data.message : '');
                  } else {
                    $rootScope.xgos.portal = res.data.portal;
                  }
                }
              },
              (err) => {
                require('toastr').error($filter('translate')('portals.help.savePortalError')
                + err.data.message ? err.data.message : '');
              }
          );
        };

        const updateHelpTools = (updatedHelpTools) => {
          scope.helpTools = updatedHelpTools;
          $rootScope.xgos.portal.parameters.helpTools.links = updatedHelpTools;
        };

        /******************
         * INITIALISATION *
         ******************/

        const portalid = angular.module('gcMain').portalid;

        scope.dzMemShare = {};

        // remove mode config if user is not admin
        scope.mode = $rootScope.xgos.isadmin ? scope.mode: '';

        scope.helpTools = [];

        /**
         * A l'ouverture de la catégorie "Help",
         * après un clic sur l'icône "?" de la barre des catégories,
         * initialise la liste des liens de navigation
         * @see scope.selectSpecialTool
         */
        if ($rootScope.xgos && $rootScope.xgos.portal && $rootScope.xgos.portal.parameters) {
          if (!$rootScope.xgos.portal.parameters.helpTools) {
            $rootScope.xgos.portal.parameters.helpTools = {};
          }
          // init defaultHelpTools
          scope.defaultHelpTools = {
            showWiki: $rootScope.xgos.portal.parameters.helpTools.showWiki !== undefined
                ? $rootScope.xgos.portal.parameters.helpTools.showWiki : true,
            showMantis: $rootScope.xgos.portal.parameters.helpTools.showMantis  !== undefined
                ? $rootScope.xgos.portal.parameters.helpTools.showMantis : true
          }

          // init specialHelpTools
          // rectifie le nom des helpTools déjà existants avant les changements du ticket KIS-3301
          const portalHelpTools = cleanCorruptedFileNames($rootScope.xgos.portal);

          if (portalHelpTools) {
            scope.helpTools = portalHelpTools;
          }
        }

      },
    };
  };

  portalHelpLinks.$inject = [
    '$rootScope',
    '$timeout',
    '$window',
    'ngDialog',
    '$filter',
    'PortalsFactory',
    'gaDomUtils',
    'gaJsUtils'
  ];
  return portalHelpLinks;
});
