'use strict';
define(function() {
  var dialogsCommon = function() {
    /**
     * this method is used for resize of the dialogs but it doesn't do it's
     *    job very well. feel free to bomb it. It looks overcomplicated for what it shoud do
     * checkIfMarginIsReached seems to only be used in extendedNgDialog and gcPopup
     */
    this.checkIfMarginIsReached = dialogParams => {
      let dialogType = dialogParams.type;
      let coordinates = dialogParams.coordinates;
      let element = dialogParams.element;
      let event = dialogParams.event;

      let draggableBoundings = element[0].getBoundingClientRect();
      let viewportHeight = window.innerHeight;
      let viewportWidth = window.innerWidth;
      let isMargin = false;

      let leftOffset = draggableBoundings.left;
      let viewportTopOffset = 0;

      let popupContentHeight = 0;
      let draggableZoneHeight = 0;

      if (element[0].classList.contains('ga-draggable-zone')) {
        draggableZoneHeight = element[0].querySelector('.ga-draggable-zone').clientHeight;
        popupContentHeight = draggableBoundings.height - draggableZoneHeight;
      }


      let topOffset = draggableBoundings.top - 2;
      let rightOffset = draggableBoundings.right;
      let botttomOffset = draggableBoundings.bottom + viewportTopOffset;

      let isDraggingLeft =
        coordinates.mouseStartHorizontalPosition >=
        coordinates.mouseMoveHorizontalPosition;

      let isDraggingTop =
          coordinates.mouseStartVerticalPosition >=
          coordinates.mouseMoveVerticalPosition;

      let isDraggingRight =
          coordinates.mouseStartHorizontalPosition <=
          coordinates.mouseMoveHorizontalPosition;

      let isDraggingBottom =
          coordinates.mouseStartVerticalPosition <=
          coordinates.mouseMoveVerticalPosition;

      if (leftOffset <= 0 && isDraggingLeft) {
        if (dialogType === 'gcPopup') {
          element.css('left', 0);
        } else {
          element.css('left', -viewportWidth / 2);
        }
        stopEvent(event);
        isMargin = true;
      }

      if (topOffset <= 0 && isDraggingTop) {
        if (dialogType === 'gcPopup') {
          const top = -(viewportTopOffset + 20);
          element.css('top', top < 0 ? 0 : top);
        } else {
          const top = -viewportHeight / 2 - viewportTopOffset;
          element.css('top', top < 0 ? 0 : top);
        }

        stopEvent(event);
        isMargin = true;
      }

      if (rightOffset >= viewportWidth && isDraggingRight) {
        if (dialogType === 'gcPopup') {
          element.css('left', viewportWidth - element.width());
        } else {
          element.css('left', viewportWidth / 2 - element.width());
        }

        stopEvent(event);
        isMargin = true;
      }

      if (botttomOffset - popupContentHeight >= viewportHeight && isDraggingBottom) {
        if (dialogType === 'gcPopup') {
          element.css('top', viewportHeight - element.height() + popupContentHeight - (viewportTopOffset + 20));
        } else {
          element.css(
            'top',
            viewportHeight / 2 - viewportTopOffset - element.height() + popupContentHeight
          );
        }

        stopEvent(event);
        isMargin = true;
      }

      return isMargin;
    };

    this.getMaxIndex = ()=>{
      let maxZIndex = -1;
      $('div').each(function () {
        const zIndex =  parseInt($(this).css('z-index'));
        if (!isNaN(zIndex) && zIndex > maxZIndex
          && !$(this).hasClass('xgos_loader')
          && !$(this).hasClass('sweet-alert')) {
          maxZIndex = parseInt(zIndex);
        }
      });
      if (maxZIndex === -1) {
        maxZIndex = 10000;
      }
      return maxZIndex;
    };

    function stopEvent(event) {
      event.preventDefault();
      event.stopPropagation();
    }

    return {
      checkIfMarginIsReached: this.checkIfMarginIsReached,
      getMaxIndex: this.getMaxIndex,
    };
  };

  dialogsCommon.$inject = [];
  return dialogsCommon;
});
