'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    EditTypesFactory,
    $translate,
    RuleCfgFactory
  ) {
    return {
      templateUrl: 'js/XG/modules/edit/views/rules/cfg/cfg.setAttribute.html',

      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope, element, attrs, ctrl) {
        //scope.result = {};
        scope.rule.name = 'SetAttribute';
        scope.rule.type = 'OnEnd';

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.updateattributes,
          EditTypesFactory.editTypes.update,
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
        if (scope.rule.parameters.dataSource == undefined) {
          scope.rule.parameters.dataSource = {
            sourceName: undefined,
            layers: [],
          };
        }

        scope.initSourceLayer = function(layerName) {
          var selectedFti = undefined;
          for (var i = 0; i < scope.featureTypes.length; i++) {
            if (scope.featureTypes[i].name == layerName) {
              selectedFti = scope.featureTypes[i];
              break;
            }
          }
          return selectedFti;
        };

        scope.addSource = function() {
          if (scope.rule['parameters']['dataSource']['layers'] == undefined) {
            scope.rule['parameters']['dataSource']['layers'] = [];
          }
          var sourceArray = scope.rule['parameters']['dataSource']['layers'];
          sourceArray.push({});
        };
        scope.removeSource = function(sourceIndex) {
          var sourceArray = scope.rule['parameters']['dataSource']['layers'];
          sourceArray.splice(sourceIndex, 1);
        };

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          });
        } else {
          scope.featureTypes = angular.copy(
            FeatureTypeFactory.resources.featuretypes
          );
        }

        scope.allSharedObjectsNames = [];
        angular.forEach(scope.currentfeaturetype.rules, function(rule, key) {
          if (rule.parameters.sharedObjects) {
            angular.forEach(rule.parameters.sharedObjects, function(
              shareObj,
              key
            ) {
              scope.allSharedObjectsNames.push(shareObj.name);
            });
          }
        });
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'EditTypesFactory',
    '$translate',
    'RuleCfgFactory',
  ];
  return gcelement;
});
