'use strict';
define(function() {
  var gcelement = function(EditTypesFactory, $filter, attributeRestrictionsUtils, QueryFactory) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setDefaultValueByRole.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        scope.rule.name = 'SetDefaultValueByRole';
        scope.rule.type = 'OnEnd';

        const editTypesSource = [
          EditTypesFactory.editTypes.add,
        ];

        if (angular.isUndefined(scope.rule.editTypes)) {
          scope.rule.editTypes = [];
          angular.forEach(editTypesSource, function(editType, index) {
            scope.rule.editTypes.push(editType);
          });
        }
        scope.editTypeList = {
          leftData: editTypesSource,
          leftDisplayAttribute: 'label',
          rightData: scope.rule.editTypes,
          rightDisplayAttribute: 'label',
          source: 'left',
        };
        scope.editTypeList.leftTitle = $filter('translate')(
          'rulecfg.common.availableEditTypes'
        );
        scope.editTypeList.rightTitle = $filter('translate')(
          'rulecfg.common.executeEditTypes'
        );

        if (angular.isUndefined(scope.rule.parameters)) {
          //init prameters
          scope.rule.parameters = {
            targetField: undefined,
            rolesAndValues: []
          };
        }

        /**
         * @returns a default value depending on attribute type
         */
        scope.getInitValue = () => {
          let valueObject = {};
          if (scope.attributeType === "java.lang.String") {
            valueObject[scope.rule.parameters.targetField] = "";
          } else {
            valueObject[scope.rule.parameters.targetField] = undefined;
          }
          return valueObject;
        }

        scope.initAttribute = () => {
          if (scope.currentfeaturetype && Array.isArray(scope.currentfeaturetype.attributes)) {
            const attribute = scope.currentfeaturetype.attributes.find((attribute) => {
              return attribute.name === scope.rule.parameters.targetField
            });
            if (attribute) {
              scope.attributeType = attribute.type;

              //handle legacy table restriction values
              // table restriction data should be stored in scope.rule.parameters.rolesAndValues[*].keyTableRestriction[attribute.name]
              // and scope.rule.parameters.rolesAndValues[*].value[attribute.name] should be undefined in this case
              const restiction = attribute.restrictions[0];
              if (restiction.type===attributeRestrictionsUtils.TABLE) {
                for (let config of scope.rule.parameters.rolesAndValues) {
                  if (config.value[attribute.name]) {
                    // do not apply filter if it contains dynamic fields
                    const filter = restiction.applyFilter && restiction.filterDefinition.indexOf('#$') < 0 ? restiction.filterDefinition : '';
                    QueryFactory.getKeyRestrictionTable(
                      scope.currentfeaturetype.uid, attribute.name, config.value[attribute.name], filter).then( res => {
                      if (!config.keyTableRestriction) {
                        config.keyTableRestriction = {};
                      }
                      config.keyTableRestriction[attribute.name] = res.data.key;
                      delete config.value[attribute.name];
                    }, (err) => {
                      // Do nothing
                    });
                  }
                }
              }
            }
          }
        }
        scope.initAttribute();

        /**
         * add config for default case: ""
         */
        scope.addLastLine = () => {
          scope.rule.parameters.rolesAndValues.push(
            {
              roles: [""],
              value: scope.getInitValue()
            });
        }

        scope.resetRolesAndValues = () => {
          scope.initAttribute();
          if (scope.rule && scope.rule.parameters) {
            scope.rule.parameters.rolesAndValues = [];
            scope.addLastLine();
          }
        }

        scope.addNewRolesLine = () => {
          if (scope.rule && scope.rule.parameters && scope.rule.parameters.targetField
            && scope.rule.parameters.rolesAndValues
            && Array.isArray(scope.rule.parameters.rolesAndValues)) {
            //last line should always be the default roles case
            const defaultCase = scope.rule.parameters.rolesAndValues.pop();
            scope.rule.parameters.rolesAndValues.push(
                {
                  roles: [],
                  value: scope.getInitValue()
                },
                defaultCase
              );
          }
          scope.currentlyEditedLine = undefined;
        }

        scope.removeRolesLine = (index) => {
          if (scope.rule && scope.rule.parameters
            && scope.rule.parameters.rolesAndValues
            && Array.isArray(scope.rule.parameters.rolesAndValues)
            && index >= 0) {
            if (index === scope.rule.parameters.rolesAndValues.length-1) {
              scope.rule.parameters.rolesAndValues.pop();
              scope.addLastLine();
            } else {
              scope.rule.parameters.rolesAndValues.splice(index, 1);
            }
          }
        }

        /**
         * display a popup to edit roles list
         * @param {*} index 
         */
        scope.modifyRoles = (index) => {
          if (scope.currentlyEditedLine !== index) {
            scope.currentlyEditedLine = index;
          } else {
            scope.currentlyEditedLine = undefined;
          }
        }

        scope.isTableRestriction = () => {
          const attribute = scope.currentfeaturetype.attributes
              .find(it=> it.name===scope.rule.parameters.targetField);
          if (attribute && Array.isArray(attribute.restrictions) && attribute.restrictions.length > 0) {
            return attribute.restrictions[0].type === 'Tables';
          } else {
            return false;
          }
        }

      },
    };
  };

  gcelement.$inject = [
    'EditTypesFactory',
    '$filter',
    'attributeRestrictionsUtils',
    'QueryFactory'
  ];
  return gcelement;
});
