/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  //Directive de visualisation des objets partagés par l'ensemble des configurations de règles
  var gcelement = function(ngTableParams) {
    return {
      templateUrl: 'js/XG/modules/edit/views/rules/cfgRulesInfos.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=featuretype',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.isOpen = false;

        if (scope.currentfeaturetype.rules == undefined) {
          scope.currentfeaturetype.rules = [];
        }

        scope.allSharedObjects = [];

        function getAllSharedObject() {
          scope.allSharedObjects.splice(0);
          angular.forEach(scope.currentfeaturetype.rules, function(rule, key) {
            if (rule.parameters.sharedObjects) {
              angular.forEach(rule.parameters.sharedObjects, function(
                shareObj,
                key
              ) {
                scope.allSharedObjects.push(shareObj);
              });
            }
          });
          if (scope.tableParams) scope.tableParams.reload();
        }
        getAllSharedObject();

        /**
         * Paramètres du tableau listant les configurations d'objets partagés créés par les config de règles.
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
            //                        ,filter: {
            //                            //name: 'M'       // initial filter
            //                        },
            //                        sorting: {
            //                            //idCompte: 'asc'     // initial sorting
            //                        }
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              // use build-in angular filter
              //                            var filteredData = params.filter() ?
              //                                    $filter('filter')(scope.parcelleObjects, params.filter()) :
              //                                    scope.parcelleObjects;
              //                            var orderedData = params.sorting() ?
              //                                    $filter('orderBy')(filteredData, params.orderBy()) :
              //                                    scope.parcelleObjects;
              var displayedTab = scope.allSharedObjects.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.allSharedObjects.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        //element[0] correspond à l'element html de la presente directive.
        element[0].addEventListener('updateCfgRulesInfos', getAllSharedObject);
      },
    };
  };

  gcelement.$inject = ['ngTableParams'];
  return gcelement;
});
