'use strict';
define(function () {
  var EditRuleAllowDelete = {

    $get: function ($q, $filter, ogcFactory, gclayers) {


      function countIntersections(featureToCheck, intersectingObjectsName, map) {
        const defer = $q.defer();

        // Mise en place du buffer
        const pointCoordinate = featureToCheck.getGeometry().getFirstCoordinate();
        const leftX = pointCoordinate[0] - 0.25;
        const bottomY = pointCoordinate[1] - 0.25;
        const rightX = pointCoordinate[0] + 0.25;
        const topY = pointCoordinate[1] + 0.25;
        const cql_filter = 'INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))';

        // Requetes de récupération des features
        const objectUid = gclayers.getOperationalLayerByName(intersectingObjectsName).uid;
        ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', objectUid, 'json', map.getView().getProjection().getCode(), cql_filter)
          .then(function (res) {
            defer.resolve(res.data.totalFeatures);
          }, function (res) {
            console.error('Error getting intersecting features of type ' + intersectingObjectsName + ' when applying allowDelete rule: ' + res);
            defer.reject();
          });
        return defer.promise;
      }


      function checkAllowDelete(featureToCheck, ruleConf, map) {
        const intersectingObjectsTypes = ruleConf.parameters['shareObjects'];
        let promises = [];

        if(featureToCheck != null){
          // For each possible type of intersecting object, count the number of untersecting objects
          angular.forEach(intersectingObjectsTypes, function (intersectingObjectsType) {
            promises.push(
              countIntersections(featureToCheck, intersectingObjectsType, map)
            );
          });
        } else {
          return false;
        }

        return $q.all(promises);
      }

      function allowDelete(editdescription, ruleConf, featureType, map) {
        const defer = $q.defer();

        if (featureType.typeInfo != 'POINT') {
          console.error(
            'Règle allowDelete non adaptée à la couche ' + featureType.name
          );
          defer.reject(
            'Règle allowDelete non adaptée à la couche ' + featureType.name
          );
          return defer.promise;
        }

        const localSelectedFeatures = angular.copy(
          editdescription.selectedFeatures
        );
        let promises = [];
        let localIndex = 0;
        angular.forEach(localSelectedFeatures, (localFeature) => {
          promises.push(checkAllowDelete( localFeature,ruleConf, map));
          localIndex++;
        });

        // Sum each
        $q.all(promises).then((intersectionsForFeature) => {
          //for each feature, remove it from selection if it has more or less that 2 intersections.
          for(let localIndexOfFeature in intersectionsForFeature) {
            let numberOfIntersections = 0;
            for(let layerIntersections  of intersectionsForFeature[localIndexOfFeature]){
              numberOfIntersections += layerIntersections;
            }

            // we test the number of intersecting objets
            // if the feature doesn't intersect exatly 2 objects
            // it is not allow to be deleted (unless not connected to anything).
            if (numberOfIntersections !== 0 && numberOfIntersections !== 2) {
              require('toastr').error($filter('translate')('rulecfg.allowDelete.blockDelete'));
              //remove feature from selection
              let scopeIndex = null;
              for(let selectedFeatureIndex in editdescription.selectedFeatures){
                if(editdescription.selectedFeatures[selectedFeatureIndex].getId() ==
                  localSelectedFeatures[localIndexOfFeature].getId()){
                  scopeIndex = selectedFeatureIndex;
                }
              }
              if(scopeIndex){
                editdescription.selectedFeatures.splice(scopeIndex, 1);
              } else {
                //feature not found
                defer.reject();
              }
            }

          }

          defer.resolve();
        });

        return defer.promise;
      }

      return {
        allowDelete: allowDelete
      };
    }
  };

  EditRuleAllowDelete.$get.$inject = ['$q', '$filter', 'ogcFactory', 'gclayers'];
  return EditRuleAllowDelete;
});