/**
 *
 */
 'use strict';
 define(function() {
   /**
    * AssociationCtrl
    * @param $scope
    * @param $window
    * @param $location
    * @param ApplicationFactory
    * @param RolesFactory
    * @constructor
    */
   var AssociationCtrl = function(
     $scope,
     $rootScope,
     $filter,
     AssociationFactory,
     gaDomUtils,
     DataStoreFactory,
     FeatureTypeFactory
   ) {
     $scope.evt_intervention_association_name_list = [];
     $scope.obj_association_name_list = [];
     $scope.duplicate = false;
     if($rootScope.xgos.portal && $rootScope.xgos.portal.parameters && 
      $rootScope.xgos.portal.parameters.mainDB){
        $scope.mainDataBase = $rootScope.xgos.portal.parameters.mainDB;
     }
     let checkIfmainDataBaseExist = () => {
       if($scope.mainDataBase){
        gaDomUtils.showGlobalLoader();
        AssociationFactory.createAssociationTableIfNotExit($scope.mainDataBase).then((res)=>{
          if(res && res.data && res.data ==='reload'){
            // si on ajoute un feature, on reload la liste des featuretype
            FeatureTypeFactory.get(true);
          }
          gaDomUtils.hideGlobalLoader();
        },() =>{
          swal({
            title: $filter('translate')('model.association.createTableError'),
            type: 'error',
            showCancelButton: false,
            time: 600,
          });
          gaDomUtils.hideGlobalLoader();
        });
         return true;
       }else{
          swal({
            title: $filter('translate')('model.association.noMainDB'),
            type: 'error',
            showCancelButton: false,
            time: 600,
          });
         return false;
       }
     }
     checkIfmainDataBaseExist();

     $scope.editAssociation = () => {
      AssociationFactory.addOrUpdate($scope.mainDataBase, $scope.edit_resource, $scope.isNewResource).then(()=>{
        $scope.isNewResource = false;
        refreshList();
      });
     };

     $scope.nameAssociationChanged= () => {
        $scope.edit_resource.type_patrimoine = false;
        if($scope.isEvtIncluded($scope.edit_resource.name_association_table)){
          $scope.edit_resource.type = 3;
          $scope.edit_resource.type_patrimoine = true;
        } else if($scope.isObjIncluded($scope.edit_resource.name_association_table)){
          $scope.edit_resource.type = 1;
        } else {
          $scope.edit_resource.type = null;
        }
     }

     //Vérifie si obj_association existe lors de la sélection de la source.
     $scope.checkObjIncluded = () => {
      let objsTable = $scope.tableList.find(table => 
        table.storeName === $scope.edit_resource.source_association && $scope.isObjIncluded(table.name));
      if(objsTable){
        $scope.edit_resource.name_association_table = objsTable.name;
        $scope.edit_resource.type = 1;
      }
     }

     //disabeled Option Buttons
     $scope.isEvtIncluded = (name_association_table) => {
        return $scope.evt_intervention_association_name_list.includes(name_association_table);
     }

     $scope.isObjIncluded = (name_association_table) => {
      return $scope.obj_association_name_list.includes(name_association_table);
     }
     
     $scope.nameInit= () => {
      if($scope.isNewResource && !$scope.duplicate){
        $scope.edit_resource.type_patrimoine = false;
        $scope.edit_resource.source_association = $scope.mainDataBase;
        $scope.edit_resource.name_association_table = $scope.obj_association_name_defaut;
        $scope.nameAssociationChanged();
        $scope.edit_resource.asource = $scope.dataStores.length ==1? $scope.mainDataBase: null;
        $scope.edit_resource.bsource = $scope.dataStores.length ==1? $scope.mainDataBase: null;
      }
     }

     $scope.clickPatrimoine= () => {
        $scope.edit_resource.name_association_table = 
              $scope.edit_resource.type_patrimoine? $scope.evt_intervention_association_name_defaut: $scope.obj_association_name_defaut;
        $scope.edit_resource.type = $scope.edit_resource.type_patrimoine? 3: 1;
     }

     $scope.removeAssociation = () => {
      swal({
        title: "",
        text: $filter('translate')('model.association.deleteAssociationElements'),
        type: 'info',
        showCancelButton: true,
        confirmButtonColor: '#d9534f',
        confirmButtonText: $filter('translate')('common.yes'),
        cancelButtonText: $filter('translate')('common.no'),
        closeOnConfirm: true,
        closeOnCancel: true,
      },
      function(confirmed){
          AssociationFactory.remove($scope.mainDataBase, $scope.edit_resource.ID,confirmed).then(()=>{
            refreshList();
          });
      });
     };

     $scope.disableCopy = () => {
      return !$scope.selected_resource?true:false;
    };

    $scope.duplicateAssociation = () => {
      $scope.isNewResource = true;
      $scope.duplicate = true;
      delete $scope.edit_resource.name;
      delete $scope.edit_resource.alias;
      delete $scope.edit_resource.btable;
      delete $scope.edit_resource.bfield;
      delete $scope.edit_resource.bid;
      // dans le cas au c'est null ou empty il faut changer la valeur en false
      $scope.edit_resource.type_patrimoine = !!$scope.edit_resource.type_patrimoine;
      $scope.edit_modal(0, 0, true);
    }
 
     $scope.editListCfg = {
      dataModule: 'model',
      resource_type: 'association',
      cols: ['name_association_table', 'name', 'atable', 'btable'],
      removeFunction: $scope.removeAssociation,
      extraGlobalActions: [ {
        icon: '<i class=\'fa fa-files-o\'></i>',
        label: 'model.association.copy',
        fn: $scope.duplicateAssociation,
        disablefn: $scope.disableCopy,
      }]
     };

     if (DataStoreFactory.resources.datastores.length === 0) {
      DataStoreFactory.get().then(() => {
        $scope.dataStores = DataStoreFactory.resources.datastores;
      });
    }else{
      $scope.dataStores = DataStoreFactory.resources.datastores;
    }

    let init_association_tables = () => {
      //EVT_intervention
      $scope.evt_intervention_association_name_list = $scope.tableList.filter(table =>table.name.toLowerCase() === "evt_intervention_association")
                                                                      .map(table => table.name);
      if($scope.isEvtIncluded("evt_intervention_association")){
        $scope.evt_intervention_association_name_defaut = "evt_intervention_association";
      } else if($scope.evt_intervention_association_name_list.length > 0){
        $scope.evt_intervention_association_name_defaut = $scope.evt_intervention_association_name_list[0];
      }

      //Obj_association
      $scope.obj_association_name_list = $scope.tableList.filter(table =>table.name.toLowerCase() === "obj_association")
                                                         .map(table => table.name);
      if($scope.isObjIncluded("obj_association")){
        $scope.obj_association_name_defaut = "obj_association";
      } else if($scope.obj_association_name_list.length > 0){
        $scope.obj_association_name_defaut = $scope.obj_association_name_list[0];
      }
    }

    if(FeatureTypeFactory.resources.featuretypes.length==0){
      FeatureTypeFactory.get().then(()=>{
        $scope.tableList = FeatureTypeFactory.resources.featuretypes;
        init_association_tables();
      });
    }else{
      $scope.tableList = FeatureTypeFactory.resources.featuretypes;
      init_association_tables();
    }

    $scope.getFields = (tableAOrB) => {
      if(tableAOrB == "atable"){
        $scope.aFieldList = FeatureTypeFactory.getFeatureByName($scope.edit_resource.atable);
      }else{
        $scope.bFieldList = FeatureTypeFactory.getFeatureByName($scope.edit_resource.btable);
      }
    }

    /**
     * on va récupérer le type du leftid/aid de la table source d'association
     * si le type est entier, on doit proposer seulement les type d'attribut entier pour le left table
     * si le type est string, on doit proposer seulement les types d'attribut entier et string pour le left table
     *  */
    $scope.filterAField = (attribute) => {
      let table = $scope.tableList.find(table=> table.name=== $scope.edit_resource.name_association_table);
      if(table && table.attributes){
        let attributFound = table.attributes.find(att => att.name === ($scope.edit_resource.type === '3'?'leftid':'aid'));
        if(attributFound && attributFound.type){
          let type = attributFound.type;
          if(type === 'java.lang.Integer' && attribute.type === type){
            return true;
          } else if (type === 'java.lang.String' && (attribute.type ==='java.lang.String' || attribute.type === 'java.lang.Integer')){
            return true;
          }else{
            return false;
          }
        }
      }
      return true;
    }

    /**
     * on va récupérer le type du rightid/bid de la table source d'association
     * si le type est entier, on doit proposer seulement les type d'attribut entier pour le right table
     * si le type est string, on doit proposer seulement les types d'attribut entier et string pour le right table
     *  */
    $scope.filterBField = (attribute) => {
      let table = $scope.tableList.find(table=> table.name=== $scope.edit_resource.name_association_table);
      if(table && table.attributes){
        let attributFound = table.attributes.find(att => att.name === ($scope.edit_resource.type === '3'?'rightid':'bid'));
        if(attributFound && attributFound.type){
          let type = attributFound.type;
          if(type === 'java.lang.Integer' && attribute.type === type){
            return true;
          } else if (type === 'java.lang.String' && (attribute.type ==='java.lang.String' || attribute.type === 'java.lang.Integer')){
            return true;
          }else{
            return false;
          }
        }
      }
      return true;
    }

    $scope.validateName = () => {
      var actualName = $scope.edit_resource.name;
      $scope.$watch(
        'edit_resource.name',
        function(name) {
          $scope.nameExists =
            $scope.currentResources
              .map(function(r) {
                return r.name;
              })
              .indexOf(name) != -1;
          if (!$scope.isNewResource && $scope.edit_resource.name == actualName)
            $scope.nameExists = false;
          $scope.validFormName = !$scope.nameExists;
        },
        1
      );
    };
    
    $scope.fillAliasWithNameIfEmpty = () => {
      if ($scope.edit_resource.name && !$scope.edit_resource.alias) {
        $scope.edit_resource.alias = $scope.edit_resource.name;
      }
    };
   
    let refreshList = () =>{
      if($scope.mainDataBase){
        AssociationFactory.getAll($scope.mainDataBase).then((res) => {
          $scope.currentResources = res.data;
          //recupérer les tous les valeurs unique et non vide de l'attribut category des associations 
          $scope.categorys = $scope.currentResources.map(asso => asso.category).
                              filter((asso, i, ar) =>
                                           ar.indexOf(asso) === i && asso !=='')
        });
      }
    }
    refreshList();

    $scope.disableAddButton = () => {
      if(!$scope.validFormName|| !$scope.edit_resource.name || !$scope.edit_resource.alias
        || !$scope.edit_resource.source_association|| !$scope.edit_resource.name_association_table|| !$scope.edit_resource.type
        || !$scope.edit_resource.asource|| !$scope.edit_resource.atable|| !$scope.edit_resource.afield || !$scope.edit_resource.bsource
        || !$scope.edit_resource.btable|| !$scope.edit_resource.bfield|| ($scope.edit_resource.type==2 && (!$scope.edit_resource.aid || !$scope.edit_resource.bid)) || !$scope.mainDataBase){
          return true;
      }else {
        return false;
      }
    }
   };
 
   AssociationCtrl.$inject = [
     '$scope',
     '$rootScope',
     '$filter',
     'AssociationFactory',
     'gaDomUtils',
     'DataStoreFactory',
     'FeatureTypeFactory',
   ];
   return AssociationCtrl;
 });
 