/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  let gcelement = function(ngTableParams, ngDialog, $filter, gaJsUtils) {
    return {
      templateUrl: 'js/XG/modules/model/views/directives/featuretypeRule.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=featuretype',
      },
      link: function(scope, element, attrs, ctrl) {
        if (scope.currentfeaturetype.rules == undefined) {
          scope.currentfeaturetype.rules = [];
        }

        ///////////////// Gestion de l'arbre des règles /////////////////////////

        scope.ruleNameTree = [
          {
            label: $filter('translate')('rulecfg.tree.initial'),
            children: [{ label: 'SnapOn' }],
          },
          {
            label: $filter('translate')('rulecfg.tree.attribute_related'),
            children: [
              { label: 'SetAttribute' },
              { label: 'SetDefaultValue' },
              { label: 'SetDefaultValueByRole' },
              { label: 'SetAttributeByFormula' },
              { label: 'SetAttributeByConcat' },
              { label: 'SetUniqueIdByConcat' },
              { label: 'SetRemoteAttribute' },
              { label: 'SetXYAttributes' },
              { label: 'SetLengthAttribute' },
              { label: 'SetUserAttribute' },
              { label: 'SetDateAttribute' },
              { label: 'SetW3wAttribute' },
              { label: 'SetAreaAttribute' },
              { label: 'RotateSymbolPoint' },
              { label: 'CopyPasteAttribute' },
            ],
          },
          {
            label: $filter('translate')('rulecfg.tree.geometrie'),
            children: [{ label: 'VerifZoneSaisie' }],
          },
          {
            label: $filter('translate')('rulecfg.tree.polygonalGeometry'),
            children: [{ label: 'GetFeatureIntersectingPolygon' }]
          },
          {
            label: $filter('translate')('rulecfg.tree.linear_geometry'),
            children: [
              { label: 'GetInitialFeaturesIntersectingLine' },
              { label: 'GetFeaturesIntersectingLine' },
              { label: 'GetAllFeaturesIntersectingInitialLine' },
              { label: 'GetAllFeaturesIntersectingLine' },
              { label: 'SetObjectOnExtremity' },
              { label: 'MoveExtremityPoint' },
              { label: 'MoveObjectsOnLine' },
              { label: 'CutIntersectingLine' },
              { label: 'DeleteObjectsOnLine' },
              { label: 'DeposeObjectsOnLine' },
              { label: 'CheckNbConnectionOfSnappedPoint' },
              { label: 'StartLineSnappedOnPoint' },
              { label: 'EndLineSnappedOnPoint' },
              { label: 'StartLineSnappedOnLine' },
              { label: 'EndLineSnappedOnLine' },
              { label: 'MustNotSelfIntersect' },
              { label: 'MustNotSelfOverlap' },
              { label: 'GetFeaturesFromLineAssociation' }
            ],
          },
          {
            label: $filter('translate')('rulecfg.tree.punctual_geometry'),
            children: [
              { label: 'GetFeaturesIntersectingPoint' },
              { label: 'MergeIntersectingLines' },
              { label: 'MergeRemainingLines' },
              { label: 'CutIntersectingLine' },
              { label: 'AllowDelete' },
              { label: 'MoveObjectOnEnd' },
              { label: 'ObjectNotAllowedAtIntersection' },
              { label: 'GetFeaturesFromPointAssociation' }
            ],
          },
          {
            label: $filter('translate')('rulecfg.tree.historization'),
            children: [{ label: 'Historicize' }],
          },
        ];
        scope.treeControl = [];
        scope.preventSave = false;
        /**
         * Handler de sélection d'une règle dans l'arbre de navigation des règles.
         * @param {type} branch
         * @returns {undefined}
         */
        scope.rules_tree_handler = function(branch) {
          var selected = branch;
          //Si la branche sélectionnée est bien une terminaison, il s'agit bien d'une règle.
          if (selected.classes[0] == 'leaf') {
            //instanciation d'un nouvel objet règle qui sera édité par la directive de la règle en question.
            //nouvelle instance de règle pour que le tableau ng-table puisse differncier les règles de meme nom grâce à leur réference d'objet
            //Si probleme de representation avec le ng-table, ajouter une propriété id= nombre aléatoire (Math.random())
            scope.currentEditedRule = new Object();
            scope.currentEditedRule.id = Math.random();
            scope.currentEditedRule.name = selected.label;
          }
        };

        ///////////////// Fin Gestion de l'arbre des règles /////////////////////////
        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              let displayedTab = scope.currentfeaturetype.rules.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );
              console.log('rules', scope.currentfeaturetype.rules);
              params.total(scope.currentfeaturetype.rules.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        /**
         * Ouvre la popup d'ajout d'une régle
         * @returns {undefined}
         */
        scope.addNewRule = function() {
          sortRuleNamesTree();
          scope.editMode = 'add';
          scope.currentEditedRule = undefined;
          var dialogProperties = ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.featuretypes.rules.html',

            scope: scope,
            showClose: false,
            className: 'ngdialog-theme-plain width800 miniclose',
          });
          dialogProperties.closePromise.then(function(data) {
            scope.treeControl.reset_rows();
          });
        };

        /**
         * Ouvre la popup d'ajout d'une régle avec la règle en cours 'rule'
         * @param rule la règle correspondante au bouton cliqué dans le tableau des règles enregistrées pour ce featureType.
         * @returns {undefined}
         */
        scope.updateRule = function(rule) {
          scope.editMode = 'update';
          scope.currentEditedRule = rule;
          ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.featuretypes.rules.html',
            scope: scope,
            showClose: false,
            className: 'ngdialog-theme-plain width600 miniclose',
          });
        };

        scope.noselectionatAll = function(rule) {
          scope.currentfeaturetype.rules.map(function(x) {
            if (x.id !== rule.id) {
              x.$selected = false;
            }
          });
        };

        scope.onDropg2c = (target, source) => {
          target = fixIndexCaseManyPages(target);
          let index = source == '' ? 0 : source;
          index = fixIndexCaseManyPages(index);
          const draggedRule = scope.currentfeaturetype.rules[index];
          scope.currentfeaturetype.rules.splice(index, 1);
          scope.currentfeaturetype.rules.splice(target, 0, draggedRule);
          scope.tableParams.reload();
        };

        /**
         * Méthode utilitaire de recherche d'un objet config de règle
         * dans le tableau des config de règle pour le present featuretype.
         * @param {type} rulesArray
         * @param {type} featuretypeRule
         * @returns {Number|undefined} The index of featuretypeRule
         * or -1 if rulesArray doesn't contains featuretypeRule.
         */
        function isFeatureTypeRuleExists(rulesArray, featuretypeRule) {
          for (var i = 0; i < rulesArray.length; i++) {
            if (rulesArray[i].id == featuretypeRule.id) {
              return i;
            }
          }
          return -1;
        }

        /**
         * Ajoute ou remplace dans le tableau des règles du featureType courant, la règle passé en paramtre.
         * @param {type} currentfeaturetypeRule
         * @returns {undefined}
         */
        scope.addOrUpdateRulesToFeatureType = function(currentfeaturetypeRule) {
          if (currentfeaturetypeRule == undefined) {
            return;
          }

          //scope.currentfeaturetype.rules.push(scope.currentfeaturetypeRule);
          //Recherche de l'objet config de règle dans le tableau
          var confRuleIndex = isFeatureTypeRuleExists(
            scope.currentfeaturetype.rules,
            currentfeaturetypeRule
          );
          //Si l'objet n'existe pas dans le tableau
          if (confRuleIndex == -1) {
            scope.currentfeaturetype.rules.push(currentfeaturetypeRule);
          }
          //Si l'objet existe, remplacement par le nouveau (mise à jour)
          else {
            scope.currentfeaturetype.rules.splice(
              confRuleIndex,
              1,
              currentfeaturetypeRule
            );
          }

          scope.tableParams.reload();
          $("#rulesChoiceCfgModal [ng-click='closeThisDialog()']").click();
        };

        /**
         * Supprime du tableau des règles du featureType, toutes celles sélectionnées.
         * @returns {undefined}
         */
        scope.removeRulesFromFeatureType = function() {
          var newRulesTab = [];
          for (var i = 0; i < scope.currentfeaturetype.rules.length; i++) {
            if (!scope.currentfeaturetype.rules[i].$selected) {
              newRulesTab.push(scope.currentfeaturetype.rules[i]);
            }
          }
          scope.currentfeaturetype.rules = newRulesTab;
          scope.tableParams.reload();
        };

        scope.ruleMoveDown = (rule) => {
          //Recherche de l'objet config de règle dans le tableau
          var confRuleIndex = isFeatureTypeRuleExists(
            scope.currentfeaturetype.rules,
            rule
          );
          //Si la règle existe bien dans le tableau des règles
          if (confRuleIndex > -1) {
            //Si la règle n'est pas le dernier element du tableau,
            if (confRuleIndex < scope.currentfeaturetype.rules.length - 1) {
              scope.currentfeaturetype.rules.splice(confRuleIndex, 1);
              scope.currentfeaturetype.rules.splice(confRuleIndex + 1, 0, rule);
            }
            scope.tableParams.reload();
          }
        };

        scope.ruleMoveUp = (rule) => {
          //Recherche de l'objet config de règle dans le tableau
          var confRuleIndex = isFeatureTypeRuleExists(
            scope.currentfeaturetype.rules,
            rule
          );
          //Si la règle existe bien dans le tableau des règles
          if (confRuleIndex > -1) {
            //Si la règle n'est pas le premier element du tableau,
            if (confRuleIndex > 0) {
              scope.currentfeaturetype.rules.splice(confRuleIndex, 1);
              scope.currentfeaturetype.rules.splice(confRuleIndex - 1, 0, rule);
            }
            scope.tableParams.reload();
          }
        };

        scope.disableActionMove = (idx, type) => {
          idx = fixIndexCaseManyPages(idx);
          return type === 'up'?idx === 0 : idx === scope.tableParams.total()-1;
        };

        let fixIndexCaseManyPages = (idx) => {
          if(scope.tableParams && idx !== -1){
            return (scope.tableParams.page() - 1) * scope.tableParams.count() +idx;
          }else{
            return idx;
          }
        };

        /**
         * Trie l'arbre de sélection des règles métier par ordre alphabétique
         */
        const sortRuleNamesTree = () => {
          if (Array.isArray(scope.ruleNameTree)) {
            for (const category of scope.ruleNameTree) {
              if (category && category.hasOwnProperty('children')) {
                category.children = gaJsUtils.sortByKey(category.children, 'label');
              }
            }
          }
        };
      },
    };
  };

  gcelement.$inject = ['ngTableParams', 'ngDialog', '$filter', 'gaJsUtils'];
  return gcelement;
});
