'use strict';
define(function() {
  var PrintModelCtrl = function(
    $scope,
    PrintModelFactory,
    ngDialog,
    extendedNgDialog,
    SharedFactory,
    $translate,
    SridFactory,
    gaDomUtils,
    PortalsFactory
  ) {
    $scope.getInitialFormatTypes = function() {
      PrintModelFactory.getMapFishAvailableFormats().then(function(res) {
        for (var iFormat = 0; iFormat < res.data.length; iFormat++)
          $scope.intialFormatTypes.push({
            name: res.data[iFormat],
            selected: false,
          });
      });
    };
    PrintModelFactory.getVersion().then(
      () => {$scope.mapfishVersion = PrintModelFactory.resources.version;},
      ()=>{$scope.mapfishVersion = PrintModelFactory.resources.version;}
    );

    $scope.getFontPath = function() {
      PrintModelFactory.getFontPath().then(function(res) {
        $scope.fontPath = res.data;
      });
    };

    $scope.srids = SridFactory.sridsList;

    var configSaveSuccessLabel = 'Sauvegarde réussie';
    $translate('print.config.save.succes').then(function(res) {
      configSaveSuccessLabel = res;
    });

    var configSaveErrorLabel = 'Erreur de sauvegarde';
    $translate('print.config.save.error').then(function(res) {
      configSaveErrorLabel = res;
    });

    $scope.configPrint = {};
    $scope.intialFormatTypes = [];
    $scope.getInitialFormatTypes();
    $scope.formatType = {}; // use formatType var because formats must be an array
    $scope.configPrint.formats = [];
    $scope.newName;
    $scope.getFontPath();

    var configRenameSuccessLabel = 'Renommage réussi';
    $translate('print.config.rename.succes').then(function(res) {
      configRenameSuccessLabel = res;
    });

    var configRenameErrorLabel = 'Erreur de renommage';
    $translate('print.config.rename.error').then(function(res) {
      configRenameErrorLabel = res;
    });

    $scope.setSelectedFormatList = function() {
      var iFmt;
      //-- Vider la liste des formats choisis.
      $scope.configPrint.formats.splice(0, $scope.configPrint.formats.length);
      //-- Ajouter les formats choisis à la liste.
      for (iFmt = 0; iFmt < $scope.intialFormatTypes.length; iFmt++)
        if ($scope.intialFormatTypes[iFmt].selected)
          $scope.configPrint.formats.push($scope.intialFormatTypes[iFmt].name);
    };

    var getVariables = function() {
      if ($scope.edit_resource != undefined) {
        var getVarPromise = PrintModelFactory.getVariables(
          PortalsFactory.getPortalId(),
          $scope.edit_resource.name
        );
        getVarPromise.then(
          function(data) {
            if (data && data.data && angular.isArray(data.data)) {
              PrintModelFactory.resources.configVariables = data.data;
              console.log(
                'Variable loaded : ' +
                  JSON.stringify(PrintModelFactory.resources.configVariables)
              );
            } else {
              PrintModelFactory.resources.configVariables = [];
              console.log('No variables');
            }
          },
          function(data) {
            require('toastr').info(data);
          }
        );
      }
    };

    /**
     * Model loading
     */
    if (PrintModelFactory.resources.models.length == 0) {
      PrintModelFactory.getmodellist().then(function(res) {
        $scope.currentResources = res.data;
      });

      // Get variables
      getVariables();

      // Get fonts names
      PrintModelFactory.getFontsNames().then(
        function(data) {
          if (data && data.data && data.data[0]) {
            PrintModelFactory.fontsNames = data.data;
            console.log(
              'Fonts names loaded : ' +
                JSON.stringify(PrintModelFactory.fontsNames)
            );
          } else {
            console.log('No fonts, so add a default font Helvetica');
            PrintModelFactory.fontsNames = ['Helvetica'];
          }
        },
        function(data) {
          require('toastr').info(data);
        }
      );
    } else {
      $scope.currentResources = PrintModelFactory.resources.models;
    }

    /**
     * Get variables
     */
    $scope.getVariables = function() {
      console.log('Getting variables ...');
      getVariables();
    };

    /**
         Commit pour la config
         */
    $scope.saveconfig = function() {
      PrintModelFactory.updateconfig($scope.configPrint).then(function(res) {
        if (res.data != '') {
          require('toastr').success(configSaveSuccessLabel);
        } else {
          require('toastr').error(configSaveErrorLabel);
        }
      });
    };

    /**
     *Edition du modèle (bouton détails)
     */
    $scope.editModel = function() {
      gaDomUtils.showGlobalLoader();
      console.log('$scope.isNewResource : ' + $scope.isNewResource);
      if ($scope.isNewResource) {
        PrintModelFactory.createmodel($scope.edit_resource)
          .finally(gaDomUtils.hideGlobalLoaderAfterTimeout);
      } else {
        PrintModelFactory.update($scope.edit_resource)
          .finally(gaDomUtils.hideGlobalLoaderAfterTimeout);
        updateVariables();
      }
    };
    /**
     *Vérifier si le nom existe déjà
     */
    $scope.validForm = {name : true};
    $scope.validateName = function(name) {
          $scope.nameExists =
            $scope.currentResources
              .map(function(r) {
                return r.name;
              })
              .indexOf(name) != -1;
          $scope.validForm.name = !$scope.nameExists;
    };
    /**
     * Ôuverture de la fenêtre de configuration;
     */
    $scope.showConfig = function() {
      PrintModelFactory.get().then(function(res) {
        $scope.configPrint = res.data;
        if ($scope.fontPath != undefined)
          $scope.configPrint.fonts = $scope.fontPath;

        if (!$scope.configPrint.formats)
          $scope.configPrint = {
            dpis: [100],
            formats: ['PDF'],
            hosts: [
              {
                class: 'org.mapfish.print.config.LocalHostMatcher',
                dummy: true,
                output: 'localhost : true',
              },
            ],
            scales: ['500', '1000'],
          };

        if ($scope.configPrint.prTopMargin == undefined) {
          $scope.configPrint.prTopMargin = $scope.configPrint.prLeftMargin = $scope.configPrint.prRightMargin = $scope.configPrint.prBottomMargin = 0.5;
        }
        var iFmt;
        for (iFmt = 0; iFmt < $scope.intialFormatTypes.length; iFmt++)
          if (
            $scope.configPrint.formats.indexOf(
              $scope.intialFormatTypes[iFmt].name
            ) != -1
          )
            $scope.intialFormatTypes[iFmt].selected = true;
          else $scope.intialFormatTypes[iFmt].selected = false;
        $scope.formatType.value = $scope.configPrint.formats[0];

        var restrictedDialog = ngDialog.open({
          template: 'js/XG/modules/print/views/modals/modal.config.html',
          className: 'ngdialog-theme-plain fullScreen nopadding miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      });
    };

    /**
     * Model removal
     */
    $scope.removeModel = function() {
      PrintModelFactory.deletemodel(
        $scope.edit_resource.name
      ).then(function() {});
    };

    /**
     */
    $scope.editgui = function() {
      SharedFactory.modelName = $scope.edit_resource.name;
      SharedFactory.dialog = ngDialog.open({
        template: 'js/XG/modules/print/views/modals/modal.editgui.html',
        className: 'ngdialog-theme-plain printgui fullScreen',
        showClose: false,
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Duplicate model
     */
    $scope.duplicategui = function() {
      var modalName = $scope.edit_resource.name;

      // Get the name of the modal
      for (var i = 0; i < $scope.currentResources.length; i++) {
        if ($scope.currentResources[i].$selected) {
          //modalName = $scope.currentResources[i].name;
          // break;
        }
      }

      console.log('modal name : ' + modalName);
      $scope.newName = $scope.edit_resource.name + ' Copy';
      $scope.validateName($scope.newName);

      ngDialog.open({
        template:
          'js/XG/modules/' +
          $scope.editListCfg.dataModule +
          '/views/modals/modal.' +
          $scope.editListCfg.resource_type +
          '.duplicate' +
          '.html',
        className: 'ngdialog-theme-plain width800',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Rename model
     */
    $scope.renamegui = function() {
      var modalName = $scope.edit_resource.name;

      // Get the name of the modal
      for (var i = 0; i < $scope.currentResources.length; i++) {
        if ($scope.currentResources[i].$selected) {
          //modalName = $scope.currentResources[i].name;
          // break;
        }
      }

      console.log('modal name : ' + modalName);
      $scope.newName = '';

      var cDialog = ngDialog.open({
        template:
          'js/XG/modules/' +
          $scope.editListCfg.dataModule +
          '/views/modals/modal.' +
          $scope.editListCfg.resource_type +
          '.rename' +
          '.html',
        className: 'ngdialog-theme-plain width800',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Update the file name and some content
     * @param newName
     */
    $scope.updateModal = function(newName) {
      console.log(newName);
      var currentName = $scope.edit_resource.name;

      // Get file content
      var getFilePromie = PrintModelFactory.getmodel(currentName).then(function(
        res
      ) {
        if (res.data != '') {
          var currentFileContent = JSON.stringify(res.data);
          console.log('Current content file :' + currentFileContent);
          console.log(
            'Replaing : ' + $scope.edit_resource.name + ' to : ' + newName
          );
          var newFileContent = currentFileContent.replace(currentName, newName);
          var newFileContentJson = JSON.parse(newFileContent);
          console.log(
            'New content file :' + JSON.stringify(newFileContentJson)
          );

          return newFileContentJson;
        } else {
          var errorMsg = 'Erreur de lecture, veuillez réactualiser la page.';
          require('toastr').error(errorMsg);
        }
      });
      //-- Sauvegarde du modèle dupliqué
      getFilePromie.then(function(data) {
        //-- Chercher et enregistrer les variables des éléments texte
        //updateModelConfigVariables(outputModel);
        var variables,
          varTab = [];
        for (var i = 0; i < data.elements.length; i++) {
          if (data.elements[i].type === 'textBlock') {
            variables = PrintModelFactory.getDollarVariables(
              data.elements[i].data.text
            );
            for (var iVar = 0; iVar < variables.length; iVar++)
              varTab.push(PrintModelFactory.buildVariable(variables[iVar]));
          }
        }
        PrintModelFactory.updateVariables(varTab, data.name).then(function() {
          console.log('Variables are updated');
        });

        var savePrintPromise = PrintModelFactory.createmodel(data);
        savePrintPromise.then(
          function(data) {
            require('toastr').info(configSaveSuccessLabel);
          },
          function(data) {
            require('toastr').info(data);
          }
        );
      });
    };

    /**
     * Rename the file name
     * @param newName
     */
    $scope.renameModal = function(newName) {
      console.log(newName);
      var currentName = $scope.edit_resource.name;

      var renameFilePromie = PrintModelFactory.renameModel(
        currentName,
        newName
      ).then(function(res) {
        if (res.data != '') {
          var success = res.data && res.data == 'true' ? true : false;
          console.log(success);

          if (success) {
            require('toastr').info(configRenameSuccessLabel);

            // Update name
          } else {
            require('toastr').error(configRenameErrorLabel);
          }
        } else {
          var errorMsg = 'Erreur de lecture, veuillez réactualiser la page.';
          require('toastr').error(errorMsg);
        }
      });
    };

    /**
         EditList Directive configuration
         */
    $scope.editListCfg = {
      dataModule: 'print',
      resource_type: 'models',
      cols: ['name'],
      removeFunction: $scope.removeModel,
      extraGlobalActions: [
        {
          label: 'print.config.action',
          fn: $scope.showConfig,
        },
      ],
      extraActions: [
        {
          icon: '<i class="fa fa-copy fa-lg"></i>',
          fn: $scope.duplicategui,
        },
        {
          icon: '<i class="fa fa-pencil fa-lg"></i>',
          fn: $scope.renamegui,
        },
        {
          icon: '<i class="fa fa-pencil-square-o fa-lg"></i>',
          fn: $scope.editgui,
        },
      ],
    };

    PrintModelFactory.get().then(function(res) {
      $scope.config = res.data;
    });

    var updateVariables = function() {
      PrintModelFactory.updateVariables(
        $scope.configPrint,
        $scope.edit_resource.name
      ).then(function(res) {
        if (res.data != '') {
          console.log('Variables are updated');
          //require('toastr').success(configSaveSuccessLabel);
        } else {
          console.error('Variables are not updated');
          //require('toastr').error(configSaveErrorLabel);
        }
      });
    };
  };

  PrintModelCtrl.$inject = [
    '$scope',
    'PrintModelFactory',
    'ngDialog',
    'extendedNgDialog',
    'SharedFactory',
    '$translate',
    'SridFactory',
    'gaDomUtils',
    'PortalsFactory',
  ];
  return PrintModelCtrl;
});
