'use strict';
define(function() {
  var LongitudinalProfileFactory = function($http) {
    var LongitudinalProfileFactory = {};
    /**
     * Class : LongitudinalProfileFactory
     * Factory WebServices
     */

    /**
     * Function: get
     */
    function get(senddata) {
      var promise = $http.post(
        '/services/{portalid}/profile/longitudinal?f=json',
        senddata
      );

      return promise;
    }

    function exportProfil(senddata, exportFormat, encoding) {
      var promise = $http.post(
        '/services/{portalid}/profile/exportprofil?f=json'
          + '&exportFormat=' + exportFormat
          + (encoding ? ('&encoding=' + encoding) : ''),
        senddata
      );

      return promise;
    }

    function exportProfilToShapeFile(senddata) {
      var promise = $http.post(
        '/services/{portalid}/profile/exportprofil?f=json' +
          '&exportFormat=SHAPEFILE',
        senddata
      );

      return promise;
    }

    function exportProfilToDXF(senddata) {
      var promise = $http.post(
        '/services/{portalid}/profile/exportprofil?f=json' +
          '&exportFormat=DXF',
        senddata
      );

      return promise;
    }
    function isEsriType(fuid) {
      const promise = $http.get(
        '/services/{portalid}/profile/'+fuid+'?f=json'
      );

      return promise;
    }

    function generateJasperReport(senddata) {
      const promise = $http.post(
        '/services/{portalid}/profile/generatereport?f=json', senddata);
      return promise;
    };

    return {
      LongitudinalProfileFactory: LongitudinalProfileFactory,
      get: get,
      exportProfil: exportProfil,
      exportProfilToShapeFile: exportProfilToShapeFile,
      exportProfilToDXF: exportProfilToDXF,
      isEsriType: isEsriType,
      generateJasperReport: generateJasperReport,
    };
  };
  LongitudinalProfileFactory.$inject = ['$http'];
  return LongitudinalProfileFactory;
});
