'use strict';

define(function() {
  /*
   * mailsCtrl
   */
  var mailsCtrl = function(
    $scope,
    AncAppFactory,
    FeatureTypeFactory,
    ConfigFactory,
    gaDomUtils
  ) {
    $scope.listTemplates = AncAppFactory.appCfg.main.dossierCfg.templates;
    ConfigFactory.checkTemplates($scope.listTemplates).then(function(res) {
      $scope.listTemplates = res.data;
    });
    $scope.dossierFti = angular.copy(
      FeatureTypeFactory.getFeatureByNameAndDatastore(
        AncAppFactory.appCfg.main.datastore,
        'kis_anc_dossier'
      )
    );
   /**
   * Paramétres de tableau Résultas 
   */
    const listeDossiersCfg = AncAppFactory.getListeDossiersCfg($scope.dossierFti);
    $scope.dossierAttributes = listeDossiersCfg['attributes'];
    $scope.renduTitleColonneDossier =
      listeDossiersCfg['renduTitleColonneDossier'];
    $scope.renduColonnesEtatDossier =
      listeDossiersCfg['renduColonnesEtatDossier'];
    $scope.filterRender = listeDossiersCfg['filterRender'];
    $scope.extraFilterRender = listeDossiersCfg['extraFilterRender'];
    $scope.checkboxSelected = {};
    $scope.selected = { dossiers: [] };
    $scope.searchText = {};
    $scope.restrictFtids = [$scope.dossierFti.uid];


    // getReports
    $scope.getReports = function(p) {
      return AncAppFactory.getdossiers(
        'tous',
        p.filter,
        p.crs,
        p.page,
        p.count,
        p.liaisonFilter,
        p.case_sensitive,
        p.sort,
        ''
      );
    };


    /**
     * Return whether zip can be generated and downloaded
     * @returns {boolean}
     */
    $scope.canGenerate = function() {
      if (!$scope.selected.dossiers.length) return false;
      if (!Object.keys($scope.checkboxSelected).length) return false;
      let atLeastOne = false;
      for (let i in $scope.checkboxSelected) {
        if ($scope.checkboxSelected[i]) atLeastOne = true;
      }
      return atLeastOne;
    };

    /**
     * download zip
     */
    $scope.getDocumentsZip = function(pdf) {
      let list_dossier_ids = [],
        name_list = [];

      for (let i in $scope.selected.dossiers) {
        list_dossier_ids.push($scope.selected.dossiers[i].id);
      }
      for (let i in $scope.checkboxSelected) {
        if ($scope.checkboxSelected[i]) name_list.push(i);
      }

      gaDomUtils.showGlobalLoader();
      AncAppFactory.getZipDocumentsTypes(
        list_dossier_ids,
        name_list.join(','),
        pdf
      ).then(
        function(res) {
          window.open(
            '/services/' +
              res.data.portalid +
              '/documents/downloaddocx?' +
              '&name=' +
              res.data.name
          );
          gaDomUtils.hideGlobalLoader();
        },
        function() {
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    // used to render column values (see renderValue function)
    let contoleCfg = AncAppFactory.appCfg.main.controleCfg;
    var remplaceNomControleDernier = (controle, dossier) => {
      let value = controle;
      for (const item of contoleCfg) {
        if (controle == item.type) {
          value = item.label;
        }
      };
      return (value|| '')  +  ' ' + (dossier.properties.dernierControle.agent || '') ;
    };
    var remplaceNomControle = (controle, dossier) => {
      let value = controle;
      for (const item of contoleCfg) {
        if (controle == item.type) {
          value = item.label;
        }
      };
      return (value|| '')  +  ' ' + (dossier.properties.agent_prochain_rdv || '') ;
    };

    $scope.renduColonnesEtatDossier = {
      prochain_controle: remplaceNomControle,
      type_dernier_controle: remplaceNomControleDernier,
    };

    /** advancedFilters **/
    $scope.showAdvanced = false;
    $scope.toggleAdvancedFilters = function() {
      $scope.showAdvanced = !$scope.showAdvanced;
      $scope.advancedFiltersResult = { res: {} };
    };
    $scope.filterfti = {};
    $scope.advancedFiltersResult = { res: {} };
    $scope.$watch(
      'advancedFiltersResult',
      function(af) {
        if (!$scope.filterfti.data) return;
        if ($scope.filterfti.data.name != 'kis_anc_dossier') {
          require('toastr').error('Veuillez sélectionner des dossiers ANC');
          return;
        }
        let finalWhere = '';
        if (af.res.totalFeatures == 0) {
          finalWhere = '1=0';
        }
        if (af.res.totalFeatures > 0) {
          let filteredReportsIds = af.res.features.map(function(f) {
            return f.properties.ref_dossier;
          });

          finalWhere =
            "ref_dossier IN ('" + filteredReportsIds.join("','") + "')";
        }
        $scope.listeDossiersWhere = finalWhere;
      },
      1
    );
  };

  mailsCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'FeatureTypeFactory',
    'ConfigFactory',
    'gaDomUtils',
  ];
  return mailsCtrl;
});
