'use strict';
define(function() {
  var ancDossierPersonne = function(
    FeatureTypeFactory,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    gaDomUtils,
    $filter,
    $rootScope,
    EditFactory,
    gaJsUtils,
    $q,
    dateUtils,
    CommonFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_dossier_personne.html',
      restrict: 'EA',
      scope: {
        type: '@',
        idDossier: '=',
        ancpersonnes: '=?',
        refreshListePersonnes: '&',
        propertiesDossier: '=?',
        currentRelationProprio: '=',
        dossier: '=?',
        apptype: '=?',
        saveReport: '&',
      },
      link: function(scope, elt, attrs, ctrl) {
        let infoPropDateNames = ['debut'];

        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;

        scope.proprietaireFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          scope.apptype == 'bac'
            ? 'kis_bac_dossier_proprietaire'
            : 'kis_anc_dossier_proprietaire'
        );
        scope.locataireFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          scope.apptype == 'bac'
            ? 'kis_bac_dossier_locataire'
            : 'kis_anc_dossier_locataire'
        );
        scope.dateDebutObligatoire = false;
        if (
          angular.isDefined(
            CurrentAppFactory.appCfg.main.properties.setDateDebutPropObligatoire
          ) &&
          scope.type == 'proprietaires'
        ) {
          scope.dateDebutObligatoire =
            CurrentAppFactory.appCfg.main.properties.setDateDebutPropObligatoire;
        }
        scope.typeProprietaire = scope.proprietaireFti.attributes.filter(
          function(att) {
            return att.name == 'type_proprietaire';
          }
        )[0];

        // break two way binding because we will now use complete person objects
        var watchAncPersonnes = scope.$watch(
          'ancpersonnes',
          function(p) {
            // retrieve all person infos
            scope.personnes = angular.copy(scope.ancpersonnes);
            // retrieve all person infos
            if (scope.personnes && scope.personnes.length) {
              scope.personnes.forEach(function(p, i) {
                CurrentAppFactory.getpersonne(p.id).then(function(res) {
                  CurrentAppFactory.getInfosLocataireOrProprio(scope.idDossier,p.id,scope.type).then((resultInfosPropOrLoc)=>{
                    scope.personnes[i] = res.data.features[0];
                    if (resultInfosPropOrLoc.data.features[0].properties && scope.personnes[i].properties) {
                      scope.personnes[i].properties.debut = resultInfosPropOrLoc.data.features[0].properties.debut;
                      scope.personnes[i].properties.courant = resultInfosPropOrLoc.data.features[0].properties.courant ? resultInfosPropOrLoc.data.features[0].properties.courant : null;
                      scope.personnes[i].properties.est_redevable = resultInfosPropOrLoc.data.features[0].properties.est_redevable ? resultInfosPropOrLoc.data.features[0].properties.est_redevable : null;
                      scope.personnes[i].properties.fin = resultInfosPropOrLoc.data.features[0].properties.fin ? resultInfosPropOrLoc.data.features[0].properties.fin : null;
                    }
                  })
                });
              });
            }
          },
          1
        );

        const getInfosPropFirst = personne => {
          let def = $q.defer();

          scope.currentPerson = personne || {};
          scope.personEdited = personne ? personne : false;

          scope.specifcModalTitle = 'propriétaire';
          if (scope.type == 'locataires') {
            scope.specifcModalTitle = 'occupant';
          } else if (scope.type == 'demandeurs') {
            scope.specifcModalTitle = 'demandeur';
          }

          // si personne éditée est propriétaire, on vérifie si une date de
          // début est présente
          if (
            angular.isDefined(scope.dateDebutObligatoire) &&
            scope.dateDebutObligatoire &&
            scope.specifcModalTitle === 'propriétaire' &&
            scope.personEdited !== false
          ) {
            gethistopersonnesdossier().then(
              function(res) {
                if (res.data) {
                  res.data.forEach(function(personneH) {
                    if (scope.personEdited.id == personneH.featurePersonne.id) {
                      scope.infoProp = personneH.feature;
                      scope.personnes.infoProp = personneH.feature;
                      dateUtils.convertAllDatesToDateString(
                        scope.infoProp.properties,
                        infoPropDateNames
                      );
                      dateUtils.convertAllDatesToDateString(
                        scope.personnes.infoProp.properties,
                        infoPropDateNames
                      );
                    }
                  });
                }
                def.resolve();
              },
              () => {
                def.resolve();
              }
            );
          } else if (
            scope.personEdited == false &&
            scope.type == 'proprietaires'
          ) {
            scope.infoProp = { properties: {} };
            def.resolve();
          } else {
            def.resolve();
          }
          return def.promise;
        };

        var addPersonModal;
        scope.openAddPersonModal = function(personne) {
          gaDomUtils.showGlobalLoader();
          getInfosPropFirst(personne).then(() => {
            gaDomUtils.hideGlobalLoader();
            addPersonModal = ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.person.html',
              className: 'ngdialog-theme-plain width800 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
              preCloseCallback: function() {
                if (angular.isDefined(scope.infoProp)) delete scope.infoProp;
              },
            });
          });
        };

        /** when a person is edited */
        scope.editedPerson = function(id, infoProp) {
          // ajout personne
          if (addPersonModal) {
            addPersonModal.close();
            scope.choisirPersonne(id, infoProp);
          } else {
            scope.refreshListePersonnes();
          }
        };

        scope.checkIfNotProp = function(type) {
          var loc = false;
          if (type == 'locataires') loc = true;
          return loc;
        };

        var seachPersonModal;
        scope.openSearchPersonModal = function() {
          scope.personnesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            'kis_anc_personne'
          );
          scope.selectedPerson = { data: [] };
          scope.personnesWhere = " nom <> '' and nom IS NOT NULL ";
          if (scope.type == 'proprietaires') {
            scope.infoProp = { properties: {} };
          }
          seachPersonModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.person.search.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Ajoute la personne sélectionnée dans la liste aux personnes du dossier
         * @param {string} personne_id propriété id de la personne sélectionnée
         * @param {object} infoProp objet properties de la personne sélectionnée
         */
        scope.choisirPersonne = (personne_id, infoProp) => {
          if (infoProp === undefined && scope.selectedPerson !== undefined) {
            infoProp = {};
            infoProp.newPersonne = {};
            infoProp.newPersonne = scope.selectedPerson.data[0].properties;
          } else if (infoProp === undefined && scope.selectedPerson === undefined) {
            // Cas du boutton "="
            infoProp = {};
            infoProp.newPersonne = {};
            infoProp.newPersonne = scope.dossier.properties.proprietaires[0];
          }
          // les informations en paramètre sont obligatoires du formulaire
          // Correct personne Id ( à voir)
            CurrentAppFactory.getIdLastPersonneAdded(infoProp.newPersonne.adresse_pays,
            infoProp.newPersonne.nom, infoProp.newPersonne.civilite,
            infoProp.newPersonne.adresse_cp, infoProp.newPersonne.adresse_rue,
            infoProp.newPersonne.adresse_ville, infoProp.newPersonne.prenom ? infoProp.newPersonne.prenom : undefined).then(
            (res) => {
              if (typeof res.data === 'string' && res.data.includes('.')) {
                personne_id = res.data.split('.')[1];

                // méthode interne de factorisation
                // pour ne pas dupliquer le code à chaque cas de récupération de personne_id
                const addPersonneToDossier = (personne_id) => {
                  if (!personne_id && infoProp.typeProp !== 'omega') {
                    require('toastr').warning('Cette personne est déjà associée au dossier', '',
                        {positionClass: 'toast-bottom-left'});
                    return;
                  }
                  gaDomUtils.showGlobalLoader();

                  // verifie que la personne n' est pas deja liée au dossier
                  let editedAncPersonneInd;
                  if (scope.personnes != null) {
                    editedAncPersonneInd = scope.personnes.findIndex(pers => pers.id === 'kis_anc_personne.' + personne_id);
                  }
                  const dejaLiee = scope.personnes != null && editedAncPersonneInd > -1;

                  if (dejaLiee && (angular.isUndefined(scope.personEdited) || !scope.personEdited)) {
                    require('toastr').warning('Cette personne est déjà associée au dossier', '',
                        {positionClass: 'toast-bottom-left'});
                    gaDomUtils.hideGlobalLoader();
                    return;
                  } else if (dejaLiee && angular.isDefined(scope.personEdited) && scope.personEdited) {
                    const editedToSplice = CommonFactory.createPersonFromFirstFeature(
                        [scope.personEdited]);
                    editedToSplice.cp = scope.personEdited.properties.adresse_cp;
                    editedToSplice.numRue = scope.personEdited.properties.adresse_num_rue;
                    editedToSplice.pays = scope.personEdited.properties.adresse_pays;
                    editedToSplice.rue = scope.personEdited.properties.adresse_rue;
                    editedToSplice.ville = scope.personEdited.properties.adresse_ville;

                    scope.ancpersonnes.splice(editedAncPersonneInd, 1, editedToSplice);

                    scope.personEdited = false;
                    $rootScope.$broadcast('refreshDossierPersonne');
                    gaDomUtils.hideGlobalLoader();
                    return;
                  }

                  if (!infoProp && personne_id) {
                    infoProp = scope.currentRelationProprio[scope.getUniqueCurrentPerson(personne_id)];
                  }

                  // convertAllDatesToTimestamps
                  if (infoProp && infoProp.properties) {
                    dateUtils.convertAllDatesToTimestamps(infoProp.newPersonne, infoPropDateNames);
                  }
                  
                  const propHasDate = (scope.dateDebutObligatoire === true && scope.type
                      === 'proprietaires') || scope.type === 'locataires';
                     
                  const dateDebut = gaJsUtils.notNullAndDefined(infoProp, 'newPersonne.debut')
                  && propHasDate ?
                      infoProp.newPersonne.debut : null;
                  const facturationType = CurrentAppFactory.appCfg.main.properties.dolibarr.facturationTierce.interface.type;
                  const fin = gaJsUtils.notNullAndDefined(infoProp, 'newPersonne.debut') && propHasDate ? infoProp.newPersonne.fin : null;

                  let personneIdToSend = personne_id;
                  if (personneIdToSend.indexOf('kis_anc_personne') === -1) {
                    personneIdToSend = 'kis_anc_personne.'+personne_id
                  }
                  // InfoProp : les infos de la personne qui existe déjà et que l'on va chercher dans la base avec la loupe
                  let dateDebutNewPersone  =  new Date();      
                  if (scope.infoProp && scope.infoProp.properties.debut) {
                    dateDebutNewPersone = new Date(scope.infoProp.properties.debut).setHours(8);
                    // currentPerson : les infos de la personne en cours de création
                  } else if (scope.currentPerson) {
                    dateDebutNewPersone = new Date(scope.currentPerson.properties.debut).setHours(8);
                  }
                  
                  CurrentAppFactory.addpersonnetodossier(scope.type,scope.idDossier,personneIdToSend,
                    dateDebutNewPersone, null, facturationType,infoProp.properties && infoProp.properties.fin ? infoProp.properties.fin: null).then(
                      (res) => {
                        gethistopersonnesdossier();
                        if (scope.type === 'proprietaires') {
                          scope.personnes.push(res.data.features[0]);
                          scope.ancpersonnes.push(
                              CommonFactory.createPersonFromFirstFeature(res.data.features));
                        } else {
                          scope.personnes[0] = res.data.features[0];
                          scope.ancpersonnes[0] = CommonFactory.createPersonFromFirstFeature(
                              res.data.features); 
                        }
                        $rootScope.$broadcast('refreshDossierPersonne');
                        scope.refreshListePersonnes({noself: 1});

                        scope.$emit('updateDossierName');
                        $rootScope.$broadcast('setHideEqual', { flag: false });

                        require('toastr').success('Personne associée au dossier', '', {
                          positionClass: 'toast-bottom-left',
                        });

                      }).finally(
                      () => {
                        gaDomUtils.hideGlobalLoader();
                        if (seachPersonModal) {
                          seachPersonModal.close();
                        }
                      }
                  );
                }; // fin méthode interne addPersonneToDossier

                // choisirPersonne process
                if (angular.isUndefined(infoProp) && angular.isDefined(scope.infoProp)) {
                  infoProp = scope.infoProp;
                }
                const somePersonSelected = scope.selectedPerson && Array.isArray(
                    scope.selectedPerson.data) && scope.selectedPerson.data.length > 0;

                if (!personne_id && somePersonSelected) {
                  personne_id = scope.selectedPerson.data[0].id;
                }
                if (personne_id) {
                  addPersonneToDossier(personne_id);
                } else {
                  if (!infoProp) {
                    infoProp = {};
                  }
                  if (!infoProp.newPersonne && somePersonSelected) {
                    infoProp.newPersonne = scope.selectedPerson.data[0];
                  }
                  if (infoProp.newPersonne) {
                    if (infoProp.newPersonne.id) {
                      addPersonneToDossier(infoProp.newPersonne.id);
                    } else {
                      // les informations en paramètre sont obligatoires du formulaire
                      AncAppFactory.getIdLastPersonneAdded(infoProp.newPersonne.adresse_pays,
                          infoProp.newPersonne.nom, infoProp.newPersonne.civilite,
                          infoProp.newPersonne.adresse_cp, infoProp.newPersonne.adresse_rue,
                          infoProp.newPersonne.adresse_ville).then(
                          (res) => {
                            if (typeof res.data === 'string' && res.data.includes('.')) {
                              personne_id = res.data.split('.')[1];
                              addPersonneToDossier(personne_id);
                            } else {
                              console.error('choisirPersonne : aucun id de personne à associer au dossier', res.data);
                            }
                          }
                      );
                    }
                  }
                }
              } else {
                console.error('choisirPersonne : aucun id de personne à associer au dossier', res.data);
              }
            }
        );
        };

        scope.showModalInfosPersonne = function(id_personne) {
          gaDomUtils.showGlobalLoader();

          CurrentAppFactory.getpersonne(id_personne).then(
              (res) => {
                scope.personneInfos = res.data.features[0];
                ngDialog.open({
                  template:
                      'js/XG/widgets/ancapp/main/views/modals/modal.person.infos.html',
                  className: 'ngdialog-theme-plain width800 miniclose nopadding',
                  closeByDocument: false,
                  scope: scope,
                });
              }).finally(
              () => {
                gaDomUtils.hideGlobalLoader();
              }
          );
        };

        scope.initRemoveHisto = function(histo, index) {
          var propOrLoc;
          var typeToDelete = histo.feature.id.replace(/[^a-z_]/gi, '');

          if (typeToDelete === scope.proprietaireFti.name) {
            propOrLoc = 'proprietaires';
          } else if (typeToDelete === scope.locataireFti.name) {
            propOrLoc = 'locataires';
          }

          scope.dossier.properties[propOrLoc].forEach(function(pers) {
            if (pers.id === histo.info_personne.id) {
              scope.historique[index].disabled = true;
            }
          });
        };

        scope.removeHisto = function(histo, index) {
          var typeToDelete = histo.feature.id.replace(/[^a-z_]/gi, '');

          var ans = confirm(
            "Êtes-vous sur de vouloir supprimer cette ligne d'historique ?"
          );

          if (ans) {
            EditFactory.remove(typeToDelete, histo.feature.id).then(function(
              res
            ) {
              scope.historique.splice(index, 1);
              require('toastr').success("Ligne d'historique supprimée");
            });
          }
        };

        scope.openHistoPersonneModal = function() {
          scope.currentEditHisto = {};

          gethistopersonnesdossier().then(function(res) {
            scope.historique = res.data.sort(function(a, b) {
              return (
                b.feature.properties.courant - a.feature.properties.courant
              );
            });

            ngDialog.open({
              template:
                'js/XG/widgets/ancapp/main/views/modals/modal.person.historique.html',
              className: 'ngdialog-theme-plain width1000 miniclose nopadding',
              closeByDocument: false,
              scope: scope,
            });
          });
        };

        /**
         * Supression d'une personne d'un dossier
         *
         * @param {object} personne la personne à suprprimer
         * @param {number} index l'index de la personne en cas de plusieurs à la fois
         */
        scope.removePersonne = function (personne, index,infoProp) {
          const typePersonne =
            scope.type === 'proprietaires' ? 'ce propriétaire' : 'cet occupant';
          let ans = confirm(
            'Êtes-vous sûr de vouloir archiver ' +
              typePersonne +
              ' du dossier ?'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();
            CurrentAppFactory.removepersonneencoursfromdossier(
                scope.type,
                scope.idDossier,
                personne.id,
                null,
                infoProp ? infoProp.debut : null
            ).then(
                () => {
                  // clean if necessary
                  delete scope.currentRelationProprio[
                      scope.getUniqueCurrentPerson(personne.id)
                      ];
                  scope.personnes.splice(index, 1);
                  if (scope.personnes.length === 0) {
                    $rootScope.$broadcast('setHideEqual', { flag: true });
                  }
                  scope.ancpersonnes.splice(index, 1);
                  scope.refreshListePersonnes({ noself: 1 });
                  $rootScope.$broadcast('refreshDossierPersonne');
                  if (scope.type === 'proprietaires')
                    scope.$emit('updateDossierName');
                  gethistopersonnesdossier();
                  gaDomUtils.hideGlobalLoader();
                },
                () => {
                  console.log('error');
                  gaDomUtils.hideGlobalLoader();
                }
            );
          }
        };

        /**
         * transformTypeToLabel
         *
         * @param type
         * @returns {*}
         */
        scope.transformTypeToLabel = function(type) {
          var label;
          switch (type) {
            case 'proprietaires':
              label = 'Propriétaire(s) actuel(s)';
              break;
            case 'locataires':
              label = 'Occupant(s) actuel(s)';
              break;
          }
          return label;
        };

        /**
         * transformAucunToLabel
         *
         * @param type
         * @returns {*}
         */
        scope.transformAucunToLabel = function(type) {
          var label;
          switch (type) {
            case 'proprietaires':
              label = "Aucun propriétaire n'est associé à ce dossier";
              break;
            case 'locataires':
              label = "Aucun occupant n'est associé à ce dossier";
              break;
          }
          return label;
        };

        scope.currentEditHisto = {};
        scope.edithisto = function(histo, index) {
          scope.currentEditHisto[index] = true;
        };

        scope.closehisto = function(index) {
          delete scope.currentEditHisto[index];
        };

        var formatDate = function(dateSource) {
          var date;
          if (dateSource) {
            date = moment(dateSource);
            date = date.toISOString();
            date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          }
          return date;
        };

        scope.updatehisto = function(histo, index) {
          var removePersonFromDossier = false;
          histo.feature.properties.debut = formatDate(
            histo.feature.properties.debut
          );
          if (histo.feature.properties.fin) {
            histo.feature.properties.fin = formatDate(
              histo.feature.properties.fin
            ) ;
            if (histo.feature.properties.courant == true) {
              removePersonFromDossier = true;
              histo.feature.properties.courant = false;
            }
          }

          delete scope.currentEditHisto[index];
          var type = histo.feature.id;
          if (histo.feature.id.indexOf('proprietaire') != -1) {
            type = 'proprietaires';
          } else if (histo.feature.id.indexOf('locataire') != -1) {
            type = 'locataires';
          } else if (histo.feature.id.indexOf('demandeur') != -1) {
            type = 'demandeurs';
          }
          var FeatureCollection = {
            type: 'FeatureCollection',
            features: [histo.feature],
          };

          // @RB FIX !
          // le select de type restriction renvoie ------------- et "" pour
          // une valeur nulle ce qui fait planter l'update
          // fix temporaire, à régler dans la directive.
          if (angular.isDefined(histo.feature.properties.type_proprietaire)) {
            if (histo.feature.properties.type_proprietaire == '')
              histo.feature.properties.type_proprietaire = null;
          }

          gaDomUtils.showGlobalLoader();

          CurrentAppFactory.updatepersonhistory(FeatureCollection, type).then(
            function(res) {
              if (removePersonFromDossier) {
                CurrentAppFactory.removepersonneencoursfromdossier(
                  scope.type,
                  scope.idDossier,
                  histo.feature.id,
                  histo.feature.properties.fin
                ).then(
                  function(res) {
                    for (var i = 0; i < scope.personnes.length; i++) {
                      if (
                        scope.personnes[i].id ==
                        histo.feature.properties.id_personne
                      ) {
                        scope.personnes.splice(i, 1);
                        scope.ancpersonnes.splice(index, 1);
                      }
                    }
                    $rootScope.$broadcast('refreshDossierPersonne');
                    scope.refreshListePersonnes();
                    gaDomUtils.hideGlobalLoader();
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              } else {
                gaDomUtils.hideGlobalLoader();
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
            }
          );

        };

        scope.getUniqueCurrentPerson = (personId, type) => {
          return (type || scope.type) + '.' + personId;
        };

        const gethistopersonnesdossier = function() {
          var def = $q.defer();

          if (scope.dossier && scope.dossier.properties) {
            CurrentAppFactory.gethistopersonnesdossier(
              scope.type,
              scope.idDossier
            ).then(
              function(res) {
                if (
                  scope.type == 'proprietaires' ||
                  scope.type == 'locataires'
                ) {
                  var tmp = res.data
                    .filter(function(f) {
                      return f.feature.properties.courant;
                    })
                    .map(function(x) {
                      if (x.feature.properties.est_redevable == null) {
                        x.feature.properties.est_redevable = false;
                      }
                      if (scope.type == 'proprietaires') {
                        // Avec cette ligne , tous les proprio deviennent redevable quelque soit leur status dans la base
                        //  x.feature.properties.est_redevable = true;
                        if (x.feature.properties.type_proprietaire == null) {
                          x.feature.properties.type_proprietaire = '';
                        } else {
                          x.feature.properties.type_proprietaire =
                            '' + x.feature.properties.type_proprietaire;
                        }
                      }
                      return x.feature;
                    });
                  tmp.forEach(function(t) {
                    const uniquePersonId = scope.getUniqueCurrentPerson(
                      t.properties.id_personne
                    );
                    scope.currentRelationProprio[uniquePersonId] = t;
                    scope.currentRelationProprio[uniquePersonId].type =
                      scope.type;
                  });
                }

                scope.historique = res.data.sort(function(a, b) {
                  return (
                    b.feature.properties.courant - a.feature.properties.courant
                  );
                });
                def.resolve(res);
              },
              function() {
                def.resolve();
              }
            );
          } else {
            def.resolve();
          }
          return def.promise;
        };

        gethistopersonnesdossier();

        scope.$on('attributeRestrictionChange', function(event, args) {
          if (
            args.fti == scope.proprietaireFti &&
            args.attribute == scope.typeProprietaire
          ) {
            scope.updateTableProprietaire();
          }
        });

        /**
         * renderHistoryStart
         *
         * @param id
         * @returns {*}
         */
        scope.renderHistoryStart = function(id) {
          var lib = 'Date de début inconnue';
          if (scope.historique) {
            for (var i = 0; i < scope.historique.length; i++) {
              if (
                scope.historique[i].feature.properties.id_personne == id &&
                scope.historique[i].feature.properties.debut != null &&
                scope.historique[i].feature.properties.courant == true
              ) {
                lib =
                  'Depuis le ' +
                  $filter('date')(scope.historique[i].feature.properties.debut);
              }
            }
          }
          return lib;
        };

        /**
         * Builder du nom complet de la personne
         *
         * @param {*} personneProperties  Json les propriétes de la personne
         *
         * @returns {string} nom complet de la personne
         */
         scope.renderPersonFullname = (personneProperties) => {
          let nomComplet = '';
          if (personneProperties) {
            let properties = [
              'civilite',
              'nom',
              'prenom',
              'nom_complement',
            ];
            for (let propertie of properties) {
              if (personneProperties[propertie]) {
                nomComplet = nomComplet + personneProperties[propertie] + ' ';
              }
            }
          }
          return nomComplet;
        };

        /**
         * Builder de l'adresse complete de la personne
         *
         * @param {*} personneProperties  Json les propriétes de la personne
         *
         * @returns {string} adresse complet de la personne
         */
        scope.renderPersonAdress = (personneProperties) => {
          let adresseComplet = '';
          if (personneProperties) {
            let properties = [
              'adresse_num_rue',
              'adresse_num_rue_extra',
              'adresse_rue',
              'adresse_batiment',
              'adresse_appt',
              'adresse_etage',
              'adresse_escalier',
              'adresse_complement',
              'adresse_bp',
              'adresse_cp',
              'adresse_ville',
              'adresse_pays',
            ];
            for (let propertie of properties) {
              if (personneProperties[propertie]) {
                adresseComplet = adresseComplet + personneProperties[propertie] + ' ';
              }
            }
          }
          return adresseComplet;
        };

        /**
         * render Person Nums Telephonnes
         *
         * @param properties
         * @returns {string}
         */
        scope.renderPersonNumsTelephonnes = function(properties) {
          var espace = '';
          if (properties != undefined) {
            if (!properties.num_tel) properties.num_tel = '';
            if (!properties.num_port) properties.num_port = '';
            if (properties.num_tel && properties.num_port) espace = '-';
            return '  ' + properties.num_tel + espace + properties.num_port;
          }
        };

        /**
         * copier une personne du dossier
         */
        const personneInfoPicker = scope.$watch(
          'personneInfoPicker.value',
          function(v) {
            scope.personneInfoPicker = {};

            if (v) {
              if (
                angular.isDefined(scope.dateDebutObligatoire) &&
                scope.dateDebutObligatoire &&
                scope.type == 'proprietaires'
              ) {
                scope.infoProp = {
                  properties: {
                    debut: v.dateDebutProp,
                  },
                };
                scope.personnes.infoProp = {
                  properties: {
                    debut: v.dateDebutProp,
                  },
                };
              }
              scope.choisirPersonne(v.features[0].id);
            }
          },
          1
        );
        
        scope.updateFacturation = personId => {
          scope.currentRelationProprio = Object.values(
            scope.currentRelationProprio
          ).reduce((accumulator, personne) => {
            const currentPersonId =
              personne.properties && personne.properties.id_personne;
            if (!currentPersonId) {
              return;
            } // Ignore entirely the personne here.

            const uniquePersonId = scope.getUniqueCurrentPerson(
              currentPersonId,
              personne.type
            );

            accumulator[uniquePersonId] = personne;

            if (uniquePersonId !== scope.getUniqueCurrentPerson(personId)) {
              accumulator[uniquePersonId].properties.est_redevable = false;
            }

            return accumulator;
          }, {});

          gaDomUtils.showGlobalLoader();

          $q.all(scope.updateTableProprietaire(), scope.updateTableLocataire())
            .then(
              () =>
                require('toastr').success(
                  $filter('translate')('common.updated')
                ),
              () =>
                require('toastr').error(
                  'Erreur lors de la mise à jour des infos du payeur.'
                )
            )
            .finally(() => gaDomUtils.hideGlobalLoader());
        };

        scope.updateTableProprietaire = () => {
          if (scope.currentRelationProprio) {
            const proprietaires = Object.values(
              angular.copy(scope.currentRelationProprio)
            )
              .filter(personne => personne && personne.type === 'proprietaires')
              .map(proprietaire => {
                proprietaire.properties.type_proprietaire = parseInt(
                  proprietaire.properties.type_proprietaire
                );
                proprietaire.type = undefined; // Remove type property as the server doesn't handle it
                return proprietaire;
              });

            if (proprietaires.length === 0) {
              return;
            } // Do not make the call to the server if there are no proprietaires

            return EditFactory.update(
              scope.proprietaireFti.uid,
              gaJsUtils.setNewFeatureCollection(proprietaires),
              ''
            );
          }

        };

        scope.updateTableLocataire = () => {
          if (scope.currentRelationProprio) {
            const locataires = Object.values(
              angular.copy(scope.currentRelationProprio)
            )
              .filter(personne => personne && personne.type === 'locataires')
              .map(locataire => {
                locataire.type = undefined; // Remove type property as the server doesn't handle it
                return locataire;
              });

            if (locataires.length === 0) {
              return;
            } // Do not make the call to the server if there are no locataires

            return EditFactory.update(
              scope.locataireFti.uid,
              gaJsUtils.setNewFeatureCollection(locataires),
              ''
            );
          }
        };

        $rootScope.$on('refreshDatePersonne', function(event, data) {
          gethistopersonnesdossier();
          scope.renderHistoryStart(data);
        });

        // Render tooltip on modal.person.search
        scope.tooltipTitle = {};
        scope.tooltipTitle.titleEdit = 'Editer la personne';
        scope.tooltipTitle.titleFilter = 'Appliquer un filtre';
        scope.tooltipTitle.save = 'Sauvegarder la personne';
        scope.tooltipTitle.class = 'cursorHelp';

        // when we want to add a personne from outside of the directive, ie the
        // report
        // its used for the omegaLinkForExample
        scope.$on('addAncPersonneFromDossier', function(event, args) {
          scope.infoPropToSend =  args;
          // only if same type of personne (proprietaire|occupant)
          if (args.type == scope.type) {
            if(!personneExistDansDossierRemoveOthers(args.id_personne,args.type)){
              CurrentAppFactory.getpersonne(args.id_personne).then(function(res) {
                scope.personEdited = res.data.features[0];
              });
            }
            scope.choisirPersonne(args.id_personne, {
              properties: { debut: args.debut ,fin : args.fin, typeProp : args.typeProp ? args.typeProp : null },
            });
          }
        });
        let personneExistDansDossierRemoveOthers = (newPersonneId , type) => {
          let exist = false;
          let personnes = scope.dossier.properties[type];
          for (let i = 0; i < personnes.length; i++) {
            let personne = personnes[i].id;
            if (personne != newPersonneId) {
              scope.removePersonne(personnes[i],i,scope.infoPropToSend);
            }else {
              exist = true;
            }
          }
          return exist;
        };
        // cleanup
        scope.$on('$destroy', function() {
          watchAncPersonnes();
          personneInfoPicker();
        });
      },
    };
  };

  ancDossierPersonne.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'gaDomUtils',
    '$filter',
    '$rootScope',
    'EditFactory',
    'gaJsUtils',
    '$q',
    'dateUtils',
    'CommonFactory'
  ];
  return ancDossierPersonne;
});
