'use strict';
define(function() {
  var ancPersonne = function(
    FeatureTypeFactory,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    gaDomUtils,
    FeatureHistoryFactory,
    $rootScope,
    OmegaFactory,
    dateUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_personne.html',
      restrict: 'EA',
      scope: {
        selectType: '=?',
        personne: '=',
        editable: '=',
        contracted: '=?',
        afterEdit: '&?',
        propertiesDossier: '=?',
        toggleAdresse: '=?',
        dateDebutObligatoire: '=?',
        infoProp: '=?',
        idDossier: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        let personeDateNames = ['date_naissance'];
        let infoPropDateNames = ['debut'];
        if (scope.personne) {
          dateUtils.convertAllDatesToDateString(
            scope.personne.properties,
            personeDateNames
          );
        }
        
        if (scope.infoProp && scope.infoProp.properties) {
          dateUtils.convertAllDatesToDateString(
            scope.infoProp.properties,
            infoPropDateNames
          );
        }
        var CurrentAppFactory = !AncAppFactory.appCfg.main
          ? BacAppFactory
          : AncAppFactory;

        scope.proprietaireFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          !AncAppFactory.appCfg.main
            ? 'kis_bac_dossier_proprietaire'
            : 'kis_anc_dossier_proprietaire'
        );
        scope.typeProprietaire = scope.proprietaireFti.attributes.filter(
          function(att) {
            return att.name == 'type_proprietaire';
          }
        )[0];

        scope.displayTiersCivil =
          CurrentAppFactory.appCfg.main.properties.dolibarr.active == true;

        /** allinfo or excerpt (contracted) * */
        if (angular.isUndefined(scope.contracted)) {
          scope.contracted = false;
          scope.allowContract = false;
        } else {
          scope.allowContract = true;
        }

        if (
          angular.isDefined(AncAppFactory) &&
          AncAppFactory.appCfg &&
          AncAppFactory.appCfg.main &&
          AncAppFactory.appCfg.main.properties
        ) {
          scope.civilites = angular.copy(
            AncAppFactory.appCfg.main.properties.civilites.liste
          );
        }

        scope.personneTabs = [
          {
            title: 'Informations',
            content:
              'js/XG/widgets/ancapp/main/views/directives/anc_personne.general.html',
          },
        ];
        scope.personneTabs.activeTab = 0;

        // show histo tab if not new personne and not contracted
        var watchPersonneId = scope.$watch('personne.id', function(id) {
          if (angular.isDefined(id)) {
            if (!scope.contracted && scope.personneTabs.length == 1) {
              scope.personneTabs.push({
                title: 'Historique',
                content:
                  'js/XG/widgets/ancapp/main/views/directives/anc_personne.historique.html',
              });
            }
          }
        });

        var refreshHistorique = function() {
          if (typeof AppAndroid !== 'undefined') return;
          if (!scope.personne || !scope.personne.id) return;
          scope.personneFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            CurrentAppFactory.appCfg.main.datastore,
            'kis_anc_personne'
          );

          scope.historique = [];
          FeatureHistoryFactory.getactions(
            scope.personne.id,
            scope.personneFti.uid
          ).then(function(res) {
            scope.historique = res.data.features;
          });
        };
        refreshHistorique();

        /**
         * save personne
         */
        scope.savePerson = function() {
          console.log("sauvegarde de la personne sur le dossier: " + scope.idDossier);
          let typePersonne = "";
          if(scope.infoProp === undefined) {
            typePersonne = "occupant"
          } else {
            typePersonne = "proprietaire"
          }
          // Proprio ou occupant
          let propOrLoc = "";
          let featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.infoProp = {}
         
          scope.infoProp.newPersonne = {};
          // infos nouvelle personne (infos obligatoires dans le formulaire, ces infos permettent de récupérées l id de la personne qui vient d'être rajoutée)
          scope.infoProp.newPersonne.nom = scope.personne.properties.nom;
          scope.infoProp.newPersonne.civilite = scope.personne.properties.civilite;
          scope.infoProp.newPersonne.adresse_cp = scope.personne.properties.adresse_cp;
          scope.infoProp.newPersonne.adresse_num_rue = scope.personne.properties.adresse_num_rue;
          scope.infoProp.newPersonne.adresse_pays = scope.personne.properties.adresse_pays;
          scope.infoProp.newPersonne.adresse_rue = scope.personne.properties.adresse_rue;
          scope.infoProp.newPersonne.adresse_ville = scope.personne.properties.adresse_ville;
          scope.infoProp.newPersonne.prenom = scope.personne.properties.prenom ? scope.personne.properties.prenom : undefined;

          // Comment gérer la date de debut de l'occupant dans date inscrite ?
          scope.infoProp.newPersonne.debut = scope.personne.properties.debut ? Date.parse(scope.personne.properties.debut) : null ; //Ou date d aujourd'hui?

          let personne = angular.copy(scope.personne);

          if (personne.properties.adresse_num_rue == '') {
            personne.properties.adresse_num_rue = null;
          }

          personne.properties.debut = scope.personne.properties.debut ? Date.parse(scope.personne.properties.debut) : null ; //Ou date d aujourd'hui?


          dateUtils.convertAllDatesToTimestamps(
            personne.properties,
            personeDateNames
          );
          if (scope.infoProp && scope.infoProp.properties) {
            dateUtils.convertAllDatesToTimestamps(
              scope.infoProp.properties,
              infoPropDateNames
            );
          }
          gaDomUtils.showGlobalLoader();

          if (angular.isUndefined(scope.personne.id)) {
            if (typeof AppAndroid !== 'undefined') {
              if (angular.equals(personne.properties.date_naissance, {}))
                personne.properties.date_naissance = null;
            }
            featureCollection.features.push({
              type: 'Feature',
              properties: personne.properties,
            });
            let updateOrCreate = "create";
            CurrentAppFactory.addpersonne(featureCollection.features[0],typePersonne,scope.idDossier,updateOrCreate)
              .then(res => {
                gaDomUtils.hideGlobalLoader();
                refreshHistorique();

                scope.afterEdit({
                  id: res.data.id, // res.data[0].id,
                });
                require('toastr').success('Personne enregistrée');
              })
              .catch(res => {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  "Erreur lors de l'enregistrement de la personne"
                );
              });
          } else {
            featureCollection.features.push(personne);
            CurrentAppFactory.updatepersonne(featureCollection)
              .then(() => {
                if (
                  angular.isUndefined(scope.dateDebutObligatoire) ||
                  !scope.dateDebutObligatoire
                ) {
                   refreshHistorique();
                } else {
                  dateUtils.convertAllDatesToTimestamps(
                    scope.infoProp.properties,
                    infoPropDateNames
                  );
                  $rootScope.$broadcast('updateHistorique', scope.infoProp);
                }

                scope.afterEdit({
                  id: scope.personne.id,
                });                
                if (typePersonne === "occupant") {
                  propOrLoc = "locataires"
                } else {
                  propOrLoc = "proprietaires"
                }
                let dateDebutNewPersone  =  new Date();      
                if (scope.personne.properties.debut) {
                  dateDebutNewPersone = new Date(scope.personne.properties.debut).setHours(8);
                }
                CurrentAppFactory.addpersonnetodossier(propOrLoc, scope.idDossier,scope.personne.id, dateDebutNewPersone,
                '',CurrentAppFactory.appCfg.main.properties.dolibarr.facturationTierce.interface.type,(new Date(scope.personne.properties.fin)).getTime() ? (new Date(scope.personne.properties.fin).setHours(8, 0)).getTime() : null).then(((result)=>{
                  require('toastr').success('Personne mise à jour');
                  scope.$emit('updateDossierName');
                  gaDomUtils.hideGlobalLoader();
                }))
              })
              .catch(res => {
                gaDomUtils.hideGlobalLoader();
                console.log(res);
                require('toastr').error(
                  "Erreur lors de l'enregistrement de la personne"
                );
              });
          }
        };

        scope.$on('refreshHistorique', function(e) {
          refreshHistorique();
        });

        scope.getInfosDuDossier = function() {
          if (!scope.personne.properties) {
            scope.personne.properties = {};
          }
          scope.personne.properties.adresse_num_rue =
            scope.propertiesDossier.adresse_num_rue;
          scope.personne.properties.adresse_num_rue_extra =
            scope.propertiesDossier.adresse_num_rue_extra;
          scope.personne.properties.adresse_rue =
            scope.propertiesDossier.adresse_rue;
          scope.personne.properties.adresse_ville =
            scope.propertiesDossier.adresse_ville;
          scope.personne.properties.adresse_cp =
            scope.propertiesDossier.adresse_cp;
          scope.personne.properties.adresse_bp =
            scope.propertiesDossier.adresse_bp;
          scope.personne.properties.adresse_pays =
            scope.propertiesDossier.adresse_pays;
          scope.personne.properties.adresse_complement =
            scope.propertiesDossier.adresse_complement;
        };
      /**
       * Renvoi true si les champs Code Postal, Rue, Pays, Nom, Civilite et DateDebut respectent les conditions
       */
      // Cette fonciton ne sert plus, puisqu'on a viré la saisie de la date de debut obligatoire
        scope.canSavePersonNoOmega = () => {
          if(scope.personne && scope.personne.properties){
            const isCpOk = 
              (scope.personne.properties.adresse_cp != undefined && 
              scope.personne.properties.adresse_cp.length === 5) ||
              scope.personne.properties.adresse_pays != 'France' ;
            const isAdresseOk = scope.personne.properties.adresse_rue != undefined;
            const isNomOk = scope.personne.properties.nom != undefined;
            const isCiviliteOk = scope.personne.properties.civilite != undefined;
            const isPaysOk = scope.personne.properties.adresse_pays != undefined;
            // la date n etant plus obligatoire, alors plus besoin de ce critère
            // const isDateOk = scope.dateDebutObligatoire && scope.infoProp || scope.personne.properties.debut  ? scope.personne.properties.debut  || scope.infoProp.properties.debut != null  // scope.infoProp.properties.debut != null
            //  : true;
            return isCpOk && isAdresseOk && isNomOk && isCiviliteOk && isPaysOk; // && isDateOk;
          } else {
            return false;
          }
          
        }

        // cleanup
        scope.$on('$destroy', function() {
          watchPersonneId();
        });
      },
    };
  };

  ancPersonne.$inject = [
    'FeatureTypeFactory',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'gaDomUtils',
    'FeatureHistoryFactory',
    '$rootScope',
    'OmegaFactory',
    'dateUtils',
  ];
  return ancPersonne;
});
