'use strict';
define(function() {
  var signatureClient = function(FeatureAttachmentFactory, $rootScope) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/signatureClient.html',
      restrict: 'EA',
      scope: {
        controle: '=',
        dossier: '=',
        isMobileBrowser: '=',
        feature: '=feature',
      },
      link: function(scope) {
        scope.drawing = false;
        var canvasContainer = document.querySelector('#canvas-container');

        if (
          canvasContainer.clientWidth === undefined ||
          canvasContainer.clientWidth === 0
        ) {
          canvasContainer = angular.element(document).find('#canvas-container');
          scope.width = Math.round(angular.element( document.querySelector( '.row' )).width() * 7 / 12 );
          scope.height = Math.round(angular.element( document.querySelector( '.row' )).height() * 5 / 12 );
        } else {
          scope.width = Math.round(canvasContainer.clientWidth * 0.9);
          scope.height = Math.round(canvasContainer.clientHeight * 0.75);
        }

        $('#canvas-container').append(
          '<canvas id="canvas" style="width:' +
            scope.width +
            'pxh;height:' +
            scope.height +
            ';" width="' +
            scope.width +
            '" height="' +
            scope.height +
            '"></canvas>'
        );
        var canvas = document.querySelector('#canvas');
        scope.signaturePad = new SignaturePad(canvas);
        scope.signaturePad.off();
        try {
          scope.src = ancAppAndroid.getSignature(
            scope.controle.id,
            scope.dossier.properties.ref_dossier
          );
          if (scope.src) scope.signaturePad.fromDataURL(scope.src);
        } catch (e) {
          e.stack;
        }

        scope.$watch('controle', function(newval, oldval) {
          if (newval && newval !== oldval) {
            try {
              scope.clearSignature();
              scope.src = ancAppAndroid.getSignature(
                scope.controle.id,
                scope.dossier.properties.ref_dossier
              );
              if (scope.src) scope.signaturePad.fromDataURL(scope.src);
            } catch (e) {
              e.stack;
            }
          }
        });

        scope.clearSignature = function() {
          if (!scope.signaturePad.isEmpty()) scope.signaturePad.clear();
        };

        scope.validerSignature = function() {
          if (!scope.signaturePad.isEmpty()) {
            scope.src = scope.signaturePad.toDataURL('image/png');
            scope.drawing = false;
            scope.signaturePad.off();

            let dossierReference = scope.dossier.properties.ref_dossier;
            let signatureDate = moment()
              .format('DD/MM/YYYY/h/mm/ss')
              .split('/')
              .join('');
            let signatureName =
              dossierReference + '_signature_' + signatureDate + '.png';

            FeatureAttachmentFactory.add(
              scope.src,
              signatureName,
              1,
              scope.feature.featuretype,
              scope.feature.id,
              false
            )
              .then(() => {
                require('toastr').success('Signature enregistrée');
                $rootScope.$broadcast('signatureUploaded', {});
              })
              .catch(e => {
                require('toastr').error("échec de l'enregistrement");
                e.stack;
              });
          }
        };

        scope.drawSignature = function() {
          scope.drawing = true;
          scope.clearSignature();
          scope.signaturePad.on();
        };

        scope.abondonModif = function() {
          if (scope.src) {
            scope.clearSignature();
            scope.signaturePad.fromDataURL(scope.src);
            scope.drawing = false;
            scope.signaturePad.off();
          }
        };
      },
    };
  };

  signatureClient.$inject = ['FeatureAttachmentFactory', '$rootScope'];
  return signatureClient;
});
