'use strict';
define(function() {
  var multicritereAnalyseConfig = function(
    AlertHpoFactory,
    HpoCarteAppFactory,
    ngDialog,
    $filter,
    $rootScope,
    gaDomUtils,
    QueryFactory,
    HpoAppServices,
    HpoMulticritereServices,
    authFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_parameters_config.html',
      restrict: 'EA',
      link: function(scope) {
        /**
         * Template
         * @type {String}
         */
        scope.multicritereTemplate =
          'js/XG/widgets/hpoapp/analye_multicritere/views/templates/analyse.tpl.html';

        /**
         * New element creation
         * @return {[type]} [description]
         */
        scope.initNewParam = function() {
          return {
            isNew: true,
            uid: HpoCarteAppFactory.getAppFactory().getRandomInteger(),
            label: 'hpo.multicritere.analyse.new_ponderation',
            type: 'ponderation',
            name: undefined,
            selected_critereas: {},
            range: {},
            date: HpoCarteAppFactory.getAppFactory().formatDate(new Date()),
            fti: undefined,
            saved: false,
            savedCassandraName: undefined,
            expression: undefined,
          };
        };

        /**
         * CRUD SERVICES
         * @type {[type]}
         */
        scope.getService = HpoMulticritereServices.getPonderation;
        scope.deleteService = HpoMulticritereServices.deletePonderation;
        scope.saveService = HpoMulticritereServices.savePonderation;

        /**
         * Widget config
         * @type {[type]}
         */
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoPonderationCritereaConfig';
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            if (dataHpo.savedata.ftiuid) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(dataHpo.savedata.ftiuid);
              if (~idx) {
                dataHpo.savedata.fti = scope.ftis[idx];
              } else {
                AlertHpoFactory.showAlertTemplateUpdate();
                dataHpo.savedata.fti = undefined;
                dataHpo.savedata.ftiuid = undefined;
              }
            } else if (dataHpo.savedata.fti) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(dataHpo.savedata.fti.uid);
              if (~idx) {
                dataHpo.savedata.fti = scope.ftis[idx];
              } else {
                AlertHpoFactory.showAlertTemplateUpdate();
                dataHpo.savedata.fti = undefined;
                dataHpo.savedata.ftiuid = undefined;
              }
            }

            if (
              scope.currentParameter.isNew &&
              scope.currentParameter.uid !== dataHpo.savedata.uid
            ) {
              dataHpo.savedata.uid = HpoCarteAppFactory.getAppFactory().getRandomInteger();
              scope.oldParameter.uid = dataHpo.savedata.uid;
            } else {
              dataHpo.savedata.uid = scope.currentParameter.uid;
            }
            if (scope.currentParameter.isNew) {
              dataHpo.savedata.isNew = true;
              dataHpo.savedata.date = scope.currentParameter.date;
              delete dataHpo.savedata.id;
              delete scope.oldParameter.id;
            } else {
              dataHpo.savedata.id = scope.currentParameter.id;
            }
            if (scope.currentParameter.name)
              dataHpo.savedata.name = scope.currentParameter.name;
            if (scope.currentParameter.commentaire)
              dataHpo.savedata.commentaire = scope.currentParameter.commentaire;
            scope.currentParameter = angular.copy(dataHpo.savedata);
            scope.currentParameter.fti = dataHpo.savedata.fti;
          }
        };
        scope.disableButtons = function() {
          return !(
            scope.currentParameter &&
            (scope.currentParameter.hasOwnProperty('type') ||
              scope.currentParameter.isNew)
          );
        };

        scope.fti_component = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'ponderation'
        )[0];
        scope.fti_critereas = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'critereas'
        )[0];
        scope.ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();
        scope.keysToCheckOblig = [
          'name',
          'type',
          'categorie',
          'fti',
          'selected_critereas',
          'range',
        ];
        scope.keysToCheckNotoblig = [
          'commentaire',
          'uid',
          'label',
          'isNew',
          'data',
          'columnDefs',
          'id',
          'date',
          'ftiuid',
          'saved',
          'savedCassandraName',
          'expression',
          'critereas',
          'critereaInformations',
        ];

        scope.addTitle = 'hpo.multicritere.analyse.add';
        scope.removeTitle = 'hpo.multicritere.analyse.remove';
        scope.elementsNames = 'hpo.multicritere.analyse.ponderations';

        /**
         * Supplements
         * @type {Boolean}
         */
        scope.hasFti = true;
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;

        scope.informations = {
          parameters: undefined,
        };

        var getAvailableCategories = function(parameters, uid, featid) {
          var categories = [];
          parameters.map(function(x) {
            if (
              !x.isNew &&
              x.categorie &&
              !~categories.indexOf(x.categorie) &&
              (!uid || x.uid !== uid) &&
              (!featid ||
                (x.ftiuid && x.ftiuid === featid) ||
                (x.fti && x.fti.uid === featid))
            )
              categories.push(x.categorie);
          });
          return categories;
        };

        var ftiparameters = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'parameters'
        )[0];
        HpoMulticritereServices.getParameters(ftiparameters.uid).then(
          function(res) {
            if (res && res.data) {
              scope.informations.parameters = res.data;
              scope.informations.categories = getAvailableCategories(
                scope.informations.parameters
              );
            }
          },
          function(res) {
            AlertHpoFactory.showErrorMessage(res);
          }
        );

        HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.ftiprevision = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        var fti_filter = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'amc_filter'
        )[0];
        const initialseFilter = function (fti) {
          var filter = '"FTI_TABLE" = \'' + fti.uid + '\'';
          var promise = QueryFactory.data(
            fti_filter.uid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          );
          promise.then(
            function (res) {
              if (res && res.data && res.data.features.length > 0) {
                let filtredFeature = res.data.features.filter(feature => feature.properties.USED == true);
                scope.clauseWhere = filtredFeature.length > 0 ? filtredFeature[0].properties.FILTER : '1=1';
              } else {
                scope.clauseWhere = '1=1';
              }
            },
            () => {
              scope.clauseWhere = '1=1';
            }
          );
        };


        /**
         * Si WCD (WeightDataChart) n'existe pas, on le crée en le partageant
         * entre ce scope et le "currentParameter".
         * Si WCD existe, on le vide, puisque l'on va tout recalculer.
         */
        const initWcd = () => {
          let iCrit;

          if (!scope.wcd) {
            scope.currentParameter.wcd = scope.wcd = [];
          }
          if (scope.wcd.length != 0) {
            for (iCrit = 0; iCrit < scope.availableCritereas.length; iCrit++) {
              delete scope.availableCritereas[iCrit].weightPercent;
            }
            scope.wcd.splice(0, scope.wcd.length);
          }
        };


        /**
         * Prépare la liste pour afficher la "bar chart" des pourcentages
         * de poids des critéres.
         *
         * @returns
         */
        const prepareWcd = () => {
          let iCrit, crit, som=0;
          //-- Parcours des critéres disponibles pour
          //-- -- calculer la somme des poids.
          //-- -- préparer l'objet qui contiendre les infos pour l'IHM
          for (iCrit = 0; iCrit < scope.availableCritereas.length; iCrit++)
          {
            crit = scope.availableCritereas[iCrit];
            if (scope.currentParameter.selected_critereas[crit.properties.IDENTIFIANT]) {
              som += scope.currentParameter.range[crit.properties.IDENTIFIANT];
              //-- Info pour IHM:  label et valeur
              //-- "crit" permet dans la boucle plus loin de positionner
              //-- la valeur du pourcentage pour la ligne du critére dans
              //-- la zone "Critères associés ..."
              scope.wcd.push({
                label: crit.properties.NAME,
                value:
                  scope.currentParameter.range[crit.properties.IDENTIFIANT],
                crit: crit
              });
            }
          }
          return som;
        };


        /**
         * Suite ticket 1812,  on calcule ici le pourcentage du poids
         * de chaque critère choisi.
         * Cela permet dans l'IHM :
         * -- d'afficher une barre représentant la part
         *    du poids de chaque critére.
         * -- d'afficher la valeur en pourcent sur la ligne du critére.
         */
        scope.getWeightChartData = function () {

          initWcd();
          const som = prepareWcd();

          const colors = ['#ffff66', '#ff7777', '#88ff88', '#9999ff',
            '#99ffff', '#ff99ff'];
          let iCol = 0, pcSom=0;
          for (let iCrit = 0; iCrit < scope.wcd.length; iCrit++)
          {
            scope.wcd[iCrit].value
              = Math.round(scope.wcd[iCrit].value * 100 / som);
            pcSom += scope.wcd[iCrit].value;
            if (pcSom > 100) {
              scope.wcd[iCrit].value -= pcSom - 100;
            }
            else if (iCrit==scope.wcd.length-1 && pcSom < 100) {
              scope.wcd[iCrit].value += 100 - pcSom;
            }
            scope.wcd[iCrit].crit.weightPercent = scope.wcd[iCrit].value;
            scope.wcd[iCrit].style = {
              'width': scope.wcd[iCrit].value + '%',
              'background-color': colors[iCol],
              'text-align': 'center',
              'overflow': 'hidden',
              'height': '100%'
            };
            if (++iCol > colors.length-1) {
              iCol = 0;
            }
          }
        };


        scope.getAvailableCritereas = function(fti) {
          var filter = '"FEATID" = \'' + fti.uid + '\'';
          QueryFactory.data(
            scope.fti_critereas.uid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          ).then(
            function(res) {
              if (res && res.data) {
                scope.availableCritereas = res.data.features;
                scope.getWeightChartData();
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };


        scope.getCritereaInfo = function(criterea) {
          HpoMulticritereServices.getCritereas(
            scope.fti_critereas.uid,
            criterea.id
          ).then(
            function(res) {
              if (res && res.data) {
                scope.newCurrentParameter = res.data[0];
                if (scope.newCurrentParameter.ftiuid) {
                  var idx = scope.ftis
                    .map(function(x) {
                      return x.uid;
                    })
                    .indexOf(scope.newCurrentParameter.ftiuid);
                  if (~idx) scope.newCurrentParameter.fti = scope.ftis[idx];
                }
                scope.readonly = true;
                ngDialog.open({
                  template:
                    'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.preview.tpl.html',
                  className:
                    'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
                  closeByDocument: false,
                  scope: scope,
                });
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.$watch('currentParameter.fti', function(newval) {
          if (newval && newval.uid) {
            scope.getAvailableCritereas(newval);
            initialseFilter(newval);
          } else {
            scope.availableCritereas = [];
          }
        });

        scope.previewExpression = function(
          currentParameter,
          expression,
          supplementAttributes,
          template_calc,
          showsaveButton,
          forceCalculate
        ) {
          if(currentParameter.isNew && !confirm($filter('translate')('hpo.common.previnormationmsg'))){
            return;
          }
          var analysis = {
            analysistool: 'calculatoranalysis',
            tableselected: currentParameter.fti,
            result: [],
            geoj: {},
            operands: [],
            attributestoselect: {},
            expression: expression || currentParameter.data,
            interpreteattributes: 'and',
            interpreteconditions: 'and',
            selectedall: false,
            attributestouseindatatable: [],
            supplementAttributes: null,
            adminConfig: HpoCarteAppFactory.getInitProvider().getHpoConfig(),
            featid_parameters: ftiparameters.uid,
            featid_critereas: scope.fti_critereas.uid,
            featid_prevision: undefined,
            parameter: currentParameter.parameter,
            criterea: currentParameter.criterea,
            prevision: currentParameter.prevision,
            parameterInformations: currentParameter.parameterInformations,
            critereaInformations: currentParameter.critereaInformations,
            previsionInformations: currentParameter.previsionInformations,
            forceCalculate:forceCalculate,
            isNew : currentParameter.isNew,
            uidCriteria : currentParameter.uid,
            fti_component:scope.fti_component.uid,
            preview_source:'ponderation',
            clauseWhere : scope.clauseWhere,
            checkClause : true,

          };
          if (scope.ftiprevision && scope.ftiprevision.uid) {
            analysis.featid_prevision = scope.ftiprevision.uid;
          }
          gaDomUtils.showGlobalLoader();
          HpoAppServices.analyseData(analysis).then(
            function(res) {
              if (res.data && res.data.status && res.data.result) {
                scope.result = {
                  geoj: res.data.result,
                  supplementAttributes: supplementAttributes || [
                    HpoCarteAppFactory.getAppFactory().getCalcAttribute(),
                  ],
                  fti: currentParameter.fti,
                  attributes: HpoCarteAppFactory.getAppFactory().getAttributesWithFilter(currentParameter.fti.attributes),
                  expression: currentParameter.data,
                  showsaveButton: showsaveButton,
                  allresultserror: res.data.allresultserror,
                };
                try {
                  if (
                    scope.result.geoj &&
                    scope.result.geoj.features &&
                    scope.result.geoj.features.length === 0
                  ) {
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')(
                        'hpo.data.prepare.analysissuccessbutnodata'
                      ),
                      true,
                      'info'
                    );
                  } else {
                    scope.datatableHeight = (window.innerHeight * 0.7).toFixed(0);
                    ngDialog.open({
                      template:
                        template_calc ||
                        'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.criterea.preview.html',
                      className:
                        'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
                      closeByDocument: false,
                      scope: scope,
                    });
                  }
                } catch (e) {
                  console.error(e.stack);
                }
              } else {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.prepare.succes'),
                  $filter('translate')('hpo.data.prepare.analysissuccess'),
                  false
                );
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.changedValRange = function(range, id) {
          if (range && id && angular.isDefined(range[id]) && range[id] > 100) {
            range[id] = 100;
          }
        };

        scope.template_calcul =
          'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.analyse.calcul.html';
        scope.calculModel = function(currentParameter) {
          var expressions = [];
          var critereas = [];
          var uids_critereas = scope.availableCritereas.map(function(x) {
            return x.properties.IDENTIFIANT;
          });
          var sommePonderation = 0;
          Object.keys(currentParameter.selected_critereas).map(function(x) {
            if (
              x &&
              currentParameter.selected_critereas[x] &&
              currentParameter.range.hasOwnProperty(x)
            ) {
              var idx = uids_critereas.indexOf(x);
              if (~idx) {
                critereas.push({
                  ponderation: currentParameter.range[x],
                  criterea: scope.availableCritereas[idx],
                });
                sommePonderation += parseInt(currentParameter.range[x]);
              }
            }
          });
          critereas.map(function(x) {
            if (x) {
              expressions.push(
                '(' +
                  parseInt(x.ponderation) / sommePonderation +
                  ' * norm({criterea(\'' +
                  x.criterea.properties.NAME +
                  '\')})' +
                  ')'
              );
              if (!currentParameter.criterea) currentParameter.criterea = {};
              currentParameter.criterea[x.criterea.properties.IDENTIFIANT] =
                x.criterea.properties.NAME;
            }
          });
          var expresion = expressions.join(' + ');
          if (currentParameter.data) {
            if (expresion != '') {
              expresion =
                '(' + expresion + ') * (' + currentParameter.data + ')';
            } else {
              expresion = currentParameter.data;
            }
          }
          currentParameter.expression = expresion;
          var suppattr = [
            HpoCarteAppFactory.getAppFactory().getCalcAttribute(),
          ];
          scope.previewExpression(
            currentParameter,
            currentParameter.expression,
            suppattr,
            scope.template_calcul,
            true,
            true
          );
        };

        scope.specialFunctionBeforeSave = function(sendata, key) {
          var expressions = [];
          var critereas = [];
          var uids_critereas = scope.availableCritereas.map(function(x) {
            return x.properties.IDENTIFIANT;
          });
          var sommePonderation = 0;
          Object.keys(sendata.selected_critereas).map(function(x) {
            if (
              x &&
              sendata.selected_critereas[x] &&
              sendata.range.hasOwnProperty(x)
            ) {
              var idx = uids_critereas.indexOf(x);
              if (~idx) {
                critereas.push({
                  ponderation: sendata.range[x],
                  criterea: scope.availableCritereas[idx],
                });
                sommePonderation += parseInt(sendata.range[x]);
              }
            }
          });
          critereas.map(function(x) {
            if (x) {
              expressions.push(
                '(' +
                  parseInt(x.ponderation) / sommePonderation +
                  ' * norm({criterea(\'' +
                  x.criterea.properties.NAME +
                  '\')})' +
                  ')'
              );
              if (!sendata.criterea) sendata.criterea = {};
              sendata.criterea[x.criterea.properties.IDENTIFIANT] =
                x.criterea.properties.NAME;
            }
          });
          var expresion = expressions.join(' + ');
          if (sendata.data)
            expresion = '(' + expresion + ') * (' + sendata.data + ')';
          if (!key) sendata.expression = expresion;
          else sendata[key] = expresion;
          sendata.type = 'simple';
        };

        scope.saveAsCriterea = function(currentParameter) {
          var sendata = angular.copy(currentParameter);
          scope.specialFunctionBeforeSave(sendata, 'data');
          gaDomUtils.showGlobalLoader();
          HpoMulticritereServices.saveCriterea(
            sendata,
            scope.fti_critereas.uid,
            true
          ).then(
            function(res) {
              if (res && res.data) {
                AlertHpoFactory.successSave();
              } else {
                AlertHpoFactory.failSave();
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.extraFunctions = [
          {
            label: 'hpo.multicritere.analyse.saveAscriterea',
            class: 'btn-primary',
            func: scope.saveAsCriterea,
          },
          {
            label: 'hpo.multicritere.analyse.calc',
            class: 'btn-success',
            func: scope.calculModel,
          },
        ];

        scope.saveResultAttribute = function(result) {
          var idx = result.supplementAttributes
            .map(function(x) {
              if (x && x.name) return x.name;
            })
            .indexOf('CALC');
          var attributesCalc;
          if (~idx) {
            attributesCalc = result.supplementAttributes[idx];
          }
          scope.newAttributeInformations = {
            existing: [],
            possible: [],
            update: 'add',
            ftiuid: result.fti.uid,
            newAttribute: {},
            updatedAttribute: undefined,
            type: {
              id: 'java.lang.Double',
              label: 'java.lang.Double',
            },
            data: result.geoj,
          };
          var attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            result.fti,
            'w'
          );
          attributesAuthorised.map(function(x) {
            if (
              x &&
              x.name !== attributesCalc.name &&
              x.type === attributesCalc.type
            ) {
              scope.newAttributeInformations.possible.push(x);
              scope.newAttributeInformations.existing.push(x.name);
            } else {
              scope.newAttributeInformations.existing.push(x.name);
            }
          });
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.analyse.save.html',
            className:
              'ngdialog-theme-plain width800 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
          dialog.then(function(data) {
            var sendata = {
              typeAttribute: data.update,
              attribute:
                data.update === 'add'
                  ? data.newAttribute
                  : data.updatedAttribute,
              featid: data.ftiuid,
              data: data.data,
            };
            gaDomUtils.showGlobalLoader();
            HpoMulticritereServices.saveScore(sendata).then(
              function(res) {
                if (res && res.data) {
                  if (sendata.type === 'add') {
                    var callback = function(res) {
                      AlertHpoFactory.successSave();
                      $rootScope.initApplicationInformations();
                    };
                    authFactory.getcurrentuser().then(callback, callback);
                  } else {
                    AlertHpoFactory.successSave();
                  }
                } else {
                  AlertHpoFactory.failSave();
                }
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          });
        };

        scope.validName = function(name, attributesNames) {
          if (name && attributesNames && attributesNames.length > 0) {
            var idx = attributesNames.indexOf(name);
            if (~idx) return false;
          }
          return /^[A-Za-z0-9-_\ éèêûùà]+$/.test(name);
        };


        scope.checkCorrectInformations = function(newAttributeInformations) {
          if (newAttributeInformations.update === 'update') {
            if (
              !newAttributeInformations.updatedAttribute ||
              !newAttributeInformations.updatedAttribute.name ||
              !newAttributeInformations.updatedAttribute.type
            )
              return true;
          } else {
            if (
              !newAttributeInformations.newAttribute ||
              !newAttributeInformations.newAttribute.name ||
              !newAttributeInformations.newAttribute.type
            )
              return true;
          }
          return false;
        };

      },
    };
  };

  multicritereAnalyseConfig.$inject = [
    'AlertHpoFactory',
    'HpoCarteAppFactory',
    'ngDialog',
    '$filter',
    '$rootScope',
    'gaDomUtils',
    'QueryFactory',
    'HpoAppServices',
    'HpoMulticritereServices',
    'authFactory',
  ];
  return multicritereAnalyseConfig;
});
