'use strict';
define(function() {
  var troncateRoundValue = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/troncate_round_value.html',
      restrict: 'EA',
      scope: {
        attr: '=',
        fti: '=',
        res: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.types = [
          {
            id: 'round',
            label: $filter('translate')(
              'hpo.data.prepare.correctiontools.correctrealinteger.round'
            ),
          },
          {
            id: 'roundsup',
            label: $filter('translate')(
              'hpo.data.prepare.correctiontools.correctrealinteger.roundsup'
            ),
          },
          {
            id: 'roundinf',
            label: $filter('translate')(
              'hpo.data.prepare.correctiontools.correctrealinteger.roundinf'
            ),
          },
        ];

        if (!scope.res)
          scope.res = {
            type: scope.types[0],
            value: null,
          };
        else {
          if (scope.res && scope.res.type && scope.res.type.id)
            var idx = scope.types
              .map(function(x) {
                return x.id;
              })
              .indexOf(scope.res.type.id);
          if (idx !== -1) scope.res.type = scope.types[idx];
        }
      },
    };
  };

  troncateRoundValue.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
  ];
  return troncateRoundValue;
});
