'use strict';
define([
  'angular',
  /**
   * Directive modelisation
   */
  'widgets/hpoapp/model/directives/model/modelSurvieHpo',
  'widgets/hpoapp/model/directives/model/modelJeuHpo',
  'widgets/hpoapp/model/directives/model/modelCalageHpo',
  'widgets/hpoapp/model/directives/model/modelValidationHpo',
  'widgets/hpoapp/model/directives/model/modelPrevisionHpo',

  /**
   * utilities
   */
  'widgets/hpoapp/model/directives/utilities/modelJeuDataHpo',
  'widgets/hpoapp/model/directives/utilities/modelSelectDataHpo',

  /**
   * Services
   */
  'widgets/hpoapp/model/services/HpoAppModelServices',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  modelSurvieHpo,
  modelJeuHpo,
  modelCalageHpo,
  modelValidationHpo,
  modelPrevisionHpo,
  modelJeuDataHpo,
  modelSelectDataHpo,
  HpoAppModelServices
) {
  // generation du module
  var gcMain = angular.module('gcMainHpoModel', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Directives
   */
  gcMain.directive('modelSurvieHpo', modelSurvieHpo);
  gcMain.directive('modelJeuHpo', modelJeuHpo);
  gcMain.directive('modelCalageHpo', modelCalageHpo);
  gcMain.directive('modelValidationHpo', modelValidationHpo);
  gcMain.directive('modelPrevisionHpo', modelPrevisionHpo);

  /**
   * utilities
   */
  gcMain.directive('modelJeuDataHpo', modelJeuDataHpo);
  gcMain.directive('modelSelectDataHpo', modelSelectDataHpo);

  /**
   * Services
   */
  gcMain.factory('HpoAppModelServices', HpoAppModelServices);

  return gcMain;
});
