'use strict';
define([
  'angular',

  /**
   * directives
   */
  'widgets/mapappv2/home_admin_data/directives/listeDataCarte',
  'widgets/mapappv2/home_admin_data/directives/addComponentConfigCarte',

  'widgets/indigauapp/home_admin_data/directives/adminCarte',
  'widgets/indigauapp/home_admin_data/directives/adminNetworkIndigau',
  'widgets/indigauapp/home_admin_data/directives/indigauChoixDensiteRegle',
  'widgets/indigauapp/home_admin_data/directives/dataOfComponent',
  'widgets/indigauapp/home_admin_data/directives/refreshRerau',

  /**
   * utilities
   */
  'widgets/mapappv2/home_admin_data/directives/utilities/data/dashboardCarte',

  /**
   * Services
   */
  'widgets/mapappv2/home_admin_data/services/CarteAppServices',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  listeDataCarte,
  addComponentConfigCarte,
  adminCarte,
  adminNetworkIndigau,
  indigauChoixDensiteRegle,
  dataOfComponent,
  refreshRerau,
  dashboardCarte,
  CarteAppServices
) {
  // generation du module
  var gcMain = angular.module('gcMainCarteHomeAdminData', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Directives
   */
  gcMain.directive('listeDataCarte', listeDataCarte);
  gcMain.directive('addComponentConfigCarte', addComponentConfigCarte);
  gcMain.directive('adminCarte', adminCarte);
  gcMain.directive('adminNetworkIndigau', adminNetworkIndigau);
  gcMain.directive('indigauChoixDensiteRegle', indigauChoixDensiteRegle);
  gcMain.directive('dataofcomponent', dataOfComponent);
  gcMain.directive('refreshRerau', refreshRerau);

  /**
   * utilities
   */
  gcMain.directive('dashboardCarte', dashboardCarte);

  /**
   * Services
   */
  gcMain.factory('CarteAppServices', CarteAppServices);

  return gcMain;
});
