'use strict';
define(function() {
  const EditTypesFactory = function ($translate) {

    const editTypes = {
      add: { name: 'add', label: 'Creation_test' },
      update: { name: 'update', label: 'Mise à jour géométrique_test' },
      reverse: { name: 'reverse', label: 'Inversion du sens d\'écoulement' },
      updateattributes: {
        name: 'updateattributes',
        label: 'Mise à jour attributaire_test',
      },
      delete: { name: 'delete', label: 'Suppression_test' },
      tohistorize: { name: 'tohistorize', label: 'A historiser' },
      todepose: { name: 'todepose', label: 'A Déposer' },
      import: { name: 'import', label: 'Import' }
    };


    const translationKeys = {
      add: 'bizedition.addedittypelabel',
      update: 'bizedition.updateedittypelabel',
      updateattributes: 'bizedition.updateattributesedittypelabel',
      delete: 'bizedition.deleteedittypelabel',
      tohistorize: 'bizedition.historicedittypelabel',
      todepose: 'bizedition.deposeedittypelabel'
    };

    // Chargement des traductions
    Object.entries(translationKeys).forEach(([type, key]) => {
      $translate(key).then(res => {
        editTypes[type].label = res;
      });
    });


    // Types d'édition liés à la suppression
    const deleteRelatedTypes = ['delete', 'tohistorize', 'todepose'];

    /**
     * Vérifie si le type d'édition n'est pas lié à une suppression
     * @param {string} editType - Le type d'édition à vérifier
     * @returns {boolean} Vrai si le type d'édition n'est pas un type de suppression
     */
    const editTypeIsNotDelete = (editType) => {
      return !deleteRelatedTypes.includes(editType);
    };


    return {
      editTypes: editTypes,
      editTypeIsNotDelete: editTypeIsNotDelete
    };
  };
  EditTypesFactory.$inject = ['$translate'];
  return EditTypesFactory;
});
