'use strict';
define(function() {
  /**
   * ToolBarElevation directive
   */
  const toolbarelevation = function(
    $timeout,
    GoogleMapsFactory,
    gcInteractions,
    $filter,
    $rootScope,
    $http
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/elevation/views/toolbarelevation.html',
      restrict: 'A',
      link: function(scope, element) {

        var m = scope.map,
          coordinates = [],
          wgs84Sphere = new ol.Sphere(6378137);
        var linearPointsLayer = new ol.layer.Vector({
          source: new ol.source.Vector(),
          zIndex: 1000,
        });
        var defaultPointStyle = new ol.style.Style({
          image: new ol.style.Circle({
            radius: 7,
            fill: new ol.style.Fill({
              color: '#444444',
            }),
          }),
        });
        var hoveredPointStyle = new ol.style.Style({
          image: new ol.style.Circle({
            radius: 13,
            fill: new ol.style.Fill({
              color: '#f4c53c',
            }),
            stroke: new ol.style.Stroke({
              color: '#444',
              width: 5,
            }),
          }),
        });
        var chartInitialized = false;
        var theChart;
        scope.linearPoints = { nb: 10 };
        // Elevation Vector/Interaction
        var elevationFeatures;
        var elevationSource = new ol.source.Vector(),
          elevationLayer = new ol.layer.Vector({
            source: elevationSource,
            style: new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: 'rgba(255,0,0,0.7)',
                width: 10,
              }),
            }),
            zIndex: 1000,
          });
        scope.elevationInteraction = new ol.interaction.Draw({
          source: elevationSource,
          type: 'LineString',
        });
        scope.elevationInteraction.setActive(false);
        scope.elevationInteraction.set('gctype', 'kis');
        scope.elevationInteraction.set('interaction', 'Draw');
        scope.elevationInteraction.set('widget', 'select');

        scope.isActivePopupChosse = false;
        scope.isActiveKeyOptions = false;

        scope.choosenkey = '';

        const apikey = $rootScope.xgos.portal.parameters.apikey;

        if (!apikey) {
          scope.chooseOpenroute = true;
          scope.disableIfNoKeyOpenroute = true;
        }
        else {
          scope.chooseOpenroute = true;
          scope.disableIfNoKeyOpenroute = !apikey.openroute;

          scope.chooseGoogle = true;
          scope.disableIfNoKeyGoogle = !apikey.google;

          scope.chooseIgn = true;
          scope.disableIfNoKeyIgn = !apikey.ign;
        }

        scope.checkedoign = function() {
          if (document.querySelector('#ignkey').checked == true) {
            scope.choosenkey  = 'ign';
          }

        };

        scope.checkedopenroute = function(){
          if (document.querySelector('#openroutekey').checked == true) {
            scope.choosenkey  = 'openroute';
          }
        };

        scope.checkedopenroute = function(){
          if (document.querySelector('#googlekey').checked == true) {
            scope.choosenkey  = 'googlekey';
          }
        };
        /**
         * Interpolate Path segments to get an array of points separated
         * by the same distance (linearPoints)
         *
         * @param feature
         * @returns {Array}
         */
        function interpolatePoints(feature) {
          // distance between points
          var distanceBetweenPoints =
              feature.getGeometry().getLength() / (scope.linearPoints.nb - 1),
            // InterpolatedPoint
            intPoint = { x: 0, y: 0 },
            // current segment progression
            progressionPercent = 0,
            // previousSegment unused length
            previousSegmentUnusedLength = 0,
            // linear points
            linearPoints = [],
            // Coordinates of the path line
            coord = feature.getGeometry().getCoordinates();
          for (var i = 1; i < coord.length; i++) {
            var segmentStart = coord[i - 1],
              segmentEnd = coord[i];
            // Create a feature from the segment coordinates which we use to get the segment length
            var tmpFeature = new ol.Feature({
                geometry: new ol.geom.LineString([segmentStart, segmentEnd]),
              }),
              segmentLength = tmpFeature.getGeometry().getLength(),
              prcentAvancee = (distanceBetweenPoints * 100) / segmentLength;
            // Fixing previous segment unused length
            if (previousSegmentUnusedLength != 0) {
              progressionPercent =
                prcentAvancee -
                (previousSegmentUnusedLength * 100) / segmentLength;
            }
            // Last point percentage may be slightly above 100
            // because of the rounding errors, so we check if the rounded value is 100
            // if(i==coord.length-1 &&  Math.round(progressionPercent)==100)
            //progressionPercent = 100;
            // While still on the same segment
            while (progressionPercent <= 100) {
              // Calculate the new X position
              intPoint.x = segmentStart[0];
              if (intPoint.x != 0) {
                // the absolute length of the segment projected on the X axis * progessionPercent
                intPoint.x +=
                  (progressionPercent * (segmentEnd[0] - segmentStart[0])) /
                  100;
              }
              // increment progression
              progressionPercent += prcentAvancee;
              // Interpolation to get the Y property of our point
              // Calculate the y2 of or interpolated point standing between x1 and x2
              // y2 = ( (x2-x1) * (y3-y1) / (x3-x1) ) + y1;
              intPoint.y =
                ((intPoint.x - segmentStart[0]) *
                  (segmentEnd[1] - segmentStart[1])) /
                  (segmentEnd[0] - segmentStart[0]) +
                segmentStart[1];
              // save new point
              linearPoints.push([intPoint.x, intPoint.y]);
            }
            //console.log(progressionPercent);
            // When the next point is on the next segment, we store the remaining distance
            // on the current segment
            previousSegmentUnusedLength =
              (segmentLength * (100 - (progressionPercent - prcentAvancee))) /
              100;
          }
          // last point is always the path end
          if (linearPoints.length == scope.linearPoints.nb) linearPoints.pop();
          linearPoints.push(coord[coord.length - 1]);
          return linearPoints;
        }
        var btnElt = $(element.children()[0]);
        scope.clearMapElemention = function() {



          btnElt.addClass('btn-default');



          scope.panelsManager.removePanel('elevationView');
          try {
            scope.panelsManager.removePanel('elevationapikey');

            scope.elevationInteraction.setActive(false);
            m.removeInteraction(scope.elevationInteraction);
            m.removeLayer(elevationLayer);
            elevationLayer.getSource().clear();
            m.removeLayer(linearPointsLayer);
            linearPointsLayer.getSource().clear();
          } catch (e) {
            console.log('init');
          }

          scope.isActivePopupChosse = false;


        };

        scope.refreshMap = (selectedKey) => {
            if(selectedKey){
              getElevation(selectedKey);
            }
        };
        scope.addInteractionForNew = function() {
          scope.isActiveKeyOptions = true;

          btnElt.addClass('btn-info');
          scope.panelsManager.addPanel({
            id: 'elevationView',
            stickToRight: true,
            templateUrl:
              'js/XG/widgets/mapapp/elevation/views/elevationcontrol.html',
            scope: scope,
            visible: false,
            stickToBorder: true,
          });

          GoogleMapsFactory.lazyLoad().then(function() {
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            scope.elevationInteraction.setActive(true);
            m.addInteraction(scope.elevationInteraction);
            scope.elevationInteraction.on('drawend', function(e) {
              elevationFeatures = e.feature;
              scope.elevationInteraction.setActive(false);
              m.removeInteraction(scope.elevationInteraction);
              m.addLayer(elevationLayer);
              m.addLayer(linearPointsLayer);
              drawPath();
            });
            scope.isActive = true;

          });

          scope.isActivePopupChosse = true;


        };
        /* Click on the GoogleStreetView toolbar button*/
        btnElt.bind('click', function() {
          btnElt.removeClass('btn-info btn-default');
          if (scope.isActive) {
            scope.elevationInteraction.setActive(false);
            scope.clearMapElemention();
            scope.isActive = false;
          } else {
            scope.addInteractionForNew();
          }
        });
        scope.$on('closeToolsBar_toolbarelevation', function(event) {
          closeToolbarElevation();
        });
        function closeToolbarElevation() {
          btnElt.removeClass('btn-info btn-default');
          scope.clearMapElemention();
          scope.isActive = false;
          scope.elevationInteraction.setActive(false);
        }
        /**
         * drawPath
         */
        function drawPath() {
          // Path Feature
          var feature = elevationFeatures,
            coord = feature.getGeometry().getCoordinates()[0];
          // Interpolation of points
          var linearPoints = interpolatePoints(feature);
          // First point
          coordinates = [];
          coordinates.push({
            d: 0,
            c: linearPoints[0],
          });
          // Other points
          for (var i = 1; i < linearPoints.length; i++) {
            coordinates.push({
              d: wgs84Sphere.haversineDistance(
                ol.proj.transform(
                  linearPoints[i - 1],
                  m.getView().getProjection(),
                  'EPSG:4326'
                ),
                ol.proj.transform(
                  linearPoints[i],
                  m.getView().getProjection(),
                  'EPSG:4326'
                )
              ),
              c: linearPoints[i],
            });
          }
          linearPointsLayer.getSource().clear();
          var featuresToadd = [];
          console.log(linearPoints);
          var animatePoints = function(n) {
            var toFeature = new ol.Feature({
              geometry: new ol.geom.Point([
                linearPoints[n][0],
                linearPoints[n][1],
              ]),
            });
            toFeature.setStyle(defaultPointStyle);
            toFeature.setId('point' + (n + 1));
            featuresToadd.push(toFeature);
            // linearPointsLayer.getSource().addFeature(toFeature);
            /* var points = linearPointsLayer.getSource().getFeatures(),
                            test = points[0];
                        var testtest = test.getGeometry().getCoordinates();
                        console.log(testtest);*/
            if (n < linearPoints.length - 1) {
              $timeout(function() {
                animatePoints(n + 1);
              }, 1000 / linearPoints.length);
            } else {
              linearPointsLayer.getSource().addFeatures(featuresToadd);
            }
          };
          animatePoints(0);
          getElevation(scope.choosenApiKey);
        }
        /*scope.$watch(function(){
                    return scope.linearPoints.nb;
                }, function(n,old){
                    if(n==old || !angular.isNumber(old) || old<=0) return;
                    drawPath();
                }, true);*/
        /**
         * Set number of elevation points
         */
        scope.setElevationPoints = function(selectedKey) {
          // Toujours mettre à jour le scope.choosenApiKey pour qu'il applique le changement avec le même api affiché
          scope.choosenApiKey = selectedKey;
          var nb = scope.linearPoints.nb;
          if (angular.isNumber(nb)) {
            drawPath();
          }
        };
        /**
         * getElevationArray
         */
        scope.getElevationArray = function() {
          var csv = [];
          var points = linearPointsLayer.getSource().getFeatures();
          points.forEach(function(feature, index) {
            var coord = feature.getGeometry().getCoordinates();
            csv.push({
              x: coord[0],
              y: coord[1],
              z: elevationResults[index],
            });
          });
          return csv;
        };
        /**
         * Highlight a point when hovered in chartist
         * @param index
         */
        var hoveredIndex;
        var highLightPoint = function() {
          var hoveredPoint = linearPointsLayer
            .getSource()
            .getFeatureById('point' + hoveredIndex);
          if (hoveredPoint !== null) hoveredPoint.setStyle(hoveredPointStyle);
        };
        /**
         * Reset hovered points style
         */
        var clearHighLightPoint = function() {
          var hoveredPoint = linearPointsLayer
            .getSource()
            .getFeatureById('point' + hoveredIndex);
          if (hoveredPoint !== null) hoveredPoint.setStyle(defaultPointStyle);
        };
        function getTheElevationFromGoogleOrOpenroute(
          results,
          status,
          typeOfApi
        ) {
          if (
            (typeOfApi == 'google' &&
              status == google.maps.ElevationStatus.OK) ||
            (typeOfApi == 'openroute' && results.status == 200
            || typeOfApi == 'IGN' && results.status == 200 )
          ) {
            scope.panelsManager.showPanel('elevationView');
            if (typeOfApi == 'google') {
              elevationResults = results.map(function(r) {
                return Math.round(r.elevation * 10) / 10;
              });
            } else {
              elevationResults = results.data.geometry.coordinates.map(function(
                r
              ) {
                return Math.round(r[2] * 10) / 10;
              });
            }

            var data = {
              labels: coordinates.map(function(c) {
                return Math.round(c.d * 100) / 100;
              }),
              series: [
                {
                  name: 'Elevation',
                  data: elevationResults,
                },
              ],
            };
            // console.log($('#elevationView'));
            theChart = new Chartist.Line('#elevationView .ct-chart', data, {
              fullWidth: true,
            });
            if (!chartInitialized) {
              var seq = 0,
                delays = 80,
                durations = 500;
              // Once the chart is fully created we reset the sequence
              theChart.on('created', function() {
                seq = 0;
              });
              // On each drawn element by Chartist we use the Chartist.Svg API
              // to trigger SMIL animations
              theChart.on('draw', function(data) {
                seq++;
                if (data.type === 'line') {
                  data.element.animate({
                    opacity: {
                      begin: seq * delays + 1000,
                      dur: durations,
                      from: 0,
                      to: 1,
                    },
                  });
                } else if (data.type === 'label' && data.axis === 'x') {
                  data.element.animate({
                    y: {
                      begin: seq * delays,
                      dur: durations,
                      from: data.y + 100,
                      to: data.y,
                      // We can specify an easing function from Chartist.Svg.Easing
                      easing: 'easeOutQuart',
                    },
                  });
                } else if (data.type === 'label' && data.axis === 'y') {
                  data.element.animate({
                    x: {
                      begin: seq * delays,
                      dur: durations,
                      from: data.x - 100,
                      to: data.x,
                      easing: 'easeOutQuart',
                    },
                  });
                } else if (data.type === 'point') {
                  data.element.animate({
                    x1: {
                      begin: seq * delays,
                      dur: durations,
                      from: data.x - 10,
                      to: data.x,
                      easing: 'easeOutQuart',
                    },
                    x2: {
                      begin: seq * delays,
                      dur: durations,
                      from: data.x - 10,
                      to: data.x,
                      easing: 'easeOutQuart',
                    },
                    opacity: {
                      begin: seq * delays,
                      dur: durations,
                      from: 0,
                      to: 1,
                      easing: 'easeOutQuart',
                    },
                  });
                } else if (data.type === 'grid') {
                  // Using data.axis we get x or y which we can use to construct
                  // our animation definition objects
                  var pos1Animation = {
                    begin: seq * delays,
                    dur: durations,
                    from: data[data.axis + '1'] - 30,
                    to: data[data.axis + '1'],
                    easing: 'easeOutQuart',
                  };
                  var pos2Animation = {
                    begin: seq * delays,
                    dur: durations,
                    from: data[data.axis + '2'] - 100,
                    to: data[data.axis + '2'],
                    easing: 'easeOutQuart',
                  };
                  var animations = {};
                  animations[data.axis + '1'] = pos1Animation;
                  animations[data.axis + '2'] = pos2Animation;
                  animations['opacity'] = {
                    begin: seq * delays,
                    dur: durations,
                    from: 0,
                    to: 1,
                    easing: 'easeOutQuart',
                  };
                  data.element.animate(animations);
                }
              });
              chartInitialized = true;
            }
            var $chart = $('#elevationView .ct-chart');
            var $toolTip = $chart
              .append('<div class="elevation_tooltip"></div>')
              .find('.elevation_tooltip')
              .hide();
            $chart.on('mouseenter', '.ct-point', function() {
              var $point = $(this),
                value = $point.attr('ct:value'),
                seriesName = $point.parent().attr('ct:series-name'),
                pointIndex = $point
                  .parent()
                  .children()
                  .index(this);
              hoveredIndex = pointIndex;
              //               console.log(pointIndex);
              highLightPoint();
              $toolTip.html(seriesName + '<br>' + value + 'm').show();
            });
            $chart.on('mouseleave', '.ct-point', function() {
              clearHighLightPoint();
              $toolTip.hide();
            });
            $chart.on('mousemove', function(event) {
              $toolTip.css({
                left:
                  (event.offsetX || event.originalEvent.layerX) -
                  $toolTip.width() / 2 -
                  10 +
                  100,
                top:
                  (event.offsetY || event.originalEvent.layerY) -
                  $toolTip.height() -
                  40,
              });
            });
          } else {
            closeToolbarElevation();
            require('toastr').error(
              'Elevation service failed due to: ' + status
            );
          }
        }

        function coordinatesToLatLng(coords, projection){
          var transformCoordinates = ol.proj.transform(
              [coords[0], coords[1]],
              projection,
              'EPSG:4326'


            ),
            lat = Math.round(transformCoordinates[1] * 10000000) / 10000000,
            lng = Math.round(transformCoordinates[0] * 10000000) / 10000000;
          return [lng, lat];
        }

        const checkTheApiKey = () => {
          const googleKey = scope.apiKey.google;
          // Verifier si l'API key est valide
          const url = `https://maps.googleapis.com/maps/api/elevation/json?locations=0,0&key=${googleKey}`;
          
          return $http.get(url)
            .then(response => {
              if (response.data.status === 'OK') {
                return true;
              } else {
                require('toastr').error('Elevation service failed due to: Google maps api key error');
                return false;
              }
            })
            .catch(error => {
              require('toastr').error('Elevation service failed due to: Google maps api key error');
              return false;
            });
  
        }
        /**
         * Return the elevation data for the drawn line
         */
        var elevationResults;
        var getElevation = function(selectedKey) {
          scope.apiKey = $rootScope.xgos.portal.parameters.apikey;

          // Filtrer 'what3words' et clés invalides (vides ou undefined)
          scope.apiKey = Object.fromEntries(
            Object.entries(scope.apiKey).filter(
              ([key, value]) => value !== '' && value !== undefined && key !== 'what3words'
            )
          );
      
          let typeOfApi;
      
          if (selectedKey) {
            // Vérifier  si la clé est définie et contient une valeur non vide
            if (scope.apiKey[selectedKey] && scope.apiKey[selectedKey].trim() != '') {
              typeOfApi = selectedKey;
            } else {
              require('toastr').warning($filter('translate')('elevation.emptyApiKey'));
              return;
            }
          } else {
            // Cas où aucune clé n'est sélectionnée
            const availableKeys = Object.keys(scope.apiKey);
    
            if (availableKeys.length === 0) {
              // Aucun API Key disponible
              closeToolbarElevation();
              require('toastr').warning($filter('translate')('elevation.emptyApiKey'));
            } else if (availableKeys.length === 1) {
              // Une seule clé disponible, la sélectionner automatiquement
              typeOfApi = availableKeys[0];
              scope.choosenApiKey = typeOfApi;
            } else {
              // Plusieurs clés disponibles
              typeOfApi = scope.choosenApiKey = GoogleMapsFactory.typeOfApiUsed();
            }
          }
      
          console.log(typeOfApi);
          if (typeOfApi == 'ign') {
            var newCoordinates = [];
            for (var i=0; i<coordinates.length; i++){
              console.log(coordinates[i].c);
              var coords =  coordinatesToLatLng(coordinates[i].c,  m.getView().getProjection());
              console.log(coords);
              newCoordinates.push(coords);
            }
            console.log(coordinates);
            console.log(newCoordinates);
            //var endRequest = 'sampling=10&';
            var lon = 'lon=';
            for(var k=0; k<newCoordinates.length - 1; k++){
              lon = lon + newCoordinates[k][0]+'|';
            }
            lon = lon + newCoordinates[newCoordinates.length -1][0];

            var lat = '&lat=';
            for(var l=0; l<newCoordinates.length - 1; l++){
              lat = lat + newCoordinates[l][1]+'|';
            }
            lat = lat + newCoordinates[newCoordinates.length -1][1];

            var request = 'https://data.geopf.fr/altimetrie/1.0/calcul/alti/rest/elevation.json?'+lon+lat+'&resource=ign_rge_alti_wld&delimiter=|&indent=true&measures=false&zonly=false';

            fetch(
              request, {
                method: 'GET',
                mode: 'cors',
                cache: 'default'
              }
            ).then(response => {
              // reponse en json
              console.log('reponse du nouveau geocodeur : ',response);
              response.json().then(data =>{
                // results.data.geometry.coordinates
                var tosend = {};
                tosend.status = 200;

                tosend.data = {};
                tosend.data.geometry = {};
                tosend.data.geometry.coordinates = [];

                for (var i=0; i<data.elevations.length; i++){
                  var coords = [];
                  coords[0] = (data.elevations[i]).lon;
                  coords[1] = (data.elevations[i]).lat;
                  coords[2] = (data.elevations[i]).z;
                  tosend.data.geometry.coordinates.push(coords);

                }
                getTheElevationFromGoogleOrOpenroute(tosend, tosend.status, 'IGN');
              });
            });

          }
          //  transform into lat lng
          if (typeOfApi != 'none') {
            var coordinatesLatLng = [];
            for (var i = 0; i < coordinates.length; i++) {
              coordinatesLatLng.push(
                GoogleMapsFactory.coordinatesToLatLng(
                  coordinates[i].c,
                  m.getView().getProjection(),
                  typeOfApi
                )
              );
            }
            if (typeOfApi == 'google') {
              checkTheApiKey().then((isValidKey) => {
                if (!isValidKey) {
                  closeToolbarElevation();
                } else {
                  new google.maps.ElevationService().getElevationForLocations(
                    {
                      locations: coordinatesLatLng,
                    },
                    (results, status) => {
                      getTheElevationFromGoogleOrOpenroute(
                        results,
                        status,
                        typeOfApi
                      );
                    }
                  );
                }
              });
             
            } else if (typeOfApi == 'openroute') {
              GoogleMapsFactory.getElevationFromOpenRoute(
                coordinatesLatLng
              ).then(
                function(results) {
                  getTheElevationFromGoogleOrOpenroute(
                    results,
                    status,
                    typeOfApi
                  );
                },
                () => {
                  closeToolbarElevation();
                  require('toastr').error(
                    'Elevation service failed due to: Openroute api error'
                  );
                }
              );
            }
          } else {
            swal({
              title: $filter('translate')('apierrormessage.noApiKey'),
              text: $filter('translate')('apierrormessage.visitWikiApi'),
              type: 'error',
              showCancelButton: false,
              confirmButtonColor: '#CCC',
              confirmButtonText: $filter('translate')('common.ok'),
              closeOnConfirm: true,
            });
          }
        };
      },
    };
  };
  toolbarelevation.$inject = [
    '$timeout',
    'GoogleMapsFactory',
    'gcInteractions',
    '$filter',
    '$rootScope',
    '$http',
  ];
  return toolbarelevation;
});
