'use strict';
define(function() {
  var meteowidget = function(gcPropertiesLayers) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/openweathermap/views/meteowidget.html',
      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        scope.meteolayers = [
          { label: 'cloud' },
          { label: 'pressure' },
          { label: 'precipitation' },
        ];

        /**
         *
         */
        scope.add = function(layer) {
          if (layer == 'cloud') {
            var nuages = new ol.layer.Tile({
              label: 'Nuages',
              source: new ol.source.XYZ({
                //attributions: [attribution],
                //url:  "http://2.tile.openweathermap.org/map/clouds/{z}/{x}/{y}/256/png"
                url:
                  'http://2.tile.openweathermap.org/map/clouds/{z}/{x}/{y}.png',
              }),
            });
            gcPropertiesLayers(nuages);
            scope.map.addLayer(nuages);
          }
          if (layer == 'pressure') {
            var nuages = new ol.layer.Tile({
              label: 'Pressions',
              source: new ol.source.XYZ({
                //attributions: [attribution],
                //url:  "http://2.tile.openweathermap.org/map/pressure_cntr/{z}/{x}/{y}/256/png"
                url:
                  'http://2.tile.openweathermap.org/map/pressure_cntr/{z}/{x}/{y}.png',
              }),
            });
            gcPropertiesLayers(nuages);
            scope.map.addLayer(nuages);
          }
          if (layer == 'precipitation') {
            var nuages = new ol.layer.Tile({
              label: 'Precipitation',
              source: new ol.source.XYZ({
                //attributions: [attribution],
                //url:  "http://2.tile.openweathermap.org/map/precipitation/{z}/{x}/{y}/256/png"
                url:
                  'http://2.tile.openweathermap.org/map/precipitation/{z}/{x}/{y}.png',
              }),
            });
            gcPropertiesLayers(nuages);
            scope.map.addLayer(nuages);
          }
        };
      },
    };
  };

  meteowidget.$inject = ['gcPropertiesLayers'];
  return meteowidget;
});
