'use strict';
define(function() {
  var selectedfeaturestree = function(
    $http,
    extendedNgDialog,
    ParametersFactory,
    EditFactory,
    SelectManager,
    gclayers,
    QueryFactory,
    $translate,
    GeometryFactory,
    gcPopup,
    FeatureTypeFactory,
    ChartsFactory,
    $filter,
    $timeout,
    $rootScope,
    FeatureAttachmentFactory,
    gcStyleFactory,
    FontAwesomeFactory,
    DocumentFactory,
    $q,
    ConfigFactory,
    FilesFactory,
    ReportIndicatorFactory,
    ngDialog,
    ngTableParams,
    ActionsFactory,
    gaJsUtils,
    ChartLocaliseFactory,
    ActionsManager,
    bizeditProvider,
    mapJsUtils,
    EditTypesFactory,
    EditRulesFactory,
    MajicFactory,
    selecttoolbypointutilitiesservice,
    RightsFactory,
    ObjectFilesFactory
  ) {
    /* Recuperation des labels pour les titres des onglets */
    var title_tab_info = 'Information';
    $translate('selectfeaturetree.tab_information').then(function(res) {
      title_tab_info = res;
    });
    var title_tab_rel = 'Relation';
    $translate('selectfeaturetree.tab_relation').then(function(res) {
      title_tab_rel = res;
    });
    var title_tab_attach = 'Attachments';
    $translate('selectfeaturetree.tab_attachment').then(function(res) {
      title_tab_attach = res;
    });
    var statis = 'statistique';
    $translate('selectfeaturetree.statistique').then(function(res) {
      statis = res;
    });
    // Fin de la recuperation des traductions
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selecttoolbypointutilities/views/selectedfeaturestree.html',
      controller: [
        '$scope',
        '$element',
        '$attrs',
        function($scope) {
          $scope.feattree = {};
          $scope.featdata = [];
          $scope.result = {};
          $scope.currentselect = {};
          $scope.currentselectfti = null;
          $scope.relatedfeature = {};
          $scope.tableResult = {
            elements: {
              features: [],
            },
          };
          // liste des composants comportant des objets reliés à l'objet en cours
          $scope.availableRelatedFeatureIds = [];
          $scope.currentselectedActionOnComponentTable = {
            value: {},
          };
          // les variables qui definissent les titres sont recuperees dans la fonctions precedente
          $scope.tabs = [
            {
              title: title_tab_info,
            },
            {
              title: title_tab_rel,
            },
            {
              title: title_tab_attach,
            },
          ];

          $scope.tabs.activeTab = 0;
          $scope.csvseparator = ';';
        },
      ],
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        var map = scope.map;
        scope.result = SelectManager.getfeatures();
        scope.fontAwesome = FontAwesomeFactory.FontAwesomeFactory.map(function(
          x
        ) {
          return x.unicode + ' ' + x.name.replace('fa-', '');
        });
        function getDefaultTemplate() {
          var style;
          switch (scope.currentselectfti.typeInfo) {
            case 'POINT':
              style = {
                type: scope.currentselectfti.typeInfo,
                image: {
                  fill: {
                    color: '#ffff00',
                  },
                  radius: 10,
                },
              };
              break;
            case 'LINE':
              style = {
                type: scope.currentselectfti.typeInfo,
                stroke: {
                  color: '#ff8000',
                  width: 5,
                },
              };
              break;
            case 'POLYGON':
              style = {
                type: scope.currentselectfti.typeInfo,
                fill: {
                  color: '#ffff00',
                },
                stroke: {
                  color: '#ff8000',
                  width: 5,
                },
              };
              break;
          }
          return style;
        }

        function getDefaultStyle(styleTemplate) {
          var style;
          switch (styleTemplate.type) {
            case 'POINT':
              switch (styleTemplate.styleChoice) {
                case $filter('translate')('annotations.circle'):
                  var style = {
                    image: new ol.style.Circle({
                      radius: styleTemplate.image.radius,
                      fill: new ol.style.Fill({
                        color: styleTemplate.image.fill.color,
                      }),
                    }),
                  };
                  break;
                case $filter('translate')('annotations.icon'):
                  var unicodeindex = scope.fontAwesome.indexOf(
                    styleTemplate.text
                  );
                  var unicode =
                    FontAwesomeFactory.FontAwesomeFactory[unicodeindex].unicode;
                  var style = {
                    text: new ol.style.Text({
                      text: String.fromCharCode(
                        unicode.replace('&#x', '0x').replace(';', '')
                      ),
                      font:
                        'normal ' +
                        styleTemplate.image.radius +
                        'px FontAwesome',
                      textBaseline: 'Bottom',
                      fill: new ol.style.Fill({
                        color: styleTemplate.image.fill.color,
                      }),
                    }),
                  };
              }
              break;
            case 'LINE':
              style = {
                stroke: new ol.style.Stroke({
                  color: styleTemplate.stroke.color,
                  width: styleTemplate.stroke.width,
                }),
              };
              break;
            case 'POLYGON':
              style = {
                fill: new ol.style.Fill({
                  color: stylfeTemplate.fill.color,
                }),
                stroke: new ol.style.Stroke({
                  color: styleTemplate.stroke.color,
                  width: styleTemplate.stroke.width,
                }),
              };
              break;
          }
          return new ol.style.Style(style);
        }

        //GESTION DES CHART DIAGRAMME
        scope.selectChart = { config: {}, data: {} };
        scope.vopenPie = function() {
          // je recupere le geojson que je veux representer
          scope.selectChart.data = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          scope.selectChart.config.ftiUidData = scope.currentselectfti.uid;
          scope.selectChart.config.ftiNameData = scope.currentselectfti.name;
          if (scope.stylepopover) scope.stylepopover.close();
          scope.chartpopover = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverChart.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('annotations.style'),
            draggable: true,
          });
        };

        scope.styleFunction = function(feature, resolution) {
          return [
            new ol.style.Style({
              image: new ol.style.Icon({
                scale: 1,
                src: feature.get('icon'),
              }),
            }),
          ];
        };

        scope.applyCharts = function() {
          ChartLocaliseFactory.datastats(scope.selectChart).then(function(
            rdata
          ) {
            var vectorSource = new ol.source.Vector({
              features: new ol.format.GeoJSON().readFeatures(rdata.data),
            });

            var vectorLayer = new ol.layer.Vector({
              source: vectorSource,
              style: scope.styleFunction,
            });

            scope.map.addLayer(vectorLayer);
          });
        };

        // GESTION DES STYLES
        scope.vopenStyle = function() {
          scope.pointsTypes = [
            $filter('translate')('annotations.circle'),
            $filter('translate')('annotations.icon'),
          ];
          scope.fontAwesome = FontAwesomeFactory.FontAwesomeFactory.map(
            function(x) {
              return x.unicode + ' ' + x.name.replace('fa-', '');
            }
          );
          scope.geoj = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          if (angular.isDefined(scope.geoj.features[0].kiscurrentstyle)) {
            scope.styleTemplate = angular.copy(
              scope.geoj.features[0].kiscurrentstyle
            );
          } else {
            scope.styleTemplate = getDefaultTemplate();
          }
          if (scope.stylepopover) scope.stylepopover.close();
          scope.stylepopover = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverStyle.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('annotations.style'),
            draggable: true,
          });
        };

        scope.config = {
          fullfilter: {},
        };
        scope.zoomOndata = function() {
          scope.displayAttributesType = {};
          gclayers.clearhighLightFeatures();
          scope.currentselectfti.attributes.map(function(a) {
            var fieldType = '';
            var displayKey = false;

            switch (a.type) {
              case 'java.util.Date':
              case 'java.sql.Timestamp':
              case 'java.sql.Time':
              case 'java.sql.Date':
                fieldType = 'date';
                break;
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Integer':
                fieldType = 'number';
                break;
              case 'java.lang.Boolean':
                fieldType = 'boolean';
                break;
              case 'ObjectsArray':
                fieldType = 'ObjectsArray';
                displayKey = a.key;
                break;
              default:
                fieldType = 'string';
                break;
            }

            scope.displayAttributesType[a.name] = {
              type: a.type,
              fieldType: fieldType,
              filterType: a.filterType || 'default',
            };

            if (displayKey) {
              scope.displayAttributesType[a.name].key = displayKey;
            }
          });
          scope.fc = {
            type: 'FeatureCollection',
            features: scope.geoj.features.filter(function(item) {
              var showItem = true;

              for (var index in scope.config.fullfilter) {
                var c = scope.config.fullfilter[index],
                  value = c.value,
                  symbol = c.symbol;

                if (value) {
                  if (scope.displayAttributesType[index].fieldType != 'date') {
                    var cmp = '' + item.properties[index];
                    if (scope.config.case) {
                      if (
                        !item.properties.hasOwnProperty(index) ||
                        cmp.indexOf(value) == -1
                      ) {
                        showItem = false;
                      }
                    } else {
                      if (
                        !item.properties.hasOwnProperty(index) ||
                        cmp
                          .toLocaleLowerCase()
                          .indexOf(value.toLocaleLowerCase()) == -1
                      ) {
                        showItem = false;
                      }
                    }
                  } else {
                    var dateCmp = new Date(value);
                    var dateLigne = new Date(item.properties[index]);
                    if (dateCmp.getTime() > 0 && dateLigne.getTime() > 0) {
                      if (symbol == '=')
                        showItem = dateLigne.getTime() == dateCmp.getTime();
                      if (symbol == '>')
                        showItem = dateLigne.getTime() > dateCmp.getTime();
                      if (symbol == '<')
                        showItem = dateLigne.getTime() < dateCmp.getTime();
                      if (symbol == '>=')
                        showItem = dateLigne.getTime() >= dateCmp.getTime();
                      if (symbol == '<=')
                        showItem = dateLigne.getTime() <= dateCmp.getTime();
                      if (symbol == 'between') {
                        var dateMax = new Date(c.valuemax);
                        if (dateMax.getTime() > 0) {
                          showItem =
                            dateLigne.getTime() >= dateCmp.getTime() &&
                            dateLigne.getTime() <= dateMax.getTime();
                        }
                      }
                    }
                  }
                }
              }
              if (showItem) return item;
            }),
          };

          var geojsonreader = new ol.format.GeoJSON();
          var g = geojsonreader.readFeatures(scope.fc);
          var extent = ol.extent.createEmpty();
          g.forEach(function(feature, index) {
            ol.extent.extend(extent, feature.getGeometry().getExtent());
            gclayers.addhighLightFeatures(scope.fc.features[index].id);
          });
          scope.map.getView().fit(extent, scope.map.getSize());
        };

        scope.applyFeature = function() {
          var style = getDefaultStyle(scope.styleTemplate);
          var features = gclayers.getselectSource().getFeatures();
          var Ids = scope.geoj.features.map(function(x) {
            return x.id;
          });
          SelectManager.getfeatures().features.map(function(x) {
            if (Ids.indexOf(x.id) !== -1) {
              x.kiscurrentstyle = angular.copy(scope.styleTemplate);
            }
          });
          features.map(function(feature) {
            if (Ids.indexOf(feature.getId()) !== -1) feature.setStyle(style);
          });
        };

        scope.cancelStyle = function() {
          var features = gclayers.getselectSource().getFeatures();
          var Ids = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          ).features.map(function(x) {
            delete x.kiscurrentstyle;
            return x.id;
          });
          features.map(function(feature) {
            if (Ids.indexOf(feature.getId()) !== -1)
              feature.setStyle(gcStyleFactory.getStyle('select'));
          });
          scope.styleTemplate = getDefaultTemplate();
        };

        /**
         * [vopenStats Ouverture de la page des statistique]
         * @return {nothig} [nothing]
         */
        scope.vopenStats = function() {
          console.log(scope.result);
          var result = scope.result;
          if (result && result.features && result.features.length > 0)
            result.features.map(function(f) {
              if (f && f.id && f.id.indexOf('.') !== -1) {
                var index = FeatureTypeFactory.resources.featuretypes
                  .map(function(x) {
                    return x.name;
                  })
                  .indexOf(f.id.split('.')[0]);
                if (index !== -1) {
                  var fti = FeatureTypeFactory.resources.featuretypes[index];
                  f.uid = fti.uid;
                }
              }
            });
          ChartsFactory.datastats(result).then(function(res) {
            scope.resstats = res.data;
            if (scope.resstats.length) {
              scope.resstats[0].area =
                Math.round(res.data[0].area * 100) / 100 + ' ' + 'm²';
              scope.resstats[0].perimeter =
                Math.round(res.data[0].perimeter * 100) / 100 + ' ' + 'm';
            }

            extendedNgDialog.open({
              template:
                'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverStatistiques.html',
              className: 'ngdialog-theme-plain width400 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title: statis,
              draggable: true,
            });
          });
        };


        scope.viewsattachement = (name, fti, feature) => {
          let id = gaJsUtils.getIdInCaseEsriId(feature, fti);
          FeatureAttachmentFactory.getdownloadurl(name, fti.uid, id).then(
            (res) => {
              console.log(res);
              window.open(escape(res.data));
            });
        };


        /**
         * [ContainfeatureClass description]
         * @param {[type]}
         */
        scope.containfeatureClass = function(featuretypename) {
          for (var i = 0, length = scope.featdata.length; i < length; i++) {
            if (scope.featdata[i].label == featuretypename) {
              return true;
            }
            // `chunk` is each member of the array.
          }
          return false;
        };
        //data for datatable
        scope.saveSelect = false;
        scope.openSelect = false;
        scope.collectionList = [];
        scope.selectedCollec = null;
        scope.editmode = false;
        scope.filtertemp = { filter: '' };
        scope.expression = { filter: '' };
        scope.visibleInfo = false;

        scope.openeditmode = function() {
          if (scope.editmode) {
            scope.editmode = false;
          } else {
            scope.editmode = true;
          }
        };

        scope.opengraph = function() {
          console.log(scope.result);
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/charts/SelectedCharts.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('layermanager.charts'),
            draggable: true,
          });
        };

        scope.openExpressionUpdate = function() {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverExpressionUpdate.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: 'Calculatrice Expressions',
            draggable: true,
          });
        };

        scope.updateAttribute = function(att) {

          // KIS-2993: mise à jour d'un attribut restreint (Table ou Domain)
          const attribute = scope.currentselectfti.attributes.find(attr => attr.name === att);
          const hasRestriction = attribute !== undefined && attribute.restrictions.length > 0;

          if (attribute) {
            swal(
              {
                title: $filter('translate')('layermanager.updateAttribute.title'),
                text: $filter('translate')('layermanager.updateAttribute.text1') + attribute.alias
                      + $filter('translate')('layermanager.updateAttribute.text2'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'rgb(92, 184, 92)',
                confirmButtonText: $filter('translate')('common.ok'),
                cancelButtonText: $filter('translate')('common.cancel'),
                closeOnConfirm: true,
              },
              (isConfirm) => {
                if (isConfirm) {
                  scope.submitUpdateAttribute(att, hasRestriction);
                }
              });
          } else {
            require('toastr').error(
              $filter('translate')('layermanager.no_attribute_layer')
            );
          }
        };

        /**
         * KIS-3537: code en triple
         * @param att
         * @param hasRestriction
         */
        scope.submitUpdateAttribute = (att, hasRestriction) => {
          const sdata = {
            attribute: att,
            listfid: SelectManager.getFeaturesIdByftiType(scope.currentselectfti.name),
            expression: hasRestriction ? `'${scope.expression.filter}'` : scope.expression.filter,
          };
          console.log(sdata);
          EditFactory.updateexpression(sdata, scope.currentselectfti.uid).then(
            (res) => {
              scope.geoj = res.data;
              SelectManager.updateFeaturesIdByftiType(
                scope.currentselectfti.name,
                res.data
              );
            }
          );
        };

        scope.closepanel = function() {
          gclayers.clearhighLightFeatures();
          console.log('closepanels');
          scope.panelsManager.removePanel('selecttab');
          scope.tabs.activeTab = 0;
        };

        scope.layerdatatable = {};
        scope.vopenTabPanels = function() {
          scope.geoj = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          // the default height of the datatable
          scope.layerdatatable.height = 320;

          scope.panelsManager.removePanel('selecttab');
          scope.panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverDatatable.html',
            scope: scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });

          // update table height when element is resized
          $rootScope.$on('elementResized', function(event, args) {
            console.log(event);
            console.log(args);
            if (
              args.element.type == 'panel' &&
              args.element.id == 'selecttab'
            ) {
              var currHeight =
                scope.layerdatatable.height + args.transformation.y;
              $timeout(function() {
                scope.layerdatatable.height = currHeight;
              });
            }
          });
        };

        scope.vsaveSelection = function() {
          if (scope.saveSelect == true) {
            scope.saveSelect = false;
            scope.openSelect = false;
          } else {
            scope.saveSelect = true;
            scope.openSelect = false;
          }
        };

        var refreshCollection = function() {
          return ParametersFactory.getbytype('selection').then(function(res) {
            scope.collectionList = res.data;
          });
        };

        scope.vopenSelection = function() {
          if (scope.openSelect == true) {
            scope.openSelect = false;
            scope.saveSelect = false;
          } else {
            refreshCollection().then(function() {
              scope.openSelect = true;
              scope.saveSelect = false;
            });
          }
        };

        /**
         * [saveSelection description]
         * @return {[type]} [description]
         */
        scope.saveSelection = function() {
          // already exist ?
          refreshCollection().then(function() {
            var found = scope.collectionList
              .map(function(x) {
                return x.name;
              })
              .indexOf(scope.selectname);

            if (found == -1) {
              ParametersFactory.add(
                SelectManager.getfeatures(),
                'selection',
                scope.selectname
              ).then(function(res) {
                scope.selectname = '';
                scope.currentSelection = res.data;
                require('toastr').success($filter('translate')('common.saved'));
                scope.saveSelect = false;
              });
            } else {
              // confirm
              var ans = confirm($filter('translate')('query.confirm_update'));
              if (ans) {
                // update
                ParametersFactory.getbyid(scope.collectionList[found].id).then(
                  function(res) {
                    var newObj = res.data;
                    newObj.data = SelectManager.getfeatures();
                    ParametersFactory.update(newObj, newObj.id).then(function(
                      res
                    ) {
                      refreshCollection();
                      scope.currentSelection = res.data;
                      require('toastr').success(
                        $filter('translate')('common.saved')
                      );
                      scope.saveSelect = false;
                    });
                  }
                );
              }
            }
          });
        };

        /**
         * [removeSelection description]
         * @return {[type]} [description]
         */
        scope.removeSelection = function() {
          console.log(scope.selectedCollec);

          var ans = confirm(
            $filter('translate')('selectfeaturetree.confirm_delete_selection')
          );
          if (ans) {
            scope.visibleInfo = false;
            scope.tabs.activeTab = 0;
            ParametersFactory.remove(scope.selectedCollec.id).then(function(
              res
            ) {
              scope.vopenSelection();
              scope.selectedCollec = null;
              SelectManager.clear();
              scope.currentselect = null;
              scope.currentselectfti = null;
            });
          }
        };

        scope.openSelection = function() {
          console.log(scope.selectedCollec, 'selectedCollec');
          scope.selectname = scope.selectedCollec.name;
          scope.currentSelection = scope.selectedCollec;
          SelectManager.addFeaturesFromGeojson(scope.selectedCollec.data);

          var features = gclayers.getselectSource().getFeatures();

          var infos = [];
          scope.selectedCollec.data.features.map(function(x) {
            if (x.kiscurrentstyle) {
              infos.push({
                id: x.id,
                styleTemplate: x.kiscurrentstyle,
              });
            }
          });
          features.map(function(feature) {
            var index = infos
              .map(function(x) {
                return x.id;
              })
              .indexOf(feature.getId());
            if (index !== -1) {
              feature.setStyle(getDefaultStyle(infos[index].styleTemplate));
              scope.styleTemplate = infos[index].styleTemplate;
            }
          });
          scope.localiseSelection();
        };

        scope.localise = function(feature) {
          let currentFeature = null;
          if (feature == undefined ){
            if (scope.currentselect && scope.currentselect.id) {
              currentFeature = gclayers
                .getselectSource()
                .getFeatureById(scope.currentselect.id);
            }
          }
          else {
            currentFeature = gclayers.getselectSource().getFeatureById(feature.id);
          }
          if (currentFeature == undefined) {
            currentFeature = new ol.format.GeoJSON().readFeature(feature);
          }
          if (currentFeature) {
            mapJsUtils.localiseData(currentFeature, scope.map);
          }
        };

        scope.getfeatureClass = function(featuretypename) {
          for (var i = 0, length = scope.featdata.length; i < length; i++) {
            if (scope.featdata[i].label == featuretypename) {
              return scope.featdata[i];
            }
            // `chunk` is each member of the array.
          }
          return null;
        };

        scope.clear = function() {
          SelectManager.clear();

          scope.currentselect = {};

          scope.currentselectfti = {};
          gclayers.clearhighLightFeatures();
        };

        scope.removeselect = function() {
          SelectManager.removefeatures(scope.currentselect.id);
          scope.currentselect = {};
          gclayers.clearhighLightFeatures();
          $timeout(function() {
            scope.feattree.expand_all();
          });
        };

        scope.getHeader = function() {
          var arrayheaderdata = [];
          angular.forEach(scope.currentselect.properties, function(value, key) {
            arrayheaderdata.push(key);
          });
          return arrayheaderdata;
        };

        scope.localiseSelection = function() {
          var selectedFeatures = scope.result.features;
          var featuresExtents = [];
          var format = new ol.format.GeoJSON();
          for (var i = 0; i < selectedFeatures.length; i++) {
            var featureGeometry = selectedFeatures[i].geometry;
            featuresExtents.push(featureGeometry);
          }

          GeometryFactory.union(featuresExtents).then(function(res) {
            var geometry = format.readGeometry(res.data);
            var extent = geometry.getExtent();
            map.getView().fit(extent, map.getSize());
          });
        };

        scope.getattributefti = function(name) {
          for (var i = 0; i < scope.currentselectfti.attributes.length; i++) {
            if (scope.currentselectfti.attributes[i].name == name) {
              return scope.currentselectfti.attributes[i];
              break;
            }
          }
          return null;
        };

        /**
         * Rendu de la valeur d'un domaine sur la datatable
         * @param  {obj} att [Définition du fti]
         * @param  {obj} propName [clé de la propriété]
         * @return [string]     [valeur de la clé du domaine]
         */
        scope.renderRestrict = function(att, propName) {
          for (var i = att.restrictions.length - 1; i >= 0; i--) {
            if (propName != undefined)
              if (att.restrictions[i].type == 'Domain') {
                // Récupère l'objet restriction de type Domain
                // Test si plusieurs domaines afin d'être sur qu'il renvoie quelquechose
                if (
                  att.restrictions[i].listofValues != undefined &&
                  att.restrictions[i].listofValues[propName] !== undefined
                )
                  // Renvoi la valeur de la clé recherchée
                  return $filter('translate')(
                    'features.' +
                      scope.currentselectfti.name +
                      '.domaine.' +
                      att.name +
                      '.' +
                      propName
                  ).indexOf('features.') === -1
                    ? $filter('translate')(
                      'features.' +
                          scope.currentselectfti.name +
                          '.domaine.' +
                          att.name +
                          '.' +
                          propName
                    )
                    : att.restrictions[i].listofValues[propName];
              }
          }
          return propName;
        };

        var oldBranch = {};

        scope.selecttype = function(branch) {
          if (JSON.stringify(oldBranch) === JSON.stringify({})) {
            oldBranch = branch;
          } else if (JSON.stringify(oldBranch) != JSON.stringify(branch)) {
            oldBranch.expanded == false;
            scope.visibleInfo = false;
            scope.tabs.activeTab = 0;
            oldBranch = branch;
          }
          if (!branch.expanded) {
            scope.visibleInfo = false;
            scope.tabs.activeTab = 0;
          }
          scope.currentselectfti = gclayers.getOperationalLayerByName(
            branch.data.featuretype
          );

          scope.objectActions = [];
          scope.componentActions = [];
          if (
            scope.currentselectfti &&
            scope.currentselectfti.actions &&
            scope.currentselectfti.actions.length > 0
          )
            scope.currentselectfti.actions.map(function(x) {
              x.currentComponent
                ? scope.componentActions.push(x)
                : scope.objectActions.push(x);
            });
          if ($rootScope.xgos) {
            scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
            scope.authorizedReadAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.currentselectfti, scope.isAdmin, true);
            scope.authorizedWriteAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.currentselectfti, scope.isAdmin);
            scope.authorizedWriteAttributesNames = scope.authorizedWriteAttributes.map(att => att.name);
          } else {
            scope.authorizedWriteAttributes = [];
            console.error('$rootScope.xgos = ', $rootScope.xgos);
          }
        };

        scope.attachmentIsImage = function(fn) {
          if (fn == undefined) return false;
          var fnlc = fn.toLowerCase();
          if (fnlc.endsWith('.jpeg')) return true;
          if (fnlc.endsWith('.jpg')) return true;
          if (fnlc.endsWith('.png')) return true;
          if (fnlc.endsWith('.gif')) return true;
          return false;
        };

        /**
         *     Si le nom de fichier en paramètre a une extension connue
         *  de fichier ilmage, on télécharge l'image afin d'en afficher uneminiature.
         *
         */
        scope.loadPicture = function(fti, feat, fn) {
          if (fn != undefined && fn != '' && scope.attachmentIsImage(fn)) {
            FeatureAttachmentFactory.getcontent(
              fn,
              fti.name,
              feat.id,
              'base64;thumbnail'
            ).then(function(res) {
              if (res.data != 'fichier inexistant')
                scope.pictures[fn] = 'data:image/jpeg;base64,' + res.data;
            });
          }
        };

        /**
         *     Récupération des images afin de pouvoir
         *  les afficher en tant que miniature.
         */
        scope.loadPictures = function(fti, feat) {
          var iatt, att, picNames, ipicname;

          if (scope.pictures != undefined) delete scope.pictures;
          scope.pictures = {};

          for (iatt = 0; iatt < fti.attributes.length; iatt++) {
            att = fti.attributes[iatt];
            if (feat.properties[att.name] != undefined) {
              if (att.type == 'g2c.attachment')
                scope.loadPicture(fti, feat, feat.properties[att.name]);
              else if (att.type == 'g2c.attachments') {
                picNames = feat.properties[att.name].split(',');
                for (ipicname = 0; ipicname < picNames.length; ipicname++) {
                  if (picNames[ipicname] != '')
                    scope.loadPicture(fti, feat, picNames[ipicname]);
                }
              }
            }
          }
        };

        /**
         * format length output
         * @param {ol.geom.LineString} line
         * @return {string}
         */
        scope.formatLength = function(length) {
          var output;
          if (length > 1000) {
            output = Math.round((length / 100) * 10) / 100 + ' ' + 'km';
          } else {
            output = Math.round(length * 100) / 100 + ' ' + 'm';
          }
          return output;
        };

        var openDossierAnc = function(dossier) {
          openDossier([dossier]);
        };

        var openDossier = function(dossier) {
          $rootScope.$broadcast('anc_open_dossier', dossier);
        };

        /**
         * format length output
         * @param {ol.geom.Polygon} polygon
         * @return {string}
         */
        scope.formatArea = function(area) {
          var output;
          if (area > 10000) {
            output = Math.round((area / 1000000) * 100) / 100 + ' ' + 'km²';
          } else {
            output = Math.round(area * 100) / 100 + ' ' + 'm²';
          }
          return output;
        };

        scope.selectbranch = function(branch) {
          let parentBranch = scope.featdata.find(feat => feat.uid === branch.parent_uid);
          if (parentBranch && oldBranch.data.featuretype !== branch.data.featuretype){
            scope.selecttype(parentBranch);
          }
          scope.uploadfile = {};
          scope.goformfield = true;
          scope.currentselect = branch.data;
          scope.arraydata = [];
          scope.visibleInfo = true;
          scope.tabs.activeTab = 0;

          scope.arraydata.push(scope.currentselect.properties);

          gclayers.clearhighLightFeatures();
          gclayers.addhighLightFeatures(scope.currentselect.id);

          var index = FeatureTypeFactory.resources.featuretypes
            .map(function(x) {
              return x.name;
            })
            .indexOf(scope.currentselect.featuretype);
          var fti = FeatureTypeFactory.resources.featuretypes[index];
          scope.currentselectfti = fti;
          scope.newobj = {};
          // traiter le cas ou des actions sont définies
          if (scope.currentselectfti.defaultsAction) {
            scope.newobj.current = scope.result.features.find(f => f.id === scope.currentselect.id);
            scope.fti = scope.currentselectfti;
            var selectedAction = scope.currentselectfti.defaultsAction;
            switch (selectedAction.actionType) {
              case $filter('translate')('model.featuretypes.actions.form'):
                executeForm(selectedAction);
                break;
              case $filter('translate')('model.featuretypes.actions.url'):
                executeUrl(selectedAction, scope.newobj.current.properties);
                break;
              case $filter('translate')('model.featuretypes.actions.html'):
                executeHtml(selectedAction);
                break;
              case $filter('translate')('model.featuretypes.actions.anomalie'):
                $rootScope.$broadcast('opendosseraep', scope.newobj);
                break;
              case $filter('translate')('model.featuretypes.actions.majic'):
                openMajicForm(selectedAction, scope.newobj);
                break;
              case $filter('translate')('model.featuretypes.actions.jasper'):
                executeJasper(selectedAction, scope.newobj, 'onobject');
                break;
              case $filter('translate')(
                'model.featuretypes.actions.dossier_anc'
              ):
                openDossierAnc(scope.newobj.current);
                break;
            }
          }
          scope.configurationTab = false;
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(
            scope.currentselectfti.uid,scope.authorizedReadAttributes).then(res =>{
            if (typeof res === 'object' && res != null && res.active) {
              scope.configurationTab = res;
            }
          });
        };

        function executeForm(action) {
          ConfigFactory.get(action.type, action.form).then(
            function(res) {
              scope.currentTemplate = res.data;
              if (scope.openFormulaireDialog) {
                scope.openFormulaireDialog.close();
              }
              const newScope = scope.$new();
              scope.openFormulaireDialog = extendedNgDialog.open({
                template:
                  'js/XG/widgets/mapapp/selectFeatureTree/views/panel/formulaire.html',
                className: 'ngdialog-theme-plain width800 nopadding miniclose',
                closeByDocument: false,
                scope: newScope,
                title: '',
                draggable: true,
                scrollable:true,
                minimizeMaximize: true,
                resizable: true,
              });
              newScope.dlgPopup = scope.openFormulaireDialog;
            },
            function() {
              console.log('form does not exist');
            }
          );
        }

        function executeHtml(action) {
          if (scope.openHTMLDialog) scope.openHTMLDialog.close();
          scope.openHTMLDialog = extendedNgDialog.open({
            template: 'fichemetiers/' + action.url,
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: scope.currentselectfti.alias,
            draggable: true,
          });
        }

        function openMajicForm(action, parcelle) {
          //-- Si on a déjà ouvert une fenêtre majic depuis le sélecteur d'objet, on le ferme.
          if (scope.magicForm !== undefined) {
            scope.magicForm.destroy();
            scope.magicForm = undefined;
          }
          //-- Demande la fermeture d'autres fiches majic éventuellement ouverte
          //-- depuis les widgets majic directement.
          $rootScope.$broadcast('pleaseRemoveExistingMajicForm', {
            id: 'iRouge',
          });

          const userCommunes = $rootScope.xgos !== null && $rootScope.xgos.hasOwnProperty(
            'user') && $rootScope.xgos.user.hasOwnProperty('communes') ? $rootScope.xgos.user.communes : [];


          // recherche de la configuration du widget 'majic' nécessaire
          // pour récupérer le champ identifiant de la parcelle
          selecttoolbypointutilitiesservice.userHasMajicAuthorizationOnParcelle(parcelle,userCommunes).then(
            res => {
              if (res){
                //-- On passe la parcelle au widget de consultation majic.
                scope.parcellefromparent = JSON.stringify(parcelle);
                scope.magicForm = gcPopup.open({
                  title: 'Majic',
                  showClose: true,
                  resizable: true,
                  minimizeMaximize: true,
                  template:
                        'js/XG/widgets/mapapp/selecttoolbypointutilities/views/tbselecttoolbypointutilities.majic.html',
                  scope: scope,
                  onclose: function() {
                    gclayers.getselectSource().clear();
                    gclayers.clearhighLightFeatures();
                  }
                });
                $timeout(()=>{
                  MajicFactory.setInitPopupWidthAndMinWidth('consult', true);
                }, 400);
              } else {
                SelectManager.clear();
                require('toastr').warning(
                  $filter('translate')('tools.majicedigeo.majic.parcNonAutorise')
                );
              }
            }
          );
        }

        function executeUrl(action, properties) {
          scope.parametersRapportUtilisateur = [];
          var param = [];
          for (var j = 0; j < action.parameters.length; j++) {
            if (
              action.parameters[j].saisieMode ===
                $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ) ||
              action.parameters[j].typeInfo === 'saisieUtilisateur'
            ) {
              param.push(action.parameters[j]);
            }
          }
          if (param.length > 0)
            scope.parametersRapportUtilisateur.push({
              name: action.name,
              parameters: param,
            });
          if (scope.parametersRapportUtilisateur.length > 0) {
            scope.tableParamsParameters = new ngTableParams(
              {
                page: 1, // show first page
                count: 10, // count per page
              },
              {
                total: 0, // length of data
                getData: function($defer, params) {
                  var displayedTab = scope.parametersRapportUtilisateur.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  );

                  params.total(scope.parametersRapportUtilisateur.length); // set total for recalc pagination
                  $defer.resolve(displayedTab);
                },
              }
            );
            scope.ngdiaParameters = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
              scope: scope,
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
            });
            scope.ngdiaParameters.then(
              function() {
                var url = parseUrl(action, properties);
                window.open(url);
              },
              function() {
                require('toastr').info(
                  $filter('translate')('selectfeaturetree.saisirtocontinue')
                );
              }
            );
          } else {
            var url = parseUrl(action, properties);
            window.open(url);
          }
        }

        function parseUrl(action, properties) {
          var url = action.url;
          var params = action.parameters;
          if (params.length > 0) {
            url += '?';
            var value;
            for (var i = 0; i < params.length; i++) {
              switch (params[i].saisieMode) {
                case $filter('translate')(
                  'model.featuretypes.actions.saisieAttribut'
                ):
                  properties[params[i].value] &&
                  properties[params[i].value] !== null
                    ? (value = properties[params[i].value])
                    : (value = '');
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + value;
                  break;
                case $filter('translate')(
                  'model.featuretypes.actions.saisieStatic'
                ):
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].attribute;
                  break;
                case $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ):
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].value;
                  break;
                default:
                  switch (params[i].typeInfo) {
                    case 'saisieAttribut':
                      properties[params[i].value] &&
                      properties[params[i].value] !== null
                        ? (value = properties[params[i].value])
                        : (value = '');
                      if (i > 0) url += '&';
                      url += params[i].name + '=' + value;
                      break;
                    case 'saisieStatic':
                      if (i > 0) url += '&';
                      url += params[i].name + '=' + params[i].attribute;
                      break;
                    case 'saisieUtilisateur':
                      if (i > 0) url += '&';
                      url += params[i].name + '=' + params[i].value;
                      break;
                  }
                  break;
              }
            }
          }
          return url;
        }

        function executeJasper(action, currentselect, which) {
          scope.parametersRapportUtilisateur = [];
          for (var i = 0; i < action.rapports.length; i++) {
            if (
              (action.rapports[i].type ===
                $filter('translate')(
                  'model.featuretypes.actions.JasperModel'
                ) ||
                action.rapports[i].typeInfo === 'JasperModel') &&
              action.rapports[i].parameters &&
              action.rapports[i].parameters.length > 0
            ) {
              var param = [];
              for (var j = 0; j < action.rapports[i].parameters.length; j++) {
                if (
                  action.rapports[i].parameters[j].saisieMode ===
                    $filter('translate')(
                      'model.featuretypes.actions.saisieUtilisateur'
                    ) ||
                  action.rapports[i].parameters[j].typeInfo ===
                    'saisieUtilisateur'
                ) {
                  param.push(action.rapports[i].parameters[j]);
                }
              }
              if (param.length > 0)
                scope.parametersRapportUtilisateur.push({
                  name: action.rapports[i].name,
                  parameters: param,
                });
            }
          }
          if (scope.parametersRapportUtilisateur.length > 0) {
            scope.tableParamsParameters = new ngTableParams(
              {
                page: 1, // show first page
                count: 10, // count per page
              },
              {
                total: 0, // length of data
                getData: function($defer, params) {
                  var displayedTab = scope.parametersRapportUtilisateur.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  );

                  params.total(scope.parametersRapportUtilisateur.length); // set total for recalc pagination
                  $defer.resolve(displayedTab);
                },
              }
            );
            scope.ngdiaParameters = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
              scope: scope,
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
            });
            scope.ngdiaParameters.then(
              function() {
                switch (which) {
                  case 'oncomponent':
                    JasperOnComponent(action, currentselect);
                    break;
                  case 'onobject':
                    Jasper(action, currentselect);
                    break;
                }
              },
              function() {
                require('toastr').info(
                  $filter('translate')('selectfeaturetree.saisirtocontinue')
                );
              }
            );
          } else {
            switch (which) {
              case 'oncomponent':
                JasperOnComponent(action, currentselect);
                break;
              case 'onobject':
                Jasper(action, currentselect);
                break;
            }
          }
        }

        function Jasper(action, currentselect) {
          if (action.rapports.length === 1) {
            var rapport = action.rapports[0];
            switch (rapport.type) {
              case $filter('translate')(
                'model.featuretypes.actions.PortalModel'
              ):
                var sendata = getPortalDoc(currentselect);
                DocumentFactory.generatedocx(
                  sendata,
                  rapport.file,
                  currentselect.id,
                  false,
                  scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(function(res) {
                  window.open(
                    '/services/' +
                      angular.module('gcMain').portalid +
                      '/documents/downloaddocx?' +
                      '&name=' +
                      res.data.name
                  );
                });
                break;
              case $filter('translate')(
                'model.featuretypes.actions.StaticModel'
              ):
                window.open(
                  '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
                    scope.fti.name +
                    '&filename=' +
                    rapport.file
                );
                break;
              case $filter('translate')(
                'model.featuretypes.actions.JasperModel'
              ):
                generateJasperDoc(rapport, currentselect);
                break;
              default:
                switch (rapport.typeInfo) {
                  case 'PortalModel':
                    sendata = getPortalDoc(currentselect);
                    DocumentFactory.generatedocx(
                      sendata,
                      rapport.file,
                      currentselect.id,
                      false,
                      scope.map
                        .getView()
                        .getProjection()
                        .getCode()
                    ).then(function(res) {
                      window.open(
                        '/services/' +
                          angular.module('gcMain').portalid +
                          '/documents/downloaddocx?' +
                          '&name=' +
                          res.data.name
                      );
                    });
                    break;
                  case 'StaticModel':
                    window.open(
                      '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
                        scope.fti.name +
                        '&filename=' +
                        rapport.file
                    );
                    break;
                  case 'JasperModel':
                    generateJasperDoc(rapport, currentselect);
                    break;
                }
                break;
            }
          } else {
            var promisses = [];
            var FullDataGenerate = [];
            for (var i = 0; i < action.rapports.length; i++) {
              rapport = action.rapports[i];
              switch (rapport.type) {
                case $filter('translate')(
                  'model.featuretypes.actions.PortalModel'
                ):
                  sendata = getPortalDoc(currentselect);
                  var promise = DocumentFactory.generatedocx(
                    sendata,
                    rapport.file,
                    currentselect.id,
                    false,
                    scope.map
                      .getView()
                      .getProjection()
                      .getCode()
                  ).then(
                    function(res) {
                      FullDataGenerate.push({
                        type: 'PortalModel',
                        file: res.data.name,
                      });
                    },
                    function() {
                      require('toastr').error('error');
                    }
                  );
                  promisses.push(promise);
                  break;
                case $filter('translate')(
                  'model.featuretypes.actions.StaticModel'
                ):
                  FullDataGenerate.push({
                    type: 'StaticModel',
                    file: rapport.file,
                    ftiname: scope.fti.name,
                  });
                  break;
                case $filter('translate')(
                  'model.featuretypes.actions.JasperModel'
                ):
                  promise = generateJasperDocWhithoutDownload(
                    rapport,
                    currentselect
                  ).then(function(res) {
                    if (res.data.pdfdone)
                      FullDataGenerate.push({
                        type: 'JasperModel',
                        file: res.data.fileNameGenerated,
                        appname: angular.module('gcMain').app,
                      });
                  });
                  promisses.push(promise);
                  break;
                default:
                  switch (rapport.type) {
                    case 'PortalModel':
                      sendata = getPortalDoc(currentselect);
                      promise = DocumentFactory.generatedocx(
                        sendata,
                        rapport.file,
                        currentselect.id,
                        false,
                        scope.map
                          .getView()
                          .getProjection()
                          .getCode()
                      ).then(
                        (res) => {
                          FullDataGenerate.push({
                            type: 'PortalModel',
                            file: res.data.name,
                          });
                        },
                        function() {
                          require('toastr').error('error');
                        }
                      );
                      promisses.push(promise);
                      break;
                    case 'StaticModel':
                      FullDataGenerate.push({
                        type: 'StaticModel',
                        file: rapport.file,
                        ftiname: scope.fti.name,
                      });
                      break;
                    case 'JasperModel':
                      var promise = generateJasperDocWhithoutDownload(
                        rapport,
                        currentselect
                      ).then(function(res) {
                        if (res.data.pdfdone)
                          FullDataGenerate.push({
                            type: 'JasperModel',
                            file: res.data.fileNameGenerated,
                            appname: angular.module('gcMain').app,
                          });
                      });
                      promisses.push(promise);
                      break;
                  }
                  break;
              }
            }
            $q.all(promisses).then(function() {
              FilesFactory.getActionsGeneratedZip(FullDataGenerate).then(
                function(res) {
                  window.open(
                    '/services/' +
                      angular.module('gcMain').portalid +
                      '/files/getgeneratedzip?filename=' +
                      res.data.filename
                  );
                },
                function() {
                  require('toastr').error('error');
                }
              );
            });
          }
        }

        function JasperOnComponent(action, geoj) {
          var rapport = action.rapports[0];
          var features = geoj.features;
          var sendata = [];
          angular.forEach(features, function(feature) {
            sendata.push(generateSendata(rapport, feature));
          });
          const execStoreName = scope.fti.type === 'esri' && rapport.storeName
            ? rapport.storeName : scope.fti.storeName;
          ReportIndicatorFactory.generateMultipleReportExtended(
            rapport.file,
            execStoreName,
            sendata
          ).then(
            function(res) {
              if (res.data.etat === 'fini') {
                window.open(
                  '/services/' +
                    angular.module('gcMain').portalid +
                    '/indicator/' +
                    angular.module('gcMain').app +
                    '/getgeneratedzip?filename=' +
                    res.data.file
                );
              } else {
                require('toastr').error('error');
              }
            },
            function() {
              require('toastr').error('error');
            }
          );
        }

        const generateJasperDocWhithoutDownload = (rapport, currentselect) => {
          const sendata = generateSendata(rapport, currentselect);
          const execStoreName = scope.fti.type==='esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
          if (!rapport.format || rapport.format.length===0){
            rapport.format = 'pdf';
          }
          const promise = ReportIndicatorFactory.generateReportExtended(
            rapport.file,
            execStoreName,
            sendata,
            rapport.format,
            false
          );
          promise.then(
            (res) => {
              if (!res.data.pdfdone)
                require('toastr').error(
                  $filter('translate')(
                    'model.featuretypes.actions.unabletogeneratepdf'
                  ) +
                    ' ' +
                    rapport.file
                );
            },
            () => {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.actions.unabletogeneratepdf'
                ) +
                  ' ' +
                  rapport.file
              );
            }
          );
          return promise;
        }

        const generateJasperDoc = (rapport, currentselect) => {
          const sendata = generateSendata(rapport, currentselect);
          const execStoreName = scope.fti.type==='esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
          if (!rapport.format || rapport.format.length===0){
            rapport.format = 'pdf';
          }
          ReportIndicatorFactory.generateReportExtended(
            rapport.file,
            execStoreName,
            sendata,
            rapport.format,
            false
          ).then(
            (res) => {
              if (res.data.pdfdone) {
                ReportIndicatorFactory.getPdf(res.data.fileNameGenerated).then(
                  (data) => {
                    const resultObject = data.data;
                    const blob
                      = new Blob([resultObject], gaJsUtils.applicationTypes[rapport.format]);
                    if ('rtf,odt,ods'.includes(rapport.format)){
                      const a = document.createElement('a');
                      document.body.appendChild(a);
                      a.style = 'display: none';
                      const url = window.URL.createObjectURL(blob);
                      a.href = url;
                      a.download = res.data.fileNameGenerated + '.' + rapport.format;
                      a.click();
                      window.URL.revokeObjectURL(url);
                    }else{
                      const objectUrl = URL.createObjectURL(blob);
                      window.open(objectUrl);
                    }
                  },
                  () => {
                    require('toastr').error(
                      $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                        + rapport.format);
                  }
                );
              } else {
                require('toastr').error(
                  $filter('translate')(
                    'model.featuretypes.actions.unabletogeneratepdf'
                  ) +
                    ' ' +
                    rapport.file
                );
              }
            },
            () => {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.actions.unabletogeneratepdf'
                ) +
                  ' ' +
                  rapport.file
              );
            }
          );
        }

        const generateSendata = (rapport, currentselect) => {
          const res = {};
          angular.forEach(rapport.parameters, (param) => {
            switch (param.saisieMode) {
              case $filter(
                'translate'
              )('model.featuretypes.actions.saisieAttribut'):
                if (param.attribut === 'id') {
                  res[param.name] = Number(
                    currentselect.id.replace(scope.fti.name + '.', '')
                  );
                } else {
                  res[param.name] = currentselect.properties[param.attribut];
                }
                break;
              default:
                switch (param.saisieMode) {
                  case 'saisieAttribut':
                    if (param.attribut === 'id') {
                      res[param.name] = Number(
                        currentselect.id.replace(scope.fti.name + '.', '')
                      );
                    } else {
                      res[param.name] =
                        currentselect.properties[param.attribut];
                    }
                    break;
                  default:
                    res[param.name] = param.value;
                    break;
                }
                break;
            }
          });
          return res;
        }

        function getPortalDoc(currentselect) {
          scope.relatedfeature = {
            features: [],
          };
          var res = {
            current: currentselect,
          };
          var idsNames = getNamesIds();
          res = createSendMessage(res, idsNames);

          return res;
        }

        function createSendMessage(res, idsNames) {
          var relationN = idsNames[2];
          var features = idsNames[3];
          var uniqueRelationNames = angular.copy(relationN);
          uniqueRelationNames = $.unique(uniqueRelationNames);
          for (var i = 0; i < uniqueRelationNames.length; i++) {
            var arr = [];
            for (var j = 0; j < relationN.length; j++) {
              if (relationN[j] === uniqueRelationNames[i])
                arr.push(features[j]);
            }
            res[uniqueRelationNames[i]] = arr;
          }

          return res;
        }

        function getNamesIds() {
          var ids = [];
          var names = [];
          var relationN = [];
          var features = [];
          var relations = scope.fti.relations;
          var relationsComponentsEnd = [];
          var relationsNames = [];
          relations.map(function(x) {
            if (x.componentEnd) {
              relationsComponentsEnd.push(x.componentEnd);
              relationsNames.push(x.name);
            }
          });
          for (var i = 0; i < scope.relatedfeature.features.length; i++) {
            var feature = scope.relatedfeature.features[i];
            var id = feature.id;
            var name = id.substring(0, id.lastIndexOf('.'));
            if (relationsComponentsEnd.indexOf(name) !== -1) {
              ids.push(id);
              names.push(name);
              features.push(feature);
              relationN.push(
                relationsNames[relationsComponentsEnd.indexOf(name)]
              );
            }
          }

          return [ids, names, relationN, features];
        }

        scope.summaryWS = function(feat, rel) {
          var summary = angular.copy(rel.attributeview);
          angular.forEach(feat.properties, function(value, key) {
            var attm = '{' + key + '}';
            summary = summary.replace(attm, value);
          });
          return summary;
        };

        scope.getWSe = function(url) {
          var promise = $http.get('/services/ogc/proxy?url=' + url);
          return promise;
        };

        scope.openlinkWS = function(link, feat) {
          var linkurl = angular.copy(link);
          angular.forEach(feat.properties, function(value, key) {
            var attm = '{' + key + '}';
            linkurl = linkurl.replace(attm, value);
          });

          scope.getWSe(linkurl).then(function(res) {
            scope.selectlink = res.data;
            var pop3 = gcPopup.open({
              scope: scope,
              title: relatedFeaturePopUpTitle,
              template: 'js/XG/biz/wshtml/views/' + 'link.html',
              showClose: true,
            });
          });
        };

        scope.openpageWS = function(html, feat) {
          scope.selectWsFeat = feat;
          var pop2 = gcPopup.open({
            scope: scope,
            title: relatedFeaturePopUpTitle,
            template: 'js/XG/biz/wshtml/views/' + html,
            showClose: true,
          });
        };

        scope.viewRelatedFeature = function(relatedFeature) {
          var relatedFeatureFTIName = relatedFeature.id.split('.')[0];
          if (
            FeatureTypeFactory.resources.featuretypes == undefined ||
            FeatureTypeFactory.resources.featuretypes.length == 0
          )
            FeatureTypeFactory.get().then(function() {
              for (
                var i = 0;
                i < FeatureTypeFactory.resources.featuretypes.length;
                i++
              )
                if (
                  FeatureTypeFactory.resources.featuretypes[i].name ==
                  relatedFeatureFTIName
                )
                  scope.relatedFeaturefti =
                    FeatureTypeFactory.resources.featuretypes[i];
            });
          else {
            for (
              var i = 0;
              i < FeatureTypeFactory.resources.featuretypes.length;
              i++
            )
              if (
                FeatureTypeFactory.resources.featuretypes[i].name ==
                relatedFeatureFTIName
              )
                scope.relatedFeaturefti =
                  FeatureTypeFactory.resources.featuretypes[i];
          }
        };

        let relatedFeaturePopUpTitle = $translate('selectfeaturetree.relatedFeaturePopUpTitle');

        scope.viewfihelink = function(relatedFeature) {
          scope.viewRelatedFeature(relatedFeature);
          scope.relatedFeature = relatedFeature;
          var pop = gcPopup.open({
            scope: scope,
            minimizeMaximize: true,
            title: relatedFeaturePopUpTitle,
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/relatedFeaturePopUp.html',
            showClose: true,
          });
        };

        /**
         */

        var exportPopUpTitle = 'Exporter';
        $translate('selectfeaturetree.exportpopuptitle').then(function(res) {
          exportPopUpTitle = res;
        });

        scope.isGeomFeature = function(relatedFeature) {
          if (relatedFeature.geometry == undefined) return false;
          else return true;
        };

        scope.exportSelection = function() {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/selectFeatureTree/views/dxfExport.html',
            className:
              'ngdialog-theme-plain overflowY width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: exportPopUpTitle,
            draggable: true,
          });
        };

        ActionsManager.setMap(scope.map);

        /*
         * Add Action OUS
         */
        scope.executeAction = function() {
          ActionsManager.executeAction(
            scope.currentselectedActionOnObject,
            scope.objectActions,
            scope.currentselect,
            scope.currentselectfti,
            scope.result,
            scope.relatedfeature
          );
        };

        scope.executeActionOnComponent = function() {
          scope.geoj = SelectManager.getFeaturesByftiType(
            scope.currentselectfti.name
          );
          ActionsManager.executeActionOnComponent(
            scope.currentselectedActionOnComponent,
            scope.componentActions,
            scope.currentselectfti,
            scope.geoj,
            scope.result,
            scope.relatedfeature
          );
        };

        scope.currentselectedActionOnComponent = undefined;
        scope.currentselectedActionOnObject = undefined;
        scope.currentselectedActionOnGlobal = undefined;

        scope.validAction = true;
        var watchValidAction = scope.$watch(
          'currentselectedActionOnObject',
          function(newval) {
            if (newval && newval !== '') {
              scope.validAction = false;
              watchValidAction();
            }
          }
        );

        scope.validActionOnComponent = true;
        var watchValidActionOnComponent = scope.$watch(
          'currentselectedActionOnComponent',
          function(newval) {
            if (newval && newval !== '') {
              scope.validActionOnComponent = false;
              watchValidActionOnComponent();
            }
          }
        );

        scope.validActionOnGlobal = true;
        var validateActionOnGlobal = scope.$watch(
          'currentselectedActionOnGlobal',
          function(newval) {
            if (newval && newval !== '') {
              scope.validActionOnGlobal = false;
              validateActionOnGlobal();
            }
          }
        );

        ActionsFactory.getconf().then(function(res) {
          if (res.data.etat === 'fini') {
            scope.globalActions = res.data.data;
            console.info('actions globales chargées');
          } else {
            console.info('no config');
          }
        });

        scope.executeActionOnGlobal = function() {
          ActionsManager.executeActionOnGlobal(
            scope.currentselectedActionOnGlobal,
            scope.result
          );
        };

        scope.executeActionOnComponentTable = function() {
          ActionsManager.executeActionOnComponent(
            scope.currentselectedActionOnComponentTable.value,
            scope.componentActions,
            scope.currentselectfti,
            scope.tableResult.elements,
            scope.result,
            []
          );
        };

        function getAuthorizedAttributes(fti) {
          var isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
          if (isAdmin) return fti.attributes;

          var userRights = [];
          $rootScope.xgos.user.roles.forEach(function(role) {
            role.authorizations.forEach(function(authorization) {
              if (authorization.item == fti.uid) {
                authorization.subItems.forEach(function(sub) {
                  userRights[sub.item] = {
                    read:
                    userRights[sub.item] == undefined ||
                    !userRights[sub.item].read
                      ? sub.read
                      : true,
                    write:
                      userRights[sub.item] == undefined ||
                      !userRights[sub.item].write
                        ? sub.write
                        : true,
                  };
                });
              }
            });
          });
          $rootScope.xgos.user.groups.forEach(function(group) {
            group.roles.forEach(function(inRole) {
              inRole.authorizations.forEach(function(inAuthorization) {
                if (inAuthorization.item == fti.uid) {
                  inAuthorization.subItems.forEach(function(inSub) {
                    userRights[inSub.item] = {
                      read:
                        userRights[inSub.item] == undefined ||
                        !userRights[inSub.item].read
                          ? inSub.read
                          : true,
                      write:
                        userRights[inSub.item] == undefined ||
                        !userRights[inSub.item].write
                          ? inSub.write
                          : true,
                    };
                  });
                }
              });
            });
          });

          var authorizedAttrs = [];
          for (var i = 0; i < fti.attributes.length; i++) {
            var attr = fti.attributes[i];
            if (
              userRights[attr.name] != undefined &&
              userRights[attr.name].write == true
            )
              authorizedAttrs.push(attr);
          }
          return authorizedAttrs;
        }

        scope.validFeatures = function(currentProperties) {
          let editdescriptionTemplate = {
            theme: '',
            editType: '',
            fastMode: false,
            fti: undefined,
            editedfeature: undefined,
            relatedfeatures: [],
            shareObjects: [],
            interactions: [],
          };

          scope.newobj = {};
          for (var i = 0; i < scope.result.features.length; i++) {
            if (scope.currentselect.id == scope.result.features[i].id) {
              scope.newobj = scope.result.features[i];
            }
          }

          if (
            !bizeditProvider.checkMandatory(
              scope,
              scope.authorizedWriteAttributes,
              1,
              undefined,
              currentProperties
            )
          ) {
            return;
          }
          //Méthode appelée par les composant d'édition lors de leur activation
          //pour créer un nouvel objet décrivant l'action d'édition .
          scope.createeditdescription = () => {
            const description = angular.copy(editdescriptionTemplate);
            description.fastMode = false;
            description.theme = 'Default';
            return description;
          };

          /* save rules */
          scope.editdescription = scope.createeditdescription();
          if(scope.editdescription === undefined) return;
          scope.editdescription.editType =
            EditTypesFactory.editTypes.updateattributes.name;
          scope.editdescription.fti = scope.currentselectfti;
          let collection = {
            features: [scope.newobj],
            type: 'FeatureCollection',
          };
          const formatz = new ol.format.GeoJSON();
          let feat = formatz.readFeatures(collection);
          scope.editdescription.editedfeature = feat[0];
          let postValidation = EditRulesFactory.executePostValidationRules(
            scope.editdescription,
            scope.currentselectfti,
            map
          );
          postValidation.then(
            ()=>{
              let saveEnd = EditRulesFactory.executeEndRules(
                scope.editdescription,
                scope.currentselectfti,
                scope.map
              );
              saveEnd.then(
                () => {
                  let prop = scope.editdescription.editedfeature.getProperties();
                  delete prop.geometry;
                  scope.newobj.properties = prop;
                  const sendata = {
                    type: 'FeatureCollection',
                    features: [scope.newobj],
                  };
                  EditFactory.update(
                    scope.currentselectfti.uid,
                    sendata,
                    scope.map
                      .getView()
                      .getProjection()
                      .getCode()
                  ).then(function(res) {
                    selecttoolbypointutilitiesservice.displayToastrAfterUpdate(res.data);
                  });
                }
                ,() => {
                  require('toastr').error($filter('translate')('bizedition.postValidError'));
                });
            },
            () => {
              require('toastr').error($filter('translate')('bizedition.postValidError'));
            });
        };

        function sortLayersByLabel(layer1, layer2) {
          var index1 = layer1.label;
          var index2 = layer2.label;
          if (index1 == null) return -1;
          else if (index2 == null) return 1;
          else if (index1 < index2) return -1;
          return 1;
        }

        /**
         * Dans le cas de certains noms en provenance de ESRI,
         * le nom de la couche est construit avec des points
         * exemple: sig.reseau.eaua,
         * il faut donc prendre seulement le dernier point
         * comme séparateur (voir expérience avec Nevers).
         */
        function getPairFromFeatId(featid) {
          var pair = [];
          var iDot = featid.lastIndexOf('.');
          pair.push(featid.substring(0, iDot));
          pair.push(featid.substring(iDot + 1));
          return pair;
        }

        /**
         * Evenement recuperer sur la selection
         * @param  {[type]}
         * @return {[type]}
         */
        var destroyevent = scope.$on('gcSelectChange', function(event) {
          scope.result = {};
          scope.featdata = [];
          scope.result = SelectManager.getfeatures();

          var i = false;
          angular.forEach(scope.result.features, function(feat) {
            var pair = getPairFromFeatId(feat.id);
            if (!i) {
              scope.currentselect = {};
            }
            var fti = FeatureTypeFactory.getFeatureByName(pair[0]);
            i = true;
            //Si il exite deja
            if (scope.containfeatureClass('features.' + pair[0] + '.alias ')) {
              scope
                .getfeatureClass('features.' + pair[0] + '.alias ')
                ['children'].push({
                  label: QueryFactory.getObjectId(feat, fti),
                  children: [],
                  data: {
                    properties: feat['properties'],
                    id: feat.id,
                    featuretype: pair[0],
                  },
                  onSelect: scope.selectbranch,
                });
            } else {
              //Si il n'existe pas
              scope.featdata.push({
                label: 'features.' + pair[0] + '.alias ',
                onSelect: scope.selecttype,
                data: { featuretype: pair[0] },
                children: [],
              });
              scope
                .getfeatureClass('features.' + pair[0] + '.alias ')
                ['children'].push({
                  label: QueryFactory.getObjectId(feat, fti),
                  children: [],
                  data: {
                    properties: feat['properties'],
                    id: feat.id,
                    featuretype: pair[0],
                  },
                  onSelect: scope.selectbranch,
                });
            }
          });
          if (scope.featdata && scope.featdata.length > 0)
            scope.featdata.map(function(x) {
              if (x && x.children && x.children.length > 0) {
                x.children = x.children.sort(sortLayersByLabel);
              }
            });
        });

        scope.$on('$destroy', function() {
          destroyevent(); // remove listener.
        });

        scope.featdata = [];
        var i = false;

        angular.forEach(scope.result.features, function(feat, key) {
          var pair = getPairFromFeatId(feat.id);
          if (!i) {
            scope.currentselect = {};
          }
          i = true;
          var fti = FeatureTypeFactory.getFeatureByName(pair[0]);
          //Si il exite deja
          if (scope.containfeatureClass('features.' + pair[0] + '.alias ')) {
            scope
              .getfeatureClass('features.' + pair[0] + '.alias ')
              ['children'].push({
                label: QueryFactory.getObjectId(feat, fti),
                children: [],

                data: {
                  properties: feat['properties'],
                  id: feat.id,
                  featuretype: pair[0],
                },
                onSelect: scope.selectbranch,
              });
          } else {
            //Si il n'existe pas
            scope.featdata.push({
              label: 'features.' + pair[0] + '.alias ',
              onSelect: scope.selecttype,
              data: { featuretype: pair[0] },
              children: [],
            });
            scope
              .getfeatureClass('features.' + pair[0] + '.alias ')
              ['children'].push({
                label: QueryFactory.getObjectId(feat, fti),
                children: [],
                data: {
                  properties: feat['properties'],
                  id: feat.id,
                  featuretype: pair[0],
                },
                onSelect: scope.selectbranch,
              });
          }
        });

        if (scope.featdata && scope.featdata.length > 0){
          scope.featdata.map(function(x) {
            if (x && x.children && x.children.length > 0) {
              x.children = x.children.sort(sortLayersByLabel);
            }
          });
        }
        if (scope.result.totalFeatures == 1) {
          $timeout(function() {
            console.log('ICIC');
            scope.feattree.expand_all();
            scope.feattree.select_first_branch();
            scope.feattree.select_next_branch();
            console.log(scope.feattree);
          });
        }

        /**
         * A chaque mise à jour du dom,
         * renvoie true si la largeur de la popup est inférieure à 780px
         * ajoute des modifications de mise en page spécifique suivant l'onglet
         * et la largeur de la popup
         * @param viewMode search/consult...
         * @return {boolean} est true si la largeur de la popup est inférieure à 780px
         */
        scope.adaptPopupSizeByViewMode = (viewMode) => {
          return MajicFactory.adaptPopupSizeByViewMode(viewMode, true);
        };
      },
    };
  };

  selectedfeaturestree.$inject = [
    '$http',
    'extendedNgDialog',
    'ParametersFactory',
    'EditFactory',
    'SelectManager',
    'gclayers',
    'QueryFactory',
    '$translate',
    'GeometryFactory',
    'gcPopup',
    'FeatureTypeFactory',
    'ChartsFactory',
    '$filter',
    '$timeout',
    '$rootScope',
    'FeatureAttachmentFactory',
    'gcStyleFactory',
    'FontAwesomeFactory',
    'DocumentFactory',
    '$q',
    'ConfigFactory',
    'FilesFactory',
    'ReportIndicatorFactory',
    'ngDialog',
    'ngTableParams',
    'ActionsFactory',
    'gaJsUtils',
    'ChartLocaliseFactory',
    'ActionsManager',
    'bizeditProvider',
    'mapJsUtils',
    'EditTypesFactory',
    'EditRulesFactory',
    'MajicFactory',
    'selecttoolbypointutilitiesservice',
    'RightsFactory',
    'ObjectFilesFactory'
  ];
  return selectedfeaturestree;
});
