'use strict';
define(function() {
  var tierceWidget = function(
    gcTierceFunctions,
    ConfigFactory,
    FeatureTypeFactory,
    SelectManager,
    gcPopup,
    ngDialog,
    extendedNgDialog,
    ngTableParams,
    $location
  ) {
    return {
      restrict: 'A',

      templateUrl: 'js/XG/widgets/mapapp/tiercewidget/views/tiercewidget.html',

      // controller:'tierceController',

      link: function(scope, elt, attrs, ctrl) {
        var IFRAME_TIERCE_ID = 'iframeTierce';
        var map = scope.map;

        scope.data = '';
        scope.data2 = '';
        scope.active = { isActive: true };
        scope.activeSelect = false;

        // Collapse actions
        scope.bufferCollapse = 'plus';
        scope.associationCollapse = 'plus';

        // To calculate dynamic iframe id
        scope.active.id = IFRAME_TIERCE_ID + scope.$id;
        var iframeId = IFRAME_TIERCE_ID;

        scope.originServer = $location.protocol() + '://' + $location.host();

        updateIframeId();
        loadConfiguration();
        addListeners();
        addEventWidgetListeners();

        ////////////////////////////////////////////////////////////////////
        //
        // Gestion de la configuration du widget
        //
        ////////////////////////////////////////////////////////////////////

        scope.config = {};

        /**
         * Récupèration de la configuration.
         * @returns {undefined}
         */
        scope.getConfig = function() {
          ConfigFactory.get('widgets', scope.ConfigName).then(
            function(res) {
              if (res.data !== '' && res.status == 200) {
                scope.config = res.data;

                readConfiguration();
                initWidgetFromConfig();
              }
              console.info('Configuration de tierce widget chargée.');
            },
            function(reason) {
              console.error(
                'Configuration de tierce widget non chargée: ' + reason
              );
            }
          );
        };
        scope.getConfig();

        /**
         * Ouvre l'IHM de la configuration et permet de la modifer.
         * @returns {undefined}
         */
        var ngDialogPromise;
        scope.openConfig = function() {
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/tiercewidget/views/configuration.html',
            className:
              'ngdialog-theme-plain overflowY width800 nopadding miniclose',
            scope: scope,
            showClose: true,
          });
          ngDialogPromise.then(
            function(data) {
              scope.saveconfig();

              // Reset collapse actions
              scope.bufferCollapse = 'plus';
              scope.associationCollapse = 'plus';

              require('toastr').info(data);
            },
            function(data) {
              scope.getConfig();

              // Reset collapse actions
              scope.bufferCollapse = 'plus';
              scope.associationCollapse = 'plus';

              require('toastr').info(data);
            }
          );
        };

        /**
         * Set buffer collapse
         */
        scope.updateBufferCollapse = function() {
          scope.bufferCollapse =
            scope.bufferCollapse == 'plus'
              ? (scope.bufferCollapse = 'minus')
              : 'plus';
        };

        /**
         * Set association collapse
         */
        scope.updateAssociationCollapse = function() {
          scope.associationCollapse =
            scope.associationCollapse == 'plus'
              ? (scope.associationCollapse = 'minus')
              : 'plus';
        };

        /**
         * Sauve dans le fichier de configuration,
         *  la configuration presente dans le scope courant.
         * @returns {undefined}
         */
        scope.saveconfig = function() {
          console.log(scope.ConfigName);
          ConfigFactory.add(scope.config, 'widgets', scope.ConfigName).then(
            function(res) {
              require('toastr').success(res.data);
              initWidgetFromConfig();
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };

        /**
         *
         */
        scope.updateBufferType = function() {
          console.log('Buffer type : ' + scope.config.buffer.type);
        };

        /**
         * Initialise le widget à partir de l'objet configuration.
         * @returns {undefined}
         */
        function initWidgetFromConfig() {
          scope.url = scope.config.url;
          scope.widgetWidth = scope.config.widgetWidth;
          var currentIframeId = document.getElementById(iframeId);
          currentIframeId.style.width = scope.widgetWidth + 'px';
        }

        /////////////////////////////////////////////////////////////////////
        //
        // FIN CONFIGURATION du widget
        //
        /////////////////////////////////////////////////////////////////////

        /*====================================================================
                *
                * Global functions
                *
                ====================================================================*/

        /**=================================================================
                 * Main function
                 * Handler on data changement
                 =================================================================*/

        /**
         * Disable/Active iframe ?
         */
        scope.$watch('active.isActive', function(newValue, oldValue) {
          console.log('---> Values ' + newValue + ', ' + oldValue);
          if (!scope.active.isActive) {
            document.getElementById(scope.active.id).style.display = 'none';
          } else {
            document.getElementById(scope.active.id).style.display = 'block';
          }
        });

        /**
         * For Test : KIS sent data to tierce app
         */
        scope.test = function(data) {
          console.log('Recieved data : ' + JSON.stringify(data));

          // Processing
          data.response = 'test reuperé de KIS';

          var iframe = window.frames[IFRAME_TIERCE_ID];
          var message = JSON.stringify({
            data: data,
            method: 'setDataTierce',
          });

          iframe.postMessage(message, scope.originServer);
        };

        /*
         * Fonction de test
         * Envoyer des données de KIS vers Tierce (ONAS)
         * Récupère les données du form ng-model="data2" du template (tiercewidget.html)
         * et l'envoi vers l'application tierce (ONAS)
         */
        scope.sendDataTest = function() {
          console.log('Sending data from KIS to tierce ...');
          console.log('Data : ' + scope.data2);

          var iframe = window.frames[IFRAME_TIERCE_ID];
          var message = JSON.stringify({
            data: scope.data2,
            method: 'setDataTierce',
          });

          iframe.postMessage(message, scope.originServer);
        };

        /*====================================================================
                 *
                 * Local functions
                 *
                 ====================================================================*/

        function loadConfiguration() {
          ConfigFactory.get('widgets', scope.ConfigName).then(
            function(res) {
              if (res.data != '') {
                scope.config = res.data;
                console.info('Tierce application is loaded');
                readConfiguration();
              } else {
                console.error('widgets or tierce.json' + ' does not exist !');
              }
            },
            function(reason) {
              console.error(
                'An error is occured when loading tierce configuration : ' +
                  reason
              );
            }
          );
        }

        /**
         *
         */
        function readConfiguration() {
          console.log('Configuration : ' + JSON.stringify(scope.config));

          if (scope.config.hasOwnProperty('postmessage')) {
            var postmessage = scope.config['postmessage'];

            if (
              postmessage.hasOwnProperty('originServer') &&
              postmessage['originServer'] != ''
            ) {
              scope.originServer = postmessage['originServer'];
            }
          }

          /*
           * Set default values, there are not configured in file config.
           */
          if (!scope.config.hasOwnProperty('zoom')) {
            scope.config.zoom = 14;
          }

          if (!scope.config.hasOwnProperty('widgetWidth')) {
            scope.config.widgetWidth = 600;
            //                        alert("1 : " + scope.config.widgetWidth);
          }

          // Buffer
          if (!scope.config.hasOwnProperty('buffer')) {
            scope.config.buffer = {};
          }
          if (!scope.config.buffer.hasOwnProperty('distance')) {
            scope.config.buffer['distance'] = 0.2;
          }
          if (!scope.config.buffer.hasOwnProperty('type')) {
            scope.config.buffer['type'] = 'ROUND';
          }

          // Association
          if (!scope.config.hasOwnProperty('association')) {
            scope.config.association = {};
          }
          if (!scope.config.buffer.hasOwnProperty('layername')) {
            scope.config.association['layername'] = 'CAJ_REL_AR';
          }
          if (!scope.config.buffer.hasOwnProperty('relname')) {
            scope.config.association['relname'] = 'REL_NAME';
          }
          if (!scope.config.buffer.hasOwnProperty('feata')) {
            scope.config.association['feata'] = 'FEATA';
          }
          if (!scope.config.buffer.hasOwnProperty('ida')) {
            scope.config.association['ida'] = 'IDA';
          }
          if (!scope.config.buffer.hasOwnProperty('featd')) {
            scope.config.association['featd'] = 'FEATD';
          }
          if (!scope.config.buffer.hasOwnProperty('idd')) {
            scope.config.association['idd'] = 'IDD';
          }
        }

        /**
         * Update the id and name frame dynamically
         */
        function updateIframeId() {
          var iframe = document.getElementById(IFRAME_TIERCE_ID);

          iframeId = scope.active.id;
          iframe.id = iframeId;
          iframe.name = iframeId;

          console.log(
            'New iframe id : ' + document.getElementById(iframeId).id
          );
        }

        /**
         * Add listener for listen event comming from tierce app
         */
        function addListeners() {
          addEvent(window, 'message', function(event) {
            console.log('Receiving message from : ' + event.origin + '....');

            if (event.origin !== scope.originServer) {
              console.error(
                'server origin : ' +
                  event.origin +
                  ' is different to server config : ' +
                  scope.originServer
              );
              return;
            }

            console.log('Active : ' + scope.active.isActive);
            if (!scope.active.isActive) {
              return;
            }

            event.stopPropagation();

            var response = $.parseJSON(event.data);

            console.log('Function : ' + response.method);
            console.log('Data : ' + JSON.stringify(response.data));

            // Set data in view, to do watch listener
            scope.data = response;
            try {
              scope.$apply(function() {
                console.log('Modification done !');
              });
            } catch(err) {}
          });
        }

        // Watch function
        var unbindWatch = undefined;

        /**
         * On opening the widget we subscribe to an event "openTools_tiercedirective",
         * to create a watch on data ngModel view
         */
        function addEventWidgetListeners() {
          scope.$on('openTools_tiercedirective', function(event, tool) {
            var currentIframeId = document.getElementById(iframeId);
            currentIframeId.style.width = scope.config.widgetWidth + 'px';
            currentIframeId.src = currentIframeId.src;
            scope.data = '';

            // If current widget, create watch on data (ngModel in view)
            if (scope.ConfigName == tool.config) {
              if (unbindWatch) {
                unbindWatch();
              }
              unbindWatch = scope.$watch('data', function(newValue, oldValue) {
                if (newValue != '') {
                  gcTierceFunctions.excuteFunction(
                    newValue,
                    map,
                    scope,
                    ngTableParams
                  );
                }
              });
            }
          });

          /**
           * On closing the widget we subscribe to an event "closeTools_tiercedirective",
           * to remove the watch on data ngModel view
           */
          scope.$on('closeTools_tiercedirective', function(event, tool) {
            // If current widget, remove watch from data (ngModel in view)
            if (scope.ConfigName == tool.config) {
              unbindWatch();
              scope.data = '';
            }
          });

          scope.$on('openCloseTools_tiercedirective', function(event, tool) {
            // If current widget, remove watch from data (ngModel in view)
            if (scope.ConfigName == tool.config) {
              unbindWatch();
              scope.data = '';
            }
          });
        }
      },
    };
  };

  tierceWidget.$inject = [
    'gcTierceFunctions',
    'ConfigFactory',
    'FeatureTypeFactory',
    'SelectManager',
    'gcPopup',
    'ngDialog',
    'extendedNgDialog',
    'ngTableParams',
    '$location',
  ];

  return tierceWidget;
});
