'use strict';
define([
  'angular',

  'widgets/sirocoapp/init/directives/paramsList',
  'widgets/sirocoapp/init/directives/cassesDetailExp',

  'widgets/sirocoapp/init/controllers/supervisionCtrl',
  'widgets/sirocoapp/init/controllers/initCtrl',
  'widgets/sirocoapp/init/controllers/mapCtrl',
  'widgets/sirocoapp/init/controllers/cassesCtrl',
  'widgets/sirocoapp/init/controllers/parametersCtrl',
  'widgets/sirocoapp/init/controllers/ponderationCtrl',
  'widgets/sirocoapp/init/controllers/varianteCtrl',
  'widgets/sirocoapp/init/controllers/varianteCompareCtrl',
  'widgets/sirocoapp/init/controllers/affinageCtrl',
  'widgets/sirocoapp/init/controllers/sitesCtrl',
  'widgets/sirocoapp/init/controllers/sitesPlanningCtrl',
], function(
  angular,
  paramsList,
  cassesDetailExp,
  supervisionCtrl,
  initCtrl,
  mapCtrl,
  cassesCtrl,
  parametersCtrl,
  ponderationCtrl,
  varianteCtrl,
  varianteCompareCtrl,
  affinageCtrl,
  sitesCtrl,
  sitesPlanningCtrl
) {
  // Module
  var mod = angular.module('siroco_init', []);

  // Directives
  mod.directive('paramsList', paramsList);
  mod.directive('cassesDetailExp', cassesDetailExp);

  // Controllers
  mod.controller('supervisionCtrl', supervisionCtrl);
  mod.controller('initCtrl', initCtrl);
  mod.controller('mapCtrl', mapCtrl);
  mod.controller('cassesCtrl', cassesCtrl);
  mod.controller('parametersCtrl', parametersCtrl);
  mod.controller('varianteCtrl', varianteCtrl);
  mod.controller('varianteCompareCtrl', varianteCompareCtrl);
  mod.controller('affinageCtrl', affinageCtrl);
  mod.controller('sitesCtrl', sitesCtrl);
  mod.controller('sitesPlanningCtrl', sitesPlanningCtrl);

  //route provider
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/siroco/', {
        templateUrl: 'siroco.html',
        controller: 'gcSirocoController',
      });

      $routeProvider.when('/siroco/supervision', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/supervision.html',
        controller: supervisionCtrl,
      });

      $routeProvider.when('/siroco/init', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/init.html',
        controller: initCtrl,
      });
      $routeProvider.when('/siroco/map', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/map.html',
        controller: mapCtrl,
      });
      $routeProvider.when('/siroco/casses', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/casses.html',
        controller: cassesCtrl,
      });
      $routeProvider.when('/siroco/parameters', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/parameters.html',
        controller: parametersCtrl,
      });
      $routeProvider.when('/siroco/ponderation', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/ponderation.html',
        controller: ponderationCtrl,
      });
      $routeProvider.when('/siroco/criticality', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/criticality.html',
      });
      $routeProvider.when('/siroco/scenarii', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/scenarii.html',
        controller: varianteCtrl,
      });
      $routeProvider.when('/siroco/scenarii_comparison', {
        templateUrl:
          'js/XG/widgets/sirocoapp/init/views/scenarii_comparison.html',
        controller: varianteCompareCtrl,
      });
      $routeProvider.when('/siroco/refine', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/refine.html',
        controller: affinageCtrl,
      });
      $routeProvider.when('/siroco/sites', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/sites.html',
        controller: sitesCtrl,
      });

      $routeProvider.when('/siroco/sites_planning', {
        templateUrl: 'js/XG/widgets/sirocoapp/init/views/sites_planning.html',
        controller: sitesPlanningCtrl,
      });
    },
  ]);
  return mod;
});
