/**@module layerManager*/
'use strict';
define(function() {
  var dbParamInfo = function(
    $rootScope,
    gcPopup,
    ConfigFactory,
    extendedNgDialog,
    $timeout,
    EditFactory,
    $filter,
    ParametersFactory,
    SelectManager,
    QueryFactory,
    gaDomUtils
  ) {
    return {
      /**@property {String} templateUrl Url of the directive UI*/
      templateUrl: 'js/XG/widgets/utilities/dbParamInfo/views/dbParamInfo.html',
      /** @type {String} [description] */
      restrict: 'AE',

      scope: {
        paramData: '=pParamData',
        prepareParamInfo: '&',
        setParamData: '&',
        ConfigNameTemplate: '=ConfigNameTemplate',
      },

      /**
       * link
       * @param scope
       * @param element
       * @param attrs
       * @param ctrl
       */
      link: function(scope, element, attrs, ctrl) {
        scope.messages = {};
        scope.messages.defaultVal = $filter('translate')(
          attrs.dbParamIdentifier + '.default'
        );
        scope.messages.addDbParam = $filter('translate')(
          attrs.dbParamIdentifier + '.addDbParam'
        );
        scope.messages.dbParamName = $filter('translate')(
          attrs.dbParamIdentifier + '.dbParamName'
        );
        scope.messages.updateDbParam = $filter('translate')(
          attrs.dbParamIdentifier + '.updateDbParam'
        );
        scope.messages.getDbParam = $filter('translate')(
          attrs.dbParamIdentifier + '.getDbParam'
        );
        scope.messages.name_exists = $filter('translate')(
          attrs.dbParamIdentifier + '.name_exists'
        );
        scope.messages.setDefault = $filter('translate')(
          attrs.dbParamIdentifier + '.setDefault'
        );
        scope.dbParams = [];
        scope.selected = {};
        if (attrs.idOfSelected != undefined) {
          scope.selected.id = attrs.idOfSelected;
          scope.withInitialSelectedParam = true;
        }

        if (attrs.size != undefined) {
          //-- Préparation des nom de classes CSS
          scope.sizeOfText = 'db-params-font-' + attrs.size;
          scope.widthOfDiv = 'db-param-width-' + attrs.size;
          scope.cmdHorizPadding = 'db-params-cmd-padding-' + attrs.size;
        }

        var map = scope.map;
        // The ngRepeat collection is the map's array of layers. ngRepeat
        // uses $watchCollection internally. $watchCollection watches the
        // array, but does not shallow watch the array items! The array
        // items are OpenLayers layers, we don't want Angular to shallow
        // watch them.

        scope.currentuser = $rootScope.xgos.user;
        scope.DEFAULT_DB_PARAM_CONFIGURATION_NAME =
          attrs.dbParamType + '_LAST_EDITED' + $rootScope.xgos.user.uid;

        function loadDbParamList() {
          var promise = ParametersFactory.getbytype(attrs.dbParamType);
          promise.then(
            function(res) {
              if (scope.dbParams == undefined) scope.dbParams = [];
              else scope.dbParams.splice(0, scope.dbParams.length);
              for (var ii = 0; ii < res.data.length; ii++) {
                res.data[ii].data.id = res.data[ii].id;
                res.data[ii].data.name = res.data[ii].name;
                scope.dbParams.push(res.data[ii]);
              }
              //--  Garder valeurs avant modifications éventuelles.
              scope.dbParamsOri = angular.copy(scope.dbParams);
              //--  Transmettre paramètre sélectionné par défaut.
              if (scope.withInitialSelectedParam) {
                for (var ii = 0; ii < res.data.length; ii++) {
                  if (res.data[ii].id == scope.selected.id) {
                    scope.thisSetParam(scope.selected.id);
                    break;
                  }
                }
                scope.withInitialSelectedParam = false;
              }
            },
            function(res) {
              console.error('no config user');
            }
          );
          return promise;
        }

        loadDbParamList().then(
          function() {
            getDefaultDbParam();
          },
          function() {
            getDefaultDbParam();
          }
        );

        scope.currentDbParam = {
          id: Math.floor(Math.random() * 100000000000),
          name: undefined,
        };

        /**
         *    Récupération du paramètre désigné comme paramètre par défaut.
         *
         * @param {Object} noReload
         */
        function getDefaultDbParam(noReload) {
          ParametersFactory.getbytype(
            scope.DEFAULT_DB_PARAM_CONFIGURATION_NAME
          ).then(
            function(res) {
              if (res.data.length > 0) {
                scope.defaultDbParam = res.data[0];
                if (!noReload && scope.dbParams && scope.dbParams.length > 0) {
                  var modified = false;
                  scope.dbParams.map(function(x) {
                    if (x.id === scope.defaultDbParam.data.id) {
                      //scope.defaultDbParam = x;
                      modified = true;
                    }
                  });
                }
              } else scope.defaultDbParam = undefined;
            },
            function() {
              console.error('no config user');
            }
          );
        }

        function broadcastDbParamUpdated(fromDefault, action) {
          $rootScope.$broadcast('dbParamListUpdated', scope.$id);
          if (fromDefault)
            $rootScope.$broadcast('dbParamdefaultUpdated', scope.$id, action);
        }

        /**
         *     Mise à jour du paramètre par défaut :
         * si le paramètre par défaut existait il est supprimé,
         * puis cette fonction d'ajout du paramètre par défaut
         * est appelée.
         *
         * @param {Object} data
         * @param {Object} fromDefault
         * @param {Object} action
         */
        function updateDefaultDbParamOk(data, fromDefault, action) {
          ParametersFactory.add(
            data,
            scope.DEFAULT_DB_PARAM_CONFIGURATION_NAME,
            scope.DEFAULT_DB_PARAM_CONFIGURATION_NAME
          ).then(
            function(res) {
              scope.defaultDbParam = res.data;
              broadcastDbParamUpdated(fromDefault, action);
            },
            function() {
              broadcastDbParamUpdated(fromDefault, action);
            }
          );
        }

        /**
         *     Si le paramètre par défaut existe, on le supprime, et
         * on le recrée, sinon on se content de le créer.
         *
         * @param {Object} data
         * @param {Object} fromDefault
         * @param {Object} action
         */
        function updateDefaultDbParam(data, fromDefault, action) {
          if (!scope.defaultDbParam || scope.defaultDbParam.id == undefined) {
            updateDefaultDbParamOk(data, fromDefault, action);
          } else {
            ParametersFactory.remove(scope.defaultDbParam.id).then(
              function() {
                updateDefaultDbParamOk(data, fromDefault, action);
              },
              function() {
                broadcastDbParamUpdated(fromDefault, action);
              }
            );
          }
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
        }

        function removeLastEditedMapModel(fromDefault, action) {
          ParametersFactory.remove(scope.defaultDbParam.id).then(
            function() {
              scope.defaultDbParam = undefined;
              if (fromDefault)
                $rootScope.$broadcast(
                  'dbParamdefaultUpdated',
                  scope.$id,
                  action
                );
            },
            function() {}
          );
        }

        function saveDbParam() {
          ParametersFactory.add(
            scope.paramData,
            attrs.dbParamType,
            scope.paramData.name
          ).then(
            function(res) {
              scope.dbParams.push(res.data);
              scope.dbParamsOri.push(angular.copy(res.data));
              scope.selected.id = res.data.id;
              if (attrs.eventToBroadcastWhenUpdate != undefined)
                $rootScope.$broadcast(
                  attrs.eventToBroadcastWhenUpdate,
                  scope.$id
                );
              require('toastr').success($filter('translate')('common.saved'));
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
              if (attrs.eventToBroadcastWhenUpdate != undefined)
                $rootScope.$broadcast(
                  attrs.eventToBroadcastWhenUpdate,
                  scope.$id
                );
            }
          );
        }

        function updateParam(param) {
          //-- Si le paramètre modifié est le paramètre par défaut
          //-- on appele la fonction de mise à jour du paramètre par défaut.
          if (
            scope.defaultDbParam &&
            scope.defaultDbParam.data &&
            param.id === scope.defaultDbParam.id
          )
            updateDefaultDbParam(param.data);
          param.data.id = param.id;
          param.data.name = param.name;

          //-- Modification = suppression + création
          ParametersFactory.remove(param.id).then(
            function() {
              ParametersFactory.add(
                param.data,
                attrs.dbParamType,
                param.name
              ).then(
                function(res) {
                  var idx = scope.dbParams
                    .map(function(x) {
                      return x.id;
                    })
                    .indexOf(param.id);
                  if (idx !== -1) {
                    var updatingSelectedParam = param.id == scope.selected.id;
                    res.data.data.id = res.data.id;
                    scope.dbParams[idx] = res.data;
                    scope.dbParamsOri[idx] = angular.copy(res.data);
                    //if (updatingSelectedParam)
                    scope.selected.id = res.data.id;
                    scope.thisSetParam(scope.selected.id);
                  }
                  //-- Broadcast pour envoyer à autre occurence du widget
                  //-- info comme quoi la liste est actualisée.
                  $rootScope.$broadcast('dbParamListUpdated', scope.$id);
                  //updateDefaultDbParam(res.data.data);
                  require('toastr').success(
                    $filter('translate')('common.updated')
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                  $rootScope.$broadcast('dbParamListUpdated', scope.$id);
                }
              );
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
              $rootScope.$broadcast('dbParamListUpdated', scope.$id);
            }
          );
        }

        function removeDbParamConfig(dbparam) {
          if (
            scope.defaultDbParam &&
            scope.defaultDbParam.data &&
            dbparam.data.name === scope.defaultDbParam.data.name
          )
            removeLastEditedMapModel();
          var promise = ParametersFactory.remove(dbparam.id).then(
            function() {
              $rootScope.$broadcast('dbParamListUpdated', scope.$id);
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
              $rootScope.$broadcast('dbParamListUpdated', scope.$id);
            }
          );

          return promise;
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
        }

        scope.addDbParam = function() {
          //-- Si une fonction pour compléter le paramètre en base est à appeler, on le fait.
          //-- Cette fonction portée par le parent peut completer "paramData"
          //-- On devrait l'appeler dans le cas du "mapmodel" pour réaliser les 2 lignes suivantes:
          //--   scope.currentDbParam.propmap = getmapconfig();
          //--   scope.currentDbParam.data = getMapModelOperational();
          if (scope.prepareParamInfo != undefined)
            scope.paramData = scope.prepareParamInfo();
          scope.paramData.lastEdited = true;
          scope.dbParams.map(function(x) {
            x.lastEdited = false;
          });
          scope.paramData.name = scope.paramDataName;
          scope.paramDataName = '';
          saveDbParam();
          scope.currentDbParam = {
            id: Math.floor(Math.random() * 100000000000),
            name: undefined,
          };
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
          // $rootScope.$broadcast("dbParamListUpdated",scope.$id);
        };

        scope.updateParamData = function(param) {
          if (scope.prepareParamInfo != undefined)
            param.data = scope.prepareParamInfo();
          scope.dbParams.map(function(x) {
            x.lastEdited = false;
          });
          param.lastEdited = true;
          updateParam(param);
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
          // $rootScope.$broadcast("dbParamListUpdated",scope.$id);
        };

        scope.removeDbParam = function(mapmodel) {
          var ans = confirm($filter('translate')('common.delete_confirm'));
          if (ans) {
            removeDbParamConfig(mapmodel).then(function() {
              var idx = scope.dbParams
                .map(function(x) {
                  return x.id;
                })
                .indexOf(mapmodel.id);
              if (idx !== -1) scope.dbParams.splice(idx, 1);
              scope.dbParamsOri.splice(idx, 1);
            });
          }
          //-- Broadcast pour envoyer à autre occurence du widget
          //-- info comme quoi la liste est actualisée.
        };

        scope.setDefaultDbParamStep2 = function(dbparam) {
          var idDefault = dbparam.id;
          var action;

          if (
            angular.isUndefined(scope.defaultDbParam) ||
            angular.isUndefined(scope.defaultDbParam.data) ||
            dbparam.id !== scope.defaultDbParam.id
          ) {
            action = 'set';
            //-- Pour être capable de rattacher le paramètre
            //-- par défaut à la liste des paramètres.
            dbparam.data.id = dbparam.id;
            dbparam.data.name = dbparam.name;
            updateDefaultDbParam(dbparam.data, true, action);
          } else {
            action = 'remove';
            removeLastEditedMapModel(true, action);
          }
        };

        /**
         *    Choix du paramètre par défaut.
         *  Lorsqu'un paramétrage est choisi comme paramétrage par défaut
         *  on l'enregistre dans le type de paramètre calculé dans
         *  la variable DEFAULT_DB_PARAM_CONFIGURATION_NAME.
         *
         * @param {Object} dbparam
         */
        scope.setDefaultDbParam = function(dbparam) {
          ParametersFactory.getbytype(
            scope.DEFAULT_DB_PARAM_CONFIGURATION_NAME
          ).then(function(res) {
            var ind;
            if (res.data.length != 0) {
              for (ind = 0; ind < res.data.length; ind++) {
                var newDefault = res.data[ind].data.id != dbparam.id;
                ParametersFactory.remove(res.data[ind].id).then(function() {
                  if (!newDefault) scope.defaultDbParam = undefined;
                  else if (ind == res.data.length)
                    scope.setDefaultDbParamStep2(dbparam);
                });
              }
            } else scope.setDefaultDbParamStep2(dbparam);
          });
        };

        scope.nameexists = function(newName) {
          var b = false;
          if (scope.dbParams && scope.dbParams.length > 0)
            scope.dbParams.map(function(x) {
              if (x.name === newName) b = true;
            });
          return b;
        };

        scope.getOriginalParamData = function(id) {
          var ind;
          for (ind = 0; ind < scope.dbParams.length; ind++)
            if (scope.dbParams[ind].id == id) {
              //-- Rétablir le dernier paramètre tel que
              //-- sauvegardé pour la dernière fois.
              scope.dbParams[ind] = angular.copy(scope.dbParamsOri[ind]);
              //-- Sécurité pour le cas où
              scope.dbParams[ind].data.name = scope.dbParams[ind].name;
              break;
            }
        };

        scope.thisSetParam = function(paramDataId) {
          scope.getOriginalParamData(paramDataId);
          var ind,
            obj = {};
          for (ind = 0; ind < scope.dbParams.length; ind++)
            if (scope.dbParams[ind].id == paramDataId) {
              obj.paramData = scope.dbParams[ind].data;
              scope.paramData = obj.paramData;
              scope.setParamData(obj);
            }
          scope.selected.id = paramDataId;
        };

        scope.$on('dbParamInfoUnselectCurrent', function(evt, param) {
          scope.selected.id = undefined;
        });

        scope.$on('dbParamListUpdated', function(evt, scopeId) {
          if (scope.$id != scopeId)
            //-- Une autre occurence du widget a modifié la liste des modéles de carte.
            //-- Il faut un timeout, car on risque de reonstruire la liste avant
            //-- que les requêtes de suppression et ajout en cas de modification ne soient effectives.
            // setTimeout(loadModelList,500);
            loadDbParamList();
        });

        scope.$on('dbParamdefaultUpdated', function(evt, scopeId, action) {
          if (scope.$id != scopeId)
            //-- Une autre occurence du widget a modifié la liste des modéles de carte.
            //-- Il faut un timeout, car on risque de reonstruire la liste avant
            //-- que les requêtes de suppression et ajout en cas de modification ne soient effectives.
            // setTimeout(function(){
            //     switch (action){
            //       case "remove":
            //         scope.lasteditedMapModel = undefined;
            //         break;
            //       case "set":
            //         getLastEditedMapModel(true);
            //         break;
            //     }
            // },500);
            switch (action) {
              case 'remove':
                scope.defaultDbParam = undefined;
                break;
              case 'set':
                getDefaultDbParam(true);
                break;
            }
        });
      },
    };
  };

  dbParamInfo.$inject = [
    '$rootScope',
    'gcPopup',
    'ConfigFactory',
    'extendedNgDialog',
    '$timeout',
    'EditFactory',
    '$filter',
    'ParametersFactory',
    'SelectManager',
    'QueryFactory',
    'gaDomUtils',
  ];
  return dbParamInfo;
});
