'use strict';
define(function() {
  var gceditsaveAttachmentFactory = function(
    $timeout,
    ngDialog,
    FeatureAttachmentFactory,
    gaDomUtils
  ) {
    /**
     * Class : gceditsaveAttachmentFactory
     * Factory contenant certainement que du code mort depuis KIS-2877
     */

    /**
     * Ouvre la popup de chargement des fichiers attachés.<br>
     * Exécute la construction d'un tableau d'informations sur tous les fichiers à uploader (les fichiers de tous les objets sans distinction de fti).<br>
     * <code>isAbleToSaveRelatedFeatureAttachments</code> est le booleen qui indique si on souhaite sauvegarder les fichiers attachés de tous les objets (objets liés compris).
     * Si cette variable est true on ouvre une popup avec barre de progression. Si false, c'est une popup amateur et ultra-sale qui est ouverte.
     * @param scope variables de la directive bizeditwidget/bizeditsave
     */
    const showPercent = (scope) => {
      scope.uploadedFiles = [];
      scope.filesToUpload = getFilesToUpload(scope);
      if (scope.isAbleToSaveRelatedFeatureAttachments) {
        let isClosing = false;
        scope.pbDialog = ngDialog.open({
          template: 'js/XG/widgets/utilities/edit/views/gceditsave.upload.progress.html',
          className: 'ngdialog-theme-plain width600 nopadding miniclose gceditsave-upload',
          closeByDocument: false,
          scope: scope,
          preCloseCallback: () => {
            if (!isClosing) {
              delete scope.totalFileSize;
              delete scope.uploadProgress;
              delete scope.progressWidth;
              isClosing = true;
            }
          }
        });
      } else {
        scope.pbDialog = ngDialog.open({
          template: 'js/XG/widgets/utilities/edit/views/gceditsave.upload.html',
          className: 'ngdialog-theme-plain width600 nopadding',
          closeByDocument: false,
          scope: scope,
        });
        $timeout(function() {
          getContainerElt(scope);
        }, 0);
      }
    };

    /**
     * Construit un tableau d'objet contenant les caractéristiques sur chaque fichier attaché à uploader (nom, taille...).
     * Attention, la structure de la variable {@link scope.uploadfile} est très différente suivant la valeur de isAbleToSaveRelatedFeatureAttachments:<ul><li>
     *   <code>{@link isAbleToSaveRelatedFeatureAttachments} = true</code> : sauvegarde aussi les fichiers attachés des objets liés</li><li>
     *   <code>isAbleToSaveRelatedFeatureAttachments = false</code> : ancienne façon de faire qui arrive seulement à sauvegarder les fichiers attachés d'un seul objet avec des défauts</li></ul>
     * @param scope variables de la directive bizeditwidget/bizeditsave
     * @return {object[]} tableau de caractéristiques sur les fichiers à uploader
     */
    const getFilesToUpload = (scope) => {
      let files = [];
      if (scope.isAbleToSaveRelatedFeatureAttachments) {
        scope.totalFileSize = 0;
        for (let ftiGroup of Object.values(scope.uploadfile)) {
          for (let featureGroup of Object.values(ftiGroup)) {
            for (const attributeGroup of Object.values(featureGroup)) {
              for (const file of attributeGroup) {
                files.push({
                  name: file.name,
                  progressBarIsNeeded: false,
                  progression: 0,
                  size: file.size
                });
                scope.totalFileSize += file.size;
              }
            }
          }
        }
      } else {
        for (let group in scope.uploadfile) {
          for (let ind = 0; ind < scope.uploadfile[group].length; ind++) {
            files.push({
              name: scope.uploadfile[group][ind].name,
              progressBarIsNeeded: false,
              progression: 0,
            });
          }
        }
      }
      return files;
    };

    function getContainerElt(scope) {
      scope.containerElt = document.getElementById(
        'upload_content_of_gceditsave'
      );
      if (scope.containerElt == null)
        $timeout(function() {
          getContainerElt(scope);
        }, 100);
      else
        scope.setScrolPos = function(iFile) {
          if (iFile < 2) return;
          if (scope.containerElt.scrollHeight > scope.filesToUpload.length) {
            let lineHeight =
              scope.containerElt.scrollHeight / scope.filesToUpload.length;
            if (iFile * lineHeight > scope.containerElt.clientHeight)
              scope.containerElt.scrollTo(
                0,
                (iFile + 1) * lineHeight - scope.containerElt.clientHeight
              );
          }
        };
    }

    function uploadAttachmentFiles(scope, ftiname, id) {
      var svgUploadFile = angular.extend({}, scope.uploadfile);

      var i = 0;

      var keys = Object.keys(svgUploadFile);
      var key = keys[i];
      if (!svgUploadFile[key] || !svgUploadFile[key].length
        || svgUploadFile[key].length === 0) return;
      svgUploadFile[key] = svgUploadFile[key].sort(function(a, b) {
        if (a.size > b.size) return 1;
        if (a.size < b.size) return -1;
      });
      if (i < keys.length) {
        if (!scope.isAbleToSaveRelatedFeatureAttachments) {
          gaDomUtils.showGlobalLoader();
        }
        showPercent(scope);
        var j = 0;

        var files = svgUploadFile[key];
        var files_length = files.length;
        if (j < files_length)
          uploadFilesForFTID(i, j, id, files, files_length, keys,
            svgUploadFile, scope, ftiname
          );
      }
    }

    /**
     *   Arrêt de l'affichage des éléments d'attente.
     */
    function closeWaitingStuffs(scope) {
      $timeout(function() {
        scope.pbDialog.close();
        //vider la liste des uploadFile après le chargement
        scope.uploadfile = {};
        gaDomUtils.hideGlobalLoader();
      }, 3500);
    }

    function getFileToUploadIndex(scope, filename) {
      for (let ind = 0; ind < scope.filesToUpload.length; ind++) {
        if (scope.filesToUpload[ind].name === filename) {
          return ind;
        }
      }
      return -1;
    }

    /**
     * Upload de ficheir sur le serveur avec stockage en piéce attaché à
     * l'objet décrit dans les paramétres.
     *
     * @param {*} i : index du contenu de fichier à uploader
     * @param {number} j : index du fichier à traiter
     * @param {*} id : identifiant de l'objet pour construire
     *                 le dossier de stockage dans le repository
     * @param {*} files : liste des ficheirs à uploader
     * @param {*} files_length : taille des ficheirs à uploader
     * @param {*} keys : clefs des conteus de fichier à uploader (à confirmer)
     * @param {*} svgUploadFile : contenu des fichiers à uploader (à confirmer)
     * @param {*} scope : scope de la directive pour agir sur l'IHM
     * @param {*} ftiname : nom du composant pour construire
     *                      le dossier de stockage dans le repository
     */
    function uploadFilesForFTID(i, j, id, files, files_length, keys,
      svgUploadFile, scope, ftiname) {
      try {
        scope.fileBeingLoaded = files[j].name;
        let iFile = getFileToUploadIndex(scope, scope.fileBeingLoaded);
        if (scope.setScrolPos != undefined) scope.setScrolPos(iFile);
        FeatureAttachmentFactory.uploadFile(files[j], ftiname, id,
          scope.filesToUpload[iFile]).then(function() {
          scope.uploadedFiles.push(scope.fileBeingLoaded);
          scope.fileBeingLoaded = '';
          j++;
          if (j < files_length) {
            uploadFilesForFTID(
              i,
              j,
              id,
              files,
              files_length,
              keys,
              svgUploadFile,
              scope,
              ftiname
            );
          } else {
            i++;
            j = 0;
            if (i < keys.length) {
              var key = keys[i];
              if (j < files_length)
                uploadFilesForFTID(
                  i,
                  j,
                  id,
                  svgUploadFile[key],
                  svgUploadFile[key].length,
                  keys,
                  svgUploadFile,
                  scope,
                  ftiname
                );
            } else {
              closeWaitingStuffs(scope);
            }
          }
        });
      } catch (error) {
        console.log('error', error);
      }
    }

    /**
     * Méthode pour copier un fichier attaché dans le dossier ATTACHMENTS du repo.
     * Il s'agit d'une copie nettoyée et simplifiée de la méthode {@link uploadAttachmentFiles}
     * avec quelques vestiges nauséabonds sur l'usage d'un scope en paramètre et la gestion du 1er attribut
     * @param {object} scope contenu de la directive bizeditwidget
     * @param {object} filesToUpload objet contenant les fichiers attachés de l'objet dont l'id est fourni en paramètre
     * @param {string} ftiName nom du composant
     * @param {string} featureId id du composant (ex. <code>ASS_TRONCON.7635</code>)
     */
    const uploadFeatureAttachmentFiles = (scope, filesToUpload, ftiName, featureId) => {
      const svgUploadFile = Object.assign({}, filesToUpload);
      const attributes = Object.keys(svgUploadFile);
      const firstAttribute = attributes[0];
      const firstAttributeFiles = svgUploadFile[firstAttribute];
      if(!firstAttributeFiles || Object.keys(firstAttributeFiles).length === 0) {
        return;
      }
      svgUploadFile[firstAttribute] = svgUploadFile[firstAttribute].sort(function(a, b) {
        if (a.size > b.size) return 1;
        if (a.size < b.size) return -1;
      });
      if (!scope.isAbleToSaveRelatedFeatureAttachments) {
        gaDomUtils.showGlobalLoader();
      }
      showPercent(scope);
      const firstFilesCount = firstAttributeFiles.length;
      uploadFilesForFTID(0, 0, featureId, firstAttributeFiles, firstFilesCount, attributes, svgUploadFile, scope, ftiName);
    };

    return {
      uploadAttachmentFiles: uploadAttachmentFiles,
      uploadFeatureAttachmentFiles: uploadFeatureAttachmentFiles,
      showPercent: showPercent
    };
  };
  gceditsaveAttachmentFactory.$inject = [
    '$timeout',
    'ngDialog',
    'FeatureAttachmentFactory',
    'gaDomUtils',
  ];
  return gceditsaveAttachmentFactory;
});
