'use strict';
define(function() {
  var gcelement = function(
    RecursionHelper,
    $filter,
    $rootScope,
    AncAppFactory,
    BacAppFactory,
    $http,
    FeatureTypeFactory,
    gaDomUtils,
    ElasticFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/elastic/views/elasticRelations.html',
      restrict: 'A',

      scope: {
        map: '=map',
        condition: '=condition',
        components: '=components',
        filter: '=filter',
        onRemove: '&',

        allowFieldsConfiguration: '=?', // allow the user to specifiy rule configuration (ie visibility)
        fieldsConfiguration: '=?', // configuration des champs : visibilite par exemple (utilise dans elasticEditRequest),
        fakeJsonFti: '=?',
      },
      compile: function(element) {
        return RecursionHelper.compile(element, function(
          scope,
          iElement,
          iAttrs,
          controller,
          transcludeFn
        ) {
          // Define your normal link function here.
          // Alternative: instead of passing a function,
          // you can also pass an object with
          // a 'pre'- and 'post'-link function.

          // note rb : semble etre trigger plusieurs fois meme si on ne l'utilise qu'une fois
          // ce qui fait que les watch, par ex, sont trigger plusieurs fois aussi

          // console.log(scope.filter);

          scope.filter.attr = {};
          scope.applicationType = $rootScope.xgos.sector;

          scope.applicationIsAnc =
            scope.applicationType === 'anc' || scope.applicationType == 'bac';

          if (scope.components == undefined || !Array.isArray(scope.components) || scope.components.length === 0) {
            scope.components = FeatureTypeFactory.resources.featuretypes;
          }

          scope.controleAlias = false;
          var checkCtrlAlias = FeatureTypeFactory.resources.featuretypes.filter(
            function(x) {
              // @TODO RB Reactiver ici pour faire apparaitre dans bac
              return scope.applicationType === 'bac'
                ? x.name == 'kis_bac_dossier_controle'
                : x.name == 'kis_anc_dossier_controle';
            }
          );
          if (checkCtrlAlias.length)
            scope.controleAlias = checkCtrlAlias[0].alias;

          // This is a weird hack to make sure these are numbers
          scope.booleans = ['False', 'True'];
          scope.booleansOrder = ['True', 'False'];
          var allaliases;
          function defineVariables() {
            if (!scope.applicationIsAnc) {
              scope.filter.relations = scope.filter.selectedfti.relations.map(
                function(x) {
                  return x.type;
                }
              );
              scope.filter.relations.push('REL_TOPOLOGY');
              scope.filter.relations = $.unique(scope.filter.relations);
              allaliases = scope.components.map(function(x) {
                return x.alias;
              });

              /**
               * RELATION TOPOLOGIQUE
               */
              scope.rel_simple = $filter('translate')(
                'elastic.search.relation_simple'
              );
              scope.rel_NM = $filter('translate')('elastic.search.relation_NM');
              scope.rel = $filter('translate')('elastic.search.relation');
              scope.filter.relationsAliases = scope.filter.selectedfti.relations.map(
                function(x) {
                  if (x.alias && x.alias !== '') {
                    return x.alias;
                  } else {
                    return x.name;
                  }
                }
              );

              if (scope.filter.selectedfti.geographic) {
                scope.filter.choices = scope.filter.relationsAliases.concat([
                  $filter('translate')('elastic.search.DISJOINT'),
                  $filter('translate')('elastic.search.INTERSECTS'),
                  $filter('translate')('elastic.search.TOUCHES'),
                  $filter('translate')('elastic.search.CROSSES'),
                  $filter('translate')('elastic.search.WITHIN'),
                  $filter('translate')('elastic.search.CONTAINS'),
                  $filter('translate')('elastic.search.OVERLAPS'),
                ]);
              } else {
                scope.filter.choices = angular.copy(
                  scope.filter.relationsAliases
                );
              }

              scope.geometricoperand = [
                $filter('translate')('elastic.search.DISJOINT'),
                $filter('translate')('elastic.search.INTERSECTS'),
                $filter('translate')('elastic.search.TOUCHES'),
                $filter('translate')('elastic.search.CROSSES'),
                $filter('translate')('elastic.search.WITHIN'),
                $filter('translate')('elastic.search.CONTAINS'),
                $filter('translate')('elastic.search.OVERLAPS'),
              ];

              scope.aliases = scope.components
                .map(function(x) {
                  if (
                    x.geographic &&
                    x.alias !== scope.condition.selectGlobaladvancedFti
                  )
                    return x.alias;
                })
                .filter(function(x) {
                  if (x) return x;
                });
            } else {
              if (scope.filter.selectedfti.name === 'kis_anc_dossier') {
                scope.geometricoperand = [
                  $filter('translate')('elastic.search.anc.contient'),
                ];
                scope.filter.choices = scope.geometricoperand;

                var toPick = [
                  'kis_anc_dossier_controle',
                  'kis_anc_dossier_filiere',
                ];
                if (AncAppFactory.appCfg.main.properties.formVidange == true) {
                  toPick.push('kis_anc_vidange_formulaire');
                }

                scope.aliases = scope.components
                  .map(function(x) {
                    if (
                      x.inElasticSearch &&
                      x.alias !== scope.condition.selectGlobaladvancedFti &&
                      toPick.indexOf(x.name) !== -1
                    )
                      return x.alias;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });
              } else if (
                scope.filter.selectedfti.name === 'kis_anc_dossier_controle'
              ) {
                scope.geometricoperand = [
                  $filter('translate')('elastic.search.anc.contient'),
                ];
                scope.filter.choices = scope.geometricoperand;

                scope.aliases = scope.components
                  .map(function(x) {
                    if (
                      x.inElasticSearch &&
                      x.alias !== scope.condition.selectGlobaladvancedFti &&
                      ['kis_anc_dossier'].indexOf(x.name) !== -1
                    )
                      return x.alias;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });

                // scope.aliases.push("Tout type de contrôle");
                // @RB mai 2018 on deplace dans la partie elasticRule
                AncAppFactory.appCfg.main.controleCfg.forEach(function(c) {
                  scope.aliases.push(c.label_court);
                });
              } else if (
                scope.filter.selectedfti.name === 'kis_anc_vidange_formulaire'
              ) {
                console.log(scope.filter.selectedfti);

                scope.geometricoperand = [
                  $filter('translate')('elastic.search.anc.contient_vidange'),
                ];
                scope.filter.choices = scope.geometricoperand;
                // NE pas forcer sinon ne fonctionne pas avec les requetes qui ont plusieurs relations, par ex avec les dossiers (factu)
                //scope.filter.relation = 'REL_DOSSIER_VIDANGE';
                //scope.filter.alias = '*';

                // scope.aliases = scope.components.map( function(x){
                //     if ( x.inElasticSearch &&
                //             x.alias !== scope.condition.selectGlobaladvancedFti &&
                //             ["kis_anc_dossier"].indexOf(x.name) !== -1)
                //         return x.alias;
                // }).filter(function(x){
                //     if ( x ) return x;
                // });

                //scope.aliases.push("Interventions");
              } else if (
                scope.filter.selectedfti.name === 'kis_anc_dossier_filiere'
              ) {
                scope.geometricoperand = [
                  $filter('translate')('elastic.search.anc.contient'),
                ];
                scope.filter.choices = scope.geometricoperand;

                scope.aliases = scope.components
                  .map(function(x) {
                    if (
                      x.inElasticSearch &&
                      x.alias !== scope.condition.selectGlobaladvancedFti &&
                      x.name.startsWith('kis_anc_ef_')
                    )
                      return x.alias;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });
              }
              // BAC
              else if (scope.filter.selectedfti.name === 'kis_bac_dossier') {
                scope.geometricoperand = [
                  $filter('translate')('elastic.search.anc.contient'),
                ];
                scope.filter.choices = scope.geometricoperand;

                var toPick = ['kis_bac_dossier_controle'];

                scope.aliases = scope.components
                  .map(function(x) {
                    if (
                      x.inElasticSearch &&
                      x.alias !== scope.condition.selectGlobaladvancedFti &&
                      toPick.indexOf(x.name) !== -1
                    )
                      return x.alias;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });
              } else if (
                scope.filter.selectedfti.name === 'kis_bac_dossier_controle'
              ) {
                scope.geometricoperand = [
                  $filter('translate')('elastic.search.anc.contient'),
                ];
                scope.filter.choices = scope.geometricoperand;

                scope.aliases = scope.components
                  .map(function(x) {
                    if (
                      x.inElasticSearch &&
                      x.alias !== scope.condition.selectGlobaladvancedFti &&
                      ['kis_anc_dossier'].indexOf(x.name) !== -1
                    )
                      return x.alias;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });

                // scope.aliases.push("Tout type de contrôle");
                BacAppFactory.appCfg.main.controleCfg.forEach(function(c) {
                  //   console.log(c);
                  scope.aliases.push(c.label_court);
                });
              }
            }
          }

          try {
            var index = scope.components
              .map(function(x) {
                if (x.inElasticSearch) return x.alias;
              })
              .indexOf(scope.condition.selectGlobaladvancedFti);
            if (index === -1)
              index = scope.components
                .map(function(x) {
                  return x.alias;
                })
                .indexOf(scope.condition.selectGlobaladvancedFti);
            scope.filter.selectedfti = scope.components[index];
            defineVariables();
          } catch (e) {
            FeatureTypeFactory.get().then(function(res) {
              if (scope.applicationIsAnc)
                scope.components = FeatureTypeFactory.resources.featuretypes
                  .map(function(x) {
                    if (
                      ([
                        'kis_anc_dossier',
                        'kis_anc_dossier_controle',
                        'kis_anc_dossier_filiere',
                      ].indexOf(x.name) !== -1 ||
                        x.name.startsWith('kis_anc_ef_')) &&
                      x.inElasticSearch
                    )
                      return x;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });
              else scope.components = FeatureTypeFactory.resources.featuretypes;

              var index = scope.components
                .map(function(x) {
                  if (x.inElasticSearch) return x.alias;
                })
                .indexOf(scope.condition.selectGlobaladvancedFti);
              if (index === -1)
                index = scope.components
                  .map(function(x) {
                    return x.alias;
                  })
                  .indexOf(scope.condition.selectGlobaladvancedFti);
              scope.filter.selectedfti = scope.components[index];
              defineVariables();
            });
          }

          scope.clickedCheckbox = function() {
            scope.filter.value = scope.autocompleteglobalsearchinclude
              .map(function(x) {
                if (x.selected) return x.name;
              })
              .filter(function(x) {
                if (x) return x;
              })
              .join(',');
          };

          scope.howToUser = function() {
            swal({
              title: $filter('translate')('elastic.search.info'),
              text: $filter('translate')('elastic.search.useparmi'),
              type: 'info',
            });
          };

          /**
           * setCurrentAncControleQuestion
           * @param question
           */

          var kis_anc_listes_deroulantes_controles = 0;
          scope.setCurrentAncControleQuestion = function() {
            var saveQ = angular.copy(scope.filter.controle_json_value);

            scope.ancControleRestrictions = false;

            if (
              angular.isDefined(saveQ.formFieldAttname) &&
              angular.isDefined(saveQ.formFieldAttname)
            ) {
              if (!kis_anc_listes_deroulantes_controles)
                kis_anc_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByNameAndDatastore(
                  AncAppFactory.appCfg.main.datastore,
                  'kis_anc_listes_deroulantes_controles'
                );

              var attr = kis_anc_listes_deroulantes_controles.attributes.filter(
                function(x) {
                  return x.name == saveQ.formFieldAttname;
                }
              );

              if (attr.length) {
                if (attr[0].restrictions.length) {
                  var restrictions = attr[0].restrictions[0].listofValues;
                  scope.ancControleRestrictions = restrictions;
                  //    console.log(scope.ancControleRestrictions);
                }
              }
            }
            scope.filter.question = saveQ.key;
          };

          /* displayTranslatedAlias
           * @param alias
           * @returns {string}
           */
          scope.displayTranslatedAlias = function(alias) {
            if (scope.applicationIsAnc) {
              return alias;
            } else {
              var name = scope.components.filter(function(x) {
                  return x.alias === alias;
                })[0].name,
                key = 'features.' + name + '.alias';

              return !~$filter('translate')(key).indexOf(key)
                ? $filter('translate')(key)
                : alias;
            }
          };

          /* displayTranslatedAlias
           * @param alias
           * @returns {string}
           */
          scope.displayTranslatedRelation = function(alias) {
            var name = scope.components.filter(function(x) {
                return x.alias === alias;
              })[0].name,
              key = 'features.' + name + '.alias';

            return !~$filter('translate')(key).indexOf(key)
              ? $filter('translate')(key)
              : alias;
          };

          scope.$watch(
            'filter.newValueUtil',
            function(newval) {
               if (!newval || !newval[Object.keys(newval)[0]]) return;
              scope.filter.value = newval[Object.keys(newval)[0]];
            },
            1
          );

          var typeRelationControle;
          scope.$watch('filter.choicesdone', function(newval) {
            if (!newval) return;

            // desactive pour le moment
            if (
              0 &&
              scope.filter.selectedfti.name === 'kis_anc_dossier_controle'
            ) {

            } else {
              switch (newval) {
                case $filter('translate')('elastic.search.DISJOINT'):
                case $filter('translate')('elastic.search.INTERSECTS'):
                case $filter('translate')('elastic.search.TOUCHES'):
                case $filter('translate')('elastic.search.CROSSES'):
                case $filter('translate')('elastic.search.WITHIN'):
                case $filter('translate')('elastic.search.CONTAINS'):
                case $filter('translate')('elastic.search.OVERLAPS'):
                  scope.filter.relation = 'REL_TOPOLOGY';
                  scope.filter.operand = getOperand(scope.filter.choicesdone);
                  if (angular.isUndefined(scope.filter.filters))
                    scope.filter.filters = [];
                  break;
                case $filter('translate')('elastic.search.anc.contient'):
                  scope.filter.relation = 'REL_DOSSIER_CONTROLE';
                  if (angular.isUndefined(scope.filter.filters))
                    scope.filter.filters = [];
                  break;
                case $filter('translate')(
                  'elastic.search.anc.contient_vidange'
                ):
                  scope.filter.relation = 'REL_DOSSIER_VIDANGE';
                  if (angular.isUndefined(scope.filter.filters))
                    scope.filter.filters = [];
                  break;
                default:
                  if (angular.isUndefined(newval)) break;
                  if (angular.isUndefined(scope.filter.filters))
                    scope.filter.filters = [];
                  var relationAliasIndex = scope.filter.relationsAliases.indexOf(
                    newval
                  );
                  if (relationAliasIndex === -1) break;
                  var relation =
                    scope.filter.selectedfti.relations[relationAliasIndex];
                  switch (relation.type) {
                    case 'REL_NM':
                      scope.filter.relation = 'REL_NM';
                      var nameindex = scope.components
                        .map(function(x) {
                          return x.name;
                        })
                        .indexOf(relation.componentEnd);
                      scope.filter.relation_NM_choosen =
                        scope.components[nameindex];
                      scope.filter.selectGlobaladvancedFti =
                        scope.components[nameindex].alias;
                      scope.relations_NM_SIMPLE = [
                        scope.filter.selectGlobaladvancedFti,
                      ];
                      scope.filter.relation_NM_SIMPLE =
                        scope.filter.selectGlobaladvancedFti;
                      scope.filter.relationName = [relation.name];
                      break;
                    case 'REL_SIMPLE':
                      scope.filter.relation = 'REL_SIMPLE';
                      var nameindex = scope.components
                        .map(function(x) {
                          return x.name;
                        })
                        .indexOf(relation.componentEnd);
                      scope.filter.relation_SIMPLE_choosen =
                        scope.components[nameindex];
                      scope.filter.selectGlobaladvancedFti =
                        scope.components[nameindex].alias;
                      scope.relations_NM_SIMPLE = [
                        scope.filter.selectGlobaladvancedFti,
                      ];
                      scope.filter.relation_NM_SIMPLE =
                        scope.filter.selectGlobaladvancedFti;
                      scope.filter.relationName = [relation.name];
                      break;
                  }
                  break;
              }
            }
          });

          scope.$watch('filter.question', function(newval) {
            // console.log(newval);
            // console.log(scope.filter.questionschoosen);
            // console.log(scope.filter.questions);
            // console.log(scope.filter.questions.indexOf(newval));

            if (!newval) return;
            scope.filter.questionchoosen =
              scope.filter.questionschoosen[
                scope.filter.questions.indexOf(newval)
              ];

            if (scope.filter.questionchoosen.values)
              scope.filter.values = scope.filter.questionchoosen.values.map(
                function(x) {
                  return x.description;
                }
              );
          });

          scope.$watch('filter.newvalue', function(newval) {
            if (!newval) return;
            scope.filter.value =
              scope.filter.questionchoosen.values[
                scope.filter.values.indexOf(newval)
              ];
          });

          function getOperand(choice) {
            var operand;
            switch (choice) {
              case $filter('translate')('elastic.search.DISJOINT'):
                operand = 'DISJOINT';
                break;
              case $filter('translate')('elastic.search.INTERSECTS'):
                operand = 'INTERSECTS';
                break;
              case $filter('translate')('elastic.search.TOUCHES'):
                operand = 'TOUCHES';
                break;
              case $filter('translate')('elastic.search.CROSSES'):
                operand = 'CROSSES';
                break;
              case $filter('translate')('elastic.search.WITHIN'):
                operand = 'WITHIN';
                break;
              case $filter('translate')('elastic.search.CONTAINS'):
                operand = 'CONTAINS';
                break;
              case $filter('translate')('elastic.search.OVERLAPS'):
                operand = 'OVERLAPS';
                break;
            }
            return operand;
          }
          if (
            scope.filter.operand &&
            scope.filter.relation === 'REL_TOPOLOGY'
          ) {
            switch (scope.filter.operand) {
              case 'DISJOINT':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.DISJOINT'
                );
                break;
              case 'INTERSECTS':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.INTERSECTS'
                );
                break;
              case 'TOUCHES':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.TOUCHES'
                );
                break;
              case 'CROSSES':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.CROSSES'
                );
                break;
              case 'WITHIN':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.WITHIN'
                );
                break;
              case 'CONTAINS':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.CONTAINS'
                );
                break;
              case 'OVERLAPS':
                scope.filter.choicesdone = $filter('translate')(
                  'elastic.search.OVERLAPS'
                );
                break;
            }
          }

          // broadcast reset relationdashboard
          // permet de reset la liste des relations qui sans ca ne serait jamais mise a jour
          scope.resetRelationDashBoard = function() {
            $rootScope.$broadcast('elastic_resetRelationDashBoard', {});
          };

          scope.$watch('filter.alias', function(newval, oldval) {
            // on ne reset QUE si on a change dans le select directement
            if (newval && oldval && newval != oldval)
              scope.resetRelationDashBoard();

            if (newval && scope.filter.relation === 'REL_TOPOLOGY') {
              scope.filter.selectGlobaladvancedFti = newval;
              var index = allaliases.indexOf(newval);
              scope.filter.relation_TOPOLOGY_choosen = scope.components[index];
            }
            if (newval && scope.filter.relation === 'REL_DOSSIER_CONTROLE') {
              scope.filter.selectGlobaladvancedFti = newval;
              try {
                var index = scope.components
                  .map(function(x) {
                    return x.alias;
                  })
                  .indexOf(newval);

                // console.log(newval);
                // console.log(index);

                if (index != -1) {
                  scope.filter.relation_DOSSIER_CONTROLE_choosen =
                    scope.components[index];
                } else {
                  var CurrentAppFactory =
                    scope.applicationType == 'bac'
                      ? BacAppFactory
                      : AncAppFactory;

                  var indexCtrlAnc = CurrentAppFactory.appCfg.main.controleCfg
                    .map(function(c) {
                      return c.label_court;
                    })
                    .indexOf(newval);
                  CurrentAppFactory.getBuildedFakeCtrlReponseFtiForElasticSearch(
                    CurrentAppFactory.appCfg.main.controleCfg[indexCtrlAnc].type
                  ).then(function(res) {
                    // console.log(res);
                    scope.filter.relation_DOSSIER_CONTROLE_choosen = res;
                  });
                }
              } catch (e) {
                console.log(e);
                console.info('normal');
              }
            }
            if (newval && scope.filter.relation === 'REL_DOSSIER_VIDANGE') {
              scope.filter.selectGlobaladvancedFti = newval;
              try {
                var index = scope.components
                  .map(function(x) {
                    return x.alias;
                  })
                  .indexOf(newval);

                if (index != -1) {
                  scope.filter.relation_DOSSIER_CONTROLE_choosen =
                    scope.components[index];
                } else {
                  scope.filter.relation_DOSSIER_VIDANGE_choosen = {
                    name: 'kis_anc_vidange_formulaire_reponse',
                    alias: 'vidange formulaire reponse',
                    attributes: [],
                  };
                }
              } catch (e) {
                console.log(e);
                console.info('normal');
              }
            }
          });

          /**
           * RELATION NM SIMPLE
           */

          scope.relations_NM_SIMPLE = $.unique(
            scope.filter.selectedfti.relations
              .map(function(x) {
                if (x.type === 'REL_NM' || x.type === 'REL_SIMPLE') {
                  var index = scope.components
                    .map(function(x) {
                      return x.name;
                    })
                    .indexOf(x.componentEnd);
                  return scope.components.map(function(x) {
                    return x.alias;
                  })[index];
                }
              })
              .filter(function(x) {
                if (x) return x;
              })
          );

          //if ( scope.relations_NM_SIMPLE.length === 1 ) scope.filter.relation_NM_SIMPLE = scope.relations_NM[0];
          scope.$watch('filter.relation_NM_SIMPLE', function(newval) {
            if (newval) {
              if (angular.isUndefined(scope.filter.filters))
                scope.filter.filters = [];
            }
          });

          scope.initFilter = function(filter) {
            filter.alias = undefined;
            filter.relation_NM = undefined;
            filter.relation_SIMPLE = undefined;
            filter.filters = [];
          };

          scope.checkelementsforback = function(filter) {
            switch (filter.choicesdone) {
              case scope.rel:
                if (filter.relation_NM_SIMPLE_choosen == undefined) {
                  filter.getBackResults = true;
                } else {
                  filter.getBackResults = false;
                }
                break;
              case $filter('translate')('elastic.search.DISJOINT'):
              case $filter('translate')('elastic.search.INTERSECTS'):
              case $filter('translate')('elastic.search.TOUCHES'):
              case $filter('translate')('elastic.search.CROSSES'):
              case $filter('translate')('elastic.search.WITHIN'):
              case $filter('translate')('elastic.search.CONTAINS'):
              case $filter('translate')('elastic.search.OVERLAPS'):
                if (filter.relation_TOPOLOGY_choosen == undefined) {
                  filter.getBackResults = true;
                } else {
                  filter.getBackResults = false;
                }
                break;
            }
          };

          /**
           * Adds a Single Rule
           */
          scope.addRule = function() {
            if (scope.filter.filters == undefined) scope.filter.filters = [];
            scope.filter.filters.push({ choice: 'rule' });
            console.log(scope.filter.filters);
          };

          /**
           * Adds a Single Rule
           */
          scope.addRelation = function(relation) {
            if (scope.filter.filters == undefined) scope.filter.filters = [];
            scope.filter.filters.push({ choice: 'relation' });
          };

          /**
           * Removes either Group or Rule
           */
          scope.removeChild = function(idx, filters) {
            filters.splice(idx, 1);
          };

          scope.getBackResults = function(filter) {
            if (filter.getBackResult == undefined) filter.getBackResult = false;
            filter.getBackResult = !filter.getBackResult;
          };
        });
      } /*,
            link: function(scope) {
                
                scope.filter.attr={};


                // This is a weird hack to make sure these are numbers
                scope.booleans = [ 'False', 'True' ];
                scope.booleansOrder = [ 'True', 'False' ];
                   
                var index = scope.components.map( function(x){ if ( x.inElasticSearch ) return x.alias; }).indexOf(scope.condition.selectGlobaladvancedFti);
                scope.filter.selectedfti = scope.components[index];
                scope.filter.relations = scope.filter.selectedfti.relations.map(function(x){return x.type;});   
                scope.filter.relations.push("REL_TOPOLOGY");
                scope.filter.relations = $.unique(scope.filter.relations);
                var allaliases = scope.components.map( function(x){ return x.alias; });
                
                /**
                 * RELATION TOPOLOGIQUE
                 */,
      /*scope.geometricoperand = [ 'DISJOINT', 'INTERSECTS', 'TOUCHES', 'CROSSES', 'WITHIN', 'CONTAINS', 'OVERLAPS'];
            scope.aliases = scope.components.map( function(x){ 
                    if ( x.geographic && x.alias != scope.condition.selectGlobaladvancedFti )
                        return x.alias; 
                }).filter(function(x){
                    if ( x ) return x;
                });
            scope.$watch("filter.alias",function(newval , oldval){
                    if ( newval && scope.filter.relation == "REL_TOPOLOGY") {
                        scope.filter.selectGlobaladvancedFti = newval;
                        var index = allaliases.indexOf(newval);
                        scope.filter.relation_TOPOLOGY_choosen = scope.components[index];
                    };
                });
            
            /**
             * RELATION NM
             */
      /*scope.relations_NM = $.unique(scope.filter.selectedfti.relations.map(function(x) {
                if ( x.type === "REL_NM" ) {
                    var index = scope.components.map( function(x){ return x.name; }).indexOf(x.componentEnd);
                    return scope.components.map( function(x){ return x.alias; })[index];
                }
            }).filter(function(x){
                if ( x ) return x;
            }));
            if ( scope.relations_NM.length === 1 ) scope.filter.relation_NM = scope.relations_NM[0];                
            scope.$watch("filter.relation_NM",function(newval){
                if ( newval && scope.filter.relation === "REL_NM") {
                    scope.filter.selectGlobaladvancedFti = newval;
                    var index = allaliases.indexOf(newval);
                    scope.filter.relation_NM_choosen = scope.components[index];
                };
            });
            
            /**
             * RELATION SIMPLE
             */
      /*scope.relations_SIMPLE = $.unique(scope.filter.selectedfti.relations.map(function(x) {
                if ( x.type === "REL_SIMPLE" ) {
                    var index = scope.components.map( function(x){ return x.name; }).indexOf(x.componentEnd);
                    return scope.components.map( function(x){ return x.alias; })[index];
                }
            }).filter(function(x){
                if ( x ) return x;
            }));
            if ( scope.relations_SIMPLE.length === 1 ) scope.filter.relation_SIMPLE = scope.relations_SIMPLE[0];
            scope.$watch("filter.relation_SIMPLE",function(newval){
                if ( newval && scope.filter.relation === "REL_SIMPLE" ) {
                    scope.filter.selectGlobaladvancedFti = newval;
                    var index = allaliases.indexOf(newval);
                    scope.filter.relation_SIMPLE_choosen = scope.components[index];
                };
            });
            
            /**
             * Adds a Single Rule
             */
      /*scope.addRule = function() {
                if ( scope.filter.filters == undefined ) scope.filter.filters = [];
                scope.filter.filters.push({"choice" : "rule"});
            };
            
            /**
             * Adds a Single Rule
             */
      /*scope.addRelation = function(relation) {
                if ( scope.filter.filters == undefined ) scope.filter.filters = [];
                scope.filter.filters.push({"choice" : "relation"});
            };
            
            /**
            * Removes either Group or Rule
            */
      /*scope.removeChild = function(idx ,filters) {
               filters.splice(idx, 1);
            };
            scope.$watch('filter.relation',function(newval){
                switch (newval) {
                    case "REL_NM":
                        if ( !scope.filter.relation_NM ) break;
                        var index = allaliases.indexOf(scope.filter.relation_NM);
                        if ( index !== -1 ) {
                            scope.filter.relation_NM_choosen = scope.components[index];
                            scope.filter.selectGlobaladvancedFti = scope.components[index].alias;
                        }
                        break;
                    case "REL_SIMPLE":
                        if ( !scope.filter.relation_SIMPLE ) break;
                        var index = allaliases.indexOf(scope.filter.relation_SIMPLE);
                        if ( index !== -1 ) {
                            scope.filter.relation_SIMPLE_choosen = scope.components[index];
                            scope.filter.selectGlobaladvancedFti = scope.components[index].alias;
                        }
                        break;
                    case "REL_TOPOLOGY":
                        break;
                };
            });*/
      //}
    };
  };

  gcelement.$inject = [
    'RecursionHelper',
    '$filter',
    '$rootScope',
    'AncAppFactory',
    'BacAppFactory',
    '$http',
    'FeatureTypeFactory',
    'gaDomUtils',
    'ElasticFactory',
  ];
  return gcelement;
});
