/**
 * Gestion des fonctions permettant l'appel des règles métiers:
 *
 * On peut ajouter dans ce fichier d'autres fonctions pour appeler d'autres règles métiers
 *
 * Auteur : @THV
 * Date: 17/11/2021
 */
'use strict';
define(function () {
  var editRulesFunctions = function () {
    this.$get = function (
      $q,
      EditRuleSetDefaultValueByRole
      ) {

      const init = () => {
        
      };
      init();

      /**
       * Retourne les points d'entrée de ce provider:
       * -1- executeSetDefaultValueByRole la gcFormFunction qui execute la regle
       *     métier 'SetDefaultValueByRole'
       */
      return {
        /**
         * Appel de toutes les règles 'SetDefaultValueByRole' présentent dans la config
         * 
         * @param {*} formRes : variables du formulaire (ressources du
         *                      formulaire)
         */
        executeSetDefaultValueByRole: (formRes, featureType, eventOrigin) => {
          let promises = [];
          // search for rules config
          if (featureType && featureType.rules && Array.isArray(featureType.rules)
            && eventOrigin === "addButton") {
            //keep only the rules we should execute
            let rulesToExecute = featureType.rules.filter( ruleConf => {
                if (ruleConf.name === "SetDefaultValueByRole") {
                  // executer seulement si ça correspond à la config au bon evenement
                  return ruleConf.editTypes.find((state) => state.name === "add");
                } else {
                  return false
                }
              });
            if (rulesToExecute && Array.isArray(rulesToExecute)) {
              let editDescription = {};
              editDescription.formFeature = formRes;
              // for each rule -> execute it with the proper config
              for (const ruleConf of rulesToExecute) {
                promises.push(
                  EditRuleSetDefaultValueByRole.setDefaultValueByRole(editDescription, ruleConf, featureType)
                  );
              }
            }
          }

          return $q.all(promises);
        }

      };
    };
    this.$get.$inject = [
      '$q',
      'EditRuleSetDefaultValueByRole'
    ];
  };
  return editRulesFunctions;
});
