'use strict';
define(function() {
  var gcelement = function(
    gcStyleFactory,
    FeatureTypeFactory,
    gcInteractions,
    SelectManager,
    $timeout,
    gaJsUtils,
    ogcFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/select/views/gcselect.html',
      restrict: 'A',
      scope: {
        map: '=map',
        result: '=res',
        geomdrag: '=?geomdrag',
        geomselect: '=?geomselect',
        ftisid: '=ftisid',
        toolBarWidget: '=?toolbarwidget',
        onfinish: '&',
        field: '=?',
        preventselect: '=?'
      },
      link: function(scope) {
        scope.ftis = [];
        scope.geomdrag = '';

        scope.$watch('ftisid', function() {
          updateFtis();
        });
        function updateFtis() {
          scope.ftis.splice(0);
          // je prend chaque uid et je recupere le fti associe que j'injecte dans ftis
          if (scope.ftisid) {
            for (const ftiuid of scope.ftisid) {
              if (typeof ftiuid === 'string' && ftiuid.length > 0) {
                const fti = FeatureTypeFactory.getFeatureByUid(ftiuid);
                if (fti && typeof fti.uid === 'string' && fti.uid.length > 0) {
                  scope.ftis.push(fti);
                }
              }
            }
          }
        }
        updateFtis();
        scope.selectinterv = function() {
          var map = scope.map;
          scope.isActive = true;

          // evenement de demarrage de la selection
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.dragBox.getActive()
              ); /* ||
                      //return evt.originalEvent.ctrlKey||scope.isActive ;/*
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });
          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'gcselectclassic' + Math.random());
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.dragBox.setActive(true);
          // ajout de l'intercation dragBox
          //
          map.addInteraction(scope.dragBox);

          //evenement envoye a la fin de drag Box
          scope.dragBox.on('boxend', function(evt) {
            // URL de rcup des objets
            let ftiUids = '';

            // WFS a besoin des typesName (layer)
            scope.ftis.forEach(function(fType) {
              ftiUids = ftiUids + fType.uid + ',';
            });
            const geometryExtent = scope.dragBox.getGeometry().getExtent();
            scope.geomdrag = scope.dragBox.getGeometry();
            const type = scope.geomdrag.getType();
            const coords = scope.geomdrag.getCoordinates();
            scope.geomselect = {
              coordinates: coords,
              type: type,
            };
            const leftX = geometryExtent[0];
            const bottomY = geometryExtent[1];
            const rightX = geometryExtent[2];
            const topY = geometryExtent[3];

            const cql_filter =  'INTERSECTS(geom, POLYGON((' +
              leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' +
              rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' +
              leftX + ' ' + bottomY +
              ')))';
            let useMode = 'query';
            if (scope.field
              && scope.field.config.geomselect && scope.field.config.geomselect!=='') {
              useMode = 'edition';
            }
            const promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', ftiUids, 'json',
              map.getView().getProjection().getCode(), cql_filter, '',
              undefined, undefined, useMode
            );

            const promise2 = promise.then(function(res) {

              if (!SelectManager.isGeojsonEmpty(res.data)) {
                // Dans le cas d'un formulaire d'intervention simple,
                // si on veut cumuler les sélections
                if(scope.field && scope.result && scope.field.config.cumulateSelections === true) {
                  scope.result = gaJsUtils.mergeTwoGetFeatResult(res.data, scope.result);
                } else {
                  scope.result = res.data;
                }

                if ((evt.mapBrowserEvent.pointerEvent &&
                        evt.mapBrowserEvent.pointerEvent.ctrlKey) ||
                    (evt.mapBrowserEvent.originalEvent &&
                        evt.mapBrowserEvent.originalEvent.ctrlKey)
                ) {
                  scope.result.addMode = true;
                } else {
                  scope.result.addMode = false;
                }
                if (!scope.preventselect){
                  SelectManager.addFeaturesFromGeojson(scope.result);
                }
                try {
                  $timeout(()=> {
                    scope.$apply();
                  });
                } catch (err) {
                  console.log(err);
                }
              }
            });

            promise2.then(function() {
              scope.dragBox.setActive(false);
              map.removeInteraction(scope.dragBox);
              $timeout(function() {
                //Solution Edilbert: sans () ça marche pas, angular met la fonction onfinish() elle même en réference 
                scope.onfinish()(evt);
              });
            });
          });
        };
      },
    };
  };

  gcelement.$inject = [
    'gcStyleFactory',
    'FeatureTypeFactory',
    'gcInteractions',
    'SelectManager',
    '$timeout',
    'gaJsUtils',
    'ogcFactory'
  ];
  return gcelement;
});
