#!C:/Python27/python.exe
# -*- coding: utf-8 -*-

import sys , cStringIO, socket , imghdr
from StringIO import StringIO
from PIL import Image
#import multiprocessing as mp
import numpy as np
import xml.etree.ElementTree as ET
import urllib3
from cgi import parse_qs, escape


def getQuery (server , service, boundingBox , crs , size,
	format,transparency,tiled,wmsVersion,layer,
	layerstyle,cql=""):
	if cql == "":
		return "%s?SERVICE=%s&REQUEST=GetMap&VERSION=%s&FORMAT=%s&TRANSPARENT=%s&LAYERS=%s&STYLES=%s&tiled=%s&WIDTH=%s&HEIGHT=%s&CRS=%s&BBOX=%s,%s,%s,%s" %(server,service,wmsVersion,format,transparency,layer,layerstyle,tiled,size[0],size[1],crs,boundingBox[0],boundingBox[1],boundingBox[2],boundingBox[3])
	else:
		return "%s?SERVICE=%s&REQUEST=GetMap&VERSION=%s&FORMAT=%s&TRANSPARENT=%s&LAYERS=%s&STYLES=%s&tiled=%s&WIDTH=%s&HEIGHT=%s&CRS=%s&BBOX=%s,%s,%s,%s&CQL_FILTER=%s" %(server,service,wmsVersion,format,transparency,layer,layerstyle,tiled,size[0],size[1],crs,boundingBox[0],boundingBox[1],boundingBox[2],boundingBox[3],cql)

def createQuery(form):
	keys = form.keys();
	requete = ""
	for s in keys:
		field = form[s][0];
		query = "%s=%s" %(s,field);
		if "portal" in s:
			requete = "http://%s/geoserver/%s/wms?%s" %(socket.gethostbyname(socket.gethostname()),field,requete)
		else:
			if requete == "":
				requete = "%s" %query
			else:
				requete = "%s&%s" %(requete,query)
	if 'STYLES' not in keys:
		requete = '%s&STYLES=' %requete
	return requete

def setOpacity(layer,CQL,wmsSplitted,querySplitted,
	service, boundingBox , crs , size, format,transparency,tiled,
	wmsVersion,Image_Array,messages,error):

	index = wmsSplitted['LAYERS'].index(layer);	
	if len(wmsSplitted['STYLES']) == 0 :
		layerstyle = "";
	else:
		layerstyle = wmsSplitted['STYLES'][index];

	THECQL = CQL.replace('&','').replace('=','');
	if THECQL in wmsSplitted.keys():
		cql = wmsSplitted[THECQL][index];
	else:
		cql = "";

	query = getQuery(querySplitted[0], service, boundingBox , crs , size, format,transparency,tiled,wmsVersion,layer,layerstyle,cql);
	query = query.replace(' ','%20');
	http = urllib3.PoolManager();
	answer = http.request('GET', query);
	img = answer.data;
	try:
		image = Image.open(StringIO(img)).convert("RGBA");
		x = np.array(image)
		r, g, b, a = np.rollaxis(x, axis=-1)

		# Opacity traitement 
		if 'OPACITY' in wmsSplitted.keys():
			Opacity = wmsSplitted['OPACITY'][index];
			for sel in range(len(a)):
				a[sel] = (a[sel]*float(Opacity)).astype(int);
			x = np.dstack([r, g, b, a])				
			image = Image.fromarray(x , "RGBA")		
		else:
			Opacity = "";

		Image_Array.append(image);
		return [ Image_Array , messages , error ];
	except:
		error = True;
		messages.append(img);
		Image_Array.append("noLayer");
		return [ Image_Array , messages , error ];


def treatment(wmsSplitted,CQL,querySplitted):
	if wmsSplitted['REQUEST'] == 'GetMap':
		boundingBox = wmsSplitted['BBOX'];
		crs = wmsSplitted['CRS'];
		size = ( wmsSplitted['WIDTH'] , wmsSplitted['HEIGHT'] );
		format = wmsSplitted['FORMAT'];
		transparency = wmsSplitted['TRANSPARENT'];
                try :
                    tiled = wmsSplitted['tiled'] ;
                except KeyError:
                    tiled = wmsSplitted['TILED'] ;
		wmsVersion = wmsSplitted['VERSION'];
		#tilesorigin = wmsSplitted['tilesorigin'];
		service = wmsSplitted['SERVICE'];
		Image_Array = [];
		error = False;
		messages = [];
		for layer in wmsSplitted['LAYERS']:
			[ Image_Array , messages , error ] = setOpacity(layer,CQL,wmsSplitted,querySplitted,
						service, boundingBox , crs , size, format,transparency,tiled,
						wmsVersion,Image_Array,messages,error)
		if error:
			return [ Image_Array , messages , error ]
		else:
			if Image_Array[0] != "noLayer":
				image_Final = Image_Array[0];


			index = 1 ;
			while index < len(Image_Array):
				if Image_Array[index-1] != "noLayer" and Image_Array[index] != "noLayer":
					image_Final = Image.alpha_composite(image_Final , Image_Array[index]);
				else:
					if Image_Array[index] != "noLayer":
						image_Final = Image_Array[index];
				index += 1;

			f = cStringIO.StringIO()
			image_Final.save(f, 'png')
			f.seek(0)
			return [ f.getvalue() , messages , error ]

def main(form):
	
	CQL = "&CQL_FILTER="
	if sys.platform == "win32":
		import os, msvcrt
		msvcrt.setmode(1,os.O_BINARY)

	requete = createQuery(form).replace(';',',');
	if 'OPACITY' in requete or CQL in requete :
		querySplitted = requete.split("?");
		part2 = querySplitted[1];
		Arraydata = part2.split("&");

		wmsSplitted = {};
		for n in Arraydata :
			Obj = {};
			if "=" not in n :
				n = "%s=" %n;
			ArraySplit = n.split("=",1);
			Array = ArraySplit[1].split(",");
			if len(Array) > 1 or ArraySplit[0] == 'LAYERS' or ArraySplit[0] == 'STYLES' or ArraySplit[0] in CQL or ArraySplit[0] == 'OPACITY':
				wmsSplitted[ArraySplit[0]] = Array;		
			else :
				wmsSplitted[ArraySplit[0]] = ArraySplit[1];	
		[ answer , messages , error ] = treatment(wmsSplitted,CQL,querySplitted);
		return [ answer , messages , error ];
	else:
		error = False;
		messages = [];
		http = urllib3.PoolManager();
		requete =  requete.replace('&STYLES&','&STYLES=&')
		answer = http.request('GET', requete);
		content = answer.getHeaders()['Content-Type'];
		if 'text/xml' in content:
			error = True;
			messages.append(answer.data);
			return [ answer.data , messages , error ] ;
		else:
			return [ answer.data , messages , error ] ;

def application(environ, start_response):
	status = '200 OK';
	form = parse_qs(environ['QUERY_STRING']);
	[ output , messages , error ] = main(form);
	if error:
		response_headers = [('Content-type', 'text/html')]
		start_response(status, response_headers)
		return messages
	else:	
		response_headers = [('Content-type', 'image/png')]
		start_response(status, response_headers)
		return output