/**
*
**/
  "use strict";
define(function () {
  var gcWFS = function() {
    this.$get = function(gcPropertiesLayers, gcMapUtils, gaUrlUtils) {
      var Wfs = function() {

        var createWfsLayer = function(params, options, index) {
          options = options || {};
          var attributions;
          var geojsonFormat = new ol.format.GeoJSON();
          var source = new ol.source.Vector({
            
            loader: function(extent, resolution, projection) {
            //  http://localhost/geoserver/fcfb5188-f826-42d6-83b3-ca493b0416ee/wfs?
                    /*var url = '/geoserver/'+localStorage.getItem('portal')+'/wfs?outputFormat=application/json&'+
                        'service=WFS&request=GetFeature&'+
                        'version=1.1.0&typename='+params.LAYERS+'&'+
                        'srsname='+options.srsname+'&'+
                        'bbox=' + extent.join(',') ;*/
//http://localhost/services/kis70c19313-ad0b-415f-982f-0786b1967afb/ogc/getfeat?service=WFS&version=1.0.0
//&request=GetFeature//
//&typeName=5df6c409-0cc2-410e-b372-dce7d87b7acb,db1d2fe0-7612-4720-a8eb-b6e5d06d6280,08f6b94b-5031-4c19-a370-161b0d0d4f6a,2876e39a-f795-4122-b6eb-49bab16eb066,283de05e-0019-4302-acd8-0341c74ff37f,c9023e3c-e263-46d5-8d3e-eb202c6ea0f9,dd2ab6fb-2347-4d5b-b05e-e7fcbecfa28e,40795471-9a77-47a0-b28e-93276a8a5104,271340c8-bb22-49a1-8b4f-5c665f15e477
//&outputformat=json
//&srsName=EPSG:3857
//&cql_filter=INTERSECTS(geom,%20POLYGON((661405.3262199739%206317590.621362275,661431.0042841635%206317590.621362275,661431.0042841635%206317613.61218719,661405.3262199739%206317613.61218719,661405.3262199739%206317590.621362275)))
//&token=ldlvozOkiA6JkEdUmI3y5b7hkOQeBs3BWBcPRpVQnnE%3D
//
//&srsName=' + map.getView().getProjection().getCode() + '&cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))';
                    var leftX = extent[0];
                    var bottomY = extent[1];

                    var rightX = extent[2];
                    var topY = extent[3];
                    var url = '/services/'+localStorage.getItem('portal')+'/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&outputformat=json&'+
                        
                        'typeName='+params.LAYERS+'&'+
                        'srsName='+options.srsname+'&'+
                        //'bbox=' + extent.join(',') +
                        '&cql_filter=INTERSECTS(geom, POLYGON((' + leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' + leftX + ' ' + bottomY + ')))&token=007';

                    $.ajax({
                        url: url
                    })
                    .done(function(response) {
                        source.addFeatures(geojsonFormat.readFeatures(response));
                    });
                },
                strategy: ol.loadingstrategy.tile(ol.tilegrid.createXYZ({
                  maxZoom: 19
                })),

          });
          var layer = new ol.layer.Vector({
              source: source,
            opacity: options.opacity,
            visible: options.visible,
            theme : options.theme,
            name:options.name,
            type: 'wfs',
              style: new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'rgba(181, 78, 16, 0.8)',
                  width: 2
                })
              })
            });
/*          var layer = new ol.layer.Image({
            id: 'WMS||' + options.label + '||' + options.url + '||' +
                params.LAYERS,
            url: options.url,
            type: 'WMS',
            opacity: options.opacity,
            visible: options.visible,
            attribution: options.attribution,
            source: source
          });*/
          gcPropertiesLayers(layer);
          layer.preview = options.preview;
          layer.displayInLayerManager = !layer.preview;
          layer.label = options.label;
          return layer;
        };


        // Create an ol WMS layer from FeatureTypeInformation informations
        this.getOlLayerFromFeaturetypeInfoArray = function(FeaturetypeInfos) {
            var typeNames = "";
            var names = "";

            angular.forEach(FeaturetypeInfos, function(fti) {
               typeNames = typeNames+fti.uid +",";
               names = names + fti.name;
            });
            typeNames = typeNames.substr(0,typeNames.length -1 );
            names = names.substr(0,names.length -1 );
          var wfsParams = { LAYERS: typeNames/*FeaturetypeInfo.uid*//*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,TILED:true};
          var wfsOptions = {
            //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
            url:'/services/'+localStorage.getItem('portal')+'/ogc/wfs?token=007&',
            label:names,
            name:names,
            srsname:'EPSG:3857',
            /*theme:FeaturetypeInfo.theme,
            name:FeaturetypeInfo.name,*/
            //extent: getCapLayer.extent,
            //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
          };

          return createWfsLayer(wfsParams, wfsOptions);
        };
        this.getOlLayerFromFeaturetypeInfo = function(FeaturetypeInfo) {
          if ( FeaturetypeInfo.type == 'esri' ) {
            var wfsParams = {LAYERS: FeaturetypeInfo.name/*FeaturetypeInfo.uid*//*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,TILED:true};
            var wfsOptions = {
              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url:FeaturetypeInfo.wfs,
              label: FeaturetypeInfo.alias,
              srsname:'EPSG:3857',
              /*theme:FeaturetypeInfo.theme,
              name:FeaturetypeInfo.name,*/
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          } else {
            var wfsParams = {LAYERS: FeaturetypeInfo.uid/*FeaturetypeInfo.uid*//*'2876e39a-f795-4122-b6eb-49bab16eb066,271340c8-bb22-49a1-8b4f-5c665f15e477'*/,TILED:true};
            var wfsOptions = {
              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url:'/services/'+localStorage.getItem('portal')+'/ogc/wfs?token=007&',
              label: FeaturetypeInfo.alias,
              srsname:'EPSG:3857',
              /*theme:FeaturetypeInfo.theme,
              name:FeaturetypeInfo.name,*/
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          };

          return createWfsLayer(wfsParams, wfsOptions);
        };
        //Create WFS layer from WMS Layer
        this.getOlLayerFromWMSLayer = function(layer) {
          console.log(layer)
          if ( layer.fti.type == 'esri' ) {
            var wmsParams = { LAYERS: layer.fti.name ,TILED:true };
            var wmsOptions = {

              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url:layer.fti.wfs,
              label: layer.label + " Vector",
              uid:layer.uid,
              
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          } else {
            var wmsParams = {LAYERS: layer,TILED:true};
            var wmsOptions = {

              //url: 'http://localhost:8082/geoserver/ed53f43f-7fda-4d61-ba16-9f0c1bfe5503/wms?token=007',
              url:'/services/'+localStorage.getItem('portal')+'/ogc/wfs?token=007&',
              label: layer.label + " Vector",
              uid:layer.uid,
              
              //extent: getCapLayer.extent,
              //attribution: gaUrlUtils.getHostname(getCapLayer.wmsUrl)
            };
          }
          return createWfsLayer(wmsParams, wmsOptions);
        };
        // Create a WMS layer and add it to the map
        this.addWfsToMap = function(map, layerParams, layerOptions, index) {
          var olLayer = createWfsLayer(layerParams, layerOptions);
          if (index) {
            map.getLayers().insertAt(index, olLayer);
          } else {
            map.addLayer(olLayer);
          }
          return olLayer;
        
        };
      };
      return new Wfs();
    };
  };

  gcWFS.$inject = [];
  return gcWFS;
});