'use strict';

define(['angular', 'modules/configuration/mod'], function(angular, config) {
  var apps = angular.module('app', config.standardAngularModules);
  /*
   *  httpRequestInterceptor
   *  Handles every single HTTP Request sent to the backend
   */
  apps.factory('httpRequestInterceptor', [
    '$q',
    '$location',
    '$rootScope',
    function($q, $location, $rootScope) {
      return {
        /**
         * Adds the JWT / the portalid
         */
        request: function(config) {
          // only if logged !
          config.headers = config.headers || {};

          //-- Ajout du token dans la requêtes, substitution de chaîne
          //-- entre accolades(portalid, app) sont à réaliser pour les requêtes
          //-- vers le serveur kis commençant par "/servcies" mais
          //-- pas pour celles concernant le proxy esri.
          if (config.url.indexOf('services') !== -1
          && config.url.indexOf('esriproxy') === -1) {
            // replaces the portal_id
            if (config.url.indexOf('{portalid}/') !== -1) {

              //// Ancienne façon de faire
              //-- If the application name is stored on the main module, use that one.
              //-- Else opening many tabs with different application won't work
              //-- because every tab would use the same application name !!!
              // var portalid = angular.module('gcMain').portalid;
              // if (portalid == undefined || portalid == '')
              //   portalid = localStorage.getItem('portal');
              // if (portalid == undefined || portalid == '') {
              //   config.url = config.url.replace('{portalid}', '-');
              // } else {
              //   config.url = config.url.replace('{portalid}', portalid);
              // }

              // Remplacement portalid par celui contenu dans gcMain ou l'URL ou datastorage ou '-'
              if (angular.module('gcMain')
                  && angular.module('gcMain').portalid
                  && angular.module('gcMain').portalid !== '') {
                config.url = config.url.replace('{portalid}', angular.module('gcMain').portalid);
              }
              if ($location.search().portal && $location.search().portal !== '') {
                config.url = config.url.replace('{portalid}', $location.search().portal);
              }
              if (localStorage.getItem('portal') && localStorage.getItem('portal') !== '') {
                config.url = config.url.replace('{portalid}', localStorage.getItem('portal'));
              }
              config.url = config.url.replace('{portalid}', '-');
            }

            if (config.url.indexOf('{appname}/') !== -1) {
              //-- If the application name is stored on the main module, use that one.
              //-- Else opening many tabs with different application won't work
              //-- because every tab would use the same application name !!!
              // @RB if the app is set in the url, we get it from here, so it doesnt matter if we get multiple tabs
              var app;
              if ($location.search().app) {
                app = $location.search().app;
              } else {
                app = angular.module('gcMain').app;
              }

              if (app == undefined || app == '')
                app = localStorage.getItem('app');

              if (app == undefined || app === '') {
                config.url = config.url.replace('{appname}', 'unknown');
              } else {
                config.url = config.url.replace('{appname}', app);
              }
            }

            var andChar;
            if (localStorage.getItem('auth_token')) {
              andChar = config.url.indexOf('?') !== -1 ? '&' : '?';
              config.url =
                config.url +
                andChar +
                'token=' +
                encodeURIComponent(localStorage.getItem('auth_token'));
            }

            if (
              $rootScope.xgos &&
              $rootScope.xgos.sector &&
              config.url.indexOf('token') !== -1
            ) {
              andChar = config.url.indexOf('?') !== -1 ? '&' : '?';
              config.url =
                config.url + andChar + 'kis_app=' + $rootScope.xgos.sector;
            }

            if ($rootScope.xgos && $location.search().app) {
              app = $location.search().app;
              andChar = config.url.indexOf('?') !== -1 ? '&' : '?';
              config.url = config.url + andChar + '&application=' + app;
            }
          }

          if (
            localStorage.getItem('ignore_user_cas') == 1 &&
            config.url.indexOf('/services/') !== -1
          ) {
            andChar = config.url.indexOf('?') !== -1 ? '&' : '?';
            config.url = config.url + andChar + 'nocas=1';
          }
          // @TODO
          //patch de correction de $selected envoyer dans les requets
          if (config && config.data && config.data.$selected) {
            delete config.data.$selected;
          }

          // append version number to avoid cache issues on client's browser.
          if (typeof config.url === 'string' &&
            (config.url.startsWith('js/') || config.url.startsWith('./versions_kis/') || config.url.startsWith('css/')) &&
            (config.url.endsWith('.html') || config.url.endsWith('.json') || config.url.endsWith('.css'))) {
            config.url = config.url + '?version=' + '3.0.4.0'; //  <---- Update this version number on new releases
          }

          return config;
        },

        /**
         * Handles the server responses
         */
        response: function(response) {
          if (response.data==null) {
            return response;
          }
          if (response.data.CLASSTYPE === 'Error') {
            return $q.reject(response);
          }

          if (response.data.CLASSTYPE == 'UNAUTHORIZED') {
            if ($rootScope.xgos.user && $rootScope.xgos.user.name == 'root') {
              console.log('error');
              require('toastr').error(response.data.message);
            }

            if (localStorage.getItem('auth_token')) {
              if (localStorage.getItem('auth_token').indexOf('MOD_AUTH_CAS_S') !=-1) {
                console.log('UNAUTHORIZED USER CAS');
                console.log(response.data.details[0]);
                if (
                  response.data.details.length &&
                  response.data.details[0].indexOf('(CAS)') !== -1
                ) {
                  localStorage.setItem('ignore_user_cas', 1);
                }
              } else {
                $rootScope.$broadcast('logoutUser');
              }
            }
            else {
              return $q.reject(response);
            }
          }

          return response;
        },

        /**
         * Handles the server errors
         */
        responseError: function(rejection) {
          if (
            rejection.status == 900 && rejection.data.CLASSTYPE == 'UNAUTHORIZED'
          ) {
            if ($rootScope.xgos.user && $rootScope.xgos.user.name == 'root') {
              console.log('error');
              // require('toastr').error(errorMsg);
            }

            if (localStorage.getItem('auth_token')) {
              // fix temporaire pour eviter que des 403 sur des domaines != serveur kis declenchent un logout
              if (rejection.config.url.indexOf('/services/') != -1) {
                $rootScope.$broadcast('logoutUser');
              }
            }
          }


          if (rejection.status === 403) {
            // require('toastr').error('Error ' +rejection.data );
            if (localStorage.getItem('auth_token')) {
              // fix temporaire pour eviter que des 403 sur des domaines != serveur kis declenchent un logout
              if (rejection.config.url.indexOf('/services/') != -1) {
                $rootScope.$broadcast('logoutUser');
              }
            }
          }

          if ($rootScope.xgos.user && $rootScope.xgos.user.name == 'root') {
            console.log('error:');
            console.log(rejection);
          }

          return $q.reject(rejection);
        },
      };
    },
  ]);

  /*
   * Add the interceptor to $httpProvider
   */
  apps.config([
    '$httpProvider',
    '$routeProvider',
    function($httpProvider) {
      angular.lowercase = angular.$$lowercase;
      $httpProvider.interceptors.push('httpRequestInterceptor');
    },
  ]);

  /*
   * App run
   */
  apps.run([
    '$rootScope',
    '$location',
    'PortalsFactory',
    'authFactory',
    '$document',
    '$cookies',
    'licenceFactory',
    'UsersFactory',
    'panelsManager',
    function(
      $rootScope,
      $location,
      PortalsFactory,
      authFactory,
      $document,
      $cookies,
      licenceFactory,
      UsersFactory,
      panelsManager
    ) {
      $rootScope.panelsManager = panelsManager;
      // Afficher le message d'alert
      $rootScope.httpsNotActivated = false;
      // si l'url est en http
      if (window.location.href.includes('http') && !window.location.href.includes('https')) {
        $rootScope.httpsNotActivated = true;
      }
      var castok = $cookies.MOD_AUTH_CAS_S;
      if (
        castok != undefined &&
        localStorage.getItem('ignore_user_cas') == null
      ) {
        // if ($location.absUrl().indexOf("&cas=OK")==-1){
        //     window.location ="/services/?url="+$location.absUrl();
        // }
      }

      if (document.getElementById('myProgress')){
        window.kisLoadTime = window.kisLoadFullTime - 500;
      }

      // init global object
      $rootScope.xgos = {
        licence: {
          lastmonth: false,
          full: undefined,
        },
      };

      if (document.getElementById('myProgress')){
        window.kisLoadTime = window.kisLoadFullTime - 500;
      }
      // the portal list is always needed
      PortalsFactory.get().then(function() {
        PortalsFactory.setPortal().then(function() {
          // si l'on veut cacher le message d'alert https
          $rootScope.showHttpsMessage = ($rootScope.xgos
            && $rootScope.xgos.portal
            && $rootScope.xgos.portal.parameters
            && $rootScope.xgos.portal.parameters.alert_message) ?
            $rootScope.xgos.portal.parameters.alert_message.httpHttps
            : false;

          // si l'on veut cacher le message d'alert complexité mots de passe
          $rootScope.showPwdComplexityMessage = ($rootScope.xgos
            && $rootScope.xgos.portal
            && $rootScope.xgos.portal.parameters
            && $rootScope.xgos.portal.parameters.alert_message) ?
            $rootScope.xgos.portal.parameters.alert_message.complexity
            : false;
          $rootScope.pwdComplexityNotValidated = $rootScope.xgos.portal && $rootScope.xgos.portal.parameters && $rootScope.xgos.portal.parameters.settingPwd
          && ($rootScope.xgos.portal.parameters.settingPwd.minimumNumberTotalCharacters<10
            || $rootScope.xgos.portal.parameters.settingPwd.minimumNumberDigits<1 || $rootScope.xgos.portal.parameters.settingPwd.minimumNumberSpecialCharacters<1
            || $rootScope.xgos.portal.parameters.settingPwd.minimumNumberUppercase<1 || $rootScope.xgos.portal.parameters.settingPwd.minimumNumberLowercase<1
            || $rootScope.xgos.portal.parameters.settingPwd.renewalPwd>12);
          licenceFactory.getAllLicences().then(function() {
            var licence = licenceFactory.getLicence($rootScope.portalChosen);
            if ($rootScope.xgos.licence && $rootScope.xgos.licence.full) {
              $rootScope.xgos.licence.full = licence;
              if (licence && licence.type !== 'free')
                licenceFactory.checkLicence(licence);
            }
          });
        });
      });

      $rootScope.$on('logoutUser', function() {
        authFactory.logout(true);
      });

      // made this components visible only when the translation is loaded
      $rootScope.$on('$translateLoadingEnd', function() {
        $rootScope.calendar = { visible: false };
        $rootScope.alert = { visible: false };
        $rootScope.appswitcher = { visible: false };
        $rootScope.process = { visible: false };
        $rootScope.changedProcessClick = function() {
          if ($rootScope.process.visible)
            $rootScope.$broadcast('newProcessStop');
        };
      });

      $document.on('keydown', function(e) {
        if (
          e.which === 8 &&
          e.target.nodeName !== 'INPUT' &&
          e.target.nodeName !== 'TEXTAREA' &&
          e.target.nodeName !== 'SELECT' &&
          e.target.nodeName !== 'DIV'
        ) {
          e.preventDefault();
        }
        if (e.which == 27) $rootScope.$broadcast('userEnteredEscape');
      });

      var lastRouteLogged = '';
      $rootScope.$on('$routeChangeStart', function(event, next, current) {
        // if a new portal is forced which is different than the current one, logout
        if (typeof $location.search()['portal'] != 'undefined') {
          if (
            $rootScope.xgos.user && // user is logged
            $rootScope.portalChosen != $location.search()['portal'] // but the portal passed is different from the one stocked
          )
            authFactory.logout();
        }

        /**
         * Check user auth
         * @returns {*}
         */
        var checkAuth = function() {
          // dans l'admin de KIS il semble que le routeChangeStart est appellé deux fois...
          var routeToLogg =
            $rootScope.xgos.sector + '-' + $location.path().replace(/\//g, '');

          if (lastRouteLogged != routeToLogg) {
            // ... not anymore
            lastRouteLogged = routeToLogg;

            var tok1 = $location.search().token;
            var castok = $cookies.MOD_AUTH_CAS_S;
            if (
              castok != undefined &&
              localStorage.getItem('ignore_user_cas') == null
            ) {
              tok1 = 'MOD_AUTH_CAS_S=' + castok;
            }
            if (tok1 != undefined && tok1 != '') {
              localStorage.setItem('auth_token', tok1);
              localStorage.setItem('auth_token1', tok1);
              var urlUser = $location.search().user;
              if (urlUser != undefined && urlUser != '')
                localStorage.setItem('urlUser', urlUser);
            }

            return authFactory.userLogged().then(
              function() {
                // verif sector && remove empty strings
                var parts = $location
                  .path()
                  .split('/')
                  .filter(Boolean);

                $rootScope.xgos.sectorParts = parts;
                $rootScope.xgos.sector = parts[0].replace(/\//g, '');

                switch ($rootScope.xgos.sector) {
                  case 'map':
                  case 'form':
                  case 'anc':
                  case 'bac':
                  case 'indigau':
                  case 'siroco':
                  case 'login':
                  case 'home':
                  case 'hpo':
                  case 'mapv2':
                  case '503':
                  case '404':
                  case 'calendar_invite':
                  case 'supervision':
                    break;
                  default:
                    $rootScope.xgos.sector = 'admin';
                    break;
                }

                if (!authFactory.userIsAllowed()) {
                  // is the user allowed to access that page ?
                  authFactory.goToAccessDenied();
                } else {
                  // log routes
                  UsersFactory.user_monitoring({
                    sector: $rootScope.xgos.sector,
                    path: $location.path().replace(/\//g, ''),
                    category: 'Navigation',
                    parameters: '[Navigation]',
                  });
                }

                if ($rootScope.xgos.isroot && $rootScope.xgos.portal) {
                  document.title = `${$rootScope.xgos.portal.name} / ${$rootScope.xgos.sector} / ${document.title}`;
                }

              },
              function() {
                // user is not logged
                delete $rootScope.xgos.user;
                var tok = $location.search().token;
                if (tok != undefined && tok != '') {
                  localStorage.setItem('auth_token', tok);
                } else {
                  // except for the logout page
                  if ($location.path().replace(/\//g, '') != 'logout') {
                    if (!angular.isDefined($rootScope.xgos.sector)) {
                      $rootScope.xgos.sector = 'login';
                    }
                    authFactory.goToLogin();
                  }
                }
              }
            );
          }
        };

        // checkSingleSession supprimé le 11.12.2018, develop
        // be sure that checkauth is resolved before loading the route
        next.resolve = angular.extend(next.resolve || {}, {
          // __authenticating__: checkSingleSession
          __authenticating__: checkAuth,
        });
      });
    },
  ]);

  return apps;
});
