'use strict';
define(function() {
  var ApplicationFactory = function($http, $q) {
    var ApplicationFactory = {};
    /**
     * Class : ApplicationFactory
     * Factory WebServices
     */

    var resources = { applications: [] };
    let loaded = false;

    /**
     * Function: add
     */
    function add(senddata) {
      var promise = $http.post(
        '/services/{portalid}/application/add?f=json',
        senddata
      );
      promise.then(function(res) {
        resources.applications.push(res.data);
      });
      return promise;
    }
    /**
     * Function: remove
     */
    function remove(name) {
      var promise = $http.get(
        '/services/{portalid}/application/remove?f=json' + '&name=' + name
      );
      promise.then(function(res) {
        var deleteIndex = resources.applications
          .map(function(x) {
            return x.name;
          })
          .indexOf(name);
        resources.applications.splice(deleteIndex, 1);
      });
      return promise;
    }
    /**
     * Function: get
     */
    function get(withoutRoles, force = false) {
      if (typeof ancAppAndroid !== 'undefined') {
        return $q.when(['detail', 'simple']);
      } else {
        const def = $q.defer();
        if (!force && resources.applications.length > 0 && !resources.getting) {
          //-- Les applications ont déjà été récupérés (et pas de récupération en cours)
          //-- donc, pas la peine de refaire appel au service.
          def.resolve({data: resources.applications});
        } else {
          resources.getting = true;
          const promise = $http.get('/services/{portalid}/application/get?f=json'
              +(withoutRoles?'&withoutRoles=true':'')
          );
          promise.then(res => {
            loaded = true;
            resources.applications = res.data.map(app => {
              // KIS-2844: l’option “Afficher le sélecteur des modèles de carte” activée par défaut
              if ((app.type === 'MapApp' || app.type === 'MapAppV2') && !app.params.hasOwnProperty('mapModelSelector')) {
                app.params.mapModelSelector = true;
              }
              return app;
            });
            resources.getting = false;
            def.resolve({data: resources.applications});
          });
        }
        return def.promise;
      }
    }
    /**
     * Function: update
     */
    function update(senddata) {
      var promise = $http.post(
        '/services/{portalid}/application/update?f=json',
        senddata
      );
      promise.then(function(res) {
        var replaceIndex = resources.applications
          .map(function(x) {
            return x.uid;
          })
          .indexOf(senddata.uid);
        resources.applications[replaceIndex] = res.data;
      });
      return promise;
    }

    /**
     * Function: qrcode
     */
    function qrcode(name, url) {
      var promise = $http.get(
        '/services/{portalid}/application/qrcode?f=json' +
          '&name=' +
          name +
          '&url=' +
          url
      );

      return promise;
    }

    /**
     * Function: getbyname
     */
    function getbyname(name) {
      const defer = $q.defer();
      const optionalApp = resources.applications.find(app => app.name === name);
      if (resources.applications.length > 0 && optionalApp) {
        defer.resolve({data: optionalApp});
      } else {
        const promise = $http.get(
            '/services/{portalid}/application/getapps?f=json' + '&name=' + name
        );
        promise.then((res) => {
          defer.resolve(res);
        });
      }
      return defer.promise;
    }

    /**
     * Function: copy
     */
    function copy(senddata, name) {
      var promise = $http.post(
        '/services/{portalid}/application/copy?f=json' + '&name=' + name,
        senddata
      );
      promise.then(function(res) {
        resources.applications.push(res.data);
      });
      return promise;
    }

    return {
      ApplicationFactory: ApplicationFactory,
      resources: resources,
      add: add,
      remove: remove,
      get: get,
      qrcode: qrcode,
      getbyname: getbyname,
      update: update,
      copy: copy,
    };
  };
  ApplicationFactory.$inject = ['$http', '$q'];
  return ApplicationFactory;
});
