'use strict';
/**
 * Commande d'affichage et affichage de la popup de visualisation
 * des messages détaillés de l'exécution du JOB de géotraitement.
 */
define(function() {
  const atlas = function ($filter, extendedNgDialog, htmlUtils) {
    return {
      templateUrl: 'js/XG/modules/arcgis/views/arcgisJobDetailsCommand.html',
      restrict: 'AE',
      link: function(scope) {

        scope.copyToClipboard = htmlUtils.copyToClipboard;

        // -- L'onglet par défaut est la liste des messages
        scope.selectedTab='messages';

        scope.agJobDetailsTabs = [
          {
            title: 'arcgisJob.messages',
            content:
              'js/XG/modules/arcgis/views/arcgisJobDetailsMessages.html',
          },
          {
            title: 'arcgisJob.results',
            content:
              'js/XG/modules/arcgis/views/arcgisJobDetailsResults.html',
          },
        ];
        scope.agJobDetailsTabs.activeTab = 0;

        /**
         * Affichage de la popup de visualisation des messages détaillés
         * de l'exécution du JOB de géotraitement.
         */
        scope.viewJobDetails = () => {
          if (!scope.jobDetails) {
            scope.jobDetails = extendedNgDialog.open({
              template: 'js/XG/modules/arcgis/views/arcgisJobDetails.html',
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              draggable: true,
              title: $filter('translate')('arcgisJob.esriJobDetails'),
              preCloseCallback: () => {
                delete scope.jobDetails;
              }
            });
          }
        };

        /**
         * Fermeture de la popup de visualisation des messages détaillés
         * de l'exécution du JOB de géotraitement.
         */
        scope.closeEsriJobDetails = () => {
          scope.jobDetails.close();
          delete scope.jobDetails;
        };

      },
    };
  };

  atlas.$inject = [ '$filter',  'extendedNgDialog', 'HtmlUtils' ];
  return atlas;
});
