'use strict';
define(function() {
  /**
   *
   * @returns {{restrict: string, templateUrl: string}}
   */
  var arrayNumberInput = function() {
    return {
      restrict: 'A',
      templateUrl:
        'js/XG/modules/common/views/directives/arrayNumberInput.html',
      scope: {
        res: '=',
      },
      link: function(scope) {
        // Convert string number to number
        for (var i = 0; i < scope.res.length; i++) {
          var nb = Number(scope.res[i]);
          scope.res[i] = nb;

          scope.lines = angular.isArray(scope.res) ? scope.res : [0];
        }

        /**
         * Add a line
         */
        scope.addLine = function() {
          var lastIndex = scope.lines.length - 1;
          var lastLine = scope.lines[lastIndex];

          if (lastLine) {
            scope.lines.push('');
          }
        };

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.lines.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(lines) {
            scope.res = lines;
          },
          1
        );
      },
    };
  };

  arrayNumberInput.$inject = [];

  return arrayNumberInput;
});
