'use strict';
define(function() {
  var gcelement = function(FeatureTypeFactory, EditTypesFactory, $filter) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setDefaultValue.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.rule.name = 'SetDefaultValue';
        scope.rule.type = 'OnEnd';

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.updateattributes,
          EditTypesFactory.editTypes.update,
        ];

        if (angular.isUndefined(scope.rule.editTypes)) {
          scope.rule.editTypes = [];
          angular.forEach(editTypesSource, function(editType, index) {
            scope.rule.editTypes.push(editType);
          });
        }
        scope.editTypeList = {
          leftData: editTypesSource,
          leftDisplayAttribute: 'label',
          rightData: scope.rule.editTypes,
          rightDisplayAttribute: 'label',
          source: 'left',
        };
        scope.editTypeList.leftTitle = $filter('translate')(
          'rulecfg.common.availableEditTypes'
        );
        scope.editTypeList.rightTitle = $filter('translate')(
          'rulecfg.common.executeEditTypes'
        );

        if (angular.isUndefined(scope.rule.parameters)) {
          scope.rule.parameters = {};
        }
      },
    };
  };

  gcelement.$inject = ['FeatureTypeFactory', 'EditTypesFactory', '$filter'];
  return gcelement;
});
