'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    EditTypesFactory,
    $translate,
    $filter,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setUniqueIdByConcat.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=?rule',
        mode: '=?',
      },
      link: function(scope) {
        scope.rule.name = 'SetUniqueIdByConcat';
        scope.rule.type = 'PostSave';

        scope.canEditVariableName = scope.mode === 'add' || !(scope.currentfeaturetype.rules || []).filter(
          rule => rule.parameters.formula && rule.parameters.formula.numerotation.parts.filter(part => part.key === 'variable' && part.format === scope.rule.parameters.variableName).length
        ).length;

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
          EditTypesFactory.editTypes.updateattributes,
          EditTypesFactory.editTypes.import,
        ];

        if (scope.rule.editTypes === undefined) {
          scope.rule.editTypes = [];
          //Par défaut, tous les type d'édition sont activés
          angular.forEach(editTypesSource, function(editType, index) {
            scope.rule.editTypes.push(editType);
          });
        }
        scope.editTypeList = {
          leftData: editTypesSource,
          leftDisplayAttribute: 'label',
          rightData: scope.rule.editTypes,
          rightDisplayAttribute: 'label',
          source: 'left',
        };
        scope.editTypeList.leftTitle = $filter('translate')(
          'rulecfg.common.availableEditTypes'
        );
        scope.editTypeList.rightTitle = $filter('translate')(
          'rulecfg.common.executeEditTypes'
        );
        
        scope.$watch('editTypeList.rightData', (newVal) => {
          scope.featureRulesVariables = angular.copy(scope.currentfeaturetype.rules || [])
            .filter(rule => (
              rule.parameters && 
              rule.parameters.variableName &&
              rule.parameters.variableName !== scope.rule.parameters.variableName &&
              newVal.filter(
                type => rule.editTypes.find(ruleType => ruleType.name === type.name)
              ).length === newVal.length // Search if edit types are existing
            ))
            .map(rule => rule.parameters.variableName);
        }, true);

        // Formula terms
        scope.possibleTypes = [
          {
            key: 'separator',
            label: $filter('translate')(
              'rulecfg.setuniqueidbyconcat.separator'
            ),
          },
          {
            key: 'attribut',
            label: $filter('translate')('rulecfg.setuniqueidbyconcat.attribut'),
          },
          {
            key: 'value',
            label: $filter('translate')('rulecfg.setuniqueidbyconcat.value'),
          },
          {
            key: 'fid',
            label: $filter('translate')('rulecfg.setuniqueidbyconcat.fid'),
          },
          {
            key: 'variable',
            label: 'variable',
          },
        ];

        RuleCfgFactory.initFormula(scope);

        scope.partsPreview = setFormulaViewer();

        scope.moveNumerotationpart = function(direction, index) {
          if (
            (index === 0 && direction === 'up') ||
            (index === scope.formula.numerotation.parts.length - 1 &&
              direction === 'down')
          ) {
            return false;
          }

          var newIndex = direction === 'up' ? index - 1 : index + 1;
          scope.formula.numerotation.parts.splice(
            index,
            0,
            scope.formula.numerotation.parts.splice(newIndex, 1)[0]
          );
          scope.partsPreview = setFormulaViewer();
        };

        scope.removePartFromNumerotationCfg = function(index) {
          scope.formula.numerotation.parts.splice(index, 1);
          scope.partsPreview = setFormulaViewer();
        };

        function setFormulaViewer() {
          var partsPreview = [];
          let numerotation = scope.formula.numerotation;

          numerotation.parts.forEach(function(p) {
            if (p.key === 'attribut') {
              partsPreview.push('$[' + p.format);
            } else if (p.key === 'fid') {
              partsPreview.push('$[id');
            } else {
              partsPreview.push(p.format);
            }
          });
          scope.rule.parameters.formula = scope.formula;
          return partsPreview.join(numerotation.separator);
        }

        // here
        scope.addNumerotationPart = function() {
          let part = {
            key: ' ',
            format: ' ',
          };

          scope.formula.numerotation.parts.push(part);
          scope.partsPreview = setFormulaViewer();
        };

        scope.onNumerotationPartsChange = (part, changedIndex) => {
          scope.formula.numerotation.parts[changedIndex] = part;
          scope.partsPreview = setFormulaViewer();
        };

        scope.onTargetAttributeChange = targetAttribute => {
          scope.rule.parameters.targetField = targetAttribute;
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'EditTypesFactory',
    '$translate',
    '$filter',
    'RuleCfgFactory',
  ];
  return gcelement;
});
