'use strict';
define(function() {
  var GoogleGeocodeFactory = function($window, $q, $http) {
    var GoogleGeocodeFactory = {};

    /**
     * Getting Coordinates Informations from GoogleMap api
     * @param address
     * @param filters
     * @returns {*}
     */
    function getInformationsFromAddress(address, filters) {
      var params = { address: address, sensor: false };
      if (filters) {
        params.components = '';
        for (var i in filters) {
          params.components += i + ':' + filters[i] + '|';
        }
        params.components = params.components.substring(
          0,
          params.components.length - 1
        );
      }
      var promise = $http.get(
        'https://maps.googleapis.com/maps/api/geocode/json',
        { params: params }
      );
      return promise;
    }

    /**
     * Getting Coordinates Informations from GoogleMap api
     * @param address
     * @param filters
     * @returns {*}
     */
    function getAdresseFromCoordinate(coordinate) {
      var params = {
        latlng: coordinate[0] + ',' + coordinate[1],
        location_type: 'ROOFTOP',
        result_type: 'street_address',
      };

      var promise = $http.get(
        ' https://nominatim.openstreetmap.org/reverse?format=json&lat=' +
          coordinate[1] +
          '&lon=' +
          coordinate[0] +
          '&zoom=18&addressdetails=1',
        { params: params }
      );
      return promise;
    }

    return {
      GoogleGeocodeFactory: GoogleGeocodeFactory,
      getInformationsFromAddress: getInformationsFromAddress,
      getAdresseFromCoordinate: getAdresseFromCoordinate,
    };
  };
  GoogleGeocodeFactory.$inject = ['$window', '$q', '$http'];
  return GoogleGeocodeFactory;
});
