'use strict';
define(function() {
  var FeatureHistoryFactory = function($http, gaUrlUtils, $q) {
    var FeatureHistoryFactory = {};
    /**
     * Class : FeatureHistoryFactory
     * Factory WebServices
     */

    /**
     * Function: getactions
     */
    function getactions(
      feature_id,
      feature_uid,
      action_title,
      page,
      count,
      sort
    ) {
      if (typeof ancAppAndroid !== 'undefined') {
        return $q.when(['detail', 'simple']);
      } else {
        action_title = gaUrlUtils.encodeUriQuery(action_title) || '';
        page = page || 0;
        count = count || 25;
        sort = sort || '';

        var promise = $http.get(
          '/services/{portalid}/feature_history/getActions?f=json' +
            '&feature_id=' +
            feature_id +
            '&feature_uid=' +
            feature_uid +
            '&action_title=' +
            action_title +
            '&page=' +
            page +
            '&count=' +
            count +
            '&sort=' +
            sort
        );
        promise.then(function(res) {
          // service level logic if any
        });
        return promise;
      }
    }

    /**
     * Function: addaction
     */
    function addaction(fuid, id_dossier, title, detail) {
      title = gaUrlUtils.encodeUriQuery(title) || '';
      detail = gaUrlUtils.encodeUriQuery(detail) || '';
      var promise = $http.get(
        '/services/{portalid}/feature_history/addAction?f=json' +
          '&fuid=' +
          fuid +
          '&id_dossier=' +
          id_dossier +
          '&title=' +
          title +
          '&detail=' +
          detail
      );

      return promise;
    }
    /**
     * Function: removeaction
     */
    function removeaction(id) {
      var promise = $http.get(
        '/services/{portalid}/feature_history/removeAction?f=json' + '&id=' + id
      );

      return promise;
    }
    /**
     * Function: addactionwithdate
     */
    function addactionwithdate(senddata) {
      var promise = $http.post(
        '/services/{portalid}/feature_history/addActionWithDate?f=json',
        senddata
      );

      return promise;
    }
    return {
      FeatureHistoryFactory: FeatureHistoryFactory,
      getactions: getactions,
      addaction: addaction,
      removeaction: removeaction,
      addactionwithdate: addactionwithdate,
    };
  };
  FeatureHistoryFactory.$inject = ['$http', 'gaUrlUtils', '$q'];
  return FeatureHistoryFactory;
});
