'use strict';
define(function() {
  var OdkFactory = function($http) {
    var OdkFactory = {};
    /**
     * Class : OdkFactory
     * Factory WebServices
     */

    /**
     * Function: submission
     */
    function submission(senddata, deviceID) {
      var promise = $http.post(
        '/services/{portalid}/odk/submission?f=json' + '&deviceID=' + deviceID,
        senddata
      );

      return promise;
    }
    /**
     * Function: formxml
     */
    function formxml(formId) {
      var promise = $http.get(
        '/services/{portalid}/odk/formXml?f=json' + '&formId=' + formId
      );

      return promise;
    }

    /**
     * Function: getformmobile
     */
    /*function getformmobile(id) {
		 var promise = $http.get('/services/{portalid}/odk/getformmobile?f=json' +'&id=' + id);
		promise.then(function(res){
		// service level logic if any
		});
		return promise;
	};*/
    function getformmobile(sendata) {
      var promise = $http.post(
        '/services/{portalid}/odk/getformmobile?f=json',
        sendata
      );

      return promise;
    }
    /**
     * Function: formlist
     */
    function formlist() {
      var promise = $http.get('/services/{portalid}/odk/formList?f=json');

      return promise;
    }
    /**
     * Function: uploadprocess
     */
    function uploadprocess(senddata) {
      var promise = $http.post(
        '/services/{portalid}/odk/uploadfile?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: removeuploaded
     */
    function removeuploaded(fileName) {
      var promise = $http.get(
        '/services/{portalid}/odk/removeuploaded?f=json' +
          '&fileName=' +
          fileName
      );

      return promise;
    }
    /**
     * Function: getlisttemplate
     */
    function getlisttemplate() {
      var promise = $http.get(
        '/services/{portalid}/odk/getlisttemplate?f=json'
      );

      return promise;
    }
    /**
     * Function: addimei
     */
    function addimei(senddata) {
      var promise = $http.post(
        '/services/{portalid}/odk/imei/add?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: getimei
     */
    function getimei(imei) {
      var promise = $http.get(
        '/services/{portalid}/odk/imei/get?f=json' + '&imei=' + imei
      );

      return promise;
    }
    /**
     * Function: getlistimei
     */
    function getlistimei() {
      var promise = $http.get('/services/{portalid}/odk/imei/getlist?f=json');

      return promise;
    }
    /**
     * Function: updateimei
     */
    function updateimei(imei, senddata) {
      var promise = $http.post(
        '/services/{portalid}/odk/imei/update?f=json' + '&id=' + imei,
        senddata
      );

      return promise;
    }
    /**
     * Function: deleteimei
     */
    function deleteimei(imei) {
      var promise = $http.get(
        '/services/{portalid}/odk/imei/delete?f=json' + '&id=' + imei
      );

      return promise;
    }
    /**
     * Function: getlistintervention
     */
    function getlistintervention() {
      var promise = $http.get(
        '/services/{portalid}/odk/intervention/getlistintervention?f=json'
      );

      return promise;
    }
    /**
     * Function: deleteimei
     */
    function deleteintervention(id, name) {
      var promise = $http.get(
        '/services/{portalid}/odk/intervention/delete?f=json' +
          '&id=' +
          id +
          '&name=' +
          name
      );

      return promise;
    }
    return {
      OdkFactory: OdkFactory,

      submission: submission,
      formxml: formxml,
      getformmobile: getformmobile,
      formlist: formlist,

      uploadprocess: uploadprocess,
      removeuploaded: removeuploaded,

      getlisttemplate: getlisttemplate,
      deleteimei: deleteimei,
      updateimei: updateimei,
      getlistimei: getlistimei,
      getimei: getimei,
      addimei: addimei,
      getlistintervention: getlistintervention,
      deleteintervention: deleteintervention,
    };
  };
  OdkFactory.$inject = ['$http'];
  return OdkFactory;
});
