'use strict';
define(function() {
  var pageAttr = function(ConfigFactory, ngDialog) {
    return {
      restrict: 'AE',
      templateUrl:
        'js/XG/modules/print/views/directives/blocks/blocksConf/pageAttr.html',
      scope: {
        pagemanager: '=pagemanager',
      },
      link: function(scope) {
        scope.pageAttrCfgFmt = {};

        ConfigFactory.get('print', 'formats', 'kis_home').then(function(res) {
          var iFmt;
          if (res.data) scope.pageAttrCfgFmt.formats = res.data;
          else scope.pageAttrCfgFmt.formats = [];
          scope.availableFormats = [];
          scope.availableFormats.push({
            name: 'A0',
            width: 3371,
            height: 2383,
          });
          scope.availableFormats.push({
            name: 'A1',
            width: 2383,
            height: 1685,
          });
          scope.availableFormats.push({
            name: 'A2',
            width: 1685,
            height: 1101,
          });
          scope.availableFormats.push({
            name: 'A3',
            width: 1101,
            height: 842,
          });
          scope.availableFormats.push({
            name: 'A4',
            width: 842,
            height: 595,
          });
          scope.availableFormats.push({
            name: 'A4',
            width: 595,
            height: 421,
          });
          for (iFmt = 0; iFmt < scope.pageAttrCfgFmt.formats.length; iFmt++)
            scope.availableFormats.push(scope.pageAttrCfgFmt.formats[iFmt]);
        });

        scope.$watch(
          'pagemanager.activePage.data',
          function(newval, oldval) {
            if (newval != oldval)
              scope.pagemanager.refresh(scope.pagemanager.activePage);
          },
          true
        );

        scope.openCfgOfPageFormats = function() {
          /*yyyyyy*/
          ConfigFactory.get('print', 'formats', 'kis_home').then(function(res) {
            if (res.data) scope.pageAttrCfgFmt.formats = res.data;
            else scope.pageAttrCfgFmt.formats = [];
            scope.currentFmt = {};
            scope.dlg = ngDialog.open({
              template:
                'js/XG/modules/print/views/directives/blocks/blocksConf/pageAttrCfgFmt.html',
              className: 'ngdialog-theme-plain width300 nopadding miniclose',
              scope: scope,
            });
          });
        };

        scope.removeFmt = function(fmt) {
          var iFmt;

          for (iFmt = 0; iFmt < scope.pageAttrCfgFmt.formats.length; iFmt++)
            if (scope.pageAttrCfgFmt.formats[iFmt].name == fmt.name) {
              scope.pageAttrCfgFmt.formats.splice(iFmt, 1);
              break;
            }
          for (iFmt = 0; iFmt < scope.availableFormats.length; iFmt++)
            if (scope.availableFormats[iFmt].name == fmt.name) {
              scope.availableFormats.splice(iFmt, 1);
              break;
            }
        };

        scope.addCurrentFmt = function() {
          scope.pageAttrCfgFmt.formats.push(scope.currentFmt);
          scope.availableFormats.push(scope.currentFmt);
          scope.currentFmt = {};
        };

        scope.saveCfgOfPrintFmt = function() {
          ConfigFactory.add(
            scope.pageAttrCfgFmt.formats,
            'print',
            'formats',
            'kis_home'
          ).then(function(res) {
            scope.dlg.close();
          });
        };

        scope.closeCfgOfPrintFmt = function() {
          scope.dlg.close();
        };
      },
    };
  };

  pageAttr.$inject = ['ConfigFactory', 'ngDialog'];
  return pageAttr;
});
