'use strict';
define(function() {
  var PrintModelFactory = function($http, $q) {
    var PrintModelFactory = {};
    var resources = {
      version: "1.0",
      models: [],
      configVariables: [],
      deletedVariables: [],
    };
    //var configVariables = [];
    var textBlockName = '';
    var isSameTextBlockName = false;
    var lastVariablesText = [];
    var fontsNames = [];

    var KEY = 'key';
    var VALUE = 'value';
    var RESERVED_VARIABLES = ['${scale}', '${date}'];

    /* ==============================================================================
         * Getter / Setter
         ============================================================================== */
    function isSameTextBlock(name) {
      if (textBlockName === name) {
        return true;
      } else {
        return false;
      }
    }

    function setTextBlockName(name) {
      textBlockName = name;
    }

    function setTextBlockFlag(isSameTextBlock) {
      isSameTextBlockName = isSameTextBlock;
    }

    function isSameTextBlockNameFlag() {
      return isSameTextBlockName;
    }

    function getLastVariablesText() {
      return lastVariablesText;
    }

    function setLastVariablesText(textdata) {
      if (typeof textdata == 'string')
        lastVariablesText = getDollarVariables(textdata);
      else lastVariablesText = textdata;
    }

    function getDollarVariables(text) {
      var result = [];
      if (text) {
        var expReg = /\$\{\w*\W*\d*\}/g;
        var array = expReg.exec(text);

        while (array) {
          result.push(array[0]);
          array = expReg.exec(text);
        }
      }

      return result;
    }

    /**
     * Class : PrintModelFactory
     * Factory WebServices
     */

    /**
     * Function: get
     * Récupère la configuration globale au format JSON
     */
    function get() {
      var promise = $http.get(
        '/services/{portalid}/printModel/getPrintConfig?f=json'
      );
      promise.then(function(res) {
        // service level logic if any

        if (res) {
          var dpis = res.dpis;
          console.log(JSON.stringify(dpis));
        }
      });
      return promise;
    }

    /**
     * Function: update
     * Met à jour le modèle (S'il existe) envoyé en paramètre (format JSON)
     */
    function update(senddata) {
      var promise = $http.post(
        '/services/{portalid}/printModel/update?f=json',
        senddata
      );
      promise.then(function(res) {
        // service level logic if any
        console.log(senddata);

        var replaceIndex = resources.models
          .map(function(x) {
            return x.name;
          })
          .indexOf(senddata.name);

        console.log('replaceIndex : ' + replaceIndex);

        resources.models[replaceIndex] = res.data;
      });
      return promise;
    }

    /**
     * Function: getmodellist
     * Récupère la liste des modèles au format JSON
     */
    function getmodellist() {
      var promise = $http.get(
        '/services/{portalid}/printModel/getModelList?f=json'
      );
      promise.then(function(res) {
        // service level logic if any
        resources.models = res.data;
      });
      return promise;
    }

    /**
     * Function: createmodel
     * Crée un modèle et l'ajoute à la liste des modèles existants
     */
    function createmodel(senddata) {
      var promise = $http.post(
        '/services/{portalid}/printModel/createModel?f=json',
        senddata
      );
      promise.then(function(res) {
        // service level logic if any
        resources.models.push(res.data);
      });
      return promise;
    }

    /**
     * Function: getmodel
     * Récupère un modèle en ayant le nom passé en paramètre (Format JSON)
     */
    function getmodel(senddata) {
      var promise = $http.post(
        '/services/{portalid}/printModel/getModelFromName?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: deletemodel
     * Supprime un modèle et l'enlève de la liste des modèles existants
     */
    function deletemodel(senddata) {
      var promise = $http.post(
        '/services/{portalid}/printModel/deleteModel?f=json',
        senddata
      );
      promise.then(function(res) {
        // service level logic if any
        var deleteIndex = resources.models
          .map(function(x) {
            return x.name;
          })
          .indexOf(senddata);
        resources.models.splice(deleteIndex, 1);
      });
      return promise;
    }

    /**
     * Function: updateconfig
     * Met à jour la configuration globale, la nouvelle étant envoyée au format JSON
     */
    function updateconfig(senddata) {
      var promise = $http.post(
        '/services/{portalid}/printModel/updateConfig?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: getVariables
     * Récupère la liste des variables au format JSON
     */
    function getVariables(modele) {
      var promise = $http.get(
        '/services/{portalid}/printModel/getVariables?f=json&modelName=' +
          modele
      );
      promise.then(function(res) {
        if (res.data != '' && res.data != '{}') {
          resources.configVariables = res.data;
          console.log(JSON.stringify(resources.configVariables));
        }
      });

      return promise;
    }

    /**
     * Function: getversion
     * getMapFishPrintVersion
     */
    function getVersion() {
      var promise = $http.get(
        '/printv2/pdf/version'
      );
      promise.then(function(res) {
        if (res.data != '' && res.data != '{}') {
          resources.version = res.data.replace("\n","");
        }
      });

      return promise;
    }

    /**
     * Function: getAllVariables
     *
     * Récupère la liste des variables au format JSON
     * quelque soit le moéle de carte.
     */
    function getAllVariables() {
      return getVariables('all');
    }

    /**
     * Function: getVariables
     * Récupère la liste des variables au format JSON
     */
    function getVariablesNames(modele) {
      var mainPromise = $q.defer();

      getVariables(modele).then(
        function(data) {
          if (data && data.data && data.data != '{}') {
            resources.configVariables = data.data;
            console.log(
              '---> Variable loaded : ' +
                JSON.stringify(resources.configVariables)
            );

            mainPromise.resolve(data.data);
          } else {
            console.log('No variables');
            mainPromise.reject('');
          }
        },
        function(data) {
          require('toastr').info(data);
          mainPromise.reject('');
        }
      );

      return mainPromise.promise;
    }

    function updateVariablesConfig(variablesIn) {
      // var variablesUpdated = [];

      console.log(
        'Befor updating variable config : ' +
          JSON.stringify(resources.configVariables)
      );
      var index = -1;
      for (var i = 0; i < resources.configVariables.length; i++) {
        angular.forEach(resources.configVariables[i], function(value, key) {
          index = searchVariableNameInArray(key, variablesIn);

          if (index > -1) {
            return;
          }
        });
      }

      resources.configVariables.splice(index, 1);
      console.log(
        'After updating variable config : ' +
          JSON.stringify(resources.configVariables)
      );
    }

    /**
     *
     * @param text
     */
    function getNameFromDollarVariable(text) {
      if (text) {
        text = text
          .replace(/\$/g, '')
          .replace(/\{/g, '')
          .replace(/\}/g, '')
          .replace(/"/g, '');
      }

      return text;
    }

    /**
     *
     * @param arrayObj
     */
    var traitVariables = function(arrayObj) {
      var obj;
      var objArray = [];

      for (var i = 0; i < arrayObj.length; i++) {
        angular.forEach(arrayObj[i], function(value, key) {
          console.log(key + ' : ' + value);
          obj = {};
          obj[KEY] = getNameFromDollarVariable(key);
          obj[VALUE] = value;

          objArray.push(obj);
        });
      }

      return objArray;
    };

    var searchVariableNameInArray = function(text, arrayObj) {
      var index = -1;

      if (text && arrayObj) {
        text = getNameFromDollarVariable(text);
        for (var i = 0; i < arrayObj.length; i++) {
          if (arrayObj[i] == text) {
            index = i;
            break;
          }
        }
      }

      return index;
    };

    var cleanJSON = function(str) {
      return str.replace(/\\"/g, '');
    };

    function buildVariable(key, value) {
      var result = {};
      result.key = key.replace('${', '').replace('}', '');
      result.value = value ? value : '';
      result.value = '';

      return result;
    }

    /**
     * Function: updateVariables
     * Met à jour les variables
     */
    function updateVariables(senddata, modelName) {
      var iVar;
      for (iVar = senddata.length - 1; iVar >= 0; iVar--) {
        if (senddata[iVar].key === null) senddata.splice(iVar, 1);
      }
      var promise = $http.post(
        '/services/{portalid}/printModel/updateVariables?f=json&modelName=' +
          modelName,
        senddata
      );

      return promise;
    }

    function isReservedVariable(variable) {
      var i = 0;
      for (i < 0; i < RESERVED_VARIABLES.length; i++) {
        if (
          RESERVED_VARIABLES[i] === variable ||
          RESERVED_VARIABLES[i] === '${' + variable + '}'
        ) {
          return true;
        }
      }

      return false;
    }

    /**
     * Function: renameModel
     *
     * @param oldFileName
     * @param newFileName
     */
    function renameModel(oldFileName, newFileName) {
      var promise = $http.post(
        '/services/{portalid}/printModel/renameModelName?f=json' +
          '&oldFileName=' +
          oldFileName +
          '&newFileName=' +
          newFileName
      );
      promise.then(function(res) {
        // service level logic if any

        // Update the modal name in models list
        var updateIndex = resources.models
          .map(function(x) {
            return x.name;
          })
          .indexOf(oldFileName);

        console.log('Traget index : ' + updateIndex);
        resources.models[updateIndex].name = newFileName;
      });
      return promise;
    }

    function getFontsNames() {
      var promise = $http.get(
        '/services/{portalid}/printModel/getFontsNames?f=json'
      );
      promise.then(function(res) {
        if (res.data != '') {
          fontsNames = res.data;
          //console.log(JSON.stringify(res.data));
        }
      });

      return promise;
    }

    function getMapFishAvailableFormats() {
      var promise = $http.get(
        '/services/{portalid}/printModel/getMapFishAvailableFormats?f=json'
      );
      promise.then(function(res) {
        if (res.data != '') {
          console.log(JSON.stringify(res.data));
        }
      });

      return promise;
    }

    function getFontPath() {
      var promise = $http.get(
        '/services/{portalid}/printModel/getFontPath?f=json'
      );
      promise.then(function(res) {
        if (res.data != '') {
          //console.log(JSON.stringify(res.data));
        }
      });

      return promise;
    }



    return {
      PrintModelFactory: PrintModelFactory,
      resources: resources,
      //configVariables:configVariables,
      fontsNames: fontsNames,
      isSameTextBlock: isSameTextBlock,
      isSameTextBlockNameFlag: isSameTextBlockNameFlag,
      setTextBlockName: setTextBlockName,
      setTextBlockFlag: setTextBlockFlag,
      getLastVariablesText: getLastVariablesText,
      setLastVariablesText: setLastVariablesText,
      getDollarVariables: getDollarVariables,
      getNameFromDollarVariable: getNameFromDollarVariable,
      get: get,
      update: update,
      getmodellist: getmodellist,
      createmodel: createmodel,
      getmodel: getmodel,
      deletemodel: deletemodel,
      updateconfig: updateconfig,

      getVariablesNames: getVariablesNames,
      getVariables: getVariables,
      getAllVariables: getAllVariables,
      updateVariables: updateVariables,
      updateVariablesConfig: updateVariablesConfig,
      isReservedVariable: isReservedVariable,

      renameModel: renameModel,
      getFontsNames: getFontsNames,
      getFontPath: getFontPath,
      getMapFishAvailableFormats: getMapFishAvailableFormats,
      buildVariable: buildVariable,
      getVersion: getVersion
    };
  };
  PrintModelFactory.$inject = ['$http', '$q'];
  return PrintModelFactory;
});
