'use strict';
define(function() {
  var ancAdresse = function(
    AncAppFactory,
    ngDialog,
    BacAppFactory,
    $rootScope,
    gaJsUtils,
    $http
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_adresse.html',
      restrict: 'EA',
      scope: {
        res: '=?',
        editable: '=?',
        showTitle: '=?',
        complementVille: '=?',
        showContact: '=?',
        showAdresse: '=?',
        required: '=?',
        labelKey: '=?',
        forceVille: '=?', // force le choix de la ville d'apres la config
        toggleAdresse: '=?',
        adresseHab: '=?',
        emptyCommunesList: '=?',
        hideButton: '=?',
        showCoordonnes: '=?',
        coordinates: '=?',
      },
      link: function(scope) {
        if (angular.isDefined(scope.labelKey)) {
          var setted = gaJsUtils.checkNestedProperty(
            scope.labelKey,
            scope.cdata
          );
          if (setted !== false) {
            gaJsUtils.setNestedProperty(scope.labelKey, scope.cdata, null);
          }
        }
        //On initialise à France si le champ est vide quand on édite la fiche
        if (scope.res && (scope.res.adresse_pays == undefined || scope.res.adresse_pays === '' )){
          scope.res.adresse_pays = 'France';
        }

        if ($rootScope.xgos.sector !== 'map')
          var CurrentAppFactory =
            $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;
        else
          var CurrentAppFactory =
            $rootScope.xgos.sub_sector == 'bac' ? BacAppFactory : AncAppFactory;

        var typeSpancOrSpac =
          CurrentAppFactory == BacAppFactory ? 'spac' : 'spanc';

        if (!angular.isDefined(scope.res)) scope.res = {};
        if (!angular.isDefined(scope.editable)) scope.editable = true;
        if (!angular.isDefined(scope.editable)) scope.showTitle = false;
        if (!angular.isDefined(scope.showAdresse)) scope.showAdresse = true;
        if (!angular.isDefined(scope.toggleAdresse))
          scope.toggleAdresse = false;
        if (!angular.isDefined(scope.forceVille)) scope.forceVille = false;

        if (
          angular.isDefined(scope.toggleAdresse) &&
          scope.toggleAdresse == true
        )
          scope.adresseContracted = true;

        /**
         * GESTION DES VILLES
         */
        function buildListeDesVilles() {
          if (typeSpancOrSpac == 'spanc') {
            scope.listeDesVilles = CurrentAppFactory.appCfg.main.infosSpancListeVillesCfg.filter(
              (x) => {
                return x.gere_spanc;
              }
            );
            if (scope.listeDesVilles==null)
              scope.listeDesVilles = [];
          } else if (typeSpancOrSpac == 'spac') {
            if (CurrentAppFactory.appCfg.main!=null) {
                scope.listeDesVilles = CurrentAppFactory.appCfg.main.extra.infosSassListeVillesCfg.filter(
                  (x) => {
                    return x.gere_sass;
                  }
                );
            }

            if (scope.listeDesVilles==null)
              scope.listeDesVilles = [];
          }
          scope.listeDesVillesStatique = angular.copy(scope.listeDesVilles);
        }
        buildListeDesVilles();

        scope.listeDesCpDesVilles = [];
        scope.communeChange = function(ville) {
          for (var i = 0; i < scope.listeDesVilles.length; i++) {
            if (ville == scope.listeDesVilles[i].value) {
              scope.res.adresse_pays = scope.listeDesVilles[i].pays;
              scope.res.adresse_ville = scope.listeDesVilles[i].value;
              scope.listeDesCpDesVilles = scope.listeDesVilles[i].cp;
            }
          }
        };

        scope.$on('$typeahead.select', function(index, ville) {
          if (ville.cp!=null) {
            adresseVilleChange(ville);
          }
          $(':focus').blur();
        });

        function adresseVilleChange(ville) {
          if (Array.isArray(ville.cp)) {
            scope.res.adresse_cp = ville.cp[0];
          } else {
            scope.res.adresse_cp = ville.cp;
          }
          scope.res.adresse_ville = ville.value;
          scope.res.adresse_pays = ville.pays;
        }

        scope.toggle = function() {
          scope.adresseContracted = !scope.adresseContracted;
        };

        scope.getHabAdr = function() {
          var ans = confirm(
            "Etes-vous sur de vouloir récupérer l'adresse de l'habitation ?"
          );

          if (ans) {
            scope.res.adresse_num_rue =
              angular.isDefined(scope.adresseHab.adresse_num_rue) &&
              scope.adresseHab.adresse_num_rue != null
                ? scope.adresseHab.adresse_num_rue
                : null;
            scope.res.adresse_num_rue_extra =
              angular.isDefined(scope.adresseHab.adresse_num_rue_extra) &&
              scope.adresseHab.adresse_num_rue_extra != null
                ? scope.adresseHab.adresse_num_rue_extra
                : null;
            scope.res.adresse_rue =
              angular.isDefined(scope.adresseHab.adresse_rue) &&
              scope.adresseHab.adresse_rue != null
                ? scope.adresseHab.adresse_rue
                : null;
            scope.res.adresse_ville =
              angular.isDefined(scope.adresseHab.adresse_ville) &&
              scope.adresseHab.adresse_ville != null
                ? scope.adresseHab.adresse_ville
                : null;
            scope.res.adresse_cp =
              angular.isDefined(scope.adresseHab.adresse_cp) &&
              scope.adresseHab.adresse_cp != null
                ? scope.adresseHab.adresse_cp
                : null;
            scope.res.adresse_bp =
              angular.isDefined(scope.adresseHab.adresse_bp) &&
              scope.adresseHab.adresse_bp != null
                ? scope.adresseHab.adresse_bp
                : null;
            scope.res.adresse_pays =
              angular.isDefined(scope.adresseHab.adresse_pays) &&
              scope.adresseHab.adresse_pays != null
                ? scope.adresseHab.adresse_pays
                : null;
            scope.res.adresse_complement =
              angular.isDefined(scope.adresseHab.adresse_complement) &&
              scope.adresseHab.adresse_complement != null
                ? scope.adresseHab.adresse_complement
                : null;
            scope.res.adresse_batiment =
              angular.isDefined(scope.adresseHab.adresse_batiment) &&
              scope.adresseHab.adresse_batiment != null
                ? scope.adresseHab.adresse_batiment
                : null;
            scope.res.adresse_appt =
              angular.isDefined(scope.adresseHab.adresse_appt) &&
              scope.adresseHab.adresse_appt != null
                ? scope.adresseHab.adresse_appt
                : null;
            scope.res.adresse_etage =
              angular.isDefined(scope.adresseHab.adresse_etage) &&
              scope.adresseHab.adresse_etage != null
                ? scope.adresseHab.adresse_etage
                : null;
            scope.res.adresse_escalier =
              angular.isDefined(scope.adresseHab.adresse_escalier) &&
              scope.adresseHab.adresse_escalier != null
                ? scope.adresseHab.adresse_escalier
                : null;
          }
        };

        scope.resetAdr = function() {
          var ans = confirm(
            "Êtes-vous certain de vouloir réinitialiser l'adresse ?"
          );
          if (ans) {
            Object.keys(scope.res).forEach(function(t) {
              if (t.indexOf('adresse') == 0) delete scope.res[t];
            });
          }
        };

        // open modal for adding commune
        scope.openNouvelleVilleDialog = function() {
          if (scope.nouvelleVilleModale) scope.nouvelleVilleModale.close();
          scope.nouvelleVilleModale = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.openCreateCommune.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        function getCityItem(key, ville) {
          return {
            cp: key,
            value: ville.value,
            pays: ville.pays,
            gere_spanc: ville.gere_spanc,
            style: '<div>' + ville.value + ' ' + key + '</div>',
          };
        }

        function parseListeDesVilles(listeDesVilles) {
          var parsedListeDesVilles = [];
          listeDesVilles.forEach(ville => {
            //-- Il est possible de créer une commune sans code pstal (hors SPANC).
            //-- Pour qu'une telle commune apparaisse dans l'auto-complete,
            //-- on ajoute ici une code postal vide.
            if (ville.cp.length == 0) {
              ville.cp.push('');
            }
            angular.forEach(ville.cp, function(key) {
              parsedListeDesVilles.push(getCityItem(key, ville));
            });
          });
          return parsedListeDesVilles;
        }

        function getDataFromAdministration() {
          var results = [];

          if (typeSpancOrSpac === 'spac') {
            results =
              CurrentAppFactory.appCfg.main.extra.infosSassListeVillesCfg;
          } else {
            results = AncAppFactory.appCfg.main.infosSpancListeVillesCfg;
          }
          // format the list if any of communes have more than 1 postal code
          if (results) {
            scope.listeDesVilles = parseListeDesVilles(results);
          }
        }

        function getCodesPostaleFromAdministration(queryCP) {
          let results = [];
          let listeCP = [];

          if (typeSpancOrSpac === 'spac') {
            results =
              CurrentAppFactory.appCfg.main.extra.infosSassListeVillesCfg;
          } else {
            results = AncAppFactory.appCfg.main.infosSpancListeVillesCfg;
          }
          if (results) {
            results.forEach(ville => {
              angular.forEach(ville.cp, function(key) {
                if (key && key.indexOf(queryCP) != -1) {
                  listeCP.push(ville);
                }
              });
            });
          }

          // format the list
          if (listeCP) {
            scope.listeDesVilles = parseListeDesVilles(listeCP);
          }
        }

        gaJsUtils.getListePays().then(function(listePays) {
          scope.listePays = listePays;
        });

        if (!scope.forceVille) {
          scope.listeDesVilles = [];
        }

        scope.emptyCommunesList = false;

        scope.getAutocomplete = function(query) {
          scope.listeDesVilles = [];

          if (!angular.isUndefined(query)) {
            if (query.length > 1) {
              // get data from SPAC Or SPANC
              getDataFromAdministration();
              if (!scope.forceVille) {
                // get data from External API and concat to data from SPANC/SPAC
                let url =
                  'https://geo.api.gouv.fr/communes?nom=' +
                  query +
                  '&fields=codesPostaux';
                scope.allCommunes = AncAppFactory.callExternalApi(url);

                Promise.all([scope.allCommunes]).then(allFromApiGeo => {
                  allFromApiGeo = allFromApiGeo[0];
                  scope.listeDesVilles = scope.listeDesVilles.concat(
                    allFromApiGeo
                  );

                  // show-hide add commune button
                  if (allFromApiGeo.length === 0) {
                    scope.emptyCommunesList = true;
                  } else {
                    scope.emptyCommunesList = false;
                  }
                });
              }
            }
          }
        };

        scope.getCP = query => {
          let minCharCount = 1;
          if (!scope.forceVille) {
            scope.listeDesVilles = [];
            minCharCount = 2;
          }
          if (query.length > minCharCount) {
            // get data from SPAC Or SPANC
            getCodesPostaleFromAdministration(query);
            return $http
              .get('https://geo.api.gouv.fr/communes?codePostal=' + query)
              .then(function(response) {
                if (scope.forceVille) {
                  //-- On fait le retour ici, pour éviter de créer une promesse
                  //-- spécialement pour le cas de l'adresse de l'habitation.
                  return scope.listeDesVilles;
                } else {
                  let parsedResult = AncAppFactory.parseResultFromExternalApi(
                    response.data
                  );
                  return parsedResult.concat(scope.listeDesVilles);
                }
              });
          }
        };

        /**
         * Récupération des codes postaux de la commune.
         * Si un code postal correspond à celui dans
         * le champ de saisie "Code postal", on laisse.
         * Dans le cas contraire, on choisi le premier.
         */
        scope.villeHasBeenSelected = function (ville) {
          for (
            var iVille = 0;
            iVille < scope.listeDesVillesStatique.length;
            iVille++
          ) {
            if (ville == scope.listeDesVillesStatique[iVille].value) {
              scope.res.adresse_cp = scope.listeDesVillesStatique[iVille].cp[0];
              if ($rootScope.xgos.sector == 'bac') {
                scope.$emit(
                  'communeAdresseChange',
                  scope.listeDesVillesStatique[iVille]
                );
              }
              break;
            }
          }
        };

        scope.getcp = q => {
          console.log(q);

          if (q.length > 4) {
            return $http
              .get('https://geo.api.gouv.fr/communes?codePostal=' + q)
              .then(function(response) {
                return response.data[0].codesPostaux.map(function(item) {
                  return {
                    cp: item,
                  };
                });
              });
          }
        };

        scope.setVille = newVille => (scope.res.adresse_ville = newVille);
        scope.setPays = newPays => (scope.res.adresse_pays = newPays);
        scope.setCodePostal = newCp => (scope.res.adresse_cp = newCp);
      },
    };
  };

  ancAdresse.$inject = [
    'AncAppFactory',
    'ngDialog',
    'BacAppFactory',
    '$rootScope',
    'gaJsUtils',
    '$http',
  ];
  return ancAdresse;
});
