'use strict';
define(function() {
  /**
   * vidangeElementFiliere
   */
  var vidangeElementFiliere = function(
    $rootScope,
    AncAppFactory,
    FeatureTypeFactory,
    EditFactory,
    gaDomUtils,
    gaJsUtils,
    QueryFactory,
    $filter,
    ngDialog
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/vidange.element.filiere.html',
      restrict: 'EA',
      scope: {
        efUid: '=', // uid element de filiere a vidanger
        efId: '=', // id element de filiere a vidanger
        controleClos: '=?', // controleClos ?
        vidanges: '=?', //récupération des vidanges déjà existantes.
      },
      link: function(scope) {
        // -----------------------------------------------------------
        // Liste des vidanges
        // -----------------------------------------------------------

        scope.vidangeTabs = [];

        scope.entreprisesCfg = AncAppFactory.appCfg.main.entreprisesCfg;
        if (scope.entreprisesCfg) {
          scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
            AncAppFactory.appCfg.main.datastore,
            scope.entreprisesCfg.emplacement
          );
        }

        scope.vidangeFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_vidange'
        );

        var relationVidangeFTI = FeatureTypeFactory.getFeatureByNameAndDatastore(
          AncAppFactory.appCfg.main.datastore,
          'kis_anc_vidange_element_filiere'
        );

        /**
         * setTabs
         */
        var setTabs = function() {
          scope.vidangeTabs = [];

          if (angular.isDefined(scope.vidanges)) {
            scope.vidangesPourElement = scope.vidanges.filter(
              vidange => vidange.id_element_filiere === scope.efId
            );
            scope.vidangesPourElement.forEach(function(vid) {
              if (vid.id_element_filiere != scope.efId) vid.disabled = true;
              var dateVidange = '';
              if (vid.properties.date_vidange)
                dateVidange = $filter('date')(
                  vid.properties.date_vidange,
                  'dd.MM.yyyy'
                );
              scope.vidangeTabs.push({
                title: 'Vidange ' + dateVidange,
              });
            });

            if (!angular.isDefined(scope.vidangeTabs.activeTab))
              scope.vidangeTabs.activeTab =
                scope.vidangesPourElement.length - 1;
          }
        };

        scope.$watch('vidangeTabs.activeTab', function(at) {
          if (angular.isDefined(at) && Number.isInteger(at) && at >= 0) {
            scope.vidange = scope.vidangesPourElement[at];
            // recup des infos du vidangeur
            scope.vidangeur = {};
            if (
              angular.isDefined(scope.vidange) &&
              angular.isDefined(scope.vidange.properties) &&
              angular.isDefined(scope.vidange.properties.id_entreprise) &&
              scope.vidange.properties.id_entreprise !== null
            ) {
              QueryFactory.get(
                scope.entreprisesFti.uid,
                scope.vidange.properties.id_entreprise
              ).then(function(res) {
                scope.vidangeur = res.data.features[0].properties;
              });
            }
          }
        });

        // get liste des vidanges
        scope.refreshVidangesEf = function() {
          scope.loadingEnCours = true;

          scope.vidange = false;

          if (angular.isDefined(scope.vidanges)) {
            //sort by id
            scope.vidanges = scope.vidanges.sort(function(a, b) {
              var x = parseInt(a.id.split('.')[1]);
              var y = parseInt(b.id.split('.')[1]);
              return x < y ? -1 : x > y ? 1 : 0;
            });
            scope.$emit('updateNbElemVidange', scope.vidanges);
            setTabs();
            scope.vidangesPourElement = scope.vidanges.filter(
              vidange => vidange.id_element_filiere === scope.efId
            );
            scope.vidange =
              scope.vidangesPourElement[scope.vidangesPourElement.length - 1];
          }
        };

        scope.refreshVidangesEf();

        scope.addVidangeToEF = function() {
          var ans = confirm(
            'Ajouter une vidange pour cet élément de filière ?'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();
            AncAppFactory.addvidangetoelementfiliere({
              ef_uid: scope.efUid,
              ef_id: scope.efId,
            }).then(
              function(res) {
                var newVidange = {
                  id: res.data,
                  type: 'Feature',
                  properties: {},
                  id_element_filiere: scope.efId,
                };

                if (
                  angular.isUndefined(scope.vidanges) ||
                  scope.vidanges.length === 0
                )
                  scope.vidanges = [];

                scope.vidanges.push(newVidange);

                gaDomUtils.hideGlobalLoader();
                scope.refreshVidangesEf();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  "Une erreur s'est produite lors de l'ajout de la vidange."
                );
              }
            );
          }
        };

        // -----------------------------------------------------------
        // Vidange specifique
        // -----------------------------------------------------------

        scope.vidangeEffectueeChoices = [
          { label: '?', value: null },
          { label: 'Oui', value: true },
          { label: 'Non', value: false },
        ];
        scope.justifVidangeChoices = [
          { label: 'Oui', value: true },
          { label: 'Non', value: false },
        ];

        scope.vidangeur = {};

        /**
         * updateVidange
         */
        scope.updateVidange = function() {
          var featureCollection = {
            type: 'FeatureCollection',
            features: [scope.vidange],
          };

          if (
            featureCollection.features !== undefined &&
            featureCollection.features[0] !== undefined &&
            featureCollection.features[0].properties !== undefined &&
            featureCollection.features[0].properties.date_vidange !==
              undefined &&
            featureCollection.features[0].properties.date_vidange !== null
          ) {
            featureCollection.features[0].properties.date_vidange = featureCollection.features[0].properties.date_vidange.getTime();
          }

          AncAppFactory.updatevidangeelementfiliere(featureCollection).then(
            function() {
              gaDomUtils.hideGlobalLoader();

              if (scope.vidange.properties.date_vidange) {
                var dateVidange = $filter('date')(
                  scope.vidange.properties.date_vidange,
                  'dd.MM.yyyy'
                );
                scope.vidangeTabs[scope.vidangeTabs.activeTab].title =
                  'Vidange ' + dateVidange;
              }

              require('toastr').success(
                'Informations de la vidange mises à jour.'
              );
            },
            function() {
              require('toastr').error(
                "Une erreur s'est produite lors de la mise à jour de la vidange."
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * deleteVidange
         */
        scope.deleteVidange = function() {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer cette vidange ?'
          );
          if (ans) {
            gaDomUtils.showGlobalLoader();
            AncAppFactory.removevidangefromelementfiliere(
              scope.vidange.id_element_filiere,
              scope.vidange.id
            ).then(
              function() {
                var newArray = [];
                scope.vidanges.map(function(vid, i) {
                  if (vid.id !== scope.vidange.id) newArray.push(vid);
                });

                scope.vidanges = newArray;
                scope.refreshVidangesEf();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                require('toastr').error(
                  "Une erreur s'est produite lors de la suppression de la vidange."
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        // -----------------------------------------------------------
        // VIDANGEUR
        // -----------------------------------------------------------

        var pickVidangeurDialog;
        scope.prePickVidangeur = function(type) {
          // vidangeur
          if (typeof userAndroid !== 'undefined') {
            scope.selectEntrepriseFilter = "type = 3 AND actif = 'true'";
          } else {
            scope.selectEntrepriseFilter = 'type = 3 AND actif = true';
          }
          pickVidangeurDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/controle/modals/modal.pick.entreprise.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };
        /* set vidangeur */
        scope.getInfosEntreprise = function(entreprise) {
          scope.vidangeur = entreprise[0].properties;
          scope.vidange.properties.id_entreprise = entreprise[0].id;
          pickVidangeurDialog.close();
        };

        /*
                 ADD VIDANGEUR
                 */
        var addEntrepriseDialog;
        scope.ouvrirEntrepriseDialog = function() {
          scope.type = '3';
          scope.currentEntreprise = {
            properties: {
              type: '3',
              actif: true,
            },
          };
          scope.forceType = true;
          scope.forceActif = true;

          addEntrepriseDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.entreprise.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.saveEntreprise = function() {
          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          featureCollection.features.push({
            type: 'Feature',
            properties: scope.currentEntreprise.properties,
          });
          EditFactory.add(scope.entreprisesFti.uid, featureCollection).then(
            function(res) {
              require('toastr').success('Enregistré');
              scope.vidange.properties.id_entreprise = res.data.create[0].id;
              scope.vidangeur = JSON.parse(res.data.create[0].json).properties;
              addEntrepriseDialog.close();
            }
          );
        };

        /**
         * unlinkVidangeur
         */
        scope.unlinkVidangeur = function(type) {
          scope.vidangeur = {};
          delete scope.vidange.properties.id_entreprise;
        };

        /**
         * Toggle visibilité vidangeur
         */
        if (angular.isUndefined(scope.display)) {
          scope.display = {};
        }
        scope.display.vidangeur = 'reduced';
        scope.toggleDisplayVidangeur = function() {
          scope.display.vidangeur =
            scope.display.vidangeur == 'full' ? 'reduced' : 'full';
        };
      },
    };
  };

  vidangeElementFiliere.$inject = [
    '$rootScope',
    'AncAppFactory',
    'FeatureTypeFactory',
    'EditFactory',
    'gaDomUtils',
    'gaJsUtils',
    'QueryFactory',
    '$filter',
    'ngDialog',
  ];
  return vidangeElementFiliere;
});
