'use strict';
define([
  'angular',
  'widgets/ancapp/main/controllers/gcMainController',
  'widgets/ancapp/main/controllers/noCfgCtrl',
  'widgets/ancapp/main/controllers/reportsCtrl',
  'widgets/ancapp/main/controllers/facturationCtrl',
  'widgets/ancapp/main/controllers/documentsCtrl',
  'widgets/ancapp/main/controllers/dashboardCtrl',
  'widgets/ancapp/main/controllers/mailsCtrl',
  'widgets/ancapp/main/controllers/adminCtrl',
  'widgets/ancapp/main/controllers/importParcelleCtrl',
  'widgets/ancapp/main/controllers/importParcelleMapCtrl',
  'widgets/ancapp/main/controllers/configMobileCtrl',
  'widgets/ancapp/main/views/controllers/CUCtrl',
  'widgets/ancapp/main/views/controllers/ficheCCtrl',
  'widgets/ancapp/main/views/controllers/ficheDCtrl',
  'widgets/ancapp/main/views/controllers/ficheACtrl',
  'widgets/ancapp/main/views/controllers/ponctuelCtrl',
  'widgets/ancapp/main/views/controllers/FO0Ctrl',
  'widgets/ancapp/main/views/controllers/FO1Ctrl',
  'widgets/ancapp/main/views/controllers/FO2Ctrl',
  'widgets/ancapp/main/views/controllers/FO3Ctrl',
  'widgets/ancapp/main/views/controllers/FO4Ctrl',
  'widgets/ancapp/main/services/AncAppFactory',
  'widgets/ancapp/main/services/AncAppSearchFactory',

  'widgets/utilities/geoserver/services/GeoserverFactory',

  'widgets/ancapp/main/directives/listeDossiers',
  'widgets/ancapp/main/directives/ancNavigation',
  'widgets/ancapp/main/directives/ancDossierPersonne',
  'widgets/ancapp/main/directives/ancDossierParcelle',
  'widgets/ancapp/main/directives/ancDossierParcelles',
  'widgets/ancapp/main/directives/ancDossierAutorisationUrba',
  'widgets/ancapp/main/directives/ancPersonne',
  'widgets/ancapp/main/directives/recherchePointConsommation',
  'widgets/ancapp/main/directives/ancParcelle',
  'widgets/ancapp/main/directives/ancDerogation',
  'widgets/ancapp/main/directives/ancAdresse',
  'widgets/ancapp/main/directives/ancCreateCommune',
  'widgets/ancapp/main/directives/ancCivilite',
  'widgets/ancapp/main/directives/ancElementFiliere',
  'widgets/ancapp/main/directives/ancAjoutElementFiliere',
  'widgets/ancapp/main/directives/representationFiliere',
  'widgets/ancapp/main/directives/representationFiliereMobile',
  'widgets/ancapp/main/directives/ancControleFiliere',
  'widgets/ancapp/main/directives/personneInfosPicker',
  'widgets/ancapp/main/directives/ancMapWidget',
  'widgets/ancapp/main/directives/controleFormCfg',
  'widgets/ancapp/main/directives/remarqueFormD2',
  'widgets/ancapp/main/directives/ancCheckCommentaire',
  'widgets/ancapp/main/directives/ancAvisControle',
  'widgets/ancapp/main/directives/grilleConformite',
  'widgets/ancapp/main/directives/elementFiliereTemplate',
  'widgets/ancapp/main/directives/calendarAdmin',
  'widgets/ancapp/main/directives/signatureClient',
  'widgets/ancapp/main/directives/vidangeElementFiliere',
  'widgets/ancapp/main/directives/ancVidangeLogic',
  'widgets/ancapp/main/directives/ancSubventionLogic',
  'widgets/ancapp/main/directives/ancOccupantControle',
  'widgets/ancapp/main/directives/ancEditDessinFiliere',
  'widgets/ancapp/main/directives/ancCustomDossierRequetes',
  'widgets/ancapp/main/directives/mapFilter',
  'widgets/ancapp/main/directives/calendrier_rdv/calRdvAutoJour',
  'widgets/ancapp/main/directives/anc_bac/ancBacLiaisonTables',
  'widgets/ancapp/main/directives/anc_bac/ancBacMainReport',
  'widgets/ancapp/main/directives/anc_bac/ancReportWrapper',
  'widgets/ancapp/main/directives/anc_bac/ancBacMapConfiguration',
  'widgets/ancapp/main/directives/anc_bac/ancBacDossierConfiguration',
  'widgets/ancapp/main/directives/anc_bac/ancBacDocumentConfiguration',
  'widgets/ancapp/main/directives/anc_bac/ancBacControleConfiguration',
  'widgets/ancapp/main/directives/anc_bac/ancBacFacturationConfiguration',
  'widgets/ancapp/main/directives/anc_bac/ancBacControleCommonLogic',
  'widgets/ancapp/main/directives/anc_bac/ancBacDemandeurPicker',
  'widgets/ancapp/main/directives/anc_bac/ancBacBureauPicker',
  'widgets/ancapp/main/directives/anc_bac/ancBacServiceControle',
  'widgets/ancapp/main/directives/anc_bac/ancBacExtraFormFields',
  'widgets/ancapp/main/directives/anc_bac/ancBacGestionCivilites',
  'widgets/ancapp/main/directives/anc_bac/ancBacConfigurationRequeteJson',
  'widgets/ancapp/main/directives/anc_bac/ancBacPositionDossier',
  'widgets/ancapp/main/directives/anc_bac/ancBacVerificationIndexationDossier',
  'widgets/ancapp/main/directives/anc_bac/ancBacDossierEtablissement',
  'widgets/ancapp/main/directives/anc_bac/ancBacCaracteristiquesEtablissement',
  'widgets/ancapp/main/directives/ancElementsFacturation',
  'widgets/ancapp/main/directives/ancTemplatesFacturation',
  'widgets/ancapp/main/directives/ancPeriodesTarification',
  'widgets/ancapp/main/directives/ancFacturationDolibarr',
  'widgets/ancapp/main/directives/ancBibliothequeElementsFiliere',
  'modules/common/directives/executeQuery',
  'modules/common/directives/pcwinManager',
  'modules/common/directives/omegaManager',

  'widgets/ancapp/main/services/ancBacTools',
  'widgets/ancbaccommon/services/CommonFactory',
],
function (angular, gcMainController, noCfgCtrl, reportsCtrl, facturationCtrl,
  documentsCtrl, dashboardCtrl, mailsCtrl, adminCtrl, importParcelleCtrl,
  importParcelleMapCtrl, configMobileCtrl, CUCtrl, ficheCCtrl, ficheDCtrl,
  ficheACtrl, ponctuelCtrl, FO0Ctrl, FO1Ctrl, FO2Ctrl, FO3Ctrl, FO4Ctrl,
  AncAppFactory, AncAppSearchFactory, GeoserverFactory, listeDossiers,
  ancNavigation, ancDossierPersonne, ancDossierParcelle, ancDossierParcelles,
  ancDossierAutorisationUrba, ancPersonne, recherchePointConsommation,
  ancParcelle, ancDerogation, ancAdresse, ancCreateCommune, ancCivilite,
  ancElementFiliere, ancAjoutElementFiliere, representationFiliere,
  representationFiliereMobile, ancControleFiliere, personneInfosPicker,
  ancMapWidget, controleFormCfg, remarqueFormD2, ancCheckCommentaire,
  ancAvisControle, grilleConformite, elementFiliereTemplate, calendarAdmin,
  signatureClient, vidangeElementFiliere, ancVidangeLogic, ancSubventionLogic,
  ancOccupantControle, ancEditDessinFiliere, ancCustomDossierRequetes,
  mapFilter, calRdvAutoJour, ancBacLiaisonTables, ancBacMainReport,
  ancReportWrapper, ancBacMapConfiguration, ancBacDossierConfiguration,
  ancBacDocumentConfiguration, ancBacControleConfiguration,
  ancBacFacturationConfiguration, ancBacControleCommonLogic,
  ancBacDemandeurPicker, ancBacBureauPicker, ancBacServiceControle,
  ancBacExtraFormFields, ancBacGestionCivilites, ancBacConfigurationRequeteJson,
  ancBacPositionDossier, ancBacVerificationIndexationDossier,
  ancBacDossierEtablissement, ancBacCaracteristiquesEtablissement,
  ancElementsFacturation, ancTemplatesFacturation, ancPeriodesTarification,
  ancFacturationDolibarr, ancBibliothequeElementsFiliere,
  executeQuery, pcwinManager, omegaManager, ancBacTools, CommonFactory
) {
  var gcMain = angular.module('gcAncMain', ['gc_featuregeometry_editor']);

  gcMain.controller('gcAncController', gcMainController);
  gcMain.controller('noCfgCtrl', noCfgCtrl);
  gcMain.controller('reportsCtrl', reportsCtrl);
  gcMain.controller('facturationCtrl', facturationCtrl);
  gcMain.controller('dashboardCtrl', dashboardCtrl);
  gcMain.controller('documentsCtrl', documentsCtrl);
  gcMain.controller('mailsCtrl', mailsCtrl);
  gcMain.controller('adminCtrl', adminCtrl);
  gcMain.controller('importParcelleCtrl', importParcelleCtrl);
  gcMain.controller('importParcelleMapCtrl', importParcelleMapCtrl);
  gcMain.controller('configMobileCtrl', configMobileCtrl);
  gcMain.controller('CUCtrl', CUCtrl);
  gcMain.controller('ficheCCtrl', ficheCCtrl);
  gcMain.controller('ficheDCtrl', ficheDCtrl);
  gcMain.controller('ficheACtrl', ficheACtrl);
  gcMain.controller('ponctuelCtrl', ponctuelCtrl);
  gcMain.controller('FO0Ctrl', FO0Ctrl);
  gcMain.controller('FO1Ctrl', FO1Ctrl);
  gcMain.controller('FO2Ctrl', FO2Ctrl);
  gcMain.controller('FO3Ctrl', FO3Ctrl);
  gcMain.controller('FO4Ctrl', FO4Ctrl);

  gcMain.service('AncAppFactory', AncAppFactory);
  gcMain.service('CommonFactory', CommonFactory);
  gcMain.service('AncAppSearchFactory', AncAppSearchFactory);
  gcMain.service('GeoserverFactory', GeoserverFactory);

  gcMain.directive('listeDossiers', listeDossiers);
  gcMain.directive('ancNavigation', ancNavigation);
  gcMain.directive('ancDossierPersonne', ancDossierPersonne);
  gcMain.directive('ancDossierParcelle', ancDossierParcelle);
  gcMain.directive('ancDossierParcelles', ancDossierParcelles);
  gcMain.directive('ancDossierAutorisationUrba', ancDossierAutorisationUrba);
  gcMain.directive('ancPersonne', ancPersonne);
  gcMain.directive('recherchePointConsommation', recherchePointConsommation);
  gcMain.directive('ancParcelle', ancParcelle);
  gcMain.directive('ancDerogation', ancDerogation);
  gcMain.directive('ancAdresse', ancAdresse);
  gcMain.directive('ancCreateCommune', ancCreateCommune);
  gcMain.directive('ancCivilite', ancCivilite);
  gcMain.directive('ancElementFiliere', ancElementFiliere);
  gcMain.directive('ancAjoutElementFiliere', ancAjoutElementFiliere);
  if (typeof AppAndroid !== 'undefined')
    gcMain.directive('representationFiliere', representationFiliereMobile);
  else gcMain.directive('representationFiliere', representationFiliere);
  gcMain.directive('ancControleFiliere', ancControleFiliere);
  gcMain.directive('personneInfosPicker', personneInfosPicker);
  gcMain.directive('ancmapwidget', ancMapWidget);
  gcMain.directive('controleFormCfg', controleFormCfg);
  gcMain.directive('remarqueFormD2', remarqueFormD2);
  gcMain.directive('ancCheckCommentaire', ancCheckCommentaire);
  gcMain.directive('grilleConformite', grilleConformite);
  gcMain.directive('ancAvisControle', ancAvisControle);
  gcMain.directive('elementFiliereTemplate', elementFiliereTemplate);
  gcMain.directive('calendarAdmin', calendarAdmin);
  gcMain.directive('signatureClient', signatureClient);
  gcMain.directive('vidangeElementFiliere', vidangeElementFiliere);
  gcMain.directive('mapFilter', mapFilter);
  gcMain.directive('calRdvAutoJour', calRdvAutoJour);
  gcMain.directive('ancVidangeLogic', ancVidangeLogic);
  gcMain.directive('ancSubventionLogic', ancSubventionLogic);
  gcMain.directive('ancOccupantControle', ancOccupantControle);
  gcMain.directive('ancEditDessinFiliere', ancEditDessinFiliere);
  gcMain.directive('ancCustomDossierRequetes', ancCustomDossierRequetes);

  // anc - bac common directives
  gcMain.directive('ancBacLiaisonTables', ancBacLiaisonTables);
  gcMain.directive('ancBacMapConfiguration', ancBacMapConfiguration);
  gcMain.directive('ancBacMainReport', ancBacMainReport);
  gcMain.directive('ancReportWrapper', ancReportWrapper);
  gcMain.directive('ancBacDossierConfiguration', ancBacDossierConfiguration);
  gcMain.directive('ancBacDocumentConfiguration', ancBacDocumentConfiguration);
  gcMain.directive('ancBacControleConfiguration', ancBacControleConfiguration);
  gcMain.directive(
    'ancBacFacturationConfiguration',
    ancBacFacturationConfiguration
  );
  gcMain.directive('ancBacControleCommonLogic', ancBacControleCommonLogic);
  gcMain.directive('ancBacDemandeurPicker', ancBacDemandeurPicker);
  gcMain.directive('ancBacBureauPicker', ancBacBureauPicker);
  gcMain.directive('ancBacServiceControle', ancBacServiceControle);
  gcMain.directive('ancBacExtraFormFields', ancBacExtraFormFields);
  gcMain.directive('ancBacGestionCivilites', ancBacGestionCivilites);
  gcMain.directive(
    'ancBacConfigurationRequeteJson',
    ancBacConfigurationRequeteJson
  );
  gcMain.directive('ancBacPositionDossier', ancBacPositionDossier);
  gcMain.directive(
    'ancBacVerificationIndexationDossier',
    ancBacVerificationIndexationDossier
  );

  gcMain.directive('ancBacDossierEtablissement', ancBacDossierEtablissement);
  gcMain.directive(
    'ancBacCaracteristiquesEtablissement',
    ancBacCaracteristiquesEtablissement
  );

  gcMain.directive('ancElementsFacturation', ancElementsFacturation);
  gcMain.directive('ancTemplatesFacturation', ancTemplatesFacturation);
  gcMain.directive('ancPeriodesTarification', ancPeriodesTarification);
  gcMain.directive('ancFacturationDolibarr', ancFacturationDolibarr);
  gcMain.directive(
    'ancBibliothequeElementsFiliere',
    ancBibliothequeElementsFiliere
  );
  gcMain.directive('executeQuery', executeQuery);
  gcMain.directive('pcwinmanager', pcwinManager);
  gcMain.directive('omegamanager', omegaManager);

  gcMain.provider('ancBacTools', ancBacTools);

  gcMain.config([
    '$routeProvider',
    function($routeProvider, $location) {
      $routeProvider.when('/anc/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/main.html',
        controller: 'gcAncController',
      });
      $routeProvider.when('/anc/reports/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/reports.html',
        controller: reportsCtrl,
      });
      $routeProvider.when('/anc/facturation/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/facturation.html',
        controller: facturationCtrl,
      });
      $routeProvider.when('/anc/documents/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/documents.html',
        controller: documentsCtrl,
      });
      $routeProvider.when('/anc/dashboard/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/dashboard.html',
        controller: dashboardCtrl,
      });
      $routeProvider.when('/anc/mails/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/mails.html',
        controller: mailsCtrl,
      });
      $routeProvider.when('/anc/admin/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/admin.html',
        controller: adminCtrl,
      });
      $routeProvider.when('/anc/config_mobile/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/config_mobile.html',
        controller: configMobileCtrl,
      });
      $routeProvider.when('/anc/nocfg', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/no_cfg.html',
        controller: noCfgCtrl,
      });
    },
  ]);

  return gcMain;
});
