'use strict';

define(function() {
  var DRRACCtrl = function(
    $scope,
    AncAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout,
    gaJsUtils,
    $filter
  ) {
    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );

    // fonctions de reset de certaines parties du json selon les choix cochés
    var resetEtatRaccord = function(cdata) {
      if (gaJsUtils.checkNestedProperty('info_ass_coll.etat_raccord', cdata))
        delete $scope.cdata.info_ass_coll.etat_raccord;
    };
    var resetRaccordDelai = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.delai_expire',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.etat_raccord.delai_expire;
    };
    var resetRaccordAnnee = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.annee_raccordement',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.etat_raccord.annee_raccordement;
    };
    var resetRaccordDerogation = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.delai_derogation',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.etat_raccord.delai_derogation;
    };
    var resetInfosProlongationAccordee = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.duree_prolong',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.etat_raccord.duree_prolong;
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.benefic_prolong',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.etat_raccord.benefic_prolong;
    };
    var resetAutorisationRaccordement = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty('info_ass_coll.autorisation_racc', cdata)
      )
        delete $scope.cdata.info_ass_coll.autorisation_racc;
    };
    var resetDateAutorisationRacc = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.autorisation_racc.date',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.autorisation_racc.date;
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.autorisation_racc.numero',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.autorisation_racc.numero;
    };
    var resetCtrlAutorisationRacc = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.autorisation_racc.controle_realise',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.autorisation_racc.controle_realise;
    };
    var resetCertificatConformite = function(cdata) {
      if (gaJsUtils.checkNestedProperty('info_ass_coll.certif_conform', cdata))
        delete $scope.cdata.info_ass_coll.certif_conform;
    };
    var resetInfosCertificatConformite = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.certif_conform.date',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.certif_conform.date;
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.certif_conform.validite',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.certif_conform.validite;
    };
    var resetInfosCtrlCertificatConformite = function(cdata) {
      if (
        gaJsUtils.checkNestedProperty(
          'info_ass_coll.certif_conform.controle_realise',
          cdata
        )
      )
        delete $scope.cdata.info_ass_coll.certif_conform.controle_realise;
    };


    /*
    Alimentation des variables qui conditionnent l' affichage du bouton mail et des sous parties
    */
    $scope.$watch(
      'cdata',
      function(cdata) {
        console.log('watchcdata');

        // nettoyage des données des étapes suivantes lorsu'on les cache
        // par ex : reset de toutes les reponses ultérieures eventuelles quand on repasse en zone non assainie (premiere question)
        var zone_assainie = gaJsUtils.checkNestedProperty(
          'info_ass_coll.zone_assainie',
          cdata
        );
        if (zone_assainie == '0') {
          resetEtatRaccord(cdata);
          resetAutorisationRaccordement(cdata);
          resetCertificatConformite(cdata);
        }
        var propriete_racc_eu = gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.propriete_racc_eu',
          cdata
        );
        if (propriete_racc_eu == '0') {
          resetAutorisationRaccordement(cdata);
          resetCertificatConformite(cdata);
          resetRaccordAnnee(cdata);
        }
        if (propriete_racc_eu !== '0') {
          resetRaccordDelai(cdata);
          resetRaccordDerogation(cdata);
          resetInfosProlongationAccordee(cdata);
        }
        var delai_expire = gaJsUtils.checkNestedProperty(
          'info_ass_coll.etat_raccord.delai_expire',
          cdata
        );
        if (delai_expire === '0') {
          resetRaccordDerogation(cdata);
          resetInfosProlongationAccordee(cdata);
        }
        var autorisation_racc = gaJsUtils.checkNestedProperty(
          'info_ass_coll.autorisation_racc.existe',
          cdata
        );
        if (autorisation_racc === '0') {
          resetDateAutorisationRacc(cdata);
          resetCertificatConformite(cdata);
        }
        if (autorisation_racc === '1') {
          resetCtrlAutorisationRacc(cdata);
        }
        var certif_conform = gaJsUtils.checkNestedProperty(
          'info_ass_coll.certif_conform.existe',
          cdata
        );
        if (certif_conform === '0') {
          resetInfosCertificatConformite(cdata);
        }
        if (certif_conform === '1') {
          resetInfosCtrlCertificatConformite(cdata);
        }

        // affichage sous parties
        $scope.chkDrrac = {
          zone_assainie: zone_assainie,
          propriete_racc_eu: propriete_racc_eu,
          delai_expire: delai_expire,
          delai_derogation: gaJsUtils.checkNestedProperty(
            'info_ass_coll.etat_raccord.delai_derogation',
            cdata
          ),
          autorisation_racc: autorisation_racc,
          certif_conform: certif_conform,
          autorisation_racc_controle: gaJsUtils.checkNestedProperty(
            'info_ass_coll.autorisation_racc.controle_realise',
            cdata
          ),
          certif_conform_controle: gaJsUtils.checkNestedProperty(
            'info_ass_coll.certif_conform.controle_realise',
            cdata
          ),
        };

        console.log($scope.chkDrrac);

        // display bouton mail
        $scope.displayMail =
          $scope.chkDrrac.zone_assainie === '0' ||
          $scope.chkDrrac.propriete_racc_eu === '2' ||
          $scope.chkDrrac.delai_expire === '0' ||
          $scope.chkDrrac.delai_derogation === '1' ||
          $scope.chkDrrac.delai_derogation === '0' ||
          $scope.chkDrrac.autorisation_racc_controle === '0' ||
          $scope.chkDrrac.certif_conform === '1' ||
          $scope.chkDrrac.certif_conform === '0';

        $scope.displayMail2 =
          $scope.chkDrrac.delai_derogation === '1' ||
          $scope.chkDrrac.delai_expire === '0' ||
          $scope.chkDrrac.autorisation_racc_controle === '0' ||
          $scope.chkDrrac.certif_conform_controle === '0';
        $scope.displayMail3 =
          $scope.chkDrrac.autorisation_racc_controle === '0';
        $scope.displayMail4 =
          $scope.chkDrrac.delai_expire === '0' ||
          $scope.chkDrrac.autorisation_racc_controle === '0';
      },
      1
    );

    $scope.courrier1 = { val: '' };
    $scope.courrier2 = { val: '' };
    $scope.courrier3 = { val: '' };
    $scope.courrier4 = { val: '' };

    /**
     *  genereEnvoiCourrier depuis le controle
     */
    $scope.genereEnvoiCourrier = function(index) {
      // veuillez_vous_raccorder
      if (index == 1 && $scope.courrier1.val == 'veuillez_vous_raccorder') {
        gaJsUtils.setNestedProperty(
          'derniers_envois.demande_raccord.date',
          $scope.cdata,
          $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ')
        );
      }
      //relance_se_raccorder_trois_mois
      if (
        index == 2 &&
        $scope.courrier2.val == 'relance_se_raccorder_trois_mois'
      ) {
        gaJsUtils.setNestedProperty(
          'derniers_envois.relance.date',
          $scope.cdata,
          $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss.sssZ')
        );
      }
      $scope.getDocxControle(
        'drrac_' + $scope['courrier' + index].val + '.docx'
      );
    };
  };

  DRRACCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
    'gaJsUtils',
    '$filter',
  ];
  return DRRACCtrl;
});
